/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNotebookInstanceLifecycleConfigsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListNotebookInstanceLifecycleConfigsResponse.Builder, ListNotebookInstanceLifecycleConfigsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListNotebookInstanceLifecycleConfigsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<NotebookInstanceLifecycleConfigSummary>> NOTEBOOK_INSTANCE_LIFECYCLE_CONFIGS_FIELD = SdkField
            .<List<NotebookInstanceLifecycleConfigSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListNotebookInstanceLifecycleConfigsResponse::notebookInstanceLifecycleConfigs))
            .setter(setter(Builder::notebookInstanceLifecycleConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceLifecycleConfigs")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotebookInstanceLifecycleConfigSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotebookInstanceLifecycleConfigSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            NOTEBOOK_INSTANCE_LIFECYCLE_CONFIGS_FIELD));

    private final String nextToken;

    private final List<NotebookInstanceLifecycleConfigSummary> notebookInstanceLifecycleConfigs;

    private ListNotebookInstanceLifecycleConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.notebookInstanceLifecycleConfigs = builder.notebookInstanceLifecycleConfigs;
    }

    /**
     * <p>
     * If the response is truncated, Amazon SageMaker returns this token. To get the next set of lifecycle
     * configurations, use it in the next request.
     * </p>
     * 
     * @return If the response is truncated, Amazon SageMaker returns this token. To get the next set of lifecycle
     *         configurations, use it in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * An array of <code>NotebookInstanceLifecycleConfiguration</code> objects, each listing a lifecycle configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>NotebookInstanceLifecycleConfiguration</code> objects, each listing a lifecycle
     *         configuration.
     */
    public List<NotebookInstanceLifecycleConfigSummary> notebookInstanceLifecycleConfigs() {
        return notebookInstanceLifecycleConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceLifecycleConfigs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotebookInstanceLifecycleConfigsResponse)) {
            return false;
        }
        ListNotebookInstanceLifecycleConfigsResponse other = (ListNotebookInstanceLifecycleConfigsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(notebookInstanceLifecycleConfigs(), other.notebookInstanceLifecycleConfigs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListNotebookInstanceLifecycleConfigsResponse").add("NextToken", nextToken())
                .add("NotebookInstanceLifecycleConfigs", notebookInstanceLifecycleConfigs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "NotebookInstanceLifecycleConfigs":
            return Optional.ofNullable(clazz.cast(notebookInstanceLifecycleConfigs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNotebookInstanceLifecycleConfigsResponse, T> g) {
        return obj -> g.apply((ListNotebookInstanceLifecycleConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListNotebookInstanceLifecycleConfigsResponse> {
        /**
         * <p>
         * If the response is truncated, Amazon SageMaker returns this token. To get the next set of lifecycle
         * configurations, use it in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon SageMaker returns this token. To get the next set of lifecycle
         *        configurations, use it in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of <code>NotebookInstanceLifecycleConfiguration</code> objects, each listing a lifecycle
         * configuration.
         * </p>
         * 
         * @param notebookInstanceLifecycleConfigs
         *        An array of <code>NotebookInstanceLifecycleConfiguration</code> objects, each listing a lifecycle
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceLifecycleConfigs(
                Collection<NotebookInstanceLifecycleConfigSummary> notebookInstanceLifecycleConfigs);

        /**
         * <p>
         * An array of <code>NotebookInstanceLifecycleConfiguration</code> objects, each listing a lifecycle
         * configuration.
         * </p>
         * 
         * @param notebookInstanceLifecycleConfigs
         *        An array of <code>NotebookInstanceLifecycleConfiguration</code> objects, each listing a lifecycle
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceLifecycleConfigs(NotebookInstanceLifecycleConfigSummary... notebookInstanceLifecycleConfigs);

        /**
         * <p>
         * An array of <code>NotebookInstanceLifecycleConfiguration</code> objects, each listing a lifecycle
         * configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <NotebookInstanceLifecycleConfigSummary>.Builder} avoiding the need to create one manually via {@link List
         * <NotebookInstanceLifecycleConfigSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NotebookInstanceLifecycleConfigSummary>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #notebookInstanceLifecycleConfigs(List<NotebookInstanceLifecycleConfigSummary>)}.
         * 
         * @param notebookInstanceLifecycleConfigs
         *        a consumer that will call methods on {@link List<NotebookInstanceLifecycleConfigSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notebookInstanceLifecycleConfigs(List<NotebookInstanceLifecycleConfigSummary>)
         */
        Builder notebookInstanceLifecycleConfigs(
                Consumer<NotebookInstanceLifecycleConfigSummary.Builder>... notebookInstanceLifecycleConfigs);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<NotebookInstanceLifecycleConfigSummary> notebookInstanceLifecycleConfigs = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotebookInstanceLifecycleConfigsResponse model) {
            super(model);
            nextToken(model.nextToken);
            notebookInstanceLifecycleConfigs(model.notebookInstanceLifecycleConfigs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<NotebookInstanceLifecycleConfigSummary.Builder> getNotebookInstanceLifecycleConfigs() {
            return notebookInstanceLifecycleConfigs != null ? notebookInstanceLifecycleConfigs.stream()
                    .map(NotebookInstanceLifecycleConfigSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder notebookInstanceLifecycleConfigs(
                Collection<NotebookInstanceLifecycleConfigSummary> notebookInstanceLifecycleConfigs) {
            this.notebookInstanceLifecycleConfigs = NotebookInstanceLifecycleConfigSummaryListCopier
                    .copy(notebookInstanceLifecycleConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notebookInstanceLifecycleConfigs(
                NotebookInstanceLifecycleConfigSummary... notebookInstanceLifecycleConfigs) {
            notebookInstanceLifecycleConfigs(Arrays.asList(notebookInstanceLifecycleConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notebookInstanceLifecycleConfigs(
                Consumer<NotebookInstanceLifecycleConfigSummary.Builder>... notebookInstanceLifecycleConfigs) {
            notebookInstanceLifecycleConfigs(Stream.of(notebookInstanceLifecycleConfigs)
                    .map(c -> NotebookInstanceLifecycleConfigSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNotebookInstanceLifecycleConfigs(
                Collection<NotebookInstanceLifecycleConfigSummary.BuilderImpl> notebookInstanceLifecycleConfigs) {
            this.notebookInstanceLifecycleConfigs = NotebookInstanceLifecycleConfigSummaryListCopier
                    .copyFromBuilder(notebookInstanceLifecycleConfigs);
        }

        @Override
        public ListNotebookInstanceLifecycleConfigsResponse build() {
            return new ListNotebookInstanceLifecycleConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
