/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Docker container for the model package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelPackageContainerDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelPackageContainerDefinition.Builder, ModelPackageContainerDefinition> {
    private static final SdkField<String> CONTAINER_HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelPackageContainerDefinition::containerHostname)).setter(setter(Builder::containerHostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerHostname").build()).build();

    private static final SdkField<String> IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelPackageContainerDefinition::image)).setter(setter(Builder::image))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()).build();

    private static final SdkField<String> IMAGE_DIGEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelPackageContainerDefinition::imageDigest)).setter(setter(Builder::imageDigest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageDigest").build()).build();

    private static final SdkField<String> MODEL_DATA_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelPackageContainerDefinition::modelDataUrl)).setter(setter(Builder::modelDataUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDataUrl").build()).build();

    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelPackageContainerDefinition::productId)).setter(setter(Builder::productId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_HOSTNAME_FIELD,
            IMAGE_FIELD, IMAGE_DIGEST_FIELD, MODEL_DATA_URL_FIELD, PRODUCT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String containerHostname;

    private final String image;

    private final String imageDigest;

    private final String modelDataUrl;

    private final String productId;

    private ModelPackageContainerDefinition(BuilderImpl builder) {
        this.containerHostname = builder.containerHostname;
        this.image = builder.image;
        this.imageDigest = builder.imageDigest;
        this.modelDataUrl = builder.modelDataUrl;
        this.productId = builder.productId;
    }

    /**
     * <p>
     * The DNS host name for the Docker container.
     * </p>
     * 
     * @return The DNS host name for the Docker container.
     */
    public String containerHostname() {
        return containerHostname;
    }

    /**
     * <p>
     * The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.
     * </p>
     * <p>
     * If you are using your own custom algorithm instead of an algorithm provided by Amazon SageMaker, the inference
     * code must meet Amazon SageMaker requirements. Amazon SageMaker supports both
     * <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code> image path formats. For more
     * information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own
     * Algorithms with Amazon SageMaker</a>.
     * </p>
     * 
     * @return The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.</p>
     *         <p>
     *         If you are using your own custom algorithm instead of an algorithm provided by Amazon SageMaker, the
     *         inference code must meet Amazon SageMaker requirements. Amazon SageMaker supports both
     *         <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code> image path formats.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms
     *         with Amazon SageMaker</a>.
     */
    public String image() {
        return image;
    }

    /**
     * <p>
     * An MD5 hash of the training algorithm that identifies the Docker image used for training.
     * </p>
     * 
     * @return An MD5 hash of the training algorithm that identifies the Docker image used for training.
     */
    public String imageDigest() {
        return imageDigest;
    }

    /**
     * <p>
     * The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must point
     * to a single <code>gzip</code> compressed tar archive (<code>.tar.gz</code> suffix).
     * </p>
     * 
     * @return The Amazon S3 path where the model artifacts, which result from model training, are stored. This path
     *         must point to a single <code>gzip</code> compressed tar archive (<code>.tar.gz</code> suffix).
     */
    public String modelDataUrl() {
        return modelDataUrl;
    }

    /**
     * <p>
     * The AWS Marketplace product ID of the model package.
     * </p>
     * 
     * @return The AWS Marketplace product ID of the model package.
     */
    public String productId() {
        return productId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerHostname());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(imageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(modelDataUrl());
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackageContainerDefinition)) {
            return false;
        }
        ModelPackageContainerDefinition other = (ModelPackageContainerDefinition) obj;
        return Objects.equals(containerHostname(), other.containerHostname()) && Objects.equals(image(), other.image())
                && Objects.equals(imageDigest(), other.imageDigest()) && Objects.equals(modelDataUrl(), other.modelDataUrl())
                && Objects.equals(productId(), other.productId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModelPackageContainerDefinition").add("ContainerHostname", containerHostname())
                .add("Image", image()).add("ImageDigest", imageDigest()).add("ModelDataUrl", modelDataUrl())
                .add("ProductId", productId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerHostname":
            return Optional.ofNullable(clazz.cast(containerHostname()));
        case "Image":
            return Optional.ofNullable(clazz.cast(image()));
        case "ImageDigest":
            return Optional.ofNullable(clazz.cast(imageDigest()));
        case "ModelDataUrl":
            return Optional.ofNullable(clazz.cast(modelDataUrl()));
        case "ProductId":
            return Optional.ofNullable(clazz.cast(productId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelPackageContainerDefinition, T> g) {
        return obj -> g.apply((ModelPackageContainerDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelPackageContainerDefinition> {
        /**
         * <p>
         * The DNS host name for the Docker container.
         * </p>
         * 
         * @param containerHostname
         *        The DNS host name for the Docker container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerHostname(String containerHostname);

        /**
         * <p>
         * The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.
         * </p>
         * <p>
         * If you are using your own custom algorithm instead of an algorithm provided by Amazon SageMaker, the
         * inference code must meet Amazon SageMaker requirements. Amazon SageMaker supports both
         * <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code> image path formats. For
         * more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using
         * Your Own Algorithms with Amazon SageMaker</a>.
         * </p>
         * 
         * @param image
         *        The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.</p>
         *        <p>
         *        If you are using your own custom algorithm instead of an algorithm provided by Amazon SageMaker, the
         *        inference code must meet Amazon SageMaker requirements. Amazon SageMaker supports both
         *        <code>registry/repository[:tag]</code> and <code>registry/repository[@digest]</code> image path
         *        formats. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms
         *        with Amazon SageMaker</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(String image);

        /**
         * <p>
         * An MD5 hash of the training algorithm that identifies the Docker image used for training.
         * </p>
         * 
         * @param imageDigest
         *        An MD5 hash of the training algorithm that identifies the Docker image used for training.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageDigest(String imageDigest);

        /**
         * <p>
         * The Amazon S3 path where the model artifacts, which result from model training, are stored. This path must
         * point to a single <code>gzip</code> compressed tar archive (<code>.tar.gz</code> suffix).
         * </p>
         * 
         * @param modelDataUrl
         *        The Amazon S3 path where the model artifacts, which result from model training, are stored. This path
         *        must point to a single <code>gzip</code> compressed tar archive (<code>.tar.gz</code> suffix).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelDataUrl(String modelDataUrl);

        /**
         * <p>
         * The AWS Marketplace product ID of the model package.
         * </p>
         * 
         * @param productId
         *        The AWS Marketplace product ID of the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(String productId);
    }

    static final class BuilderImpl implements Builder {
        private String containerHostname;

        private String image;

        private String imageDigest;

        private String modelDataUrl;

        private String productId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackageContainerDefinition model) {
            containerHostname(model.containerHostname);
            image(model.image);
            imageDigest(model.imageDigest);
            modelDataUrl(model.modelDataUrl);
            productId(model.productId);
        }

        public final String getContainerHostname() {
            return containerHostname;
        }

        @Override
        public final Builder containerHostname(String containerHostname) {
            this.containerHostname = containerHostname;
            return this;
        }

        public final void setContainerHostname(String containerHostname) {
            this.containerHostname = containerHostname;
        }

        public final String getImage() {
            return image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        public final String getImageDigest() {
            return imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        public final String getModelDataUrl() {
            return modelDataUrl;
        }

        @Override
        public final Builder modelDataUrl(String modelDataUrl) {
            this.modelDataUrl = modelDataUrl;
            return this;
        }

        public final void setModelDataUrl(String modelDataUrl) {
            this.modelDataUrl = modelDataUrl;
        }

        public final String getProductId() {
            return productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public ModelPackageContainerDefinition build() {
            return new ModelPackageContainerDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
