/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the output location for the compiled model and the device (target) that the model runs on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputConfig implements SdkPojo, Serializable, ToCopyableBuilder<OutputConfig.Builder, OutputConfig> {
    private static final SdkField<String> S3_OUTPUT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OutputConfig::s3OutputLocation)).setter(setter(Builder::s3OutputLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputLocation").build()).build();

    private static final SdkField<String> TARGET_DEVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OutputConfig::targetDeviceAsString)).setter(setter(Builder::targetDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDevice").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OUTPUT_LOCATION_FIELD,
            TARGET_DEVICE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3OutputLocation;

    private final String targetDevice;

    private OutputConfig(BuilderImpl builder) {
        this.s3OutputLocation = builder.s3OutputLocation;
        this.targetDevice = builder.targetDevice;
    }

    /**
     * <p>
     * Identifies the S3 path where you want Amazon SageMaker to store the model artifacts. For example,
     * s3://bucket-name/key-name-prefix.
     * </p>
     * 
     * @return Identifies the S3 path where you want Amazon SageMaker to store the model artifacts. For example,
     *         s3://bucket-name/key-name-prefix.
     */
    public String s3OutputLocation() {
        return s3OutputLocation;
    }

    /**
     * <p>
     * Identifies the device that you want to run your model on after it has been compiled. For example: ml_c5.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetDevice} will
     * return {@link TargetDevice#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetDeviceAsString}.
     * </p>
     * 
     * @return Identifies the device that you want to run your model on after it has been compiled. For example: ml_c5.
     * @see TargetDevice
     */
    public TargetDevice targetDevice() {
        return TargetDevice.fromValue(targetDevice);
    }

    /**
     * <p>
     * Identifies the device that you want to run your model on after it has been compiled. For example: ml_c5.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetDevice} will
     * return {@link TargetDevice#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetDeviceAsString}.
     * </p>
     * 
     * @return Identifies the device that you want to run your model on after it has been compiled. For example: ml_c5.
     * @see TargetDevice
     */
    public String targetDeviceAsString() {
        return targetDevice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(targetDeviceAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputConfig)) {
            return false;
        }
        OutputConfig other = (OutputConfig) obj;
        return Objects.equals(s3OutputLocation(), other.s3OutputLocation())
                && Objects.equals(targetDeviceAsString(), other.targetDeviceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OutputConfig").add("S3OutputLocation", s3OutputLocation())
                .add("TargetDevice", targetDeviceAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3OutputLocation":
            return Optional.ofNullable(clazz.cast(s3OutputLocation()));
        case "TargetDevice":
            return Optional.ofNullable(clazz.cast(targetDeviceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputConfig, T> g) {
        return obj -> g.apply((OutputConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputConfig> {
        /**
         * <p>
         * Identifies the S3 path where you want Amazon SageMaker to store the model artifacts. For example,
         * s3://bucket-name/key-name-prefix.
         * </p>
         * 
         * @param s3OutputLocation
         *        Identifies the S3 path where you want Amazon SageMaker to store the model artifacts. For example,
         *        s3://bucket-name/key-name-prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputLocation(String s3OutputLocation);

        /**
         * <p>
         * Identifies the device that you want to run your model on after it has been compiled. For example: ml_c5.
         * </p>
         * 
         * @param targetDevice
         *        Identifies the device that you want to run your model on after it has been compiled. For example:
         *        ml_c5.
         * @see TargetDevice
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetDevice
         */
        Builder targetDevice(String targetDevice);

        /**
         * <p>
         * Identifies the device that you want to run your model on after it has been compiled. For example: ml_c5.
         * </p>
         * 
         * @param targetDevice
         *        Identifies the device that you want to run your model on after it has been compiled. For example:
         *        ml_c5.
         * @see TargetDevice
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetDevice
         */
        Builder targetDevice(TargetDevice targetDevice);
    }

    static final class BuilderImpl implements Builder {
        private String s3OutputLocation;

        private String targetDevice;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputConfig model) {
            s3OutputLocation(model.s3OutputLocation);
            targetDevice(model.targetDevice);
        }

        public final String getS3OutputLocation() {
            return s3OutputLocation;
        }

        @Override
        public final Builder s3OutputLocation(String s3OutputLocation) {
            this.s3OutputLocation = s3OutputLocation;
            return this;
        }

        public final void setS3OutputLocation(String s3OutputLocation) {
            this.s3OutputLocation = s3OutputLocation;
        }

        public final String getTargetDeviceAsString() {
            return targetDevice;
        }

        @Override
        public final Builder targetDevice(String targetDevice) {
            this.targetDevice = targetDevice;
            return this;
        }

        @Override
        public final Builder targetDevice(TargetDevice targetDevice) {
            this.targetDevice(targetDevice == null ? null : targetDevice.toString());
            return this;
        }

        public final void setTargetDevice(String targetDevice) {
            this.targetDevice = targetDevice;
        }

        @Override
        public OutputConfig build() {
            return new OutputConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
