/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a work team of a vendor that does the a labelling job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubscribedWorkteam implements SdkPojo, Serializable,
        ToCopyableBuilder<SubscribedWorkteam.Builder, SubscribedWorkteam> {
    private static final SdkField<String> WORKTEAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SubscribedWorkteam::workteamArn)).setter(setter(Builder::workteamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkteamArn").build()).build();

    private static final SdkField<String> MARKETPLACE_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SubscribedWorkteam::marketplaceTitle)).setter(setter(Builder::marketplaceTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarketplaceTitle").build()).build();

    private static final SdkField<String> SELLER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SubscribedWorkteam::sellerName)).setter(setter(Builder::sellerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SellerName").build()).build();

    private static final SdkField<String> MARKETPLACE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SubscribedWorkteam::marketplaceDescription)).setter(setter(Builder::marketplaceDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarketplaceDescription").build())
            .build();

    private static final SdkField<String> LISTING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SubscribedWorkteam::listingId)).setter(setter(Builder::listingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListingId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKTEAM_ARN_FIELD,
            MARKETPLACE_TITLE_FIELD, SELLER_NAME_FIELD, MARKETPLACE_DESCRIPTION_FIELD, LISTING_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String workteamArn;

    private final String marketplaceTitle;

    private final String sellerName;

    private final String marketplaceDescription;

    private final String listingId;

    private SubscribedWorkteam(BuilderImpl builder) {
        this.workteamArn = builder.workteamArn;
        this.marketplaceTitle = builder.marketplaceTitle;
        this.sellerName = builder.sellerName;
        this.marketplaceDescription = builder.marketplaceDescription;
        this.listingId = builder.listingId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the vendor that you have subscribed.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the vendor that you have subscribed.
     */
    public String workteamArn() {
        return workteamArn;
    }

    /**
     * <p>
     * The title of the service provided by the vendor in the Amazon Marketplace.
     * </p>
     * 
     * @return The title of the service provided by the vendor in the Amazon Marketplace.
     */
    public String marketplaceTitle() {
        return marketplaceTitle;
    }

    /**
     * <p>
     * The name of the vendor in the Amazon Marketplace.
     * </p>
     * 
     * @return The name of the vendor in the Amazon Marketplace.
     */
    public String sellerName() {
        return sellerName;
    }

    /**
     * <p>
     * The description of the vendor from the Amazon Marketplace.
     * </p>
     * 
     * @return The description of the vendor from the Amazon Marketplace.
     */
    public String marketplaceDescription() {
        return marketplaceDescription;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public String listingId() {
        return listingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workteamArn());
        hashCode = 31 * hashCode + Objects.hashCode(marketplaceTitle());
        hashCode = 31 * hashCode + Objects.hashCode(sellerName());
        hashCode = 31 * hashCode + Objects.hashCode(marketplaceDescription());
        hashCode = 31 * hashCode + Objects.hashCode(listingId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribedWorkteam)) {
            return false;
        }
        SubscribedWorkteam other = (SubscribedWorkteam) obj;
        return Objects.equals(workteamArn(), other.workteamArn()) && Objects.equals(marketplaceTitle(), other.marketplaceTitle())
                && Objects.equals(sellerName(), other.sellerName())
                && Objects.equals(marketplaceDescription(), other.marketplaceDescription())
                && Objects.equals(listingId(), other.listingId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SubscribedWorkteam").add("WorkteamArn", workteamArn())
                .add("MarketplaceTitle", marketplaceTitle()).add("SellerName", sellerName())
                .add("MarketplaceDescription", marketplaceDescription()).add("ListingId", listingId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkteamArn":
            return Optional.ofNullable(clazz.cast(workteamArn()));
        case "MarketplaceTitle":
            return Optional.ofNullable(clazz.cast(marketplaceTitle()));
        case "SellerName":
            return Optional.ofNullable(clazz.cast(sellerName()));
        case "MarketplaceDescription":
            return Optional.ofNullable(clazz.cast(marketplaceDescription()));
        case "ListingId":
            return Optional.ofNullable(clazz.cast(listingId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubscribedWorkteam, T> g) {
        return obj -> g.apply((SubscribedWorkteam) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubscribedWorkteam> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the vendor that you have subscribed.
         * </p>
         * 
         * @param workteamArn
         *        The Amazon Resource Name (ARN) of the vendor that you have subscribed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workteamArn(String workteamArn);

        /**
         * <p>
         * The title of the service provided by the vendor in the Amazon Marketplace.
         * </p>
         * 
         * @param marketplaceTitle
         *        The title of the service provided by the vendor in the Amazon Marketplace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marketplaceTitle(String marketplaceTitle);

        /**
         * <p>
         * The name of the vendor in the Amazon Marketplace.
         * </p>
         * 
         * @param sellerName
         *        The name of the vendor in the Amazon Marketplace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sellerName(String sellerName);

        /**
         * <p>
         * The description of the vendor from the Amazon Marketplace.
         * </p>
         * 
         * @param marketplaceDescription
         *        The description of the vendor from the Amazon Marketplace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marketplaceDescription(String marketplaceDescription);

        /**
         * <p/>
         * 
         * @param listingId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listingId(String listingId);
    }

    static final class BuilderImpl implements Builder {
        private String workteamArn;

        private String marketplaceTitle;

        private String sellerName;

        private String marketplaceDescription;

        private String listingId;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribedWorkteam model) {
            workteamArn(model.workteamArn);
            marketplaceTitle(model.marketplaceTitle);
            sellerName(model.sellerName);
            marketplaceDescription(model.marketplaceDescription);
            listingId(model.listingId);
        }

        public final String getWorkteamArn() {
            return workteamArn;
        }

        @Override
        public final Builder workteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
            return this;
        }

        public final void setWorkteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
        }

        public final String getMarketplaceTitle() {
            return marketplaceTitle;
        }

        @Override
        public final Builder marketplaceTitle(String marketplaceTitle) {
            this.marketplaceTitle = marketplaceTitle;
            return this;
        }

        public final void setMarketplaceTitle(String marketplaceTitle) {
            this.marketplaceTitle = marketplaceTitle;
        }

        public final String getSellerName() {
            return sellerName;
        }

        @Override
        public final Builder sellerName(String sellerName) {
            this.sellerName = sellerName;
            return this;
        }

        public final void setSellerName(String sellerName) {
            this.sellerName = sellerName;
        }

        public final String getMarketplaceDescription() {
            return marketplaceDescription;
        }

        @Override
        public final Builder marketplaceDescription(String marketplaceDescription) {
            this.marketplaceDescription = marketplaceDescription;
            return this;
        }

        public final void setMarketplaceDescription(String marketplaceDescription) {
            this.marketplaceDescription = marketplaceDescription;
        }

        public final String getListingId() {
            return listingId;
        }

        @Override
        public final Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public final void setListingId(String listingId) {
            this.listingId = listingId;
        }

        @Override
        public SubscribedWorkteam build() {
            return new SubscribedWorkteam(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
