/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCodeRepositoriesResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListCodeRepositoriesResponse.Builder, ListCodeRepositoriesResponse> {
    private static final SdkField<List<CodeRepositorySummary>> CODE_REPOSITORY_SUMMARY_LIST_FIELD = SdkField
            .<List<CodeRepositorySummary>> builder(MarshallingType.LIST)
            .getter(getter(ListCodeRepositoriesResponse::codeRepositorySummaryList))
            .setter(setter(Builder::codeRepositorySummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeRepositorySummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CodeRepositorySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CodeRepositorySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCodeRepositoriesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CODE_REPOSITORY_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<CodeRepositorySummary> codeRepositorySummaryList;

    private final String nextToken;

    private ListCodeRepositoriesResponse(BuilderImpl builder) {
        super(builder);
        this.codeRepositorySummaryList = builder.codeRepositorySummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the CodeRepositorySummaryList property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCodeRepositorySummaryList() {
        return codeRepositorySummaryList != null && !(codeRepositorySummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Gets a list of summaries of the Git repositories. Each summary specifies the following values for the repository:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Name
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Resource Name (ARN)
     * </p>
     * </li>
     * <li>
     * <p>
     * Creation time
     * </p>
     * </li>
     * <li>
     * <p>
     * Last modified time
     * </p>
     * </li>
     * <li>
     * <p>
     * Configuration information, including the URL location of the repository and the ARN of the AWS Secrets Manager
     * secret that contains the credentials used to access the repository.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCodeRepositorySummaryList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Gets a list of summaries of the Git repositories. Each summary specifies the following values for the
     *         repository: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Name
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Resource Name (ARN)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Creation time
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Last modified time
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Configuration information, including the URL location of the repository and the ARN of the AWS Secrets
     *         Manager secret that contains the credentials used to access the repository.
     *         </p>
     *         </li>
     */
    public List<CodeRepositorySummary> codeRepositorySummaryList() {
        return codeRepositorySummaryList;
    }

    /**
     * <p>
     * If the result of a <code>ListCodeRepositoriesOutput</code> request was truncated, the response includes a
     * <code>NextToken</code>. To get the next set of Git repositories, use the token in the next request.
     * </p>
     * 
     * @return If the result of a <code>ListCodeRepositoriesOutput</code> request was truncated, the response includes a
     *         <code>NextToken</code>. To get the next set of Git repositories, use the token in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeRepositorySummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCodeRepositoriesResponse)) {
            return false;
        }
        ListCodeRepositoriesResponse other = (ListCodeRepositoriesResponse) obj;
        return Objects.equals(codeRepositorySummaryList(), other.codeRepositorySummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListCodeRepositoriesResponse").add("CodeRepositorySummaryList", codeRepositorySummaryList())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeRepositorySummaryList":
            return Optional.ofNullable(clazz.cast(codeRepositorySummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCodeRepositoriesResponse, T> g) {
        return obj -> g.apply((ListCodeRepositoriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCodeRepositoriesResponse> {
        /**
         * <p>
         * Gets a list of summaries of the Git repositories. Each summary specifies the following values for the
         * repository:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Name
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Resource Name (ARN)
         * </p>
         * </li>
         * <li>
         * <p>
         * Creation time
         * </p>
         * </li>
         * <li>
         * <p>
         * Last modified time
         * </p>
         * </li>
         * <li>
         * <p>
         * Configuration information, including the URL location of the repository and the ARN of the AWS Secrets
         * Manager secret that contains the credentials used to access the repository.
         * </p>
         * </li>
         * </ul>
         * 
         * @param codeRepositorySummaryList
         *        Gets a list of summaries of the Git repositories. Each summary specifies the following values for the
         *        repository: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Name
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Resource Name (ARN)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Creation time
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Last modified time
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Configuration information, including the URL location of the repository and the ARN of the AWS Secrets
         *        Manager secret that contains the credentials used to access the repository.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeRepositorySummaryList(Collection<CodeRepositorySummary> codeRepositorySummaryList);

        /**
         * <p>
         * Gets a list of summaries of the Git repositories. Each summary specifies the following values for the
         * repository:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Name
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Resource Name (ARN)
         * </p>
         * </li>
         * <li>
         * <p>
         * Creation time
         * </p>
         * </li>
         * <li>
         * <p>
         * Last modified time
         * </p>
         * </li>
         * <li>
         * <p>
         * Configuration information, including the URL location of the repository and the ARN of the AWS Secrets
         * Manager secret that contains the credentials used to access the repository.
         * </p>
         * </li>
         * </ul>
         * 
         * @param codeRepositorySummaryList
         *        Gets a list of summaries of the Git repositories. Each summary specifies the following values for the
         *        repository: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Name
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Amazon Resource Name (ARN)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Creation time
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Last modified time
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Configuration information, including the URL location of the repository and the ARN of the AWS Secrets
         *        Manager secret that contains the credentials used to access the repository.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeRepositorySummaryList(CodeRepositorySummary... codeRepositorySummaryList);

        /**
         * <p>
         * Gets a list of summaries of the Git repositories. Each summary specifies the following values for the
         * repository:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Name
         * </p>
         * </li>
         * <li>
         * <p>
         * Amazon Resource Name (ARN)
         * </p>
         * </li>
         * <li>
         * <p>
         * Creation time
         * </p>
         * </li>
         * <li>
         * <p>
         * Last modified time
         * </p>
         * </li>
         * <li>
         * <p>
         * Configuration information, including the URL location of the repository and the ARN of the AWS Secrets
         * Manager secret that contains the credentials used to access the repository.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<CodeRepositorySummary>.Builder} avoiding
         * the need to create one manually via {@link List<CodeRepositorySummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CodeRepositorySummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #codeRepositorySummaryList(List<CodeRepositorySummary>)}.
         * 
         * @param codeRepositorySummaryList
         *        a consumer that will call methods on {@link List<CodeRepositorySummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeRepositorySummaryList(List<CodeRepositorySummary>)
         */
        Builder codeRepositorySummaryList(Consumer<CodeRepositorySummary.Builder>... codeRepositorySummaryList);

        /**
         * <p>
         * If the result of a <code>ListCodeRepositoriesOutput</code> request was truncated, the response includes a
         * <code>NextToken</code>. To get the next set of Git repositories, use the token in the next request.
         * </p>
         * 
         * @param nextToken
         *        If the result of a <code>ListCodeRepositoriesOutput</code> request was truncated, the response
         *        includes a <code>NextToken</code>. To get the next set of Git repositories, use the token in the next
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<CodeRepositorySummary> codeRepositorySummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCodeRepositoriesResponse model) {
            super(model);
            codeRepositorySummaryList(model.codeRepositorySummaryList);
            nextToken(model.nextToken);
        }

        public final Collection<CodeRepositorySummary.Builder> getCodeRepositorySummaryList() {
            return codeRepositorySummaryList != null ? codeRepositorySummaryList.stream().map(CodeRepositorySummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder codeRepositorySummaryList(Collection<CodeRepositorySummary> codeRepositorySummaryList) {
            this.codeRepositorySummaryList = CodeRepositorySummaryListCopier.copy(codeRepositorySummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeRepositorySummaryList(CodeRepositorySummary... codeRepositorySummaryList) {
            codeRepositorySummaryList(Arrays.asList(codeRepositorySummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeRepositorySummaryList(Consumer<CodeRepositorySummary.Builder>... codeRepositorySummaryList) {
            codeRepositorySummaryList(Stream.of(codeRepositorySummaryList)
                    .map(c -> CodeRepositorySummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCodeRepositorySummaryList(Collection<CodeRepositorySummary.BuilderImpl> codeRepositorySummaryList) {
            this.codeRepositorySummaryList = CodeRepositorySummaryListCopier.copyFromBuilder(codeRepositorySummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCodeRepositoriesResponse build() {
            return new ListCodeRepositoriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
