/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The inputs for a processing job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProcessingInput implements SdkPojo, Serializable, ToCopyableBuilder<ProcessingInput.Builder, ProcessingInput> {
    private static final SdkField<String> INPUT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProcessingInput::inputName)).setter(setter(Builder::inputName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputName").build()).build();

    private static final SdkField<ProcessingS3Input> S3_INPUT_FIELD = SdkField
            .<ProcessingS3Input> builder(MarshallingType.SDK_POJO).getter(getter(ProcessingInput::s3Input))
            .setter(setter(Builder::s3Input)).constructor(ProcessingS3Input::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Input").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_NAME_FIELD,
            S3_INPUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inputName;

    private final ProcessingS3Input s3Input;

    private ProcessingInput(BuilderImpl builder) {
        this.inputName = builder.inputName;
        this.s3Input = builder.s3Input;
    }

    /**
     * <p>
     * The name of the inputs for the processing job.
     * </p>
     * 
     * @return The name of the inputs for the processing job.
     */
    public String inputName() {
        return inputName;
    }

    /**
     * <p>
     * The S3 inputs for the processing job.
     * </p>
     * 
     * @return The S3 inputs for the processing job.
     */
    public ProcessingS3Input s3Input() {
        return s3Input;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputName());
        hashCode = 31 * hashCode + Objects.hashCode(s3Input());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessingInput)) {
            return false;
        }
        ProcessingInput other = (ProcessingInput) obj;
        return Objects.equals(inputName(), other.inputName()) && Objects.equals(s3Input(), other.s3Input());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProcessingInput").add("InputName", inputName()).add("S3Input", s3Input()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputName":
            return Optional.ofNullable(clazz.cast(inputName()));
        case "S3Input":
            return Optional.ofNullable(clazz.cast(s3Input()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProcessingInput, T> g) {
        return obj -> g.apply((ProcessingInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProcessingInput> {
        /**
         * <p>
         * The name of the inputs for the processing job.
         * </p>
         * 
         * @param inputName
         *        The name of the inputs for the processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputName(String inputName);

        /**
         * <p>
         * The S3 inputs for the processing job.
         * </p>
         * 
         * @param s3Input
         *        The S3 inputs for the processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Input(ProcessingS3Input s3Input);

        /**
         * <p>
         * The S3 inputs for the processing job.
         * </p>
         * This is a convenience that creates an instance of the {@link ProcessingS3Input.Builder} avoiding the need to
         * create one manually via {@link ProcessingS3Input#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProcessingS3Input.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Input(ProcessingS3Input)}.
         * 
         * @param s3Input
         *        a consumer that will call methods on {@link ProcessingS3Input.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Input(ProcessingS3Input)
         */
        default Builder s3Input(Consumer<ProcessingS3Input.Builder> s3Input) {
            return s3Input(ProcessingS3Input.builder().applyMutation(s3Input).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String inputName;

        private ProcessingS3Input s3Input;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessingInput model) {
            inputName(model.inputName);
            s3Input(model.s3Input);
        }

        public final String getInputName() {
            return inputName;
        }

        @Override
        public final Builder inputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public final void setInputName(String inputName) {
            this.inputName = inputName;
        }

        public final ProcessingS3Input.Builder getS3Input() {
            return s3Input != null ? s3Input.toBuilder() : null;
        }

        @Override
        public final Builder s3Input(ProcessingS3Input s3Input) {
            this.s3Input = s3Input;
            return this;
        }

        public final void setS3Input(ProcessingS3Input.BuilderImpl s3Input) {
            this.s3Input = s3Input != null ? s3Input.build() : null;
        }

        @Override
        public ProcessingInput build() {
            return new ProcessingInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
