/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHumanTaskUisResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListHumanTaskUisResponse.Builder, ListHumanTaskUisResponse> {
    private static final SdkField<List<HumanTaskUiSummary>> HUMAN_TASK_UI_SUMMARIES_FIELD = SdkField
            .<List<HumanTaskUiSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListHumanTaskUisResponse::humanTaskUiSummaries))
            .setter(setter(Builder::humanTaskUiSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanTaskUiSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HumanTaskUiSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(HumanTaskUiSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListHumanTaskUisResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_TASK_UI_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<HumanTaskUiSummary> humanTaskUiSummaries;

    private final String nextToken;

    private ListHumanTaskUisResponse(BuilderImpl builder) {
        super(builder);
        this.humanTaskUiSummaries = builder.humanTaskUiSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the HumanTaskUiSummaries property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasHumanTaskUiSummaries() {
        return humanTaskUiSummaries != null && !(humanTaskUiSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects describing the human task user interfaces.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHumanTaskUiSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects describing the human task user interfaces.
     */
    public List<HumanTaskUiSummary> humanTaskUiSummaries() {
        return humanTaskUiSummaries;
    }

    /**
     * <p>
     * A token to resume pagination.
     * </p>
     * 
     * @return A token to resume pagination.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(humanTaskUiSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHumanTaskUisResponse)) {
            return false;
        }
        ListHumanTaskUisResponse other = (ListHumanTaskUisResponse) obj;
        return Objects.equals(humanTaskUiSummaries(), other.humanTaskUiSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListHumanTaskUisResponse").add("HumanTaskUiSummaries", humanTaskUiSummaries())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HumanTaskUiSummaries":
            return Optional.ofNullable(clazz.cast(humanTaskUiSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHumanTaskUisResponse, T> g) {
        return obj -> g.apply((ListHumanTaskUisResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListHumanTaskUisResponse> {
        /**
         * <p>
         * An array of objects describing the human task user interfaces.
         * </p>
         * 
         * @param humanTaskUiSummaries
         *        An array of objects describing the human task user interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanTaskUiSummaries(Collection<HumanTaskUiSummary> humanTaskUiSummaries);

        /**
         * <p>
         * An array of objects describing the human task user interfaces.
         * </p>
         * 
         * @param humanTaskUiSummaries
         *        An array of objects describing the human task user interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanTaskUiSummaries(HumanTaskUiSummary... humanTaskUiSummaries);

        /**
         * <p>
         * An array of objects describing the human task user interfaces.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HumanTaskUiSummary>.Builder} avoiding the
         * need to create one manually via {@link List<HumanTaskUiSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HumanTaskUiSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #humanTaskUiSummaries(List<HumanTaskUiSummary>)}.
         * 
         * @param humanTaskUiSummaries
         *        a consumer that will call methods on {@link List<HumanTaskUiSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #humanTaskUiSummaries(List<HumanTaskUiSummary>)
         */
        Builder humanTaskUiSummaries(Consumer<HumanTaskUiSummary.Builder>... humanTaskUiSummaries);

        /**
         * <p>
         * A token to resume pagination.
         * </p>
         * 
         * @param nextToken
         *        A token to resume pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<HumanTaskUiSummary> humanTaskUiSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHumanTaskUisResponse model) {
            super(model);
            humanTaskUiSummaries(model.humanTaskUiSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<HumanTaskUiSummary.Builder> getHumanTaskUiSummaries() {
            return humanTaskUiSummaries != null ? humanTaskUiSummaries.stream().map(HumanTaskUiSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder humanTaskUiSummaries(Collection<HumanTaskUiSummary> humanTaskUiSummaries) {
            this.humanTaskUiSummaries = HumanTaskUiSummariesCopier.copy(humanTaskUiSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder humanTaskUiSummaries(HumanTaskUiSummary... humanTaskUiSummaries) {
            humanTaskUiSummaries(Arrays.asList(humanTaskUiSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder humanTaskUiSummaries(Consumer<HumanTaskUiSummary.Builder>... humanTaskUiSummaries) {
            humanTaskUiSummaries(Stream.of(humanTaskUiSummaries).map(c -> HumanTaskUiSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setHumanTaskUiSummaries(Collection<HumanTaskUiSummary.BuilderImpl> humanTaskUiSummaries) {
            this.humanTaskUiSummaries = HumanTaskUiSummariesCopier.copyFromBuilder(humanTaskUiSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListHumanTaskUisResponse build() {
            return new ListHumanTaskUisResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
