/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMonitoringScheduleResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeMonitoringScheduleResponse.Builder, DescribeMonitoringScheduleResponse> {
    private static final SdkField<String> MONITORING_SCHEDULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMonitoringScheduleResponse::monitoringScheduleArn))
            .setter(setter(Builder::monitoringScheduleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleArn").build())
            .build();

    private static final SdkField<String> MONITORING_SCHEDULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMonitoringScheduleResponse::monitoringScheduleName))
            .setter(setter(Builder::monitoringScheduleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleName").build())
            .build();

    private static final SdkField<String> MONITORING_SCHEDULE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMonitoringScheduleResponse::monitoringScheduleStatusAsString))
            .setter(setter(Builder::monitoringScheduleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleStatus").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMonitoringScheduleResponse::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeMonitoringScheduleResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeMonitoringScheduleResponse::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<MonitoringScheduleConfig> MONITORING_SCHEDULE_CONFIG_FIELD = SdkField
            .<MonitoringScheduleConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeMonitoringScheduleResponse::monitoringScheduleConfig))
            .setter(setter(Builder::monitoringScheduleConfig)).constructor(MonitoringScheduleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleConfig").build())
            .build();

    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMonitoringScheduleResponse::endpointName)).setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<MonitoringExecutionSummary> LAST_MONITORING_EXECUTION_SUMMARY_FIELD = SdkField
            .<MonitoringExecutionSummary> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeMonitoringScheduleResponse::lastMonitoringExecutionSummary))
            .setter(setter(Builder::lastMonitoringExecutionSummary))
            .constructor(MonitoringExecutionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastMonitoringExecutionSummary")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORING_SCHEDULE_ARN_FIELD,
            MONITORING_SCHEDULE_NAME_FIELD, MONITORING_SCHEDULE_STATUS_FIELD, FAILURE_REASON_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD, MONITORING_SCHEDULE_CONFIG_FIELD, ENDPOINT_NAME_FIELD,
            LAST_MONITORING_EXECUTION_SUMMARY_FIELD));

    private final String monitoringScheduleArn;

    private final String monitoringScheduleName;

    private final String monitoringScheduleStatus;

    private final String failureReason;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final MonitoringScheduleConfig monitoringScheduleConfig;

    private final String endpointName;

    private final MonitoringExecutionSummary lastMonitoringExecutionSummary;

    private DescribeMonitoringScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.monitoringScheduleArn = builder.monitoringScheduleArn;
        this.monitoringScheduleName = builder.monitoringScheduleName;
        this.monitoringScheduleStatus = builder.monitoringScheduleStatus;
        this.failureReason = builder.failureReason;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.monitoringScheduleConfig = builder.monitoringScheduleConfig;
        this.endpointName = builder.endpointName;
        this.lastMonitoringExecutionSummary = builder.lastMonitoringExecutionSummary;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the monitoring schedule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the monitoring schedule.
     */
    public String monitoringScheduleArn() {
        return monitoringScheduleArn;
    }

    /**
     * <p>
     * Name of the monitoring schedule.
     * </p>
     * 
     * @return Name of the monitoring schedule.
     */
    public String monitoringScheduleName() {
        return monitoringScheduleName;
    }

    /**
     * <p>
     * The status of an monitoring job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #monitoringScheduleStatus} will return {@link ScheduleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #monitoringScheduleStatusAsString}.
     * </p>
     * 
     * @return The status of an monitoring job.
     * @see ScheduleStatus
     */
    public ScheduleStatus monitoringScheduleStatus() {
        return ScheduleStatus.fromValue(monitoringScheduleStatus);
    }

    /**
     * <p>
     * The status of an monitoring job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #monitoringScheduleStatus} will return {@link ScheduleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #monitoringScheduleStatusAsString}.
     * </p>
     * 
     * @return The status of an monitoring job.
     * @see ScheduleStatus
     */
    public String monitoringScheduleStatusAsString() {
        return monitoringScheduleStatus;
    }

    /**
     * <p>
     * A string, up to one KB in size, that contains the reason a monitoring job failed, if it failed.
     * </p>
     * 
     * @return A string, up to one KB in size, that contains the reason a monitoring job failed, if it failed.
     */
    public String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The time at which the monitoring job was created.
     * </p>
     * 
     * @return The time at which the monitoring job was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time at which the monitoring job was last modified.
     * </p>
     * 
     * @return The time at which the monitoring job was last modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The configuration object that specifies the monitoring schedule and defines the monitoring job.
     * </p>
     * 
     * @return The configuration object that specifies the monitoring schedule and defines the monitoring job.
     */
    public MonitoringScheduleConfig monitoringScheduleConfig() {
        return monitoringScheduleConfig;
    }

    /**
     * <p>
     * The name of the endpoint for the monitoring job.
     * </p>
     * 
     * @return The name of the endpoint for the monitoring job.
     */
    public String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * Describes metadata on the last execution to run, if there was one.
     * </p>
     * 
     * @return Describes metadata on the last execution to run, if there was one.
     */
    public MonitoringExecutionSummary lastMonitoringExecutionSummary() {
        return lastMonitoringExecutionSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleArn());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleName());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(lastMonitoringExecutionSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMonitoringScheduleResponse)) {
            return false;
        }
        DescribeMonitoringScheduleResponse other = (DescribeMonitoringScheduleResponse) obj;
        return Objects.equals(monitoringScheduleArn(), other.monitoringScheduleArn())
                && Objects.equals(monitoringScheduleName(), other.monitoringScheduleName())
                && Objects.equals(monitoringScheduleStatusAsString(), other.monitoringScheduleStatusAsString())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(monitoringScheduleConfig(), other.monitoringScheduleConfig())
                && Objects.equals(endpointName(), other.endpointName())
                && Objects.equals(lastMonitoringExecutionSummary(), other.lastMonitoringExecutionSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeMonitoringScheduleResponse").add("MonitoringScheduleArn", monitoringScheduleArn())
                .add("MonitoringScheduleName", monitoringScheduleName())
                .add("MonitoringScheduleStatus", monitoringScheduleStatusAsString()).add("FailureReason", failureReason())
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime())
                .add("MonitoringScheduleConfig", monitoringScheduleConfig()).add("EndpointName", endpointName())
                .add("LastMonitoringExecutionSummary", lastMonitoringExecutionSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringScheduleArn":
            return Optional.ofNullable(clazz.cast(monitoringScheduleArn()));
        case "MonitoringScheduleName":
            return Optional.ofNullable(clazz.cast(monitoringScheduleName()));
        case "MonitoringScheduleStatus":
            return Optional.ofNullable(clazz.cast(monitoringScheduleStatusAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "MonitoringScheduleConfig":
            return Optional.ofNullable(clazz.cast(monitoringScheduleConfig()));
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "LastMonitoringExecutionSummary":
            return Optional.ofNullable(clazz.cast(lastMonitoringExecutionSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMonitoringScheduleResponse, T> g) {
        return obj -> g.apply((DescribeMonitoringScheduleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMonitoringScheduleResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the monitoring schedule.
         * </p>
         * 
         * @param monitoringScheduleArn
         *        The Amazon Resource Name (ARN) of the monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleArn(String monitoringScheduleArn);

        /**
         * <p>
         * Name of the monitoring schedule.
         * </p>
         * 
         * @param monitoringScheduleName
         *        Name of the monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleName(String monitoringScheduleName);

        /**
         * <p>
         * The status of an monitoring job.
         * </p>
         * 
         * @param monitoringScheduleStatus
         *        The status of an monitoring job.
         * @see ScheduleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleStatus
         */
        Builder monitoringScheduleStatus(String monitoringScheduleStatus);

        /**
         * <p>
         * The status of an monitoring job.
         * </p>
         * 
         * @param monitoringScheduleStatus
         *        The status of an monitoring job.
         * @see ScheduleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleStatus
         */
        Builder monitoringScheduleStatus(ScheduleStatus monitoringScheduleStatus);

        /**
         * <p>
         * A string, up to one KB in size, that contains the reason a monitoring job failed, if it failed.
         * </p>
         * 
         * @param failureReason
         *        A string, up to one KB in size, that contains the reason a monitoring job failed, if it failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The time at which the monitoring job was created.
         * </p>
         * 
         * @param creationTime
         *        The time at which the monitoring job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time at which the monitoring job was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time at which the monitoring job was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The configuration object that specifies the monitoring schedule and defines the monitoring job.
         * </p>
         * 
         * @param monitoringScheduleConfig
         *        The configuration object that specifies the monitoring schedule and defines the monitoring job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleConfig(MonitoringScheduleConfig monitoringScheduleConfig);

        /**
         * <p>
         * The configuration object that specifies the monitoring schedule and defines the monitoring job.
         * </p>
         * This is a convenience that creates an instance of the {@link MonitoringScheduleConfig.Builder} avoiding the
         * need to create one manually via {@link MonitoringScheduleConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringScheduleConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #monitoringScheduleConfig(MonitoringScheduleConfig)}.
         * 
         * @param monitoringScheduleConfig
         *        a consumer that will call methods on {@link MonitoringScheduleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringScheduleConfig(MonitoringScheduleConfig)
         */
        default Builder monitoringScheduleConfig(Consumer<MonitoringScheduleConfig.Builder> monitoringScheduleConfig) {
            return monitoringScheduleConfig(MonitoringScheduleConfig.builder().applyMutation(monitoringScheduleConfig).build());
        }

        /**
         * <p>
         * The name of the endpoint for the monitoring job.
         * </p>
         * 
         * @param endpointName
         *        The name of the endpoint for the monitoring job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * Describes metadata on the last execution to run, if there was one.
         * </p>
         * 
         * @param lastMonitoringExecutionSummary
         *        Describes metadata on the last execution to run, if there was one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastMonitoringExecutionSummary(MonitoringExecutionSummary lastMonitoringExecutionSummary);

        /**
         * <p>
         * Describes metadata on the last execution to run, if there was one.
         * </p>
         * This is a convenience that creates an instance of the {@link MonitoringExecutionSummary.Builder} avoiding the
         * need to create one manually via {@link MonitoringExecutionSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link MonitoringExecutionSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #lastMonitoringExecutionSummary(MonitoringExecutionSummary)}.
         * 
         * @param lastMonitoringExecutionSummary
         *        a consumer that will call methods on {@link MonitoringExecutionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastMonitoringExecutionSummary(MonitoringExecutionSummary)
         */
        default Builder lastMonitoringExecutionSummary(Consumer<MonitoringExecutionSummary.Builder> lastMonitoringExecutionSummary) {
            return lastMonitoringExecutionSummary(MonitoringExecutionSummary.builder()
                    .applyMutation(lastMonitoringExecutionSummary).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String monitoringScheduleArn;

        private String monitoringScheduleName;

        private String monitoringScheduleStatus;

        private String failureReason;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private MonitoringScheduleConfig monitoringScheduleConfig;

        private String endpointName;

        private MonitoringExecutionSummary lastMonitoringExecutionSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMonitoringScheduleResponse model) {
            super(model);
            monitoringScheduleArn(model.monitoringScheduleArn);
            monitoringScheduleName(model.monitoringScheduleName);
            monitoringScheduleStatus(model.monitoringScheduleStatus);
            failureReason(model.failureReason);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            monitoringScheduleConfig(model.monitoringScheduleConfig);
            endpointName(model.endpointName);
            lastMonitoringExecutionSummary(model.lastMonitoringExecutionSummary);
        }

        public final String getMonitoringScheduleArn() {
            return monitoringScheduleArn;
        }

        @Override
        public final Builder monitoringScheduleArn(String monitoringScheduleArn) {
            this.monitoringScheduleArn = monitoringScheduleArn;
            return this;
        }

        public final void setMonitoringScheduleArn(String monitoringScheduleArn) {
            this.monitoringScheduleArn = monitoringScheduleArn;
        }

        public final String getMonitoringScheduleName() {
            return monitoringScheduleName;
        }

        @Override
        public final Builder monitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
            return this;
        }

        public final void setMonitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
        }

        public final String getMonitoringScheduleStatusAsString() {
            return monitoringScheduleStatus;
        }

        @Override
        public final Builder monitoringScheduleStatus(String monitoringScheduleStatus) {
            this.monitoringScheduleStatus = monitoringScheduleStatus;
            return this;
        }

        @Override
        public final Builder monitoringScheduleStatus(ScheduleStatus monitoringScheduleStatus) {
            this.monitoringScheduleStatus(monitoringScheduleStatus == null ? null : monitoringScheduleStatus.toString());
            return this;
        }

        public final void setMonitoringScheduleStatus(String monitoringScheduleStatus) {
            this.monitoringScheduleStatus = monitoringScheduleStatus;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final MonitoringScheduleConfig.Builder getMonitoringScheduleConfig() {
            return monitoringScheduleConfig != null ? monitoringScheduleConfig.toBuilder() : null;
        }

        @Override
        public final Builder monitoringScheduleConfig(MonitoringScheduleConfig monitoringScheduleConfig) {
            this.monitoringScheduleConfig = monitoringScheduleConfig;
            return this;
        }

        public final void setMonitoringScheduleConfig(MonitoringScheduleConfig.BuilderImpl monitoringScheduleConfig) {
            this.monitoringScheduleConfig = monitoringScheduleConfig != null ? monitoringScheduleConfig.build() : null;
        }

        public final String getEndpointName() {
            return endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final MonitoringExecutionSummary.Builder getLastMonitoringExecutionSummary() {
            return lastMonitoringExecutionSummary != null ? lastMonitoringExecutionSummary.toBuilder() : null;
        }

        @Override
        public final Builder lastMonitoringExecutionSummary(MonitoringExecutionSummary lastMonitoringExecutionSummary) {
            this.lastMonitoringExecutionSummary = lastMonitoringExecutionSummary;
            return this;
        }

        public final void setLastMonitoringExecutionSummary(MonitoringExecutionSummary.BuilderImpl lastMonitoringExecutionSummary) {
            this.lastMonitoringExecutionSummary = lastMonitoringExecutionSummary != null ? lastMonitoringExecutionSummary.build()
                    : null;
        }

        @Override
        public DescribeMonitoringScheduleResponse build() {
            return new DescribeMonitoringScheduleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
