/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLabelingJobResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeLabelingJobResponse.Builder, DescribeLabelingJobResponse> {
    private static final SdkField<String> LABELING_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLabelingJobResponse::labelingJobStatusAsString)).setter(setter(Builder::labelingJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobStatus").build()).build();

    private static final SdkField<LabelCounters> LABEL_COUNTERS_FIELD = SdkField
            .<LabelCounters> builder(MarshallingType.SDK_POJO).getter(getter(DescribeLabelingJobResponse::labelCounters))
            .setter(setter(Builder::labelCounters)).constructor(LabelCounters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelCounters").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLabelingJobResponse::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeLabelingJobResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeLabelingJobResponse::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> JOB_REFERENCE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLabelingJobResponse::jobReferenceCode)).setter(setter(Builder::jobReferenceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobReferenceCode").build()).build();

    private static final SdkField<String> LABELING_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLabelingJobResponse::labelingJobName)).setter(setter(Builder::labelingJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobName").build()).build();

    private static final SdkField<String> LABELING_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLabelingJobResponse::labelingJobArn)).setter(setter(Builder::labelingJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobArn").build()).build();

    private static final SdkField<String> LABEL_ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLabelingJobResponse::labelAttributeName)).setter(setter(Builder::labelAttributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelAttributeName").build())
            .build();

    private static final SdkField<LabelingJobInputConfig> INPUT_CONFIG_FIELD = SdkField
            .<LabelingJobInputConfig> builder(MarshallingType.SDK_POJO).getter(getter(DescribeLabelingJobResponse::inputConfig))
            .setter(setter(Builder::inputConfig)).constructor(LabelingJobInputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()).build();

    private static final SdkField<LabelingJobOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<LabelingJobOutputConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeLabelingJobResponse::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(LabelingJobOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLabelingJobResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> LABEL_CATEGORY_CONFIG_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLabelingJobResponse::labelCategoryConfigS3Uri))
            .setter(setter(Builder::labelCategoryConfigS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelCategoryConfigS3Uri").build())
            .build();

    private static final SdkField<LabelingJobStoppingConditions> STOPPING_CONDITIONS_FIELD = SdkField
            .<LabelingJobStoppingConditions> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeLabelingJobResponse::stoppingConditions)).setter(setter(Builder::stoppingConditions))
            .constructor(LabelingJobStoppingConditions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingConditions").build())
            .build();

    private static final SdkField<LabelingJobAlgorithmsConfig> LABELING_JOB_ALGORITHMS_CONFIG_FIELD = SdkField
            .<LabelingJobAlgorithmsConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeLabelingJobResponse::labelingJobAlgorithmsConfig))
            .setter(setter(Builder::labelingJobAlgorithmsConfig))
            .constructor(LabelingJobAlgorithmsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobAlgorithmsConfig")
                    .build()).build();

    private static final SdkField<HumanTaskConfig> HUMAN_TASK_CONFIG_FIELD = SdkField
            .<HumanTaskConfig> builder(MarshallingType.SDK_POJO).getter(getter(DescribeLabelingJobResponse::humanTaskConfig))
            .setter(setter(Builder::humanTaskConfig)).constructor(HumanTaskConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanTaskConfig").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(DescribeLabelingJobResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<LabelingJobOutput> LABELING_JOB_OUTPUT_FIELD = SdkField
            .<LabelingJobOutput> builder(MarshallingType.SDK_POJO).getter(getter(DescribeLabelingJobResponse::labelingJobOutput))
            .setter(setter(Builder::labelingJobOutput)).constructor(LabelingJobOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobOutput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELING_JOB_STATUS_FIELD,
            LABEL_COUNTERS_FIELD, FAILURE_REASON_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, JOB_REFERENCE_CODE_FIELD,
            LABELING_JOB_NAME_FIELD, LABELING_JOB_ARN_FIELD, LABEL_ATTRIBUTE_NAME_FIELD, INPUT_CONFIG_FIELD, OUTPUT_CONFIG_FIELD,
            ROLE_ARN_FIELD, LABEL_CATEGORY_CONFIG_S3_URI_FIELD, STOPPING_CONDITIONS_FIELD, LABELING_JOB_ALGORITHMS_CONFIG_FIELD,
            HUMAN_TASK_CONFIG_FIELD, TAGS_FIELD, LABELING_JOB_OUTPUT_FIELD));

    private final String labelingJobStatus;

    private final LabelCounters labelCounters;

    private final String failureReason;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String jobReferenceCode;

    private final String labelingJobName;

    private final String labelingJobArn;

    private final String labelAttributeName;

    private final LabelingJobInputConfig inputConfig;

    private final LabelingJobOutputConfig outputConfig;

    private final String roleArn;

    private final String labelCategoryConfigS3Uri;

    private final LabelingJobStoppingConditions stoppingConditions;

    private final LabelingJobAlgorithmsConfig labelingJobAlgorithmsConfig;

    private final HumanTaskConfig humanTaskConfig;

    private final List<Tag> tags;

    private final LabelingJobOutput labelingJobOutput;

    private DescribeLabelingJobResponse(BuilderImpl builder) {
        super(builder);
        this.labelingJobStatus = builder.labelingJobStatus;
        this.labelCounters = builder.labelCounters;
        this.failureReason = builder.failureReason;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.jobReferenceCode = builder.jobReferenceCode;
        this.labelingJobName = builder.labelingJobName;
        this.labelingJobArn = builder.labelingJobArn;
        this.labelAttributeName = builder.labelAttributeName;
        this.inputConfig = builder.inputConfig;
        this.outputConfig = builder.outputConfig;
        this.roleArn = builder.roleArn;
        this.labelCategoryConfigS3Uri = builder.labelCategoryConfigS3Uri;
        this.stoppingConditions = builder.stoppingConditions;
        this.labelingJobAlgorithmsConfig = builder.labelingJobAlgorithmsConfig;
        this.humanTaskConfig = builder.humanTaskConfig;
        this.tags = builder.tags;
        this.labelingJobOutput = builder.labelingJobOutput;
    }

    /**
     * <p>
     * The processing status of the labeling job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #labelingJobStatus}
     * will return {@link LabelingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #labelingJobStatusAsString}.
     * </p>
     * 
     * @return The processing status of the labeling job.
     * @see LabelingJobStatus
     */
    public LabelingJobStatus labelingJobStatus() {
        return LabelingJobStatus.fromValue(labelingJobStatus);
    }

    /**
     * <p>
     * The processing status of the labeling job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #labelingJobStatus}
     * will return {@link LabelingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #labelingJobStatusAsString}.
     * </p>
     * 
     * @return The processing status of the labeling job.
     * @see LabelingJobStatus
     */
    public String labelingJobStatusAsString() {
        return labelingJobStatus;
    }

    /**
     * <p>
     * Provides a breakdown of the number of data objects labeled by humans, the number of objects labeled by machine,
     * the number of objects than couldn't be labeled, and the total number of objects labeled.
     * </p>
     * 
     * @return Provides a breakdown of the number of data objects labeled by humans, the number of objects labeled by
     *         machine, the number of objects than couldn't be labeled, and the total number of objects labeled.
     */
    public LabelCounters labelCounters() {
        return labelCounters;
    }

    /**
     * <p>
     * If the job failed, the reason that it failed.
     * </p>
     * 
     * @return If the job failed, the reason that it failed.
     */
    public String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The date and time that the labeling job was created.
     * </p>
     * 
     * @return The date and time that the labeling job was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time that the labeling job was last updated.
     * </p>
     * 
     * @return The date and time that the labeling job was last updated.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * A unique identifier for work done as part of a labeling job.
     * </p>
     * 
     * @return A unique identifier for work done as part of a labeling job.
     */
    public String jobReferenceCode() {
        return jobReferenceCode;
    }

    /**
     * <p>
     * The name assigned to the labeling job when it was created.
     * </p>
     * 
     * @return The name assigned to the labeling job when it was created.
     */
    public String labelingJobName() {
        return labelingJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the labeling job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the labeling job.
     */
    public String labelingJobArn() {
        return labelingJobArn;
    }

    /**
     * <p>
     * The attribute used as the label in the output manifest file.
     * </p>
     * 
     * @return The attribute used as the label in the output manifest file.
     */
    public String labelAttributeName() {
        return labelAttributeName;
    }

    /**
     * <p>
     * Input configuration information for the labeling job, such as the Amazon S3 location of the data objects and the
     * location of the manifest file that describes the data objects.
     * </p>
     * 
     * @return Input configuration information for the labeling job, such as the Amazon S3 location of the data objects
     *         and the location of the manifest file that describes the data objects.
     */
    public LabelingJobInputConfig inputConfig() {
        return inputConfig;
    }

    /**
     * <p>
     * The location of the job's output data and the AWS Key Management Service key ID for the key used to encrypt the
     * output data, if any.
     * </p>
     * 
     * @return The location of the job's output data and the AWS Key Management Service key ID for the key used to
     *         encrypt the output data, if any.
     */
    public LabelingJobOutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during data
     * labeling.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during data
     *         labeling.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The S3 location of the JSON file that defines the categories used to label data objects. Please note the
     * following label-category limits:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Semantic segmentation labeling jobs using automated labeling: 20 labels
     * </p>
     * </li>
     * <li>
     * <p>
     * Box bounding labeling jobs (all): 10 lables
     * </p>
     * </li>
     * </ul>
     * <p>
     * The file is a JSON structure in the following format:
     * </p>
     * <p>
     * <code>{</code>
     * </p>
     * <p>
     * <code> "document-version": "2018-11-28"</code>
     * </p>
     * <p>
     * <code> "labels": [</code>
     * </p>
     * <p>
     * <code> {</code>
     * </p>
     * <p>
     * <code> "label": "<i>label 1</i>"</code>
     * </p>
     * <p>
     * <code> },</code>
     * </p>
     * <p>
     * <code> {</code>
     * </p>
     * <p>
     * <code> "label": "<i>label 2</i>"</code>
     * </p>
     * <p>
     * <code> },</code>
     * </p>
     * <p>
     * <code> ...</code>
     * </p>
     * <p>
     * <code> {</code>
     * </p>
     * <p>
     * <code> "label": "<i>label n</i>"</code>
     * </p>
     * <p>
     * <code> }</code>
     * </p>
     * <p>
     * <code> ]</code>
     * </p>
     * <p>
     * <code>}</code>
     * </p>
     * 
     * @return The S3 location of the JSON file that defines the categories used to label data objects. Please note the
     *         following label-category limits:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Semantic segmentation labeling jobs using automated labeling: 20 labels
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Box bounding labeling jobs (all): 10 lables
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The file is a JSON structure in the following format:
     *         </p>
     *         <p>
     *         <code>{</code>
     *         </p>
     *         <p>
     *         <code> "document-version": "2018-11-28"</code>
     *         </p>
     *         <p>
     *         <code> "labels": [</code>
     *         </p>
     *         <p>
     *         <code> {</code>
     *         </p>
     *         <p>
     *         <code> "label": "<i>label 1</i>"</code>
     *         </p>
     *         <p>
     *         <code> },</code>
     *         </p>
     *         <p>
     *         <code> {</code>
     *         </p>
     *         <p>
     *         <code> "label": "<i>label 2</i>"</code>
     *         </p>
     *         <p>
     *         <code> },</code>
     *         </p>
     *         <p>
     *         <code> ...</code>
     *         </p>
     *         <p>
     *         <code> {</code>
     *         </p>
     *         <p>
     *         <code> "label": "<i>label n</i>"</code>
     *         </p>
     *         <p>
     *         <code> }</code>
     *         </p>
     *         <p>
     *         <code> ]</code>
     *         </p>
     *         <p>
     *         <code>}</code>
     */
    public String labelCategoryConfigS3Uri() {
        return labelCategoryConfigS3Uri;
    }

    /**
     * <p>
     * A set of conditions for stopping a labeling job. If any of the conditions are met, the job is automatically
     * stopped.
     * </p>
     * 
     * @return A set of conditions for stopping a labeling job. If any of the conditions are met, the job is
     *         automatically stopped.
     */
    public LabelingJobStoppingConditions stoppingConditions() {
        return stoppingConditions;
    }

    /**
     * <p>
     * Configuration information for automated data labeling.
     * </p>
     * 
     * @return Configuration information for automated data labeling.
     */
    public LabelingJobAlgorithmsConfig labelingJobAlgorithmsConfig() {
        return labelingJobAlgorithmsConfig;
    }

    /**
     * <p>
     * Configuration information required for human workers to complete a labeling task.
     * </p>
     * 
     * @return Configuration information required for human workers to complete a labeling task.
     */
    public HumanTaskConfig humanTaskConfig() {
        return humanTaskConfig;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key/value pairs. For more information, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what">Using
     * Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of key/value pairs. For more information, see <a
     *         href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
     *         >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The location of the output produced by the labeling job.
     * </p>
     * 
     * @return The location of the output produced by the labeling job.
     */
    public LabelingJobOutput labelingJobOutput() {
        return labelingJobOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(labelingJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(labelCounters());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(jobReferenceCode());
        hashCode = 31 * hashCode + Objects.hashCode(labelingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(labelingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(labelAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(labelCategoryConfigS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingConditions());
        hashCode = 31 * hashCode + Objects.hashCode(labelingJobAlgorithmsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(humanTaskConfig());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(labelingJobOutput());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLabelingJobResponse)) {
            return false;
        }
        DescribeLabelingJobResponse other = (DescribeLabelingJobResponse) obj;
        return Objects.equals(labelingJobStatusAsString(), other.labelingJobStatusAsString())
                && Objects.equals(labelCounters(), other.labelCounters())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(jobReferenceCode(), other.jobReferenceCode())
                && Objects.equals(labelingJobName(), other.labelingJobName())
                && Objects.equals(labelingJobArn(), other.labelingJobArn())
                && Objects.equals(labelAttributeName(), other.labelAttributeName())
                && Objects.equals(inputConfig(), other.inputConfig()) && Objects.equals(outputConfig(), other.outputConfig())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(labelCategoryConfigS3Uri(), other.labelCategoryConfigS3Uri())
                && Objects.equals(stoppingConditions(), other.stoppingConditions())
                && Objects.equals(labelingJobAlgorithmsConfig(), other.labelingJobAlgorithmsConfig())
                && Objects.equals(humanTaskConfig(), other.humanTaskConfig()) && Objects.equals(tags(), other.tags())
                && Objects.equals(labelingJobOutput(), other.labelingJobOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeLabelingJobResponse").add("LabelingJobStatus", labelingJobStatusAsString())
                .add("LabelCounters", labelCounters()).add("FailureReason", failureReason()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("JobReferenceCode", jobReferenceCode())
                .add("LabelingJobName", labelingJobName()).add("LabelingJobArn", labelingJobArn())
                .add("LabelAttributeName", labelAttributeName()).add("InputConfig", inputConfig())
                .add("OutputConfig", outputConfig()).add("RoleArn", roleArn())
                .add("LabelCategoryConfigS3Uri", labelCategoryConfigS3Uri()).add("StoppingConditions", stoppingConditions())
                .add("LabelingJobAlgorithmsConfig", labelingJobAlgorithmsConfig()).add("HumanTaskConfig", humanTaskConfig())
                .add("Tags", tags()).add("LabelingJobOutput", labelingJobOutput()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabelingJobStatus":
            return Optional.ofNullable(clazz.cast(labelingJobStatusAsString()));
        case "LabelCounters":
            return Optional.ofNullable(clazz.cast(labelCounters()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "JobReferenceCode":
            return Optional.ofNullable(clazz.cast(jobReferenceCode()));
        case "LabelingJobName":
            return Optional.ofNullable(clazz.cast(labelingJobName()));
        case "LabelingJobArn":
            return Optional.ofNullable(clazz.cast(labelingJobArn()));
        case "LabelAttributeName":
            return Optional.ofNullable(clazz.cast(labelAttributeName()));
        case "InputConfig":
            return Optional.ofNullable(clazz.cast(inputConfig()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "LabelCategoryConfigS3Uri":
            return Optional.ofNullable(clazz.cast(labelCategoryConfigS3Uri()));
        case "StoppingConditions":
            return Optional.ofNullable(clazz.cast(stoppingConditions()));
        case "LabelingJobAlgorithmsConfig":
            return Optional.ofNullable(clazz.cast(labelingJobAlgorithmsConfig()));
        case "HumanTaskConfig":
            return Optional.ofNullable(clazz.cast(humanTaskConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "LabelingJobOutput":
            return Optional.ofNullable(clazz.cast(labelingJobOutput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLabelingJobResponse, T> g) {
        return obj -> g.apply((DescribeLabelingJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLabelingJobResponse> {
        /**
         * <p>
         * The processing status of the labeling job.
         * </p>
         * 
         * @param labelingJobStatus
         *        The processing status of the labeling job.
         * @see LabelingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LabelingJobStatus
         */
        Builder labelingJobStatus(String labelingJobStatus);

        /**
         * <p>
         * The processing status of the labeling job.
         * </p>
         * 
         * @param labelingJobStatus
         *        The processing status of the labeling job.
         * @see LabelingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LabelingJobStatus
         */
        Builder labelingJobStatus(LabelingJobStatus labelingJobStatus);

        /**
         * <p>
         * Provides a breakdown of the number of data objects labeled by humans, the number of objects labeled by
         * machine, the number of objects than couldn't be labeled, and the total number of objects labeled.
         * </p>
         * 
         * @param labelCounters
         *        Provides a breakdown of the number of data objects labeled by humans, the number of objects labeled by
         *        machine, the number of objects than couldn't be labeled, and the total number of objects labeled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelCounters(LabelCounters labelCounters);

        /**
         * <p>
         * Provides a breakdown of the number of data objects labeled by humans, the number of objects labeled by
         * machine, the number of objects than couldn't be labeled, and the total number of objects labeled.
         * </p>
         * This is a convenience that creates an instance of the {@link LabelCounters.Builder} avoiding the need to
         * create one manually via {@link LabelCounters#builder()}.
         *
         * When the {@link Consumer} completes, {@link LabelCounters.Builder#build()} is called immediately and its
         * result is passed to {@link #labelCounters(LabelCounters)}.
         * 
         * @param labelCounters
         *        a consumer that will call methods on {@link LabelCounters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelCounters(LabelCounters)
         */
        default Builder labelCounters(Consumer<LabelCounters.Builder> labelCounters) {
            return labelCounters(LabelCounters.builder().applyMutation(labelCounters).build());
        }

        /**
         * <p>
         * If the job failed, the reason that it failed.
         * </p>
         * 
         * @param failureReason
         *        If the job failed, the reason that it failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The date and time that the labeling job was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time that the labeling job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time that the labeling job was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time that the labeling job was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * A unique identifier for work done as part of a labeling job.
         * </p>
         * 
         * @param jobReferenceCode
         *        A unique identifier for work done as part of a labeling job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobReferenceCode(String jobReferenceCode);

        /**
         * <p>
         * The name assigned to the labeling job when it was created.
         * </p>
         * 
         * @param labelingJobName
         *        The name assigned to the labeling job when it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelingJobName(String labelingJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the labeling job.
         * </p>
         * 
         * @param labelingJobArn
         *        The Amazon Resource Name (ARN) of the labeling job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelingJobArn(String labelingJobArn);

        /**
         * <p>
         * The attribute used as the label in the output manifest file.
         * </p>
         * 
         * @param labelAttributeName
         *        The attribute used as the label in the output manifest file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelAttributeName(String labelAttributeName);

        /**
         * <p>
         * Input configuration information for the labeling job, such as the Amazon S3 location of the data objects and
         * the location of the manifest file that describes the data objects.
         * </p>
         * 
         * @param inputConfig
         *        Input configuration information for the labeling job, such as the Amazon S3 location of the data
         *        objects and the location of the manifest file that describes the data objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfig(LabelingJobInputConfig inputConfig);

        /**
         * <p>
         * Input configuration information for the labeling job, such as the Amazon S3 location of the data objects and
         * the location of the manifest file that describes the data objects.
         * </p>
         * This is a convenience that creates an instance of the {@link LabelingJobInputConfig.Builder} avoiding the
         * need to create one manually via {@link LabelingJobInputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LabelingJobInputConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #inputConfig(LabelingJobInputConfig)}.
         * 
         * @param inputConfig
         *        a consumer that will call methods on {@link LabelingJobInputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConfig(LabelingJobInputConfig)
         */
        default Builder inputConfig(Consumer<LabelingJobInputConfig.Builder> inputConfig) {
            return inputConfig(LabelingJobInputConfig.builder().applyMutation(inputConfig).build());
        }

        /**
         * <p>
         * The location of the job's output data and the AWS Key Management Service key ID for the key used to encrypt
         * the output data, if any.
         * </p>
         * 
         * @param outputConfig
         *        The location of the job's output data and the AWS Key Management Service key ID for the key used to
         *        encrypt the output data, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(LabelingJobOutputConfig outputConfig);

        /**
         * <p>
         * The location of the job's output data and the AWS Key Management Service key ID for the key used to encrypt
         * the output data, if any.
         * </p>
         * This is a convenience that creates an instance of the {@link LabelingJobOutputConfig.Builder} avoiding the
         * need to create one manually via {@link LabelingJobOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LabelingJobOutputConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #outputConfig(LabelingJobOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link LabelingJobOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(LabelingJobOutputConfig)
         */
        default Builder outputConfig(Consumer<LabelingJobOutputConfig.Builder> outputConfig) {
            return outputConfig(LabelingJobOutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during data
         * labeling.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) that Amazon SageMaker assumes to perform tasks on your behalf during
         *        data labeling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The S3 location of the JSON file that defines the categories used to label data objects. Please note the
         * following label-category limits:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Semantic segmentation labeling jobs using automated labeling: 20 labels
         * </p>
         * </li>
         * <li>
         * <p>
         * Box bounding labeling jobs (all): 10 lables
         * </p>
         * </li>
         * </ul>
         * <p>
         * The file is a JSON structure in the following format:
         * </p>
         * <p>
         * <code>{</code>
         * </p>
         * <p>
         * <code> "document-version": "2018-11-28"</code>
         * </p>
         * <p>
         * <code> "labels": [</code>
         * </p>
         * <p>
         * <code> {</code>
         * </p>
         * <p>
         * <code> "label": "<i>label 1</i>"</code>
         * </p>
         * <p>
         * <code> },</code>
         * </p>
         * <p>
         * <code> {</code>
         * </p>
         * <p>
         * <code> "label": "<i>label 2</i>"</code>
         * </p>
         * <p>
         * <code> },</code>
         * </p>
         * <p>
         * <code> ...</code>
         * </p>
         * <p>
         * <code> {</code>
         * </p>
         * <p>
         * <code> "label": "<i>label n</i>"</code>
         * </p>
         * <p>
         * <code> }</code>
         * </p>
         * <p>
         * <code> ]</code>
         * </p>
         * <p>
         * <code>}</code>
         * </p>
         * 
         * @param labelCategoryConfigS3Uri
         *        The S3 location of the JSON file that defines the categories used to label data objects. Please note
         *        the following label-category limits:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Semantic segmentation labeling jobs using automated labeling: 20 labels
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Box bounding labeling jobs (all): 10 lables
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The file is a JSON structure in the following format:
         *        </p>
         *        <p>
         *        <code>{</code>
         *        </p>
         *        <p>
         *        <code> "document-version": "2018-11-28"</code>
         *        </p>
         *        <p>
         *        <code> "labels": [</code>
         *        </p>
         *        <p>
         *        <code> {</code>
         *        </p>
         *        <p>
         *        <code> "label": "<i>label 1</i>"</code>
         *        </p>
         *        <p>
         *        <code> },</code>
         *        </p>
         *        <p>
         *        <code> {</code>
         *        </p>
         *        <p>
         *        <code> "label": "<i>label 2</i>"</code>
         *        </p>
         *        <p>
         *        <code> },</code>
         *        </p>
         *        <p>
         *        <code> ...</code>
         *        </p>
         *        <p>
         *        <code> {</code>
         *        </p>
         *        <p>
         *        <code> "label": "<i>label n</i>"</code>
         *        </p>
         *        <p>
         *        <code> }</code>
         *        </p>
         *        <p>
         *        <code> ]</code>
         *        </p>
         *        <p>
         *        <code>}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelCategoryConfigS3Uri(String labelCategoryConfigS3Uri);

        /**
         * <p>
         * A set of conditions for stopping a labeling job. If any of the conditions are met, the job is automatically
         * stopped.
         * </p>
         * 
         * @param stoppingConditions
         *        A set of conditions for stopping a labeling job. If any of the conditions are met, the job is
         *        automatically stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingConditions(LabelingJobStoppingConditions stoppingConditions);

        /**
         * <p>
         * A set of conditions for stopping a labeling job. If any of the conditions are met, the job is automatically
         * stopped.
         * </p>
         * This is a convenience that creates an instance of the {@link LabelingJobStoppingConditions.Builder} avoiding
         * the need to create one manually via {@link LabelingJobStoppingConditions#builder()}.
         *
         * When the {@link Consumer} completes, {@link LabelingJobStoppingConditions.Builder#build()} is called
         * immediately and its result is passed to {@link #stoppingConditions(LabelingJobStoppingConditions)}.
         * 
         * @param stoppingConditions
         *        a consumer that will call methods on {@link LabelingJobStoppingConditions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingConditions(LabelingJobStoppingConditions)
         */
        default Builder stoppingConditions(Consumer<LabelingJobStoppingConditions.Builder> stoppingConditions) {
            return stoppingConditions(LabelingJobStoppingConditions.builder().applyMutation(stoppingConditions).build());
        }

        /**
         * <p>
         * Configuration information for automated data labeling.
         * </p>
         * 
         * @param labelingJobAlgorithmsConfig
         *        Configuration information for automated data labeling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelingJobAlgorithmsConfig(LabelingJobAlgorithmsConfig labelingJobAlgorithmsConfig);

        /**
         * <p>
         * Configuration information for automated data labeling.
         * </p>
         * This is a convenience that creates an instance of the {@link LabelingJobAlgorithmsConfig.Builder} avoiding
         * the need to create one manually via {@link LabelingJobAlgorithmsConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LabelingJobAlgorithmsConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #labelingJobAlgorithmsConfig(LabelingJobAlgorithmsConfig)}.
         * 
         * @param labelingJobAlgorithmsConfig
         *        a consumer that will call methods on {@link LabelingJobAlgorithmsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelingJobAlgorithmsConfig(LabelingJobAlgorithmsConfig)
         */
        default Builder labelingJobAlgorithmsConfig(Consumer<LabelingJobAlgorithmsConfig.Builder> labelingJobAlgorithmsConfig) {
            return labelingJobAlgorithmsConfig(LabelingJobAlgorithmsConfig.builder().applyMutation(labelingJobAlgorithmsConfig)
                    .build());
        }

        /**
         * <p>
         * Configuration information required for human workers to complete a labeling task.
         * </p>
         * 
         * @param humanTaskConfig
         *        Configuration information required for human workers to complete a labeling task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanTaskConfig(HumanTaskConfig humanTaskConfig);

        /**
         * <p>
         * Configuration information required for human workers to complete a labeling task.
         * </p>
         * This is a convenience that creates an instance of the {@link HumanTaskConfig.Builder} avoiding the need to
         * create one manually via {@link HumanTaskConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HumanTaskConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #humanTaskConfig(HumanTaskConfig)}.
         * 
         * @param humanTaskConfig
         *        a consumer that will call methods on {@link HumanTaskConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #humanTaskConfig(HumanTaskConfig)
         */
        default Builder humanTaskConfig(Consumer<HumanTaskConfig.Builder> humanTaskConfig) {
            return humanTaskConfig(HumanTaskConfig.builder().applyMutation(humanTaskConfig).build());
        }

        /**
         * <p>
         * An array of key/value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
         * >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
         * </p>
         * 
         * @param tags
         *        An array of key/value pairs. For more information, see <a href=
         *        "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
         *        >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key/value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
         * >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
         * </p>
         * 
         * @param tags
         *        An array of key/value pairs. For more information, see <a href=
         *        "https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
         *        >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key/value pairs. For more information, see <a
         * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what"
         * >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The location of the output produced by the labeling job.
         * </p>
         * 
         * @param labelingJobOutput
         *        The location of the output produced by the labeling job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelingJobOutput(LabelingJobOutput labelingJobOutput);

        /**
         * <p>
         * The location of the output produced by the labeling job.
         * </p>
         * This is a convenience that creates an instance of the {@link LabelingJobOutput.Builder} avoiding the need to
         * create one manually via {@link LabelingJobOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link LabelingJobOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #labelingJobOutput(LabelingJobOutput)}.
         * 
         * @param labelingJobOutput
         *        a consumer that will call methods on {@link LabelingJobOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelingJobOutput(LabelingJobOutput)
         */
        default Builder labelingJobOutput(Consumer<LabelingJobOutput.Builder> labelingJobOutput) {
            return labelingJobOutput(LabelingJobOutput.builder().applyMutation(labelingJobOutput).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String labelingJobStatus;

        private LabelCounters labelCounters;

        private String failureReason;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String jobReferenceCode;

        private String labelingJobName;

        private String labelingJobArn;

        private String labelAttributeName;

        private LabelingJobInputConfig inputConfig;

        private LabelingJobOutputConfig outputConfig;

        private String roleArn;

        private String labelCategoryConfigS3Uri;

        private LabelingJobStoppingConditions stoppingConditions;

        private LabelingJobAlgorithmsConfig labelingJobAlgorithmsConfig;

        private HumanTaskConfig humanTaskConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private LabelingJobOutput labelingJobOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLabelingJobResponse model) {
            super(model);
            labelingJobStatus(model.labelingJobStatus);
            labelCounters(model.labelCounters);
            failureReason(model.failureReason);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            jobReferenceCode(model.jobReferenceCode);
            labelingJobName(model.labelingJobName);
            labelingJobArn(model.labelingJobArn);
            labelAttributeName(model.labelAttributeName);
            inputConfig(model.inputConfig);
            outputConfig(model.outputConfig);
            roleArn(model.roleArn);
            labelCategoryConfigS3Uri(model.labelCategoryConfigS3Uri);
            stoppingConditions(model.stoppingConditions);
            labelingJobAlgorithmsConfig(model.labelingJobAlgorithmsConfig);
            humanTaskConfig(model.humanTaskConfig);
            tags(model.tags);
            labelingJobOutput(model.labelingJobOutput);
        }

        public final String getLabelingJobStatusAsString() {
            return labelingJobStatus;
        }

        @Override
        public final Builder labelingJobStatus(String labelingJobStatus) {
            this.labelingJobStatus = labelingJobStatus;
            return this;
        }

        @Override
        public final Builder labelingJobStatus(LabelingJobStatus labelingJobStatus) {
            this.labelingJobStatus(labelingJobStatus == null ? null : labelingJobStatus.toString());
            return this;
        }

        public final void setLabelingJobStatus(String labelingJobStatus) {
            this.labelingJobStatus = labelingJobStatus;
        }

        public final LabelCounters.Builder getLabelCounters() {
            return labelCounters != null ? labelCounters.toBuilder() : null;
        }

        @Override
        public final Builder labelCounters(LabelCounters labelCounters) {
            this.labelCounters = labelCounters;
            return this;
        }

        public final void setLabelCounters(LabelCounters.BuilderImpl labelCounters) {
            this.labelCounters = labelCounters != null ? labelCounters.build() : null;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getJobReferenceCode() {
            return jobReferenceCode;
        }

        @Override
        public final Builder jobReferenceCode(String jobReferenceCode) {
            this.jobReferenceCode = jobReferenceCode;
            return this;
        }

        public final void setJobReferenceCode(String jobReferenceCode) {
            this.jobReferenceCode = jobReferenceCode;
        }

        public final String getLabelingJobName() {
            return labelingJobName;
        }

        @Override
        public final Builder labelingJobName(String labelingJobName) {
            this.labelingJobName = labelingJobName;
            return this;
        }

        public final void setLabelingJobName(String labelingJobName) {
            this.labelingJobName = labelingJobName;
        }

        public final String getLabelingJobArn() {
            return labelingJobArn;
        }

        @Override
        public final Builder labelingJobArn(String labelingJobArn) {
            this.labelingJobArn = labelingJobArn;
            return this;
        }

        public final void setLabelingJobArn(String labelingJobArn) {
            this.labelingJobArn = labelingJobArn;
        }

        public final String getLabelAttributeName() {
            return labelAttributeName;
        }

        @Override
        public final Builder labelAttributeName(String labelAttributeName) {
            this.labelAttributeName = labelAttributeName;
            return this;
        }

        public final void setLabelAttributeName(String labelAttributeName) {
            this.labelAttributeName = labelAttributeName;
        }

        public final LabelingJobInputConfig.Builder getInputConfig() {
            return inputConfig != null ? inputConfig.toBuilder() : null;
        }

        @Override
        public final Builder inputConfig(LabelingJobInputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final void setInputConfig(LabelingJobInputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        public final LabelingJobOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputConfig(LabelingJobOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final void setOutputConfig(LabelingJobOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getLabelCategoryConfigS3Uri() {
            return labelCategoryConfigS3Uri;
        }

        @Override
        public final Builder labelCategoryConfigS3Uri(String labelCategoryConfigS3Uri) {
            this.labelCategoryConfigS3Uri = labelCategoryConfigS3Uri;
            return this;
        }

        public final void setLabelCategoryConfigS3Uri(String labelCategoryConfigS3Uri) {
            this.labelCategoryConfigS3Uri = labelCategoryConfigS3Uri;
        }

        public final LabelingJobStoppingConditions.Builder getStoppingConditions() {
            return stoppingConditions != null ? stoppingConditions.toBuilder() : null;
        }

        @Override
        public final Builder stoppingConditions(LabelingJobStoppingConditions stoppingConditions) {
            this.stoppingConditions = stoppingConditions;
            return this;
        }

        public final void setStoppingConditions(LabelingJobStoppingConditions.BuilderImpl stoppingConditions) {
            this.stoppingConditions = stoppingConditions != null ? stoppingConditions.build() : null;
        }

        public final LabelingJobAlgorithmsConfig.Builder getLabelingJobAlgorithmsConfig() {
            return labelingJobAlgorithmsConfig != null ? labelingJobAlgorithmsConfig.toBuilder() : null;
        }

        @Override
        public final Builder labelingJobAlgorithmsConfig(LabelingJobAlgorithmsConfig labelingJobAlgorithmsConfig) {
            this.labelingJobAlgorithmsConfig = labelingJobAlgorithmsConfig;
            return this;
        }

        public final void setLabelingJobAlgorithmsConfig(LabelingJobAlgorithmsConfig.BuilderImpl labelingJobAlgorithmsConfig) {
            this.labelingJobAlgorithmsConfig = labelingJobAlgorithmsConfig != null ? labelingJobAlgorithmsConfig.build() : null;
        }

        public final HumanTaskConfig.Builder getHumanTaskConfig() {
            return humanTaskConfig != null ? humanTaskConfig.toBuilder() : null;
        }

        @Override
        public final Builder humanTaskConfig(HumanTaskConfig humanTaskConfig) {
            this.humanTaskConfig = humanTaskConfig;
            return this;
        }

        public final void setHumanTaskConfig(HumanTaskConfig.BuilderImpl humanTaskConfig) {
            this.humanTaskConfig = humanTaskConfig != null ? humanTaskConfig.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final LabelingJobOutput.Builder getLabelingJobOutput() {
            return labelingJobOutput != null ? labelingJobOutput.toBuilder() : null;
        }

        @Override
        public final Builder labelingJobOutput(LabelingJobOutput labelingJobOutput) {
            this.labelingJobOutput = labelingJobOutput;
            return this;
        }

        public final void setLabelingJobOutput(LabelingJobOutput.BuilderImpl labelingJobOutput) {
            this.labelingJobOutput = labelingJobOutput != null ? labelingJobOutput.build() : null;
        }

        @Override
        public DescribeLabelingJobResponse build() {
            return new DescribeLabelingJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
