/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum TargetDevice {
    LAMBDA("lambda"),

    ML_M4("ml_m4"),

    ML_M5("ml_m5"),

    ML_C4("ml_c4"),

    ML_C5("ml_c5"),

    ML_P2("ml_p2"),

    ML_P3("ml_p3"),

    ML_INF1("ml_inf1"),

    JETSON_TX1("jetson_tx1"),

    JETSON_TX2("jetson_tx2"),

    JETSON_NANO("jetson_nano"),

    RASP3_B("rasp3b"),

    DEEPLENS("deeplens"),

    RK3399("rk3399"),

    RK3288("rk3288"),

    AISAGE("aisage"),

    SBE_C("sbe_c"),

    QCS605("qcs605"),

    QCS603("qcs603"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TargetDevice(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return TargetDevice corresponding to the value
     */
    public static TargetDevice fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TargetDevice.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link TargetDevice}s
     */
    public static Set<TargetDevice> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
