/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information about a model package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelPackageSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelPackageSummary.Builder, ModelPackageSummary> {
    private static final SdkField<String> MODEL_PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelPackageSummary::modelPackageName)).setter(setter(Builder::modelPackageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageName").build()).build();

    private static final SdkField<String> MODEL_PACKAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelPackageSummary::modelPackageArn)).setter(setter(Builder::modelPackageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageArn").build()).build();

    private static final SdkField<String> MODEL_PACKAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelPackageSummary::modelPackageDescription)).setter(setter(Builder::modelPackageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageDescription").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ModelPackageSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> MODEL_PACKAGE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ModelPackageSummary::modelPackageStatusAsString)).setter(setter(Builder::modelPackageStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_NAME_FIELD,
            MODEL_PACKAGE_ARN_FIELD, MODEL_PACKAGE_DESCRIPTION_FIELD, CREATION_TIME_FIELD, MODEL_PACKAGE_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modelPackageName;

    private final String modelPackageArn;

    private final String modelPackageDescription;

    private final Instant creationTime;

    private final String modelPackageStatus;

    private ModelPackageSummary(BuilderImpl builder) {
        this.modelPackageName = builder.modelPackageName;
        this.modelPackageArn = builder.modelPackageArn;
        this.modelPackageDescription = builder.modelPackageDescription;
        this.creationTime = builder.creationTime;
        this.modelPackageStatus = builder.modelPackageStatus;
    }

    /**
     * <p>
     * The name of the model package.
     * </p>
     * 
     * @return The name of the model package.
     */
    public String modelPackageName() {
        return modelPackageName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model package.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model package.
     */
    public String modelPackageArn() {
        return modelPackageArn;
    }

    /**
     * <p>
     * A brief description of the model package.
     * </p>
     * 
     * @return A brief description of the model package.
     */
    public String modelPackageDescription() {
        return modelPackageDescription;
    }

    /**
     * <p>
     * A timestamp that shows when the model package was created.
     * </p>
     * 
     * @return A timestamp that shows when the model package was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The overall status of the model package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelPackageStatus} will return {@link ModelPackageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #modelPackageStatusAsString}.
     * </p>
     * 
     * @return The overall status of the model package.
     * @see ModelPackageStatus
     */
    public ModelPackageStatus modelPackageStatus() {
        return ModelPackageStatus.fromValue(modelPackageStatus);
    }

    /**
     * <p>
     * The overall status of the model package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelPackageStatus} will return {@link ModelPackageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #modelPackageStatusAsString}.
     * </p>
     * 
     * @return The overall status of the model package.
     * @see ModelPackageStatus
     */
    public String modelPackageStatusAsString() {
        return modelPackageStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageName());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelPackageSummary)) {
            return false;
        }
        ModelPackageSummary other = (ModelPackageSummary) obj;
        return Objects.equals(modelPackageName(), other.modelPackageName())
                && Objects.equals(modelPackageArn(), other.modelPackageArn())
                && Objects.equals(modelPackageDescription(), other.modelPackageDescription())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(modelPackageStatusAsString(), other.modelPackageStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModelPackageSummary").add("ModelPackageName", modelPackageName())
                .add("ModelPackageArn", modelPackageArn()).add("ModelPackageDescription", modelPackageDescription())
                .add("CreationTime", creationTime()).add("ModelPackageStatus", modelPackageStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelPackageName":
            return Optional.ofNullable(clazz.cast(modelPackageName()));
        case "ModelPackageArn":
            return Optional.ofNullable(clazz.cast(modelPackageArn()));
        case "ModelPackageDescription":
            return Optional.ofNullable(clazz.cast(modelPackageDescription()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ModelPackageStatus":
            return Optional.ofNullable(clazz.cast(modelPackageStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelPackageSummary, T> g) {
        return obj -> g.apply((ModelPackageSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelPackageSummary> {
        /**
         * <p>
         * The name of the model package.
         * </p>
         * 
         * @param modelPackageName
         *        The name of the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageName(String modelPackageName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model package.
         * </p>
         * 
         * @param modelPackageArn
         *        The Amazon Resource Name (ARN) of the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageArn(String modelPackageArn);

        /**
         * <p>
         * A brief description of the model package.
         * </p>
         * 
         * @param modelPackageDescription
         *        A brief description of the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageDescription(String modelPackageDescription);

        /**
         * <p>
         * A timestamp that shows when the model package was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp that shows when the model package was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The overall status of the model package.
         * </p>
         * 
         * @param modelPackageStatus
         *        The overall status of the model package.
         * @see ModelPackageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelPackageStatus
         */
        Builder modelPackageStatus(String modelPackageStatus);

        /**
         * <p>
         * The overall status of the model package.
         * </p>
         * 
         * @param modelPackageStatus
         *        The overall status of the model package.
         * @see ModelPackageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelPackageStatus
         */
        Builder modelPackageStatus(ModelPackageStatus modelPackageStatus);
    }

    static final class BuilderImpl implements Builder {
        private String modelPackageName;

        private String modelPackageArn;

        private String modelPackageDescription;

        private Instant creationTime;

        private String modelPackageStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelPackageSummary model) {
            modelPackageName(model.modelPackageName);
            modelPackageArn(model.modelPackageArn);
            modelPackageDescription(model.modelPackageDescription);
            creationTime(model.creationTime);
            modelPackageStatus(model.modelPackageStatus);
        }

        public final String getModelPackageName() {
            return modelPackageName;
        }

        @Override
        public final Builder modelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
            return this;
        }

        public final void setModelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
        }

        public final String getModelPackageArn() {
            return modelPackageArn;
        }

        @Override
        public final Builder modelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
            return this;
        }

        public final void setModelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
        }

        public final String getModelPackageDescription() {
            return modelPackageDescription;
        }

        @Override
        public final Builder modelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
            return this;
        }

        public final void setModelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getModelPackageStatusAsString() {
            return modelPackageStatus;
        }

        @Override
        public final Builder modelPackageStatus(String modelPackageStatus) {
            this.modelPackageStatus = modelPackageStatus;
            return this;
        }

        @Override
        public final Builder modelPackageStatus(ModelPackageStatus modelPackageStatus) {
            this.modelPackageStatus(modelPackageStatus == null ? null : modelPackageStatus.toString());
            return this;
        }

        public final void setModelPackageStatus(String modelPackageStatus) {
            this.modelPackageStatus = modelPackageStatus;
        }

        @Override
        public ModelPackageSummary build() {
            return new ModelPackageSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
