/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about a labeling work team.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Workteam implements SdkPojo, Serializable, ToCopyableBuilder<Workteam.Builder, Workteam> {
    private static final SdkField<String> WORKTEAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Workteam::workteamName)).setter(setter(Builder::workteamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkteamName").build()).build();

    private static final SdkField<List<MemberDefinition>> MEMBER_DEFINITIONS_FIELD = SdkField
            .<List<MemberDefinition>> builder(MarshallingType.LIST)
            .getter(getter(Workteam::memberDefinitions))
            .setter(setter(Builder::memberDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MemberDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(MemberDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WORKTEAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Workteam::workteamArn)).setter(setter(Builder::workteamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkteamArn").build()).build();

    private static final SdkField<List<String>> PRODUCT_LISTING_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Workteam::productListingIds))
            .setter(setter(Builder::productListingIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductListingIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Workteam::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SUB_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Workteam::subDomain)).setter(setter(Builder::subDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubDomain").build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Workteam::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Workteam::lastUpdatedDate)).setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDate").build()).build();

    private static final SdkField<NotificationConfiguration> NOTIFICATION_CONFIGURATION_FIELD = SdkField
            .<NotificationConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(Workteam::notificationConfiguration))
            .setter(setter(Builder::notificationConfiguration)).constructor(NotificationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKTEAM_NAME_FIELD,
            MEMBER_DEFINITIONS_FIELD, WORKTEAM_ARN_FIELD, PRODUCT_LISTING_IDS_FIELD, DESCRIPTION_FIELD, SUB_DOMAIN_FIELD,
            CREATE_DATE_FIELD, LAST_UPDATED_DATE_FIELD, NOTIFICATION_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String workteamName;

    private final List<MemberDefinition> memberDefinitions;

    private final String workteamArn;

    private final List<String> productListingIds;

    private final String description;

    private final String subDomain;

    private final Instant createDate;

    private final Instant lastUpdatedDate;

    private final NotificationConfiguration notificationConfiguration;

    private Workteam(BuilderImpl builder) {
        this.workteamName = builder.workteamName;
        this.memberDefinitions = builder.memberDefinitions;
        this.workteamArn = builder.workteamArn;
        this.productListingIds = builder.productListingIds;
        this.description = builder.description;
        this.subDomain = builder.subDomain;
        this.createDate = builder.createDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.notificationConfiguration = builder.notificationConfiguration;
    }

    /**
     * <p>
     * The name of the work team.
     * </p>
     * 
     * @return The name of the work team.
     */
    public String workteamName() {
        return workteamName;
    }

    /**
     * Returns true if the MemberDefinitions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasMemberDefinitions() {
        return memberDefinitions != null && !(memberDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Cognito user groups that make up the work team.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMemberDefinitions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Cognito user groups that make up the work team.
     */
    public List<MemberDefinition> memberDefinitions() {
        return memberDefinitions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the work team.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the work team.
     */
    public String workteamArn() {
        return workteamArn;
    }

    /**
     * Returns true if the ProductListingIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasProductListingIds() {
        return productListingIds != null && !(productListingIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Marketplace identifier for a vendor's work team.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProductListingIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Marketplace identifier for a vendor's work team.
     */
    public List<String> productListingIds() {
        return productListingIds;
    }

    /**
     * <p>
     * A description of the work team.
     * </p>
     * 
     * @return A description of the work team.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The URI of the labeling job's user interface. Workers open this URI to start labeling your data objects.
     * </p>
     * 
     * @return The URI of the labeling job's user interface. Workers open this URI to start labeling your data objects.
     */
    public String subDomain() {
        return subDomain;
    }

    /**
     * <p>
     * The date and time that the work team was created (timestamp).
     * </p>
     * 
     * @return The date and time that the work team was created (timestamp).
     */
    public Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The date and time that the work team was last updated (timestamp).
     * </p>
     * 
     * @return The date and time that the work team was last updated (timestamp).
     */
    public Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * Configures SNS notifications of available or expiring work items for work teams.
     * </p>
     * 
     * @return Configures SNS notifications of available or expiring work items for work teams.
     */
    public NotificationConfiguration notificationConfiguration() {
        return notificationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workteamName());
        hashCode = 31 * hashCode + Objects.hashCode(memberDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(workteamArn());
        hashCode = 31 * hashCode + Objects.hashCode(productListingIds());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(subDomain());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(notificationConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workteam)) {
            return false;
        }
        Workteam other = (Workteam) obj;
        return Objects.equals(workteamName(), other.workteamName())
                && Objects.equals(memberDefinitions(), other.memberDefinitions())
                && Objects.equals(workteamArn(), other.workteamArn())
                && Objects.equals(productListingIds(), other.productListingIds())
                && Objects.equals(description(), other.description()) && Objects.equals(subDomain(), other.subDomain())
                && Objects.equals(createDate(), other.createDate()) && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate())
                && Objects.equals(notificationConfiguration(), other.notificationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Workteam").add("WorkteamName", workteamName()).add("MemberDefinitions", memberDefinitions())
                .add("WorkteamArn", workteamArn()).add("ProductListingIds", productListingIds())
                .add("Description", description()).add("SubDomain", subDomain()).add("CreateDate", createDate())
                .add("LastUpdatedDate", lastUpdatedDate()).add("NotificationConfiguration", notificationConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkteamName":
            return Optional.ofNullable(clazz.cast(workteamName()));
        case "MemberDefinitions":
            return Optional.ofNullable(clazz.cast(memberDefinitions()));
        case "WorkteamArn":
            return Optional.ofNullable(clazz.cast(workteamArn()));
        case "ProductListingIds":
            return Optional.ofNullable(clazz.cast(productListingIds()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SubDomain":
            return Optional.ofNullable(clazz.cast(subDomain()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "LastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "NotificationConfiguration":
            return Optional.ofNullable(clazz.cast(notificationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Workteam, T> g) {
        return obj -> g.apply((Workteam) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Workteam> {
        /**
         * <p>
         * The name of the work team.
         * </p>
         * 
         * @param workteamName
         *        The name of the work team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workteamName(String workteamName);

        /**
         * <p>
         * The Amazon Cognito user groups that make up the work team.
         * </p>
         * 
         * @param memberDefinitions
         *        The Amazon Cognito user groups that make up the work team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberDefinitions(Collection<MemberDefinition> memberDefinitions);

        /**
         * <p>
         * The Amazon Cognito user groups that make up the work team.
         * </p>
         * 
         * @param memberDefinitions
         *        The Amazon Cognito user groups that make up the work team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberDefinitions(MemberDefinition... memberDefinitions);

        /**
         * <p>
         * The Amazon Cognito user groups that make up the work team.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MemberDefinition>.Builder} avoiding the
         * need to create one manually via {@link List<MemberDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MemberDefinition>.Builder#build()} is called immediately and
         * its result is passed to {@link #memberDefinitions(List<MemberDefinition>)}.
         * 
         * @param memberDefinitions
         *        a consumer that will call methods on {@link List<MemberDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memberDefinitions(List<MemberDefinition>)
         */
        Builder memberDefinitions(Consumer<MemberDefinition.Builder>... memberDefinitions);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the work team.
         * </p>
         * 
         * @param workteamArn
         *        The Amazon Resource Name (ARN) that identifies the work team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workteamArn(String workteamArn);

        /**
         * <p>
         * The Amazon Marketplace identifier for a vendor's work team.
         * </p>
         * 
         * @param productListingIds
         *        The Amazon Marketplace identifier for a vendor's work team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productListingIds(Collection<String> productListingIds);

        /**
         * <p>
         * The Amazon Marketplace identifier for a vendor's work team.
         * </p>
         * 
         * @param productListingIds
         *        The Amazon Marketplace identifier for a vendor's work team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productListingIds(String... productListingIds);

        /**
         * <p>
         * A description of the work team.
         * </p>
         * 
         * @param description
         *        A description of the work team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The URI of the labeling job's user interface. Workers open this URI to start labeling your data objects.
         * </p>
         * 
         * @param subDomain
         *        The URI of the labeling job's user interface. Workers open this URI to start labeling your data
         *        objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subDomain(String subDomain);

        /**
         * <p>
         * The date and time that the work team was created (timestamp).
         * </p>
         * 
         * @param createDate
         *        The date and time that the work team was created (timestamp).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The date and time that the work team was last updated (timestamp).
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date and time that the work team was last updated (timestamp).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p>
         * Configures SNS notifications of available or expiring work items for work teams.
         * </p>
         * 
         * @param notificationConfiguration
         *        Configures SNS notifications of available or expiring work items for work teams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfiguration(NotificationConfiguration notificationConfiguration);

        /**
         * <p>
         * Configures SNS notifications of available or expiring work items for work teams.
         * </p>
         * This is a convenience that creates an instance of the {@link NotificationConfiguration.Builder} avoiding the
         * need to create one manually via {@link NotificationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link NotificationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #notificationConfiguration(NotificationConfiguration)}.
         * 
         * @param notificationConfiguration
         *        a consumer that will call methods on {@link NotificationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationConfiguration(NotificationConfiguration)
         */
        default Builder notificationConfiguration(Consumer<NotificationConfiguration.Builder> notificationConfiguration) {
            return notificationConfiguration(NotificationConfiguration.builder().applyMutation(notificationConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String workteamName;

        private List<MemberDefinition> memberDefinitions = DefaultSdkAutoConstructList.getInstance();

        private String workteamArn;

        private List<String> productListingIds = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String subDomain;

        private Instant createDate;

        private Instant lastUpdatedDate;

        private NotificationConfiguration notificationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Workteam model) {
            workteamName(model.workteamName);
            memberDefinitions(model.memberDefinitions);
            workteamArn(model.workteamArn);
            productListingIds(model.productListingIds);
            description(model.description);
            subDomain(model.subDomain);
            createDate(model.createDate);
            lastUpdatedDate(model.lastUpdatedDate);
            notificationConfiguration(model.notificationConfiguration);
        }

        public final String getWorkteamName() {
            return workteamName;
        }

        @Override
        public final Builder workteamName(String workteamName) {
            this.workteamName = workteamName;
            return this;
        }

        public final void setWorkteamName(String workteamName) {
            this.workteamName = workteamName;
        }

        public final Collection<MemberDefinition.Builder> getMemberDefinitions() {
            return memberDefinitions != null ? memberDefinitions.stream().map(MemberDefinition::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder memberDefinitions(Collection<MemberDefinition> memberDefinitions) {
            this.memberDefinitions = MemberDefinitionsCopier.copy(memberDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDefinitions(MemberDefinition... memberDefinitions) {
            memberDefinitions(Arrays.asList(memberDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberDefinitions(Consumer<MemberDefinition.Builder>... memberDefinitions) {
            memberDefinitions(Stream.of(memberDefinitions).map(c -> MemberDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMemberDefinitions(Collection<MemberDefinition.BuilderImpl> memberDefinitions) {
            this.memberDefinitions = MemberDefinitionsCopier.copyFromBuilder(memberDefinitions);
        }

        public final String getWorkteamArn() {
            return workteamArn;
        }

        @Override
        public final Builder workteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
            return this;
        }

        public final void setWorkteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
        }

        public final Collection<String> getProductListingIds() {
            return productListingIds;
        }

        @Override
        public final Builder productListingIds(Collection<String> productListingIds) {
            this.productListingIds = ProductListingsCopier.copy(productListingIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productListingIds(String... productListingIds) {
            productListingIds(Arrays.asList(productListingIds));
            return this;
        }

        public final void setProductListingIds(Collection<String> productListingIds) {
            this.productListingIds = ProductListingsCopier.copy(productListingIds);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSubDomain() {
            return subDomain;
        }

        @Override
        public final Builder subDomain(String subDomain) {
            this.subDomain = subDomain;
            return this;
        }

        public final void setSubDomain(String subDomain) {
            this.subDomain = subDomain;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final NotificationConfiguration.Builder getNotificationConfiguration() {
            return notificationConfiguration != null ? notificationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder notificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        public final void setNotificationConfiguration(NotificationConfiguration.BuilderImpl notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration != null ? notificationConfiguration.build() : null;
        }

        @Override
        public Workteam build() {
            return new Workteam(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
