/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchRequest extends SageMakerRequest implements ToCopyableBuilder<SearchRequest.Builder, SearchRequest> {
    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchRequest::resourceAsString)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()).build();

    private static final SdkField<SearchExpression> SEARCH_EXPRESSION_FIELD = SdkField
            .<SearchExpression> builder(MarshallingType.SDK_POJO).getter(getter(SearchRequest::searchExpression))
            .setter(setter(Builder::searchExpression)).constructor(SearchExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchExpression").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchRequest::sortBy)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchRequest::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SearchRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD,
            SEARCH_EXPRESSION_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String resource;

    private final SearchExpression searchExpression;

    private final String sortBy;

    private final String sortOrder;

    private final String nextToken;

    private final Integer maxResults;

    private SearchRequest(BuilderImpl builder) {
        super(builder);
        this.resource = builder.resource;
        this.searchExpression = builder.searchExpression;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The name of the Amazon SageMaker resource to search for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resource} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceAsString}.
     * </p>
     * 
     * @return The name of the Amazon SageMaker resource to search for.
     * @see ResourceType
     */
    public ResourceType resource() {
        return ResourceType.fromValue(resource);
    }

    /**
     * <p>
     * The name of the Amazon SageMaker resource to search for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resource} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceAsString}.
     * </p>
     * 
     * @return The name of the Amazon SageMaker resource to search for.
     * @see ResourceType
     */
    public String resourceAsString() {
        return resource;
    }

    /**
     * <p>
     * A Boolean conditional statement. Resource objects must satisfy this condition to be included in search results.
     * You must provide at least one subexpression, filter, or nested filter. The maximum number of recursive
     * <code>SubExpressions</code>, <code>NestedFilters</code>, and <code>Filters</code> that can be included in a
     * <code>SearchExpression</code> object is 50.
     * </p>
     * 
     * @return A Boolean conditional statement. Resource objects must satisfy this condition to be included in search
     *         results. You must provide at least one subexpression, filter, or nested filter. The maximum number of
     *         recursive <code>SubExpressions</code>, <code>NestedFilters</code>, and <code>Filters</code> that can be
     *         included in a <code>SearchExpression</code> object is 50.
     */
    public SearchExpression searchExpression() {
        return searchExpression;
    }

    /**
     * <p>
     * The name of the resource property used to sort the <code>SearchResults</code>. The default is
     * <code>LastModifiedTime</code>.
     * </p>
     * 
     * @return The name of the resource property used to sort the <code>SearchResults</code>. The default is
     *         <code>LastModifiedTime</code>.
     */
    public String sortBy() {
        return sortBy;
    }

    /**
     * <p>
     * How <code>SearchResults</code> are ordered. Valid values are <code>Ascending</code> or <code>Descending</code>.
     * The default is <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SearchSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return How <code>SearchResults</code> are ordered. Valid values are <code>Ascending</code> or
     *         <code>Descending</code>. The default is <code>Descending</code>.
     * @see SearchSortOrder
     */
    public SearchSortOrder sortOrder() {
        return SearchSortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * How <code>SearchResults</code> are ordered. Valid values are <code>Ascending</code> or <code>Descending</code>.
     * The default is <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SearchSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return How <code>SearchResults</code> are ordered. Valid values are <code>Ascending</code> or
     *         <code>Descending</code>. The default is <code>Descending</code>.
     * @see SearchSortOrder
     */
    public String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * If more than <code>MaxResults</code> resource objects match the specified <code>SearchExpression</code>, the
     * <code>SearchResponse</code> includes a <code>NextToken</code>. The <code>NextToken</code> can be passed to the
     * next <code>SearchRequest</code> to continue retrieving results for the specified <code>SearchExpression</code>
     * and <code>Sort</code> parameters.
     * </p>
     * 
     * @return If more than <code>MaxResults</code> resource objects match the specified <code>SearchExpression</code>,
     *         the <code>SearchResponse</code> includes a <code>NextToken</code>. The <code>NextToken</code> can be
     *         passed to the next <code>SearchRequest</code> to continue retrieving results for the specified
     *         <code>SearchExpression</code> and <code>Sort</code> parameters.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in a <code>SearchResponse</code>.
     * </p>
     * 
     * @return The maximum number of results to return in a <code>SearchResponse</code>.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(searchExpression());
        hashCode = 31 * hashCode + Objects.hashCode(sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRequest)) {
            return false;
        }
        SearchRequest other = (SearchRequest) obj;
        return Objects.equals(resourceAsString(), other.resourceAsString())
                && Objects.equals(searchExpression(), other.searchExpression()) && Objects.equals(sortBy(), other.sortBy())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SearchRequest").add("Resource", resourceAsString()).add("SearchExpression", searchExpression())
                .add("SortBy", sortBy()).add("SortOrder", sortOrderAsString()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Resource":
            return Optional.ofNullable(clazz.cast(resourceAsString()));
        case "SearchExpression":
            return Optional.ofNullable(clazz.cast(searchExpression()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchRequest, T> g) {
        return obj -> g.apply((SearchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchRequest> {
        /**
         * <p>
         * The name of the Amazon SageMaker resource to search for.
         * </p>
         * 
         * @param resource
         *        The name of the Amazon SageMaker resource to search for.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resource(String resource);

        /**
         * <p>
         * The name of the Amazon SageMaker resource to search for.
         * </p>
         * 
         * @param resource
         *        The name of the Amazon SageMaker resource to search for.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resource(ResourceType resource);

        /**
         * <p>
         * A Boolean conditional statement. Resource objects must satisfy this condition to be included in search
         * results. You must provide at least one subexpression, filter, or nested filter. The maximum number of
         * recursive <code>SubExpressions</code>, <code>NestedFilters</code>, and <code>Filters</code> that can be
         * included in a <code>SearchExpression</code> object is 50.
         * </p>
         * 
         * @param searchExpression
         *        A Boolean conditional statement. Resource objects must satisfy this condition to be included in search
         *        results. You must provide at least one subexpression, filter, or nested filter. The maximum number of
         *        recursive <code>SubExpressions</code>, <code>NestedFilters</code>, and <code>Filters</code> that can
         *        be included in a <code>SearchExpression</code> object is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchExpression(SearchExpression searchExpression);

        /**
         * <p>
         * A Boolean conditional statement. Resource objects must satisfy this condition to be included in search
         * results. You must provide at least one subexpression, filter, or nested filter. The maximum number of
         * recursive <code>SubExpressions</code>, <code>NestedFilters</code>, and <code>Filters</code> that can be
         * included in a <code>SearchExpression</code> object is 50.
         * </p>
         * This is a convenience that creates an instance of the {@link SearchExpression.Builder} avoiding the need to
         * create one manually via {@link SearchExpression#builder()}.
         *
         * When the {@link Consumer} completes, {@link SearchExpression.Builder#build()} is called immediately and its
         * result is passed to {@link #searchExpression(SearchExpression)}.
         * 
         * @param searchExpression
         *        a consumer that will call methods on {@link SearchExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchExpression(SearchExpression)
         */
        default Builder searchExpression(Consumer<SearchExpression.Builder> searchExpression) {
            return searchExpression(SearchExpression.builder().applyMutation(searchExpression).build());
        }

        /**
         * <p>
         * The name of the resource property used to sort the <code>SearchResults</code>. The default is
         * <code>LastModifiedTime</code>.
         * </p>
         * 
         * @param sortBy
         *        The name of the resource property used to sort the <code>SearchResults</code>. The default is
         *        <code>LastModifiedTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * How <code>SearchResults</code> are ordered. Valid values are <code>Ascending</code> or
         * <code>Descending</code>. The default is <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        How <code>SearchResults</code> are ordered. Valid values are <code>Ascending</code> or
         *        <code>Descending</code>. The default is <code>Descending</code>.
         * @see SearchSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchSortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * How <code>SearchResults</code> are ordered. Valid values are <code>Ascending</code> or
         * <code>Descending</code>. The default is <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        How <code>SearchResults</code> are ordered. Valid values are <code>Ascending</code> or
         *        <code>Descending</code>. The default is <code>Descending</code>.
         * @see SearchSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchSortOrder
         */
        Builder sortOrder(SearchSortOrder sortOrder);

        /**
         * <p>
         * If more than <code>MaxResults</code> resource objects match the specified <code>SearchExpression</code>, the
         * <code>SearchResponse</code> includes a <code>NextToken</code>. The <code>NextToken</code> can be passed to
         * the next <code>SearchRequest</code> to continue retrieving results for the specified
         * <code>SearchExpression</code> and <code>Sort</code> parameters.
         * </p>
         * 
         * @param nextToken
         *        If more than <code>MaxResults</code> resource objects match the specified
         *        <code>SearchExpression</code>, the <code>SearchResponse</code> includes a <code>NextToken</code>. The
         *        <code>NextToken</code> can be passed to the next <code>SearchRequest</code> to continue retrieving
         *        results for the specified <code>SearchExpression</code> and <code>Sort</code> parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in a <code>SearchResponse</code>.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a <code>SearchResponse</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String resource;

        private SearchExpression searchExpression;

        private String sortBy;

        private String sortOrder;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchRequest model) {
            super(model);
            resource(model.resource);
            searchExpression(model.searchExpression);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getResourceAsString() {
            return resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        @Override
        public final Builder resource(ResourceType resource) {
            this.resource(resource == null ? null : resource.toString());
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final SearchExpression.Builder getSearchExpression() {
            return searchExpression != null ? searchExpression.toBuilder() : null;
        }

        @Override
        public final Builder searchExpression(SearchExpression searchExpression) {
            this.searchExpression = searchExpression;
            return this;
        }

        public final void setSearchExpression(SearchExpression.BuilderImpl searchExpression) {
            this.searchExpression = searchExpression != null ? searchExpression.build() : null;
        }

        public final String getSortBy() {
            return sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final String getSortOrderAsString() {
            return sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SearchSortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchRequest build() {
            return new SearchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
