/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProcessingJobRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateProcessingJobRequest.Builder, CreateProcessingJobRequest> {
    private static final SdkField<List<ProcessingInput>> PROCESSING_INPUTS_FIELD = SdkField
            .<List<ProcessingInput>> builder(MarshallingType.LIST)
            .getter(getter(CreateProcessingJobRequest::processingInputs))
            .setter(setter(Builder::processingInputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingInputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProcessingInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProcessingInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProcessingOutputConfig> PROCESSING_OUTPUT_CONFIG_FIELD = SdkField
            .<ProcessingOutputConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateProcessingJobRequest::processingOutputConfig)).setter(setter(Builder::processingOutputConfig))
            .constructor(ProcessingOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingOutputConfig").build())
            .build();

    private static final SdkField<String> PROCESSING_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateProcessingJobRequest::processingJobName)).setter(setter(Builder::processingJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJobName").build()).build();

    private static final SdkField<ProcessingResources> PROCESSING_RESOURCES_FIELD = SdkField
            .<ProcessingResources> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateProcessingJobRequest::processingResources)).setter(setter(Builder::processingResources))
            .constructor(ProcessingResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingResources").build())
            .build();

    private static final SdkField<ProcessingStoppingCondition> STOPPING_CONDITION_FIELD = SdkField
            .<ProcessingStoppingCondition> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateProcessingJobRequest::stoppingCondition)).setter(setter(Builder::stoppingCondition))
            .constructor(ProcessingStoppingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()).build();

    private static final SdkField<AppSpecification> APP_SPECIFICATION_FIELD = SdkField
            .<AppSpecification> builder(MarshallingType.SDK_POJO).getter(getter(CreateProcessingJobRequest::appSpecification))
            .setter(setter(Builder::appSpecification)).constructor(AppSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppSpecification").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateProcessingJobRequest::environment))
            .setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<NetworkConfig> NETWORK_CONFIG_FIELD = SdkField
            .<NetworkConfig> builder(MarshallingType.SDK_POJO).getter(getter(CreateProcessingJobRequest::networkConfig))
            .setter(setter(Builder::networkConfig)).constructor(NetworkConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfig").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateProcessingJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateProcessingJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ExperimentConfig> EXPERIMENT_CONFIG_FIELD = SdkField
            .<ExperimentConfig> builder(MarshallingType.SDK_POJO).getter(getter(CreateProcessingJobRequest::experimentConfig))
            .setter(setter(Builder::experimentConfig)).constructor(ExperimentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PROCESSING_INPUTS_FIELD, PROCESSING_OUTPUT_CONFIG_FIELD, PROCESSING_JOB_NAME_FIELD,
                    PROCESSING_RESOURCES_FIELD, STOPPING_CONDITION_FIELD, APP_SPECIFICATION_FIELD, ENVIRONMENT_FIELD,
                    NETWORK_CONFIG_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, EXPERIMENT_CONFIG_FIELD));

    private final List<ProcessingInput> processingInputs;

    private final ProcessingOutputConfig processingOutputConfig;

    private final String processingJobName;

    private final ProcessingResources processingResources;

    private final ProcessingStoppingCondition stoppingCondition;

    private final AppSpecification appSpecification;

    private final Map<String, String> environment;

    private final NetworkConfig networkConfig;

    private final String roleArn;

    private final List<Tag> tags;

    private final ExperimentConfig experimentConfig;

    private CreateProcessingJobRequest(BuilderImpl builder) {
        super(builder);
        this.processingInputs = builder.processingInputs;
        this.processingOutputConfig = builder.processingOutputConfig;
        this.processingJobName = builder.processingJobName;
        this.processingResources = builder.processingResources;
        this.stoppingCondition = builder.stoppingCondition;
        this.appSpecification = builder.appSpecification;
        this.environment = builder.environment;
        this.networkConfig = builder.networkConfig;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.experimentConfig = builder.experimentConfig;
    }

    /**
     * Returns true if the ProcessingInputs property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasProcessingInputs() {
        return processingInputs != null && !(processingInputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For each input, data is downloaded from S3 into the processing container before the processing job begins running
     * if "S3InputMode" is set to <code>File</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProcessingInputs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return For each input, data is downloaded from S3 into the processing container before the processing job begins
     *         running if "S3InputMode" is set to <code>File</code>.
     */
    public List<ProcessingInput> processingInputs() {
        return processingInputs;
    }

    /**
     * <p>
     * Output configuration for the processing job.
     * </p>
     * 
     * @return Output configuration for the processing job.
     */
    public ProcessingOutputConfig processingOutputConfig() {
        return processingOutputConfig;
    }

    /**
     * <p>
     * The name of the processing job. The name must be unique within an AWS Region in the AWS account.
     * </p>
     * 
     * @return The name of the processing job. The name must be unique within an AWS Region in the AWS account.
     */
    public String processingJobName() {
        return processingJobName;
    }

    /**
     * <p>
     * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In
     * distributed training, you specify more than one instance.
     * </p>
     * 
     * @return Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In
     *         distributed training, you specify more than one instance.
     */
    public ProcessingResources processingResources() {
        return processingResources;
    }

    /**
     * <p>
     * The time limit for how long the processing job is allowed to run.
     * </p>
     * 
     * @return The time limit for how long the processing job is allowed to run.
     */
    public ProcessingStoppingCondition stoppingCondition() {
        return stoppingCondition;
    }

    /**
     * <p>
     * Configures the processing job to run a specified Docker container image.
     * </p>
     * 
     * @return Configures the processing job to run a specified Docker container image.
     */
    public AppSpecification appSpecification() {
        return appSpecification;
    }

    /**
     * Returns true if the Environment property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEnvironment() {
        return environment != null && !(environment instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Sets the environment variables in the Docker container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnvironment()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Sets the environment variables in the Docker container.
     */
    public Map<String, String> environment() {
        return environment;
    }

    /**
     * <p>
     * Networking options for a processing job.
     * </p>
     * 
     * @return Networking options for a processing job.
     */
    public NetworkConfig networkConfig() {
        return networkConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your
     *         behalf.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Optional) An array of key-value pairs. For more information, see <a
     * href="https://docs-aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL">Using
     * Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return (Optional) An array of key-value pairs. For more information, see <a
     *         href="https://docs-aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
     *         >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * Returns the value of the ExperimentConfig property for this object.
     * 
     * @return The value of the ExperimentConfig property for this object.
     */
    public ExperimentConfig experimentConfig() {
        return experimentConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(processingInputs());
        hashCode = 31 * hashCode + Objects.hashCode(processingOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(processingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(processingResources());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(appSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(experimentConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProcessingJobRequest)) {
            return false;
        }
        CreateProcessingJobRequest other = (CreateProcessingJobRequest) obj;
        return Objects.equals(processingInputs(), other.processingInputs())
                && Objects.equals(processingOutputConfig(), other.processingOutputConfig())
                && Objects.equals(processingJobName(), other.processingJobName())
                && Objects.equals(processingResources(), other.processingResources())
                && Objects.equals(stoppingCondition(), other.stoppingCondition())
                && Objects.equals(appSpecification(), other.appSpecification())
                && Objects.equals(environment(), other.environment()) && Objects.equals(networkConfig(), other.networkConfig())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(tags(), other.tags())
                && Objects.equals(experimentConfig(), other.experimentConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateProcessingJobRequest").add("ProcessingInputs", processingInputs())
                .add("ProcessingOutputConfig", processingOutputConfig()).add("ProcessingJobName", processingJobName())
                .add("ProcessingResources", processingResources()).add("StoppingCondition", stoppingCondition())
                .add("AppSpecification", appSpecification()).add("Environment", environment())
                .add("NetworkConfig", networkConfig()).add("RoleArn", roleArn()).add("Tags", tags())
                .add("ExperimentConfig", experimentConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProcessingInputs":
            return Optional.ofNullable(clazz.cast(processingInputs()));
        case "ProcessingOutputConfig":
            return Optional.ofNullable(clazz.cast(processingOutputConfig()));
        case "ProcessingJobName":
            return Optional.ofNullable(clazz.cast(processingJobName()));
        case "ProcessingResources":
            return Optional.ofNullable(clazz.cast(processingResources()));
        case "StoppingCondition":
            return Optional.ofNullable(clazz.cast(stoppingCondition()));
        case "AppSpecification":
            return Optional.ofNullable(clazz.cast(appSpecification()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "NetworkConfig":
            return Optional.ofNullable(clazz.cast(networkConfig()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ExperimentConfig":
            return Optional.ofNullable(clazz.cast(experimentConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProcessingJobRequest, T> g) {
        return obj -> g.apply((CreateProcessingJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateProcessingJobRequest> {
        /**
         * <p>
         * For each input, data is downloaded from S3 into the processing container before the processing job begins
         * running if "S3InputMode" is set to <code>File</code>.
         * </p>
         * 
         * @param processingInputs
         *        For each input, data is downloaded from S3 into the processing container before the processing job
         *        begins running if "S3InputMode" is set to <code>File</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingInputs(Collection<ProcessingInput> processingInputs);

        /**
         * <p>
         * For each input, data is downloaded from S3 into the processing container before the processing job begins
         * running if "S3InputMode" is set to <code>File</code>.
         * </p>
         * 
         * @param processingInputs
         *        For each input, data is downloaded from S3 into the processing container before the processing job
         *        begins running if "S3InputMode" is set to <code>File</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingInputs(ProcessingInput... processingInputs);

        /**
         * <p>
         * For each input, data is downloaded from S3 into the processing container before the processing job begins
         * running if "S3InputMode" is set to <code>File</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProcessingInput>.Builder} avoiding the need
         * to create one manually via {@link List<ProcessingInput>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProcessingInput>.Builder#build()} is called immediately and
         * its result is passed to {@link #processingInputs(List<ProcessingInput>)}.
         * 
         * @param processingInputs
         *        a consumer that will call methods on {@link List<ProcessingInput>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingInputs(List<ProcessingInput>)
         */
        Builder processingInputs(Consumer<ProcessingInput.Builder>... processingInputs);

        /**
         * <p>
         * Output configuration for the processing job.
         * </p>
         * 
         * @param processingOutputConfig
         *        Output configuration for the processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingOutputConfig(ProcessingOutputConfig processingOutputConfig);

        /**
         * <p>
         * Output configuration for the processing job.
         * </p>
         * This is a convenience that creates an instance of the {@link ProcessingOutputConfig.Builder} avoiding the
         * need to create one manually via {@link ProcessingOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProcessingOutputConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #processingOutputConfig(ProcessingOutputConfig)}.
         * 
         * @param processingOutputConfig
         *        a consumer that will call methods on {@link ProcessingOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingOutputConfig(ProcessingOutputConfig)
         */
        default Builder processingOutputConfig(Consumer<ProcessingOutputConfig.Builder> processingOutputConfig) {
            return processingOutputConfig(ProcessingOutputConfig.builder().applyMutation(processingOutputConfig).build());
        }

        /**
         * <p>
         * The name of the processing job. The name must be unique within an AWS Region in the AWS account.
         * </p>
         * 
         * @param processingJobName
         *        The name of the processing job. The name must be unique within an AWS Region in the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingJobName(String processingJobName);

        /**
         * <p>
         * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In
         * distributed training, you specify more than one instance.
         * </p>
         * 
         * @param processingResources
         *        Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job.
         *        In distributed training, you specify more than one instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingResources(ProcessingResources processingResources);

        /**
         * <p>
         * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In
         * distributed training, you specify more than one instance.
         * </p>
         * This is a convenience that creates an instance of the {@link ProcessingResources.Builder} avoiding the need
         * to create one manually via {@link ProcessingResources#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProcessingResources.Builder#build()} is called immediately and
         * its result is passed to {@link #processingResources(ProcessingResources)}.
         * 
         * @param processingResources
         *        a consumer that will call methods on {@link ProcessingResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingResources(ProcessingResources)
         */
        default Builder processingResources(Consumer<ProcessingResources.Builder> processingResources) {
            return processingResources(ProcessingResources.builder().applyMutation(processingResources).build());
        }

        /**
         * <p>
         * The time limit for how long the processing job is allowed to run.
         * </p>
         * 
         * @param stoppingCondition
         *        The time limit for how long the processing job is allowed to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingCondition(ProcessingStoppingCondition stoppingCondition);

        /**
         * <p>
         * The time limit for how long the processing job is allowed to run.
         * </p>
         * This is a convenience that creates an instance of the {@link ProcessingStoppingCondition.Builder} avoiding
         * the need to create one manually via {@link ProcessingStoppingCondition#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProcessingStoppingCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #stoppingCondition(ProcessingStoppingCondition)}.
         * 
         * @param stoppingCondition
         *        a consumer that will call methods on {@link ProcessingStoppingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingCondition(ProcessingStoppingCondition)
         */
        default Builder stoppingCondition(Consumer<ProcessingStoppingCondition.Builder> stoppingCondition) {
            return stoppingCondition(ProcessingStoppingCondition.builder().applyMutation(stoppingCondition).build());
        }

        /**
         * <p>
         * Configures the processing job to run a specified Docker container image.
         * </p>
         * 
         * @param appSpecification
         *        Configures the processing job to run a specified Docker container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appSpecification(AppSpecification appSpecification);

        /**
         * <p>
         * Configures the processing job to run a specified Docker container image.
         * </p>
         * This is a convenience that creates an instance of the {@link AppSpecification.Builder} avoiding the need to
         * create one manually via {@link AppSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link AppSpecification.Builder#build()} is called immediately and its
         * result is passed to {@link #appSpecification(AppSpecification)}.
         * 
         * @param appSpecification
         *        a consumer that will call methods on {@link AppSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appSpecification(AppSpecification)
         */
        default Builder appSpecification(Consumer<AppSpecification.Builder> appSpecification) {
            return appSpecification(AppSpecification.builder().applyMutation(appSpecification).build());
        }

        /**
         * <p>
         * Sets the environment variables in the Docker container.
         * </p>
         * 
         * @param environment
         *        Sets the environment variables in the Docker container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Map<String, String> environment);

        /**
         * <p>
         * Networking options for a processing job.
         * </p>
         * 
         * @param networkConfig
         *        Networking options for a processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfig(NetworkConfig networkConfig);

        /**
         * <p>
         * Networking options for a processing job.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkConfig.Builder} avoiding the need to
         * create one manually via {@link NetworkConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #networkConfig(NetworkConfig)}.
         * 
         * @param networkConfig
         *        a consumer that will call methods on {@link NetworkConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfig(NetworkConfig)
         */
        default Builder networkConfig(Consumer<NetworkConfig.Builder> networkConfig) {
            return networkConfig(NetworkConfig.builder().applyMutation(networkConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your
         * behalf.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on
         *        your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * (Optional) An array of key-value pairs. For more information, see <a
         * href="https://docs-aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         * >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
         * </p>
         * 
         * @param tags
         *        (Optional) An array of key-value pairs. For more information, see <a href=
         *        "https://docs-aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         *        >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * (Optional) An array of key-value pairs. For more information, see <a
         * href="https://docs-aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         * >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
         * </p>
         * 
         * @param tags
         *        (Optional) An array of key-value pairs. For more information, see <a href=
         *        "https://docs-aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         *        >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * (Optional) An array of key-value pairs. For more information, see <a
         * href="https://docs-aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL"
         * >Using Cost Allocation Tags</a> in the <i>AWS Billing and Cost Management User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * Sets the value of the ExperimentConfig property for this object.
         *
         * @param experimentConfig
         *        The new value for the ExperimentConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentConfig(ExperimentConfig experimentConfig);

        /**
         * Sets the value of the ExperimentConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link ExperimentConfig.Builder} avoiding the need to
         * create one manually via {@link ExperimentConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExperimentConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #experimentConfig(ExperimentConfig)}.
         * 
         * @param experimentConfig
         *        a consumer that will call methods on {@link ExperimentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #experimentConfig(ExperimentConfig)
         */
        default Builder experimentConfig(Consumer<ExperimentConfig.Builder> experimentConfig) {
            return experimentConfig(ExperimentConfig.builder().applyMutation(experimentConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private List<ProcessingInput> processingInputs = DefaultSdkAutoConstructList.getInstance();

        private ProcessingOutputConfig processingOutputConfig;

        private String processingJobName;

        private ProcessingResources processingResources;

        private ProcessingStoppingCondition stoppingCondition;

        private AppSpecification appSpecification;

        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();

        private NetworkConfig networkConfig;

        private String roleArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private ExperimentConfig experimentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProcessingJobRequest model) {
            super(model);
            processingInputs(model.processingInputs);
            processingOutputConfig(model.processingOutputConfig);
            processingJobName(model.processingJobName);
            processingResources(model.processingResources);
            stoppingCondition(model.stoppingCondition);
            appSpecification(model.appSpecification);
            environment(model.environment);
            networkConfig(model.networkConfig);
            roleArn(model.roleArn);
            tags(model.tags);
            experimentConfig(model.experimentConfig);
        }

        public final Collection<ProcessingInput.Builder> getProcessingInputs() {
            return processingInputs != null ? processingInputs.stream().map(ProcessingInput::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder processingInputs(Collection<ProcessingInput> processingInputs) {
            this.processingInputs = ProcessingInputsCopier.copy(processingInputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingInputs(ProcessingInput... processingInputs) {
            processingInputs(Arrays.asList(processingInputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingInputs(Consumer<ProcessingInput.Builder>... processingInputs) {
            processingInputs(Stream.of(processingInputs).map(c -> ProcessingInput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProcessingInputs(Collection<ProcessingInput.BuilderImpl> processingInputs) {
            this.processingInputs = ProcessingInputsCopier.copyFromBuilder(processingInputs);
        }

        public final ProcessingOutputConfig.Builder getProcessingOutputConfig() {
            return processingOutputConfig != null ? processingOutputConfig.toBuilder() : null;
        }

        @Override
        public final Builder processingOutputConfig(ProcessingOutputConfig processingOutputConfig) {
            this.processingOutputConfig = processingOutputConfig;
            return this;
        }

        public final void setProcessingOutputConfig(ProcessingOutputConfig.BuilderImpl processingOutputConfig) {
            this.processingOutputConfig = processingOutputConfig != null ? processingOutputConfig.build() : null;
        }

        public final String getProcessingJobName() {
            return processingJobName;
        }

        @Override
        public final Builder processingJobName(String processingJobName) {
            this.processingJobName = processingJobName;
            return this;
        }

        public final void setProcessingJobName(String processingJobName) {
            this.processingJobName = processingJobName;
        }

        public final ProcessingResources.Builder getProcessingResources() {
            return processingResources != null ? processingResources.toBuilder() : null;
        }

        @Override
        public final Builder processingResources(ProcessingResources processingResources) {
            this.processingResources = processingResources;
            return this;
        }

        public final void setProcessingResources(ProcessingResources.BuilderImpl processingResources) {
            this.processingResources = processingResources != null ? processingResources.build() : null;
        }

        public final ProcessingStoppingCondition.Builder getStoppingCondition() {
            return stoppingCondition != null ? stoppingCondition.toBuilder() : null;
        }

        @Override
        public final Builder stoppingCondition(ProcessingStoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final void setStoppingCondition(ProcessingStoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        public final AppSpecification.Builder getAppSpecification() {
            return appSpecification != null ? appSpecification.toBuilder() : null;
        }

        @Override
        public final Builder appSpecification(AppSpecification appSpecification) {
            this.appSpecification = appSpecification;
            return this;
        }

        public final void setAppSpecification(AppSpecification.BuilderImpl appSpecification) {
            this.appSpecification = appSpecification != null ? appSpecification.build() : null;
        }

        public final Map<String, String> getEnvironment() {
            return environment;
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = ProcessingEnvironmentMapCopier.copy(environment);
            return this;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = ProcessingEnvironmentMapCopier.copy(environment);
        }

        public final NetworkConfig.Builder getNetworkConfig() {
            return networkConfig != null ? networkConfig.toBuilder() : null;
        }

        @Override
        public final Builder networkConfig(NetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        public final void setNetworkConfig(NetworkConfig.BuilderImpl networkConfig) {
            this.networkConfig = networkConfig != null ? networkConfig.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final ExperimentConfig.Builder getExperimentConfig() {
            return experimentConfig != null ? experimentConfig.toBuilder() : null;
        }

        @Override
        public final Builder experimentConfig(ExperimentConfig experimentConfig) {
            this.experimentConfig = experimentConfig;
            return this;
        }

        public final void setExperimentConfig(ExperimentConfig.BuilderImpl experimentConfig) {
            this.experimentConfig = experimentConfig != null ? experimentConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProcessingJobRequest build() {
            return new CreateProcessingJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
