/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about the flow definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowDefinitionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowDefinitionSummary.Builder, FlowDefinitionSummary> {
    private static final SdkField<String> FLOW_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FlowDefinitionSummary::flowDefinitionName)).setter(setter(Builder::flowDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionName").build())
            .build();

    private static final SdkField<String> FLOW_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FlowDefinitionSummary::flowDefinitionArn)).setter(setter(Builder::flowDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionArn").build()).build();

    private static final SdkField<String> FLOW_DEFINITION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FlowDefinitionSummary::flowDefinitionStatusAsString)).setter(setter(Builder::flowDefinitionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionStatus").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(FlowDefinitionSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FlowDefinitionSummary::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_DEFINITION_NAME_FIELD,
            FLOW_DEFINITION_ARN_FIELD, FLOW_DEFINITION_STATUS_FIELD, CREATION_TIME_FIELD, FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String flowDefinitionName;

    private final String flowDefinitionArn;

    private final String flowDefinitionStatus;

    private final Instant creationTime;

    private final String failureReason;

    private FlowDefinitionSummary(BuilderImpl builder) {
        this.flowDefinitionName = builder.flowDefinitionName;
        this.flowDefinitionArn = builder.flowDefinitionArn;
        this.flowDefinitionStatus = builder.flowDefinitionStatus;
        this.creationTime = builder.creationTime;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The name of the flow definition.
     * </p>
     * 
     * @return The name of the flow definition.
     */
    public String flowDefinitionName() {
        return flowDefinitionName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the flow definition.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the flow definition.
     */
    public String flowDefinitionArn() {
        return flowDefinitionArn;
    }

    /**
     * <p>
     * The status of the flow definition. Valid values:
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flowDefinitionStatus} will return {@link FlowDefinitionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #flowDefinitionStatusAsString}.
     * </p>
     * 
     * @return The status of the flow definition. Valid values:
     * @see FlowDefinitionStatus
     */
    public FlowDefinitionStatus flowDefinitionStatus() {
        return FlowDefinitionStatus.fromValue(flowDefinitionStatus);
    }

    /**
     * <p>
     * The status of the flow definition. Valid values:
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flowDefinitionStatus} will return {@link FlowDefinitionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #flowDefinitionStatusAsString}.
     * </p>
     * 
     * @return The status of the flow definition. Valid values:
     * @see FlowDefinitionStatus
     */
    public String flowDefinitionStatusAsString() {
        return flowDefinitionStatus;
    }

    /**
     * <p>
     * The timestamp when SageMaker created the flow definition.
     * </p>
     * 
     * @return The timestamp when SageMaker created the flow definition.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The reason why the flow definition creation failed. A failure reason is returned only when the flow definition
     * status is <code>Failed</code>.
     * </p>
     * 
     * @return The reason why the flow definition creation failed. A failure reason is returned only when the flow
     *         definition status is <code>Failed</code>.
     */
    public String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(flowDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(flowDefinitionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowDefinitionSummary)) {
            return false;
        }
        FlowDefinitionSummary other = (FlowDefinitionSummary) obj;
        return Objects.equals(flowDefinitionName(), other.flowDefinitionName())
                && Objects.equals(flowDefinitionArn(), other.flowDefinitionArn())
                && Objects.equals(flowDefinitionStatusAsString(), other.flowDefinitionStatusAsString())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FlowDefinitionSummary").add("FlowDefinitionName", flowDefinitionName())
                .add("FlowDefinitionArn", flowDefinitionArn()).add("FlowDefinitionStatus", flowDefinitionStatusAsString())
                .add("CreationTime", creationTime()).add("FailureReason", failureReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowDefinitionName":
            return Optional.ofNullable(clazz.cast(flowDefinitionName()));
        case "FlowDefinitionArn":
            return Optional.ofNullable(clazz.cast(flowDefinitionArn()));
        case "FlowDefinitionStatus":
            return Optional.ofNullable(clazz.cast(flowDefinitionStatusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlowDefinitionSummary, T> g) {
        return obj -> g.apply((FlowDefinitionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowDefinitionSummary> {
        /**
         * <p>
         * The name of the flow definition.
         * </p>
         * 
         * @param flowDefinitionName
         *        The name of the flow definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowDefinitionName(String flowDefinitionName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the flow definition.
         * </p>
         * 
         * @param flowDefinitionArn
         *        The Amazon Resource Name (ARN) of the flow definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowDefinitionArn(String flowDefinitionArn);

        /**
         * <p>
         * The status of the flow definition. Valid values:
         * </p>
         * 
         * @param flowDefinitionStatus
         *        The status of the flow definition. Valid values:
         * @see FlowDefinitionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowDefinitionStatus
         */
        Builder flowDefinitionStatus(String flowDefinitionStatus);

        /**
         * <p>
         * The status of the flow definition. Valid values:
         * </p>
         * 
         * @param flowDefinitionStatus
         *        The status of the flow definition. Valid values:
         * @see FlowDefinitionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowDefinitionStatus
         */
        Builder flowDefinitionStatus(FlowDefinitionStatus flowDefinitionStatus);

        /**
         * <p>
         * The timestamp when SageMaker created the flow definition.
         * </p>
         * 
         * @param creationTime
         *        The timestamp when SageMaker created the flow definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The reason why the flow definition creation failed. A failure reason is returned only when the flow
         * definition status is <code>Failed</code>.
         * </p>
         * 
         * @param failureReason
         *        The reason why the flow definition creation failed. A failure reason is returned only when the flow
         *        definition status is <code>Failed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String flowDefinitionName;

        private String flowDefinitionArn;

        private String flowDefinitionStatus;

        private Instant creationTime;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowDefinitionSummary model) {
            flowDefinitionName(model.flowDefinitionName);
            flowDefinitionArn(model.flowDefinitionArn);
            flowDefinitionStatus(model.flowDefinitionStatus);
            creationTime(model.creationTime);
            failureReason(model.failureReason);
        }

        public final String getFlowDefinitionName() {
            return flowDefinitionName;
        }

        @Override
        public final Builder flowDefinitionName(String flowDefinitionName) {
            this.flowDefinitionName = flowDefinitionName;
            return this;
        }

        public final void setFlowDefinitionName(String flowDefinitionName) {
            this.flowDefinitionName = flowDefinitionName;
        }

        public final String getFlowDefinitionArn() {
            return flowDefinitionArn;
        }

        @Override
        public final Builder flowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
            return this;
        }

        public final void setFlowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
        }

        public final String getFlowDefinitionStatusAsString() {
            return flowDefinitionStatus;
        }

        @Override
        public final Builder flowDefinitionStatus(String flowDefinitionStatus) {
            this.flowDefinitionStatus = flowDefinitionStatus;
            return this;
        }

        @Override
        public final Builder flowDefinitionStatus(FlowDefinitionStatus flowDefinitionStatus) {
            this.flowDefinitionStatus(flowDefinitionStatus == null ? null : flowDefinitionStatus.toString());
            return this;
        }

        public final void setFlowDefinitionStatus(String flowDefinitionStatus) {
            this.flowDefinitionStatus = flowDefinitionStatus;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public FlowDefinitionSummary build() {
            return new FlowDefinitionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
