/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the resources, including ML compute instances and ML storage volumes, to use for model training.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceConfig implements SdkPojo, Serializable, ToCopyableBuilder<ResourceConfig.Builder, ResourceConfig> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceConfig::instanceTypeAsString)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ResourceConfig::instanceCount)).setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ResourceConfig::volumeSizeInGB)).setter(setter(Builder::volumeSizeInGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInGB").build()).build();

    private static final SdkField<String> VOLUME_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceConfig::volumeKmsKeyId)).setter(setter(Builder::volumeKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeKmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD,
            INSTANCE_COUNT_FIELD, VOLUME_SIZE_IN_GB_FIELD, VOLUME_KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceType;

    private final Integer instanceCount;

    private final Integer volumeSizeInGB;

    private final String volumeKmsKeyId;

    private ResourceConfig(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.instanceCount = builder.instanceCount;
        this.volumeSizeInGB = builder.volumeSizeInGB;
        this.volumeKmsKeyId = builder.volumeKmsKeyId;
    }

    /**
     * <p>
     * The ML compute instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link TrainingInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The ML compute instance type.
     * @see TrainingInstanceType
     */
    public TrainingInstanceType instanceType() {
        return TrainingInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The ML compute instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link TrainingInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The ML compute instance type.
     * @see TrainingInstanceType
     */
    public String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The number of ML compute instances to use. For distributed training, provide a value greater than 1.
     * </p>
     * 
     * @return The number of ML compute instances to use. For distributed training, provide a value greater than 1.
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The size of the ML storage volume that you want to provision.
     * </p>
     * <p>
     * ML storage volumes store model artifacts and incremental states. Training algorithms might also use the ML
     * storage volume for scratch space. If you want to store the training data in the ML storage volume, choose
     * <code>File</code> as the <code>TrainingInputMode</code> in the algorithm specification.
     * </p>
     * <p>
     * You must specify sufficient ML storage for your scenario.
     * </p>
     * <note>
     * <p>
     * Amazon SageMaker supports only the General Purpose SSD (gp2) ML storage volume type.
     * </p>
     * </note> <note>
     * <p>
     * Certain Nitro-based instances include local storage with a fixed total size, dependent on the instance type. When
     * using these instances for training, Amazon SageMaker mounts the local instance storage instead of Amazon EBS gp2
     * storage. You can't request a <code>VolumeSizeInGB</code> greater than the total size of the local instance
     * storage.
     * </p>
     * <p>
     * For a list of instance types that support local instance storage, including the total size per instance type, see
     * <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance
     * Store Volumes</a>.
     * </p>
     * </note>
     * 
     * @return The size of the ML storage volume that you want to provision. </p>
     *         <p>
     *         ML storage volumes store model artifacts and incremental states. Training algorithms might also use the
     *         ML storage volume for scratch space. If you want to store the training data in the ML storage volume,
     *         choose <code>File</code> as the <code>TrainingInputMode</code> in the algorithm specification.
     *         </p>
     *         <p>
     *         You must specify sufficient ML storage for your scenario.
     *         </p>
     *         <note>
     *         <p>
     *         Amazon SageMaker supports only the General Purpose SSD (gp2) ML storage volume type.
     *         </p>
     *         </note> <note>
     *         <p>
     *         Certain Nitro-based instances include local storage with a fixed total size, dependent on the instance
     *         type. When using these instances for training, Amazon SageMaker mounts the local instance storage instead
     *         of Amazon EBS gp2 storage. You can't request a <code>VolumeSizeInGB</code> greater than the total size of
     *         the local instance storage.
     *         </p>
     *         <p>
     *         For a list of instance types that support local instance storage, including the total size per instance
     *         type, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes"
     *         >Instance Store Volumes</a>.
     *         </p>
     */
    public Integer volumeSizeInGB() {
        return volumeSizeInGB;
    }

    /**
     * <p>
     * The AWS KMS key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute
     * instance(s) that run the training job.
     * </p>
     * <note>
     * <p>
     * Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes are
     * encrypted using a hardware module on the instance. You can't request a <code>VolumeKmsKeyId</code> when using an
     * instance type with local storage.
     * </p>
     * <p>
     * For a list of instance types that support local instance storage, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">Instance
     * Store Volumes</a>.
     * </p>
     * <p>
     * For more information about local instance storage encryption, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store
     * Volumes</a>.
     * </p>
     * </note>
     * <p>
     * The <code>VolumeKmsKeyId</code> can be in any of the following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * // KMS Key ID
     * </p>
     * <p>
     * <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * // Amazon Resource Name (ARN) of a KMS Key
     * </p>
     * <p>
     * <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The AWS KMS key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML
     *         compute instance(s) that run the training job.</p> <note>
     *         <p>
     *         Certain Nitro-based instances include local storage, dependent on the instance type. Local storage
     *         volumes are encrypted using a hardware module on the instance. You can't request a
     *         <code>VolumeKmsKeyId</code> when using an instance type with local storage.
     *         </p>
     *         <p>
     *         For a list of instance types that support local instance storage, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes"
     *         >Instance Store Volumes</a>.
     *         </p>
     *         <p>
     *         For more information about local instance storage encryption, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store
     *         Volumes</a>.
     *         </p>
     *         </note>
     *         <p>
     *         The <code>VolumeKmsKeyId</code> can be in any of the following formats:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         // KMS Key ID
     *         </p>
     *         <p>
     *         <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         // Amazon Resource Name (ARN) of a KMS Key
     *         </p>
     *         <p>
     *         <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
     *         </p>
     *         </li>
     */
    public String volumeKmsKeyId() {
        return volumeKmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(volumeKmsKeyId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceConfig)) {
            return false;
        }
        ResourceConfig other = (ResourceConfig) obj;
        return Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(volumeSizeInGB(), other.volumeSizeInGB())
                && Objects.equals(volumeKmsKeyId(), other.volumeKmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceConfig").add("InstanceType", instanceTypeAsString())
                .add("InstanceCount", instanceCount()).add("VolumeSizeInGB", volumeSizeInGB())
                .add("VolumeKmsKeyId", volumeKmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "VolumeSizeInGB":
            return Optional.ofNullable(clazz.cast(volumeSizeInGB()));
        case "VolumeKmsKeyId":
            return Optional.ofNullable(clazz.cast(volumeKmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceConfig, T> g) {
        return obj -> g.apply((ResourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceConfig> {
        /**
         * <p>
         * The ML compute instance type.
         * </p>
         * 
         * @param instanceType
         *        The ML compute instance type.
         * @see TrainingInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The ML compute instance type.
         * </p>
         * 
         * @param instanceType
         *        The ML compute instance type.
         * @see TrainingInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingInstanceType
         */
        Builder instanceType(TrainingInstanceType instanceType);

        /**
         * <p>
         * The number of ML compute instances to use. For distributed training, provide a value greater than 1.
         * </p>
         * 
         * @param instanceCount
         *        The number of ML compute instances to use. For distributed training, provide a value greater than 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The size of the ML storage volume that you want to provision.
         * </p>
         * <p>
         * ML storage volumes store model artifacts and incremental states. Training algorithms might also use the ML
         * storage volume for scratch space. If you want to store the training data in the ML storage volume, choose
         * <code>File</code> as the <code>TrainingInputMode</code> in the algorithm specification.
         * </p>
         * <p>
         * You must specify sufficient ML storage for your scenario.
         * </p>
         * <note>
         * <p>
         * Amazon SageMaker supports only the General Purpose SSD (gp2) ML storage volume type.
         * </p>
         * </note> <note>
         * <p>
         * Certain Nitro-based instances include local storage with a fixed total size, dependent on the instance type.
         * When using these instances for training, Amazon SageMaker mounts the local instance storage instead of Amazon
         * EBS gp2 storage. You can't request a <code>VolumeSizeInGB</code> greater than the total size of the local
         * instance storage.
         * </p>
         * <p>
         * For a list of instance types that support local instance storage, including the total size per instance type,
         * see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes">
         * Instance Store Volumes</a>.
         * </p>
         * </note>
         * 
         * @param volumeSizeInGB
         *        The size of the ML storage volume that you want to provision. </p>
         *        <p>
         *        ML storage volumes store model artifacts and incremental states. Training algorithms might also use
         *        the ML storage volume for scratch space. If you want to store the training data in the ML storage
         *        volume, choose <code>File</code> as the <code>TrainingInputMode</code> in the algorithm specification.
         *        </p>
         *        <p>
         *        You must specify sufficient ML storage for your scenario.
         *        </p>
         *        <note>
         *        <p>
         *        Amazon SageMaker supports only the General Purpose SSD (gp2) ML storage volume type.
         *        </p>
         *        </note> <note>
         *        <p>
         *        Certain Nitro-based instances include local storage with a fixed total size, dependent on the instance
         *        type. When using these instances for training, Amazon SageMaker mounts the local instance storage
         *        instead of Amazon EBS gp2 storage. You can't request a <code>VolumeSizeInGB</code> greater than the
         *        total size of the local instance storage.
         *        </p>
         *        <p>
         *        For a list of instance types that support local instance storage, including the total size per
         *        instance type, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes"
         *        >Instance Store Volumes</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSizeInGB(Integer volumeSizeInGB);

        /**
         * <p>
         * The AWS KMS key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute
         * instance(s) that run the training job.
         * </p>
         * <note>
         * <p>
         * Certain Nitro-based instances include local storage, dependent on the instance type. Local storage volumes
         * are encrypted using a hardware module on the instance. You can't request a <code>VolumeKmsKeyId</code> when
         * using an instance type with local storage.
         * </p>
         * <p>
         * For a list of instance types that support local instance storage, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes"
         * >Instance Store Volumes</a>.
         * </p>
         * <p>
         * For more information about local instance storage encryption, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store
         * Volumes</a>.
         * </p>
         * </note>
         * <p>
         * The <code>VolumeKmsKeyId</code> can be in any of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * // KMS Key ID
         * </p>
         * <p>
         * <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * // Amazon Resource Name (ARN) of a KMS Key
         * </p>
         * <p>
         * <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param volumeKmsKeyId
         *        The AWS KMS key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML
         *        compute instance(s) that run the training job.</p> <note>
         *        <p>
         *        Certain Nitro-based instances include local storage, dependent on the instance type. Local storage
         *        volumes are encrypted using a hardware module on the instance. You can't request a
         *        <code>VolumeKmsKeyId</code> when using an instance type with local storage.
         *        </p>
         *        <p>
         *        For a list of instance types that support local instance storage, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html#instance-store-volumes"
         *        >Instance Store Volumes</a>.
         *        </p>
         *        <p>
         *        For more information about local instance storage encryption, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ssd-instance-store.html">SSD Instance Store
         *        Volumes</a>.
         *        </p>
         *        </note>
         *        <p>
         *        The <code>VolumeKmsKeyId</code> can be in any of the following formats:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        // KMS Key ID
         *        </p>
         *        <p>
         *        <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        // Amazon Resource Name (ARN) of a KMS Key
         *        </p>
         *        <p>
         *        <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeKmsKeyId(String volumeKmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String instanceType;

        private Integer instanceCount;

        private Integer volumeSizeInGB;

        private String volumeKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceConfig model) {
            instanceType(model.instanceType);
            instanceCount(model.instanceCount);
            volumeSizeInGB(model.volumeSizeInGB);
            volumeKmsKeyId(model.volumeKmsKeyId);
        }

        public final String getInstanceTypeAsString() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(TrainingInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final Integer getVolumeSizeInGB() {
            return volumeSizeInGB;
        }

        @Override
        public final Builder volumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
            return this;
        }

        public final void setVolumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
        }

        public final String getVolumeKmsKeyId() {
            return volumeKmsKeyId;
        }

        @Override
        public final Builder volumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
            return this;
        }

        public final void setVolumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
        }

        @Override
        public ResourceConfig build() {
            return new ResourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
