/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNotebookInstanceLifecycleConfigsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListNotebookInstanceLifecycleConfigsRequest.Builder, ListNotebookInstanceLifecycleConfigsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListNotebookInstanceLifecycleConfigsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListNotebookInstanceLifecycleConfigsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListNotebookInstanceLifecycleConfigsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListNotebookInstanceLifecycleConfigsRequest::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListNotebookInstanceLifecycleConfigsRequest::nameContains)).setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()).build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListNotebookInstanceLifecycleConfigsRequest::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListNotebookInstanceLifecycleConfigsRequest::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListNotebookInstanceLifecycleConfigsRequest::lastModifiedTimeBefore))
            .setter(setter(Builder::lastModifiedTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeBefore").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListNotebookInstanceLifecycleConfigsRequest::lastModifiedTimeAfter))
            .setter(setter(Builder::lastModifiedTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeAfter").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, NAME_CONTAINS_FIELD, CREATION_TIME_BEFORE_FIELD,
            CREATION_TIME_AFTER_FIELD, LAST_MODIFIED_TIME_BEFORE_FIELD, LAST_MODIFIED_TIME_AFTER_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final String sortBy;

    private final String sortOrder;

    private final String nameContains;

    private final Instant creationTimeBefore;

    private final Instant creationTimeAfter;

    private final Instant lastModifiedTimeBefore;

    private final Instant lastModifiedTimeAfter;

    private ListNotebookInstanceLifecycleConfigsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.nameContains = builder.nameContains;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.lastModifiedTimeBefore = builder.lastModifiedTimeBefore;
        this.lastModifiedTimeAfter = builder.lastModifiedTimeAfter;
    }

    /**
     * <p>
     * If the result of a <code>ListNotebookInstanceLifecycleConfigs</code> request was truncated, the response includes
     * a <code>NextToken</code>. To get the next set of lifecycle configurations, use the token in the next request.
     * </p>
     * 
     * @return If the result of a <code>ListNotebookInstanceLifecycleConfigs</code> request was truncated, the response
     *         includes a <code>NextToken</code>. To get the next set of lifecycle configurations, use the token in the
     *         next request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of lifecycle configurations to return in the response.
     * </p>
     * 
     * @return The maximum number of lifecycle configurations to return in the response.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Sorts the list of results. The default is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link NotebookInstanceLifecycleConfigSortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #sortByAsString}.
     * </p>
     * 
     * @return Sorts the list of results. The default is <code>CreationTime</code>.
     * @see NotebookInstanceLifecycleConfigSortKey
     */
    public NotebookInstanceLifecycleConfigSortKey sortBy() {
        return NotebookInstanceLifecycleConfigSortKey.fromValue(sortBy);
    }

    /**
     * <p>
     * Sorts the list of results. The default is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link NotebookInstanceLifecycleConfigSortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #sortByAsString}.
     * </p>
     * 
     * @return Sorts the list of results. The default is <code>CreationTime</code>.
     * @see NotebookInstanceLifecycleConfigSortKey
     */
    public String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The sort order for results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link NotebookInstanceLifecycleConfigSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for results.
     * @see NotebookInstanceLifecycleConfigSortOrder
     */
    public NotebookInstanceLifecycleConfigSortOrder sortOrder() {
        return NotebookInstanceLifecycleConfigSortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order for results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link NotebookInstanceLifecycleConfigSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for results.
     * @see NotebookInstanceLifecycleConfigSortOrder
     */
    public String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * A string in the lifecycle configuration name. This filter returns only lifecycle configurations whose name
     * contains the specified string.
     * </p>
     * 
     * @return A string in the lifecycle configuration name. This filter returns only lifecycle configurations whose
     *         name contains the specified string.
     */
    public String nameContains() {
        return nameContains;
    }

    /**
     * <p>
     * A filter that returns only lifecycle configurations that were created before the specified time (timestamp).
     * </p>
     * 
     * @return A filter that returns only lifecycle configurations that were created before the specified time
     *         (timestamp).
     */
    public Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * A filter that returns only lifecycle configurations that were created after the specified time (timestamp).
     * </p>
     * 
     * @return A filter that returns only lifecycle configurations that were created after the specified time
     *         (timestamp).
     */
    public Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    /**
     * <p>
     * A filter that returns only lifecycle configurations that were modified before the specified time (timestamp).
     * </p>
     * 
     * @return A filter that returns only lifecycle configurations that were modified before the specified time
     *         (timestamp).
     */
    public Instant lastModifiedTimeBefore() {
        return lastModifiedTimeBefore;
    }

    /**
     * <p>
     * A filter that returns only lifecycle configurations that were modified after the specified time (timestamp).
     * </p>
     * 
     * @return A filter that returns only lifecycle configurations that were modified after the specified time
     *         (timestamp).
     */
    public Instant lastModifiedTimeAfter() {
        return lastModifiedTimeAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimeAfter());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotebookInstanceLifecycleConfigsRequest)) {
            return false;
        }
        ListNotebookInstanceLifecycleConfigsRequest other = (ListNotebookInstanceLifecycleConfigsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(nameContains(), other.nameContains())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(creationTimeAfter(), other.creationTimeAfter())
                && Objects.equals(lastModifiedTimeBefore(), other.lastModifiedTimeBefore())
                && Objects.equals(lastModifiedTimeAfter(), other.lastModifiedTimeAfter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListNotebookInstanceLifecycleConfigsRequest").add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString())
                .add("NameContains", nameContains()).add("CreationTimeBefore", creationTimeBefore())
                .add("CreationTimeAfter", creationTimeAfter()).add("LastModifiedTimeBefore", lastModifiedTimeBefore())
                .add("LastModifiedTimeAfter", lastModifiedTimeAfter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "NameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        case "LastModifiedTimeBefore":
            return Optional.ofNullable(clazz.cast(lastModifiedTimeBefore()));
        case "LastModifiedTimeAfter":
            return Optional.ofNullable(clazz.cast(lastModifiedTimeAfter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNotebookInstanceLifecycleConfigsRequest, T> g) {
        return obj -> g.apply((ListNotebookInstanceLifecycleConfigsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListNotebookInstanceLifecycleConfigsRequest> {
        /**
         * <p>
         * If the result of a <code>ListNotebookInstanceLifecycleConfigs</code> request was truncated, the response
         * includes a <code>NextToken</code>. To get the next set of lifecycle configurations, use the token in the next
         * request.
         * </p>
         * 
         * @param nextToken
         *        If the result of a <code>ListNotebookInstanceLifecycleConfigs</code> request was truncated, the
         *        response includes a <code>NextToken</code>. To get the next set of lifecycle configurations, use the
         *        token in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of lifecycle configurations to return in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of lifecycle configurations to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Sorts the list of results. The default is <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        Sorts the list of results. The default is <code>CreationTime</code>.
         * @see NotebookInstanceLifecycleConfigSortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotebookInstanceLifecycleConfigSortKey
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * Sorts the list of results. The default is <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        Sorts the list of results. The default is <code>CreationTime</code>.
         * @see NotebookInstanceLifecycleConfigSortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotebookInstanceLifecycleConfigSortKey
         */
        Builder sortBy(NotebookInstanceLifecycleConfigSortKey sortBy);

        /**
         * <p>
         * The sort order for results.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for results.
         * @see NotebookInstanceLifecycleConfigSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotebookInstanceLifecycleConfigSortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order for results.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for results.
         * @see NotebookInstanceLifecycleConfigSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotebookInstanceLifecycleConfigSortOrder
         */
        Builder sortOrder(NotebookInstanceLifecycleConfigSortOrder sortOrder);

        /**
         * <p>
         * A string in the lifecycle configuration name. This filter returns only lifecycle configurations whose name
         * contains the specified string.
         * </p>
         * 
         * @param nameContains
         *        A string in the lifecycle configuration name. This filter returns only lifecycle configurations whose
         *        name contains the specified string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        /**
         * <p>
         * A filter that returns only lifecycle configurations that were created before the specified time (timestamp).
         * </p>
         * 
         * @param creationTimeBefore
         *        A filter that returns only lifecycle configurations that were created before the specified time
         *        (timestamp).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * A filter that returns only lifecycle configurations that were created after the specified time (timestamp).
         * </p>
         * 
         * @param creationTimeAfter
         *        A filter that returns only lifecycle configurations that were created after the specified time
         *        (timestamp).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        /**
         * <p>
         * A filter that returns only lifecycle configurations that were modified before the specified time (timestamp).
         * </p>
         * 
         * @param lastModifiedTimeBefore
         *        A filter that returns only lifecycle configurations that were modified before the specified time
         *        (timestamp).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore);

        /**
         * <p>
         * A filter that returns only lifecycle configurations that were modified after the specified time (timestamp).
         * </p>
         * 
         * @param lastModifiedTimeAfter
         *        A filter that returns only lifecycle configurations that were modified after the specified time
         *        (timestamp).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String sortBy;

        private String sortOrder;

        private String nameContains;

        private Instant creationTimeBefore;

        private Instant creationTimeAfter;

        private Instant lastModifiedTimeBefore;

        private Instant lastModifiedTimeAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotebookInstanceLifecycleConfigsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            nameContains(model.nameContains);
            creationTimeBefore(model.creationTimeBefore);
            creationTimeAfter(model.creationTimeAfter);
            lastModifiedTimeBefore(model.lastModifiedTimeBefore);
            lastModifiedTimeAfter(model.lastModifiedTimeAfter);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getSortByAsString() {
            return sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(NotebookInstanceLifecycleConfigSortKey sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final String getSortOrderAsString() {
            return sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(NotebookInstanceLifecycleConfigSortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final String getNameContains() {
            return nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        public final Instant getLastModifiedTimeBefore() {
            return lastModifiedTimeBefore;
        }

        @Override
        public final Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
            return this;
        }

        public final void setLastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
        }

        public final Instant getLastModifiedTimeAfter() {
            return lastModifiedTimeAfter;
        }

        @Override
        public final Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
            return this;
        }

        public final void setLastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListNotebookInstanceLifecycleConfigsRequest build() {
            return new ListNotebookInstanceLifecycleConfigsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
