/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of information about a processing job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProcessingJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ProcessingJobSummary.Builder, ProcessingJobSummary> {
    private static final SdkField<String> PROCESSING_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProcessingJobSummary::processingJobName)).setter(setter(Builder::processingJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJobName").build()).build();

    private static final SdkField<String> PROCESSING_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProcessingJobSummary::processingJobArn)).setter(setter(Builder::processingJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJobArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ProcessingJobSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> PROCESSING_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ProcessingJobSummary::processingEndTime)).setter(setter(Builder::processingEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingEndTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ProcessingJobSummary::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> PROCESSING_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProcessingJobSummary::processingJobStatusAsString)).setter(setter(Builder::processingJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJobStatus").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProcessingJobSummary::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> EXIT_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProcessingJobSummary::exitMessage)).setter(setter(Builder::exitMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExitMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESSING_JOB_NAME_FIELD,
            PROCESSING_JOB_ARN_FIELD, CREATION_TIME_FIELD, PROCESSING_END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD,
            PROCESSING_JOB_STATUS_FIELD, FAILURE_REASON_FIELD, EXIT_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String processingJobName;

    private final String processingJobArn;

    private final Instant creationTime;

    private final Instant processingEndTime;

    private final Instant lastModifiedTime;

    private final String processingJobStatus;

    private final String failureReason;

    private final String exitMessage;

    private ProcessingJobSummary(BuilderImpl builder) {
        this.processingJobName = builder.processingJobName;
        this.processingJobArn = builder.processingJobArn;
        this.creationTime = builder.creationTime;
        this.processingEndTime = builder.processingEndTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.processingJobStatus = builder.processingJobStatus;
        this.failureReason = builder.failureReason;
        this.exitMessage = builder.exitMessage;
    }

    /**
     * <p>
     * The name of the processing job.
     * </p>
     * 
     * @return The name of the processing job.
     */
    public String processingJobName() {
        return processingJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the processing job..
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the processing job..
     */
    public String processingJobArn() {
        return processingJobArn;
    }

    /**
     * <p>
     * The time at which the processing job was created.
     * </p>
     * 
     * @return The time at which the processing job was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time at which the processing job completed.
     * </p>
     * 
     * @return The time at which the processing job completed.
     */
    public Instant processingEndTime() {
        return processingEndTime;
    }

    /**
     * <p>
     * A timestamp that indicates the last time the processing job was modified.
     * </p>
     * 
     * @return A timestamp that indicates the last time the processing job was modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The status of the processing job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #processingJobStatus} will return {@link ProcessingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #processingJobStatusAsString}.
     * </p>
     * 
     * @return The status of the processing job.
     * @see ProcessingJobStatus
     */
    public ProcessingJobStatus processingJobStatus() {
        return ProcessingJobStatus.fromValue(processingJobStatus);
    }

    /**
     * <p>
     * The status of the processing job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #processingJobStatus} will return {@link ProcessingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #processingJobStatusAsString}.
     * </p>
     * 
     * @return The status of the processing job.
     * @see ProcessingJobStatus
     */
    public String processingJobStatusAsString() {
        return processingJobStatus;
    }

    /**
     * <p>
     * A string, up to one KB in size, that contains the reason a processing job failed, if it failed.
     * </p>
     * 
     * @return A string, up to one KB in size, that contains the reason a processing job failed, if it failed.
     */
    public String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * An optional string, up to one KB in size, that contains metadata from the processing container when the
     * processing job exits.
     * </p>
     * 
     * @return An optional string, up to one KB in size, that contains metadata from the processing container when the
     *         processing job exits.
     */
    public String exitMessage() {
        return exitMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(processingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(processingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(processingEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(processingJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(exitMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessingJobSummary)) {
            return false;
        }
        ProcessingJobSummary other = (ProcessingJobSummary) obj;
        return Objects.equals(processingJobName(), other.processingJobName())
                && Objects.equals(processingJobArn(), other.processingJobArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(processingEndTime(), other.processingEndTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(processingJobStatusAsString(), other.processingJobStatusAsString())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(exitMessage(), other.exitMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProcessingJobSummary").add("ProcessingJobName", processingJobName())
                .add("ProcessingJobArn", processingJobArn()).add("CreationTime", creationTime())
                .add("ProcessingEndTime", processingEndTime()).add("LastModifiedTime", lastModifiedTime())
                .add("ProcessingJobStatus", processingJobStatusAsString()).add("FailureReason", failureReason())
                .add("ExitMessage", exitMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProcessingJobName":
            return Optional.ofNullable(clazz.cast(processingJobName()));
        case "ProcessingJobArn":
            return Optional.ofNullable(clazz.cast(processingJobArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ProcessingEndTime":
            return Optional.ofNullable(clazz.cast(processingEndTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "ProcessingJobStatus":
            return Optional.ofNullable(clazz.cast(processingJobStatusAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "ExitMessage":
            return Optional.ofNullable(clazz.cast(exitMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProcessingJobSummary, T> g) {
        return obj -> g.apply((ProcessingJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProcessingJobSummary> {
        /**
         * <p>
         * The name of the processing job.
         * </p>
         * 
         * @param processingJobName
         *        The name of the processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingJobName(String processingJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the processing job..
         * </p>
         * 
         * @param processingJobArn
         *        The Amazon Resource Name (ARN) of the processing job..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingJobArn(String processingJobArn);

        /**
         * <p>
         * The time at which the processing job was created.
         * </p>
         * 
         * @param creationTime
         *        The time at which the processing job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time at which the processing job completed.
         * </p>
         * 
         * @param processingEndTime
         *        The time at which the processing job completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingEndTime(Instant processingEndTime);

        /**
         * <p>
         * A timestamp that indicates the last time the processing job was modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        A timestamp that indicates the last time the processing job was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The status of the processing job.
         * </p>
         * 
         * @param processingJobStatus
         *        The status of the processing job.
         * @see ProcessingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingJobStatus
         */
        Builder processingJobStatus(String processingJobStatus);

        /**
         * <p>
         * The status of the processing job.
         * </p>
         * 
         * @param processingJobStatus
         *        The status of the processing job.
         * @see ProcessingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingJobStatus
         */
        Builder processingJobStatus(ProcessingJobStatus processingJobStatus);

        /**
         * <p>
         * A string, up to one KB in size, that contains the reason a processing job failed, if it failed.
         * </p>
         * 
         * @param failureReason
         *        A string, up to one KB in size, that contains the reason a processing job failed, if it failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * An optional string, up to one KB in size, that contains metadata from the processing container when the
         * processing job exits.
         * </p>
         * 
         * @param exitMessage
         *        An optional string, up to one KB in size, that contains metadata from the processing container when
         *        the processing job exits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exitMessage(String exitMessage);
    }

    static final class BuilderImpl implements Builder {
        private String processingJobName;

        private String processingJobArn;

        private Instant creationTime;

        private Instant processingEndTime;

        private Instant lastModifiedTime;

        private String processingJobStatus;

        private String failureReason;

        private String exitMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessingJobSummary model) {
            processingJobName(model.processingJobName);
            processingJobArn(model.processingJobArn);
            creationTime(model.creationTime);
            processingEndTime(model.processingEndTime);
            lastModifiedTime(model.lastModifiedTime);
            processingJobStatus(model.processingJobStatus);
            failureReason(model.failureReason);
            exitMessage(model.exitMessage);
        }

        public final String getProcessingJobName() {
            return processingJobName;
        }

        @Override
        public final Builder processingJobName(String processingJobName) {
            this.processingJobName = processingJobName;
            return this;
        }

        public final void setProcessingJobName(String processingJobName) {
            this.processingJobName = processingJobName;
        }

        public final String getProcessingJobArn() {
            return processingJobArn;
        }

        @Override
        public final Builder processingJobArn(String processingJobArn) {
            this.processingJobArn = processingJobArn;
            return this;
        }

        public final void setProcessingJobArn(String processingJobArn) {
            this.processingJobArn = processingJobArn;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getProcessingEndTime() {
            return processingEndTime;
        }

        @Override
        public final Builder processingEndTime(Instant processingEndTime) {
            this.processingEndTime = processingEndTime;
            return this;
        }

        public final void setProcessingEndTime(Instant processingEndTime) {
            this.processingEndTime = processingEndTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getProcessingJobStatusAsString() {
            return processingJobStatus;
        }

        @Override
        public final Builder processingJobStatus(String processingJobStatus) {
            this.processingJobStatus = processingJobStatus;
            return this;
        }

        @Override
        public final Builder processingJobStatus(ProcessingJobStatus processingJobStatus) {
            this.processingJobStatus(processingJobStatus == null ? null : processingJobStatus.toString());
            return this;
        }

        public final void setProcessingJobStatus(String processingJobStatus) {
            this.processingJobStatus = processingJobStatus;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getExitMessage() {
            return exitMessage;
        }

        @Override
        public final Builder exitMessage(String exitMessage) {
            this.exitMessage = exitMessage;
            return this;
        }

        public final void setExitMessage(String exitMessage) {
            this.exitMessage = exitMessage;
        }

        @Override
        public ProcessingJobSummary build() {
            return new ProcessingJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
