/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCompilationJobsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListCompilationJobsRequest.Builder, ListCompilationJobsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCompilationJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListCompilationJobsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListCompilationJobsRequest::creationTimeAfter)).setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()).build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListCompilationJobsRequest::creationTimeBefore)).setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListCompilationJobsRequest::lastModifiedTimeAfter)).setter(setter(Builder::lastModifiedTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeAfter").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListCompilationJobsRequest::lastModifiedTimeBefore)).setter(setter(Builder::lastModifiedTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeBefore").build())
            .build();

    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCompilationJobsRequest::nameContains)).setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()).build();

    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCompilationJobsRequest::statusEqualsAsString)).setter(setter(Builder::statusEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusEquals").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCompilationJobsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCompilationJobsRequest::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, CREATION_TIME_AFTER_FIELD, CREATION_TIME_BEFORE_FIELD, LAST_MODIFIED_TIME_AFTER_FIELD,
            LAST_MODIFIED_TIME_BEFORE_FIELD, NAME_CONTAINS_FIELD, STATUS_EQUALS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final Instant creationTimeAfter;

    private final Instant creationTimeBefore;

    private final Instant lastModifiedTimeAfter;

    private final Instant lastModifiedTimeBefore;

    private final String nameContains;

    private final String statusEquals;

    private final String sortBy;

    private final String sortOrder;

    private ListCompilationJobsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.lastModifiedTimeAfter = builder.lastModifiedTimeAfter;
        this.lastModifiedTimeBefore = builder.lastModifiedTimeBefore;
        this.nameContains = builder.nameContains;
        this.statusEquals = builder.statusEquals;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * If the result of the previous <code>ListCompilationJobs</code> request was truncated, the response includes a
     * <code>NextToken</code>. To retrieve the next set of model compilation jobs, use the token in the next request.
     * </p>
     * 
     * @return If the result of the previous <code>ListCompilationJobs</code> request was truncated, the response
     *         includes a <code>NextToken</code>. To retrieve the next set of model compilation jobs, use the token in
     *         the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of model compilation jobs to return in the response.
     * </p>
     * 
     * @return The maximum number of model compilation jobs to return in the response.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A filter that returns the model compilation jobs that were created after a specified time.
     * </p>
     * 
     * @return A filter that returns the model compilation jobs that were created after a specified time.
     */
    public Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    /**
     * <p>
     * A filter that returns the model compilation jobs that were created before a specified time.
     * </p>
     * 
     * @return A filter that returns the model compilation jobs that were created before a specified time.
     */
    public Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * A filter that returns the model compilation jobs that were modified after a specified time.
     * </p>
     * 
     * @return A filter that returns the model compilation jobs that were modified after a specified time.
     */
    public Instant lastModifiedTimeAfter() {
        return lastModifiedTimeAfter;
    }

    /**
     * <p>
     * A filter that returns the model compilation jobs that were modified before a specified time.
     * </p>
     * 
     * @return A filter that returns the model compilation jobs that were modified before a specified time.
     */
    public Instant lastModifiedTimeBefore() {
        return lastModifiedTimeBefore;
    }

    /**
     * <p>
     * A filter that returns the model compilation jobs whose name contains a specified string.
     * </p>
     * 
     * @return A filter that returns the model compilation jobs whose name contains a specified string.
     */
    public String nameContains() {
        return nameContains;
    }

    /**
     * <p>
     * A filter that retrieves model compilation jobs with a specific
     * <a>DescribeCompilationJobResponse$CompilationJobStatus</a> status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link CompilationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return A filter that retrieves model compilation jobs with a specific
     *         <a>DescribeCompilationJobResponse$CompilationJobStatus</a> status.
     * @see CompilationJobStatus
     */
    public CompilationJobStatus statusEquals() {
        return CompilationJobStatus.fromValue(statusEquals);
    }

    /**
     * <p>
     * A filter that retrieves model compilation jobs with a specific
     * <a>DescribeCompilationJobResponse$CompilationJobStatus</a> status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link CompilationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return A filter that retrieves model compilation jobs with a specific
     *         <a>DescribeCompilationJobResponse$CompilationJobStatus</a> status.
     * @see CompilationJobStatus
     */
    public String statusEqualsAsString() {
        return statusEquals;
    }

    /**
     * <p>
     * The field by which to sort results. The default is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ListCompilationJobsSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The field by which to sort results. The default is <code>CreationTime</code>.
     * @see ListCompilationJobsSortBy
     */
    public ListCompilationJobsSortBy sortBy() {
        return ListCompilationJobsSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The field by which to sort results. The default is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ListCompilationJobsSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The field by which to sort results. The default is <code>CreationTime</code>.
     * @see ListCompilationJobsSortBy
     */
    public String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The sort order for results. The default is <code>Ascending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for results. The default is <code>Ascending</code>.
     * @see SortOrder
     */
    public SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order for results. The default is <code>Ascending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for results. The default is <code>Ascending</code>.
     * @see SortOrder
     */
    public String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(statusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCompilationJobsRequest)) {
            return false;
        }
        ListCompilationJobsRequest other = (ListCompilationJobsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(creationTimeAfter(), other.creationTimeAfter())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(lastModifiedTimeAfter(), other.lastModifiedTimeAfter())
                && Objects.equals(lastModifiedTimeBefore(), other.lastModifiedTimeBefore())
                && Objects.equals(nameContains(), other.nameContains())
                && Objects.equals(statusEqualsAsString(), other.statusEqualsAsString())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListCompilationJobsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("CreationTimeAfter", creationTimeAfter()).add("CreationTimeBefore", creationTimeBefore())
                .add("LastModifiedTimeAfter", lastModifiedTimeAfter()).add("LastModifiedTimeBefore", lastModifiedTimeBefore())
                .add("NameContains", nameContains()).add("StatusEquals", statusEqualsAsString()).add("SortBy", sortByAsString())
                .add("SortOrder", sortOrderAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "LastModifiedTimeAfter":
            return Optional.ofNullable(clazz.cast(lastModifiedTimeAfter()));
        case "LastModifiedTimeBefore":
            return Optional.ofNullable(clazz.cast(lastModifiedTimeBefore()));
        case "NameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        case "StatusEquals":
            return Optional.ofNullable(clazz.cast(statusEqualsAsString()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCompilationJobsRequest, T> g) {
        return obj -> g.apply((ListCompilationJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListCompilationJobsRequest> {
        /**
         * <p>
         * If the result of the previous <code>ListCompilationJobs</code> request was truncated, the response includes a
         * <code>NextToken</code>. To retrieve the next set of model compilation jobs, use the token in the next
         * request.
         * </p>
         * 
         * @param nextToken
         *        If the result of the previous <code>ListCompilationJobs</code> request was truncated, the response
         *        includes a <code>NextToken</code>. To retrieve the next set of model compilation jobs, use the token
         *        in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of model compilation jobs to return in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of model compilation jobs to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A filter that returns the model compilation jobs that were created after a specified time.
         * </p>
         * 
         * @param creationTimeAfter
         *        A filter that returns the model compilation jobs that were created after a specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        /**
         * <p>
         * A filter that returns the model compilation jobs that were created before a specified time.
         * </p>
         * 
         * @param creationTimeBefore
         *        A filter that returns the model compilation jobs that were created before a specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * A filter that returns the model compilation jobs that were modified after a specified time.
         * </p>
         * 
         * @param lastModifiedTimeAfter
         *        A filter that returns the model compilation jobs that were modified after a specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter);

        /**
         * <p>
         * A filter that returns the model compilation jobs that were modified before a specified time.
         * </p>
         * 
         * @param lastModifiedTimeBefore
         *        A filter that returns the model compilation jobs that were modified before a specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore);

        /**
         * <p>
         * A filter that returns the model compilation jobs whose name contains a specified string.
         * </p>
         * 
         * @param nameContains
         *        A filter that returns the model compilation jobs whose name contains a specified string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        /**
         * <p>
         * A filter that retrieves model compilation jobs with a specific
         * <a>DescribeCompilationJobResponse$CompilationJobStatus</a> status.
         * </p>
         * 
         * @param statusEquals
         *        A filter that retrieves model compilation jobs with a specific
         *        <a>DescribeCompilationJobResponse$CompilationJobStatus</a> status.
         * @see CompilationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompilationJobStatus
         */
        Builder statusEquals(String statusEquals);

        /**
         * <p>
         * A filter that retrieves model compilation jobs with a specific
         * <a>DescribeCompilationJobResponse$CompilationJobStatus</a> status.
         * </p>
         * 
         * @param statusEquals
         *        A filter that retrieves model compilation jobs with a specific
         *        <a>DescribeCompilationJobResponse$CompilationJobStatus</a> status.
         * @see CompilationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompilationJobStatus
         */
        Builder statusEquals(CompilationJobStatus statusEquals);

        /**
         * <p>
         * The field by which to sort results. The default is <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        The field by which to sort results. The default is <code>CreationTime</code>.
         * @see ListCompilationJobsSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListCompilationJobsSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The field by which to sort results. The default is <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        The field by which to sort results. The default is <code>CreationTime</code>.
         * @see ListCompilationJobsSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListCompilationJobsSortBy
         */
        Builder sortBy(ListCompilationJobsSortBy sortBy);

        /**
         * <p>
         * The sort order for results. The default is <code>Ascending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for results. The default is <code>Ascending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order for results. The default is <code>Ascending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for results. The default is <code>Ascending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private Instant creationTimeAfter;

        private Instant creationTimeBefore;

        private Instant lastModifiedTimeAfter;

        private Instant lastModifiedTimeBefore;

        private String nameContains;

        private String statusEquals;

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCompilationJobsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            creationTimeAfter(model.creationTimeAfter);
            creationTimeBefore(model.creationTimeBefore);
            lastModifiedTimeAfter(model.lastModifiedTimeAfter);
            lastModifiedTimeBefore(model.lastModifiedTimeBefore);
            nameContains(model.nameContains);
            statusEquals(model.statusEquals);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        public final Instant getLastModifiedTimeAfter() {
            return lastModifiedTimeAfter;
        }

        @Override
        public final Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
            return this;
        }

        public final void setLastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
        }

        public final Instant getLastModifiedTimeBefore() {
            return lastModifiedTimeBefore;
        }

        @Override
        public final Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
            return this;
        }

        public final void setLastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
        }

        public final String getNameContains() {
            return nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        public final String getStatusEqualsAsString() {
            return statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(CompilationJobStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        public final String getSortByAsString() {
            return sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ListCompilationJobsSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final String getSortOrderAsString() {
            return sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCompilationJobsRequest build() {
            return new ListCompilationJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
