/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the properties of a trial as returned by the <a>Search</a> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Trial implements SdkPojo, Serializable, ToCopyableBuilder<Trial.Builder, Trial> {
    private static final SdkField<String> TRIAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Trial::trialName)).setter(setter(Builder::trialName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialName").build()).build();

    private static final SdkField<String> TRIAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Trial::trialArn)).setter(setter(Builder::trialArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialArn").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Trial::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> EXPERIMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Trial::experimentName)).setter(setter(Builder::experimentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentName").build()).build();

    private static final SdkField<TrialSource> SOURCE_FIELD = SdkField.<TrialSource> builder(MarshallingType.SDK_POJO)
            .getter(getter(Trial::source)).setter(setter(Builder::source)).constructor(TrialSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Trial::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .getter(getter(Trial::createdBy)).setter(setter(Builder::createdBy)).constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Trial::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .getter(getter(Trial::lastModifiedBy)).setter(setter(Builder::lastModifiedBy)).constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(Trial::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TrialComponentSimpleSummary>> TRIAL_COMPONENT_SUMMARIES_FIELD = SdkField
            .<List<TrialComponentSimpleSummary>> builder(MarshallingType.LIST)
            .getter(getter(Trial::trialComponentSummaries))
            .setter(setter(Builder::trialComponentSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrialComponentSimpleSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrialComponentSimpleSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_NAME_FIELD,
            TRIAL_ARN_FIELD, DISPLAY_NAME_FIELD, EXPERIMENT_NAME_FIELD, SOURCE_FIELD, CREATION_TIME_FIELD, CREATED_BY_FIELD,
            LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, TAGS_FIELD, TRIAL_COMPONENT_SUMMARIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String trialName;

    private final String trialArn;

    private final String displayName;

    private final String experimentName;

    private final TrialSource source;

    private final Instant creationTime;

    private final UserContext createdBy;

    private final Instant lastModifiedTime;

    private final UserContext lastModifiedBy;

    private final List<Tag> tags;

    private final List<TrialComponentSimpleSummary> trialComponentSummaries;

    private Trial(BuilderImpl builder) {
        this.trialName = builder.trialName;
        this.trialArn = builder.trialArn;
        this.displayName = builder.displayName;
        this.experimentName = builder.experimentName;
        this.source = builder.source;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.tags = builder.tags;
        this.trialComponentSummaries = builder.trialComponentSummaries;
    }

    /**
     * <p>
     * The name of the trial.
     * </p>
     * 
     * @return The name of the trial.
     */
    public String trialName() {
        return trialName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the trial.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the trial.
     */
    public String trialArn() {
        return trialArn;
    }

    /**
     * <p>
     * The name of the trial as displayed. If <code>DisplayName</code> isn't specified, <code>TrialName</code> is
     * displayed.
     * </p>
     * 
     * @return The name of the trial as displayed. If <code>DisplayName</code> isn't specified, <code>TrialName</code>
     *         is displayed.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The name of the experiment the trial is part of.
     * </p>
     * 
     * @return The name of the experiment the trial is part of.
     */
    public String experimentName() {
        return experimentName;
    }

    /**
     * Returns the value of the Source property for this object.
     * 
     * @return The value of the Source property for this object.
     */
    public TrialSource source() {
        return source;
    }

    /**
     * <p>
     * When the trial was created.
     * </p>
     * 
     * @return When the trial was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the CreatedBy property for this object.
     * 
     * @return The value of the CreatedBy property for this object.
     */
    public UserContext createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * Who last modified the trial.
     * </p>
     * 
     * @return Who last modified the trial.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns the value of the LastModifiedBy property for this object.
     * 
     * @return The value of the LastModifiedBy property for this object.
     */
    public UserContext lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of tags that are associated with the trial. You can use <a>Search</a> API to search on the tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of tags that are associated with the trial. You can use <a>Search</a> API to search on the tags.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * Returns true if the TrialComponentSummaries property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTrialComponentSummaries() {
        return trialComponentSummaries != null && !(trialComponentSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the components associated with the trial. For each component, a summary of the component's properties
     * is included.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTrialComponentSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the components associated with the trial. For each component, a summary of the component's
     *         properties is included.
     */
    public List<TrialComponentSimpleSummary> trialComponentSummaries() {
        return trialComponentSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trialName());
        hashCode = 31 * hashCode + Objects.hashCode(trialArn());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(experimentName());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(trialComponentSummaries());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Trial)) {
            return false;
        }
        Trial other = (Trial) obj;
        return Objects.equals(trialName(), other.trialName()) && Objects.equals(trialArn(), other.trialArn())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(experimentName(), other.experimentName())
                && Objects.equals(source(), other.source()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(tags(), other.tags())
                && Objects.equals(trialComponentSummaries(), other.trialComponentSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Trial").add("TrialName", trialName()).add("TrialArn", trialArn())
                .add("DisplayName", displayName()).add("ExperimentName", experimentName()).add("Source", source())
                .add("CreationTime", creationTime()).add("CreatedBy", createdBy()).add("LastModifiedTime", lastModifiedTime())
                .add("LastModifiedBy", lastModifiedBy()).add("Tags", tags())
                .add("TrialComponentSummaries", trialComponentSummaries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrialName":
            return Optional.ofNullable(clazz.cast(trialName()));
        case "TrialArn":
            return Optional.ofNullable(clazz.cast(trialArn()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "ExperimentName":
            return Optional.ofNullable(clazz.cast(experimentName()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TrialComponentSummaries":
            return Optional.ofNullable(clazz.cast(trialComponentSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Trial, T> g) {
        return obj -> g.apply((Trial) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Trial> {
        /**
         * <p>
         * The name of the trial.
         * </p>
         * 
         * @param trialName
         *        The name of the trial.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialName(String trialName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the trial.
         * </p>
         * 
         * @param trialArn
         *        The Amazon Resource Name (ARN) of the trial.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialArn(String trialArn);

        /**
         * <p>
         * The name of the trial as displayed. If <code>DisplayName</code> isn't specified, <code>TrialName</code> is
         * displayed.
         * </p>
         * 
         * @param displayName
         *        The name of the trial as displayed. If <code>DisplayName</code> isn't specified,
         *        <code>TrialName</code> is displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The name of the experiment the trial is part of.
         * </p>
         * 
         * @param experimentName
         *        The name of the experiment the trial is part of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentName(String experimentName);

        /**
         * Sets the value of the Source property for this object.
         *
         * @param source
         *        The new value for the Source property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(TrialSource source);

        /**
         * Sets the value of the Source property for this object.
         *
         * This is a convenience that creates an instance of the {@link TrialSource.Builder} avoiding the need to create
         * one manually via {@link TrialSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrialSource.Builder#build()} is called immediately and its result
         * is passed to {@link #source(TrialSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link TrialSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(TrialSource)
         */
        default Builder source(Consumer<TrialSource.Builder> source) {
            return source(TrialSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * When the trial was created.
         * </p>
         * 
         * @param creationTime
         *        When the trial was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * @param createdBy
         *        The new value for the CreatedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * This is a convenience that creates an instance of the {@link UserContext.Builder} avoiding the need to create
         * one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * Who last modified the trial.
         * </p>
         * 
         * @param lastModifiedTime
         *        Who last modified the trial.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * @param lastModifiedBy
         *        The new value for the LastModifiedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(UserContext lastModifiedBy);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * This is a convenience that creates an instance of the {@link UserContext.Builder} avoiding the need to create
         * one manually via {@link UserContext#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #lastModifiedBy(UserContext)}.
         * 
         * @param lastModifiedBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedBy(UserContext)
         */
        default Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return lastModifiedBy(UserContext.builder().applyMutation(lastModifiedBy).build());
        }

        /**
         * <p>
         * The list of tags that are associated with the trial. You can use <a>Search</a> API to search on the tags.
         * </p>
         * 
         * @param tags
         *        The list of tags that are associated with the trial. You can use <a>Search</a> API to search on the
         *        tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The list of tags that are associated with the trial. You can use <a>Search</a> API to search on the tags.
         * </p>
         * 
         * @param tags
         *        The list of tags that are associated with the trial. You can use <a>Search</a> API to search on the
         *        tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The list of tags that are associated with the trial. You can use <a>Search</a> API to search on the tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A list of the components associated with the trial. For each component, a summary of the component's
         * properties is included.
         * </p>
         * 
         * @param trialComponentSummaries
         *        A list of the components associated with the trial. For each component, a summary of the component's
         *        properties is included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialComponentSummaries(Collection<TrialComponentSimpleSummary> trialComponentSummaries);

        /**
         * <p>
         * A list of the components associated with the trial. For each component, a summary of the component's
         * properties is included.
         * </p>
         * 
         * @param trialComponentSummaries
         *        A list of the components associated with the trial. For each component, a summary of the component's
         *        properties is included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialComponentSummaries(TrialComponentSimpleSummary... trialComponentSummaries);

        /**
         * <p>
         * A list of the components associated with the trial. For each component, a summary of the component's
         * properties is included.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TrialComponentSimpleSummary>.Builder}
         * avoiding the need to create one manually via {@link List<TrialComponentSimpleSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TrialComponentSimpleSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #trialComponentSummaries(List<TrialComponentSimpleSummary>)}.
         * 
         * @param trialComponentSummaries
         *        a consumer that will call methods on {@link List<TrialComponentSimpleSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trialComponentSummaries(List<TrialComponentSimpleSummary>)
         */
        Builder trialComponentSummaries(Consumer<TrialComponentSimpleSummary.Builder>... trialComponentSummaries);
    }

    static final class BuilderImpl implements Builder {
        private String trialName;

        private String trialArn;

        private String displayName;

        private String experimentName;

        private TrialSource source;

        private Instant creationTime;

        private UserContext createdBy;

        private Instant lastModifiedTime;

        private UserContext lastModifiedBy;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<TrialComponentSimpleSummary> trialComponentSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Trial model) {
            trialName(model.trialName);
            trialArn(model.trialArn);
            displayName(model.displayName);
            experimentName(model.experimentName);
            source(model.source);
            creationTime(model.creationTime);
            createdBy(model.createdBy);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedBy(model.lastModifiedBy);
            tags(model.tags);
            trialComponentSummaries(model.trialComponentSummaries);
        }

        public final String getTrialName() {
            return trialName;
        }

        @Override
        public final Builder trialName(String trialName) {
            this.trialName = trialName;
            return this;
        }

        public final void setTrialName(String trialName) {
            this.trialName = trialName;
        }

        public final String getTrialArn() {
            return trialArn;
        }

        @Override
        public final Builder trialArn(String trialArn) {
            this.trialArn = trialArn;
            return this;
        }

        public final void setTrialArn(String trialArn) {
            this.trialArn = trialArn;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getExperimentName() {
            return experimentName;
        }

        @Override
        public final Builder experimentName(String experimentName) {
            this.experimentName = experimentName;
            return this;
        }

        public final void setExperimentName(String experimentName) {
            this.experimentName = experimentName;
        }

        public final TrialSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        @Override
        public final Builder source(TrialSource source) {
            this.source = source;
            return this;
        }

        public final void setSource(TrialSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return lastModifiedBy != null ? lastModifiedBy.toBuilder() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<TrialComponentSimpleSummary.Builder> getTrialComponentSummaries() {
            return trialComponentSummaries != null ? trialComponentSummaries.stream().map(TrialComponentSimpleSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder trialComponentSummaries(Collection<TrialComponentSimpleSummary> trialComponentSummaries) {
            this.trialComponentSummaries = TrialComponentSimpleSummariesCopier.copy(trialComponentSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trialComponentSummaries(TrialComponentSimpleSummary... trialComponentSummaries) {
            trialComponentSummaries(Arrays.asList(trialComponentSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trialComponentSummaries(Consumer<TrialComponentSimpleSummary.Builder>... trialComponentSummaries) {
            trialComponentSummaries(Stream.of(trialComponentSummaries)
                    .map(c -> TrialComponentSimpleSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTrialComponentSummaries(Collection<TrialComponentSimpleSummary.BuilderImpl> trialComponentSummaries) {
            this.trialComponentSummaries = TrialComponentSimpleSummariesCopier.copyFromBuilder(trialComponentSummaries);
        }

        @Override
        public Trial build() {
            return new Trial(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
