/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summarizes the monitoring schedule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringScheduleSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringScheduleSummary.Builder, MonitoringScheduleSummary> {
    private static final SdkField<String> MONITORING_SCHEDULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MonitoringScheduleSummary::monitoringScheduleName)).setter(setter(Builder::monitoringScheduleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleName").build())
            .build();

    private static final SdkField<String> MONITORING_SCHEDULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MonitoringScheduleSummary::monitoringScheduleArn)).setter(setter(Builder::monitoringScheduleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleArn").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(MonitoringScheduleSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(MonitoringScheduleSummary::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> MONITORING_SCHEDULE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MonitoringScheduleSummary::monitoringScheduleStatusAsString))
            .setter(setter(Builder::monitoringScheduleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleStatus").build())
            .build();

    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MonitoringScheduleSummary::endpointName)).setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MONITORING_SCHEDULE_NAME_FIELD, MONITORING_SCHEDULE_ARN_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD,
            MONITORING_SCHEDULE_STATUS_FIELD, ENDPOINT_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String monitoringScheduleName;

    private final String monitoringScheduleArn;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String monitoringScheduleStatus;

    private final String endpointName;

    private MonitoringScheduleSummary(BuilderImpl builder) {
        this.monitoringScheduleName = builder.monitoringScheduleName;
        this.monitoringScheduleArn = builder.monitoringScheduleArn;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.monitoringScheduleStatus = builder.monitoringScheduleStatus;
        this.endpointName = builder.endpointName;
    }

    /**
     * <p>
     * The name of the monitoring schedule.
     * </p>
     * 
     * @return The name of the monitoring schedule.
     */
    public String monitoringScheduleName() {
        return monitoringScheduleName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the monitoring schedule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the monitoring schedule.
     */
    public String monitoringScheduleArn() {
        return monitoringScheduleArn;
    }

    /**
     * <p>
     * The creation time of the monitoring schedule.
     * </p>
     * 
     * @return The creation time of the monitoring schedule.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the monitoring schedule was modified.
     * </p>
     * 
     * @return The last time the monitoring schedule was modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The status of the monitoring schedule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #monitoringScheduleStatus} will return {@link ScheduleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #monitoringScheduleStatusAsString}.
     * </p>
     * 
     * @return The status of the monitoring schedule.
     * @see ScheduleStatus
     */
    public ScheduleStatus monitoringScheduleStatus() {
        return ScheduleStatus.fromValue(monitoringScheduleStatus);
    }

    /**
     * <p>
     * The status of the monitoring schedule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #monitoringScheduleStatus} will return {@link ScheduleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #monitoringScheduleStatusAsString}.
     * </p>
     * 
     * @return The status of the monitoring schedule.
     * @see ScheduleStatus
     */
    public String monitoringScheduleStatusAsString() {
        return monitoringScheduleStatus;
    }

    /**
     * <p>
     * The name of the endpoint using the monitoring schedule.
     * </p>
     * 
     * @return The name of the endpoint using the monitoring schedule.
     */
    public String endpointName() {
        return endpointName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleName());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringScheduleSummary)) {
            return false;
        }
        MonitoringScheduleSummary other = (MonitoringScheduleSummary) obj;
        return Objects.equals(monitoringScheduleName(), other.monitoringScheduleName())
                && Objects.equals(monitoringScheduleArn(), other.monitoringScheduleArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(monitoringScheduleStatusAsString(), other.monitoringScheduleStatusAsString())
                && Objects.equals(endpointName(), other.endpointName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MonitoringScheduleSummary").add("MonitoringScheduleName", monitoringScheduleName())
                .add("MonitoringScheduleArn", monitoringScheduleArn()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("MonitoringScheduleStatus", monitoringScheduleStatusAsString())
                .add("EndpointName", endpointName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringScheduleName":
            return Optional.ofNullable(clazz.cast(monitoringScheduleName()));
        case "MonitoringScheduleArn":
            return Optional.ofNullable(clazz.cast(monitoringScheduleArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "MonitoringScheduleStatus":
            return Optional.ofNullable(clazz.cast(monitoringScheduleStatusAsString()));
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringScheduleSummary, T> g) {
        return obj -> g.apply((MonitoringScheduleSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringScheduleSummary> {
        /**
         * <p>
         * The name of the monitoring schedule.
         * </p>
         * 
         * @param monitoringScheduleName
         *        The name of the monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleName(String monitoringScheduleName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the monitoring schedule.
         * </p>
         * 
         * @param monitoringScheduleArn
         *        The Amazon Resource Name (ARN) of the monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleArn(String monitoringScheduleArn);

        /**
         * <p>
         * The creation time of the monitoring schedule.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the monitoring schedule was modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last time the monitoring schedule was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The status of the monitoring schedule.
         * </p>
         * 
         * @param monitoringScheduleStatus
         *        The status of the monitoring schedule.
         * @see ScheduleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleStatus
         */
        Builder monitoringScheduleStatus(String monitoringScheduleStatus);

        /**
         * <p>
         * The status of the monitoring schedule.
         * </p>
         * 
         * @param monitoringScheduleStatus
         *        The status of the monitoring schedule.
         * @see ScheduleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleStatus
         */
        Builder monitoringScheduleStatus(ScheduleStatus monitoringScheduleStatus);

        /**
         * <p>
         * The name of the endpoint using the monitoring schedule.
         * </p>
         * 
         * @param endpointName
         *        The name of the endpoint using the monitoring schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);
    }

    static final class BuilderImpl implements Builder {
        private String monitoringScheduleName;

        private String monitoringScheduleArn;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String monitoringScheduleStatus;

        private String endpointName;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringScheduleSummary model) {
            monitoringScheduleName(model.monitoringScheduleName);
            monitoringScheduleArn(model.monitoringScheduleArn);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            monitoringScheduleStatus(model.monitoringScheduleStatus);
            endpointName(model.endpointName);
        }

        public final String getMonitoringScheduleName() {
            return monitoringScheduleName;
        }

        @Override
        public final Builder monitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
            return this;
        }

        public final void setMonitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
        }

        public final String getMonitoringScheduleArn() {
            return monitoringScheduleArn;
        }

        @Override
        public final Builder monitoringScheduleArn(String monitoringScheduleArn) {
            this.monitoringScheduleArn = monitoringScheduleArn;
            return this;
        }

        public final void setMonitoringScheduleArn(String monitoringScheduleArn) {
            this.monitoringScheduleArn = monitoringScheduleArn;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getMonitoringScheduleStatusAsString() {
            return monitoringScheduleStatus;
        }

        @Override
        public final Builder monitoringScheduleStatus(String monitoringScheduleStatus) {
            this.monitoringScheduleStatus = monitoringScheduleStatus;
            return this;
        }

        @Override
        public final Builder monitoringScheduleStatus(ScheduleStatus monitoringScheduleStatus) {
            this.monitoringScheduleStatus(monitoringScheduleStatus == null ? null : monitoringScheduleStatus.toString());
            return this;
        }

        public final void setMonitoringScheduleStatus(String monitoringScheduleStatus) {
            this.monitoringScheduleStatus = monitoringScheduleStatus;
        }

        public final String getEndpointName() {
            return endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public MonitoringScheduleSummary build() {
            return new MonitoringScheduleSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
