/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A configuration for a shuffle option for input data in a channel. If you use <code>S3Prefix</code> for
 * <code>S3DataType</code>, the results of the S3 key prefix matches are shuffled. If you use <code>ManifestFile</code>,
 * the order of the S3 object references in the <code>ManifestFile</code> is shuffled. If you use
 * <code>AugmentedManifestFile</code>, the order of the JSON lines in the <code>AugmentedManifestFile</code> is
 * shuffled. The shuffling order is determined using the <code>Seed</code> value.
 * </p>
 * <p>
 * For Pipe input mode, when <code>ShuffleConfig</code> is specified shuffling is done at the start of every epoch. With
 * large datasets, this ensures that the order of the training data is different for each epoch, and it helps reduce
 * bias and possible overfitting. In a multi-node training job when <code>ShuffleConfig</code> is combined with
 * <code>S3DataDistributionType</code> of <code>ShardedByS3Key</code>, the data is shuffled across nodes so that the
 * content sent to a particular node on the first epoch might be sent to a different node on the second epoch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ShuffleConfig implements SdkPojo, Serializable, ToCopyableBuilder<ShuffleConfig.Builder, ShuffleConfig> {
    private static final SdkField<Long> SEED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ShuffleConfig::seed)).setter(setter(Builder::seed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Seed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long seed;

    private ShuffleConfig(BuilderImpl builder) {
        this.seed = builder.seed;
    }

    /**
     * <p>
     * Determines the shuffling order in <code>ShuffleConfig</code> value.
     * </p>
     * 
     * @return Determines the shuffling order in <code>ShuffleConfig</code> value.
     */
    public Long seed() {
        return seed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(seed());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShuffleConfig)) {
            return false;
        }
        ShuffleConfig other = (ShuffleConfig) obj;
        return Objects.equals(seed(), other.seed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ShuffleConfig").add("Seed", seed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Seed":
            return Optional.ofNullable(clazz.cast(seed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ShuffleConfig, T> g) {
        return obj -> g.apply((ShuffleConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ShuffleConfig> {
        /**
         * <p>
         * Determines the shuffling order in <code>ShuffleConfig</code> value.
         * </p>
         * 
         * @param seed
         *        Determines the shuffling order in <code>ShuffleConfig</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder seed(Long seed);
    }

    static final class BuilderImpl implements Builder {
        private Long seed;

        private BuilderImpl() {
        }

        private BuilderImpl(ShuffleConfig model) {
            seed(model.seed);
        }

        public final Long getSeed() {
            return seed;
        }

        @Override
        public final Builder seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public final void setSeed(Long seed) {
            this.seed = seed;
        }

        @Override
        public ShuffleConfig build() {
            return new ShuffleConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
