/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProcessingJobResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeProcessingJobResponse.Builder, DescribeProcessingJobResponse> {
    private static final SdkField<List<ProcessingInput>> PROCESSING_INPUTS_FIELD = SdkField
            .<List<ProcessingInput>> builder(MarshallingType.LIST)
            .getter(getter(DescribeProcessingJobResponse::processingInputs))
            .setter(setter(Builder::processingInputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingInputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProcessingInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProcessingInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProcessingOutputConfig> PROCESSING_OUTPUT_CONFIG_FIELD = SdkField
            .<ProcessingOutputConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeProcessingJobResponse::processingOutputConfig))
            .setter(setter(Builder::processingOutputConfig)).constructor(ProcessingOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingOutputConfig").build())
            .build();

    private static final SdkField<String> PROCESSING_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeProcessingJobResponse::processingJobName)).setter(setter(Builder::processingJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJobName").build()).build();

    private static final SdkField<ProcessingResources> PROCESSING_RESOURCES_FIELD = SdkField
            .<ProcessingResources> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeProcessingJobResponse::processingResources)).setter(setter(Builder::processingResources))
            .constructor(ProcessingResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingResources").build())
            .build();

    private static final SdkField<ProcessingStoppingCondition> STOPPING_CONDITION_FIELD = SdkField
            .<ProcessingStoppingCondition> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeProcessingJobResponse::stoppingCondition)).setter(setter(Builder::stoppingCondition))
            .constructor(ProcessingStoppingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()).build();

    private static final SdkField<AppSpecification> APP_SPECIFICATION_FIELD = SdkField
            .<AppSpecification> builder(MarshallingType.SDK_POJO).getter(getter(DescribeProcessingJobResponse::appSpecification))
            .setter(setter(Builder::appSpecification)).constructor(AppSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppSpecification").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(DescribeProcessingJobResponse::environment))
            .setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<NetworkConfig> NETWORK_CONFIG_FIELD = SdkField
            .<NetworkConfig> builder(MarshallingType.SDK_POJO).getter(getter(DescribeProcessingJobResponse::networkConfig))
            .setter(setter(Builder::networkConfig)).constructor(NetworkConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfig").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeProcessingJobResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<ExperimentConfig> EXPERIMENT_CONFIG_FIELD = SdkField
            .<ExperimentConfig> builder(MarshallingType.SDK_POJO).getter(getter(DescribeProcessingJobResponse::experimentConfig))
            .setter(setter(Builder::experimentConfig)).constructor(ExperimentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentConfig").build()).build();

    private static final SdkField<String> PROCESSING_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeProcessingJobResponse::processingJobArn)).setter(setter(Builder::processingJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJobArn").build()).build();

    private static final SdkField<String> PROCESSING_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeProcessingJobResponse::processingJobStatusAsString))
            .setter(setter(Builder::processingJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJobStatus").build())
            .build();

    private static final SdkField<String> EXIT_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeProcessingJobResponse::exitMessage)).setter(setter(Builder::exitMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExitMessage").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeProcessingJobResponse::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<Instant> PROCESSING_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeProcessingJobResponse::processingEndTime)).setter(setter(Builder::processingEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingEndTime").build()).build();

    private static final SdkField<Instant> PROCESSING_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeProcessingJobResponse::processingStartTime)).setter(setter(Builder::processingStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingStartTime").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeProcessingJobResponse::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeProcessingJobResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> MONITORING_SCHEDULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeProcessingJobResponse::monitoringScheduleArn)).setter(setter(Builder::monitoringScheduleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleArn").build())
            .build();

    private static final SdkField<String> AUTO_ML_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeProcessingJobResponse::autoMLJobArn)).setter(setter(Builder::autoMLJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobArn").build()).build();

    private static final SdkField<String> TRAINING_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeProcessingJobResponse::trainingJobArn)).setter(setter(Builder::trainingJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESSING_INPUTS_FIELD,
            PROCESSING_OUTPUT_CONFIG_FIELD, PROCESSING_JOB_NAME_FIELD, PROCESSING_RESOURCES_FIELD, STOPPING_CONDITION_FIELD,
            APP_SPECIFICATION_FIELD, ENVIRONMENT_FIELD, NETWORK_CONFIG_FIELD, ROLE_ARN_FIELD, EXPERIMENT_CONFIG_FIELD,
            PROCESSING_JOB_ARN_FIELD, PROCESSING_JOB_STATUS_FIELD, EXIT_MESSAGE_FIELD, FAILURE_REASON_FIELD,
            PROCESSING_END_TIME_FIELD, PROCESSING_START_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, CREATION_TIME_FIELD,
            MONITORING_SCHEDULE_ARN_FIELD, AUTO_ML_JOB_ARN_FIELD, TRAINING_JOB_ARN_FIELD));

    private final List<ProcessingInput> processingInputs;

    private final ProcessingOutputConfig processingOutputConfig;

    private final String processingJobName;

    private final ProcessingResources processingResources;

    private final ProcessingStoppingCondition stoppingCondition;

    private final AppSpecification appSpecification;

    private final Map<String, String> environment;

    private final NetworkConfig networkConfig;

    private final String roleArn;

    private final ExperimentConfig experimentConfig;

    private final String processingJobArn;

    private final String processingJobStatus;

    private final String exitMessage;

    private final String failureReason;

    private final Instant processingEndTime;

    private final Instant processingStartTime;

    private final Instant lastModifiedTime;

    private final Instant creationTime;

    private final String monitoringScheduleArn;

    private final String autoMLJobArn;

    private final String trainingJobArn;

    private DescribeProcessingJobResponse(BuilderImpl builder) {
        super(builder);
        this.processingInputs = builder.processingInputs;
        this.processingOutputConfig = builder.processingOutputConfig;
        this.processingJobName = builder.processingJobName;
        this.processingResources = builder.processingResources;
        this.stoppingCondition = builder.stoppingCondition;
        this.appSpecification = builder.appSpecification;
        this.environment = builder.environment;
        this.networkConfig = builder.networkConfig;
        this.roleArn = builder.roleArn;
        this.experimentConfig = builder.experimentConfig;
        this.processingJobArn = builder.processingJobArn;
        this.processingJobStatus = builder.processingJobStatus;
        this.exitMessage = builder.exitMessage;
        this.failureReason = builder.failureReason;
        this.processingEndTime = builder.processingEndTime;
        this.processingStartTime = builder.processingStartTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.creationTime = builder.creationTime;
        this.monitoringScheduleArn = builder.monitoringScheduleArn;
        this.autoMLJobArn = builder.autoMLJobArn;
        this.trainingJobArn = builder.trainingJobArn;
    }

    /**
     * Returns true if the ProcessingInputs property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasProcessingInputs() {
        return processingInputs != null && !(processingInputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The inputs for a processing job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProcessingInputs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The inputs for a processing job.
     */
    public List<ProcessingInput> processingInputs() {
        return processingInputs;
    }

    /**
     * <p>
     * Output configuration for the processing job.
     * </p>
     * 
     * @return Output configuration for the processing job.
     */
    public ProcessingOutputConfig processingOutputConfig() {
        return processingOutputConfig;
    }

    /**
     * <p>
     * The name of the processing job. The name must be unique within an AWS Region in the AWS account.
     * </p>
     * 
     * @return The name of the processing job. The name must be unique within an AWS Region in the AWS account.
     */
    public String processingJobName() {
        return processingJobName;
    }

    /**
     * <p>
     * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In
     * distributed training, you specify more than one instance.
     * </p>
     * 
     * @return Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In
     *         distributed training, you specify more than one instance.
     */
    public ProcessingResources processingResources() {
        return processingResources;
    }

    /**
     * <p>
     * The time limit for how long the processing job is allowed to run.
     * </p>
     * 
     * @return The time limit for how long the processing job is allowed to run.
     */
    public ProcessingStoppingCondition stoppingCondition() {
        return stoppingCondition;
    }

    /**
     * <p>
     * Configures the processing job to run a specified container image.
     * </p>
     * 
     * @return Configures the processing job to run a specified container image.
     */
    public AppSpecification appSpecification() {
        return appSpecification;
    }

    /**
     * Returns true if the Environment property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEnvironment() {
        return environment != null && !(environment instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The environment variables set in the Docker container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnvironment()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The environment variables set in the Docker container.
     */
    public Map<String, String> environment() {
        return environment;
    }

    /**
     * <p>
     * Networking options for a processing job.
     * </p>
     * 
     * @return Networking options for a processing job.
     */
    public NetworkConfig networkConfig() {
        return networkConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your
     *         behalf.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The configuration information used to create an experiment.
     * </p>
     * 
     * @return The configuration information used to create an experiment.
     */
    public ExperimentConfig experimentConfig() {
        return experimentConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the processing job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the processing job.
     */
    public String processingJobArn() {
        return processingJobArn;
    }

    /**
     * <p>
     * Provides the status of a processing job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #processingJobStatus} will return {@link ProcessingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #processingJobStatusAsString}.
     * </p>
     * 
     * @return Provides the status of a processing job.
     * @see ProcessingJobStatus
     */
    public ProcessingJobStatus processingJobStatus() {
        return ProcessingJobStatus.fromValue(processingJobStatus);
    }

    /**
     * <p>
     * Provides the status of a processing job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #processingJobStatus} will return {@link ProcessingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #processingJobStatusAsString}.
     * </p>
     * 
     * @return Provides the status of a processing job.
     * @see ProcessingJobStatus
     */
    public String processingJobStatusAsString() {
        return processingJobStatus;
    }

    /**
     * <p>
     * An optional string, up to one KB in size, that contains metadata from the processing container when the
     * processing job exits.
     * </p>
     * 
     * @return An optional string, up to one KB in size, that contains metadata from the processing container when the
     *         processing job exits.
     */
    public String exitMessage() {
        return exitMessage;
    }

    /**
     * <p>
     * A string, up to one KB in size, that contains the reason a processing job failed, if it failed.
     * </p>
     * 
     * @return A string, up to one KB in size, that contains the reason a processing job failed, if it failed.
     */
    public String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The time at which the processing job completed.
     * </p>
     * 
     * @return The time at which the processing job completed.
     */
    public Instant processingEndTime() {
        return processingEndTime;
    }

    /**
     * <p>
     * The time at which the processing job started.
     * </p>
     * 
     * @return The time at which the processing job started.
     */
    public Instant processingStartTime() {
        return processingStartTime;
    }

    /**
     * <p>
     * The time at which the processing job was last modified.
     * </p>
     * 
     * @return The time at which the processing job was last modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The time at which the processing job was created.
     * </p>
     * 
     * @return The time at which the processing job was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The ARN of a monitoring schedule for an endpoint associated with this processing job.
     * </p>
     * 
     * @return The ARN of a monitoring schedule for an endpoint associated with this processing job.
     */
    public String monitoringScheduleArn() {
        return monitoringScheduleArn;
    }

    /**
     * <p>
     * The ARN of an AutoML job associated with this processing job.
     * </p>
     * 
     * @return The ARN of an AutoML job associated with this processing job.
     */
    public String autoMLJobArn() {
        return autoMLJobArn;
    }

    /**
     * <p>
     * The ARN of a training job associated with this processing job.
     * </p>
     * 
     * @return The ARN of a training job associated with this processing job.
     */
    public String trainingJobArn() {
        return trainingJobArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(processingInputs());
        hashCode = 31 * hashCode + Objects.hashCode(processingOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(processingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(processingResources());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(appSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(experimentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(processingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(processingJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exitMessage());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(processingEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(processingStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringScheduleArn());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(trainingJobArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProcessingJobResponse)) {
            return false;
        }
        DescribeProcessingJobResponse other = (DescribeProcessingJobResponse) obj;
        return Objects.equals(processingInputs(), other.processingInputs())
                && Objects.equals(processingOutputConfig(), other.processingOutputConfig())
                && Objects.equals(processingJobName(), other.processingJobName())
                && Objects.equals(processingResources(), other.processingResources())
                && Objects.equals(stoppingCondition(), other.stoppingCondition())
                && Objects.equals(appSpecification(), other.appSpecification())
                && Objects.equals(environment(), other.environment()) && Objects.equals(networkConfig(), other.networkConfig())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(experimentConfig(), other.experimentConfig())
                && Objects.equals(processingJobArn(), other.processingJobArn())
                && Objects.equals(processingJobStatusAsString(), other.processingJobStatusAsString())
                && Objects.equals(exitMessage(), other.exitMessage()) && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(processingEndTime(), other.processingEndTime())
                && Objects.equals(processingStartTime(), other.processingStartTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(monitoringScheduleArn(), other.monitoringScheduleArn())
                && Objects.equals(autoMLJobArn(), other.autoMLJobArn())
                && Objects.equals(trainingJobArn(), other.trainingJobArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeProcessingJobResponse").add("ProcessingInputs", processingInputs())
                .add("ProcessingOutputConfig", processingOutputConfig()).add("ProcessingJobName", processingJobName())
                .add("ProcessingResources", processingResources()).add("StoppingCondition", stoppingCondition())
                .add("AppSpecification", appSpecification()).add("Environment", environment())
                .add("NetworkConfig", networkConfig()).add("RoleArn", roleArn()).add("ExperimentConfig", experimentConfig())
                .add("ProcessingJobArn", processingJobArn()).add("ProcessingJobStatus", processingJobStatusAsString())
                .add("ExitMessage", exitMessage()).add("FailureReason", failureReason())
                .add("ProcessingEndTime", processingEndTime()).add("ProcessingStartTime", processingStartTime())
                .add("LastModifiedTime", lastModifiedTime()).add("CreationTime", creationTime())
                .add("MonitoringScheduleArn", monitoringScheduleArn()).add("AutoMLJobArn", autoMLJobArn())
                .add("TrainingJobArn", trainingJobArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProcessingInputs":
            return Optional.ofNullable(clazz.cast(processingInputs()));
        case "ProcessingOutputConfig":
            return Optional.ofNullable(clazz.cast(processingOutputConfig()));
        case "ProcessingJobName":
            return Optional.ofNullable(clazz.cast(processingJobName()));
        case "ProcessingResources":
            return Optional.ofNullable(clazz.cast(processingResources()));
        case "StoppingCondition":
            return Optional.ofNullable(clazz.cast(stoppingCondition()));
        case "AppSpecification":
            return Optional.ofNullable(clazz.cast(appSpecification()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "NetworkConfig":
            return Optional.ofNullable(clazz.cast(networkConfig()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "ExperimentConfig":
            return Optional.ofNullable(clazz.cast(experimentConfig()));
        case "ProcessingJobArn":
            return Optional.ofNullable(clazz.cast(processingJobArn()));
        case "ProcessingJobStatus":
            return Optional.ofNullable(clazz.cast(processingJobStatusAsString()));
        case "ExitMessage":
            return Optional.ofNullable(clazz.cast(exitMessage()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "ProcessingEndTime":
            return Optional.ofNullable(clazz.cast(processingEndTime()));
        case "ProcessingStartTime":
            return Optional.ofNullable(clazz.cast(processingStartTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "MonitoringScheduleArn":
            return Optional.ofNullable(clazz.cast(monitoringScheduleArn()));
        case "AutoMLJobArn":
            return Optional.ofNullable(clazz.cast(autoMLJobArn()));
        case "TrainingJobArn":
            return Optional.ofNullable(clazz.cast(trainingJobArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProcessingJobResponse, T> g) {
        return obj -> g.apply((DescribeProcessingJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeProcessingJobResponse> {
        /**
         * <p>
         * The inputs for a processing job.
         * </p>
         * 
         * @param processingInputs
         *        The inputs for a processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingInputs(Collection<ProcessingInput> processingInputs);

        /**
         * <p>
         * The inputs for a processing job.
         * </p>
         * 
         * @param processingInputs
         *        The inputs for a processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingInputs(ProcessingInput... processingInputs);

        /**
         * <p>
         * The inputs for a processing job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProcessingInput>.Builder} avoiding the need
         * to create one manually via {@link List<ProcessingInput>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProcessingInput>.Builder#build()} is called immediately and
         * its result is passed to {@link #processingInputs(List<ProcessingInput>)}.
         * 
         * @param processingInputs
         *        a consumer that will call methods on {@link List<ProcessingInput>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingInputs(List<ProcessingInput>)
         */
        Builder processingInputs(Consumer<ProcessingInput.Builder>... processingInputs);

        /**
         * <p>
         * Output configuration for the processing job.
         * </p>
         * 
         * @param processingOutputConfig
         *        Output configuration for the processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingOutputConfig(ProcessingOutputConfig processingOutputConfig);

        /**
         * <p>
         * Output configuration for the processing job.
         * </p>
         * This is a convenience that creates an instance of the {@link ProcessingOutputConfig.Builder} avoiding the
         * need to create one manually via {@link ProcessingOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProcessingOutputConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #processingOutputConfig(ProcessingOutputConfig)}.
         * 
         * @param processingOutputConfig
         *        a consumer that will call methods on {@link ProcessingOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingOutputConfig(ProcessingOutputConfig)
         */
        default Builder processingOutputConfig(Consumer<ProcessingOutputConfig.Builder> processingOutputConfig) {
            return processingOutputConfig(ProcessingOutputConfig.builder().applyMutation(processingOutputConfig).build());
        }

        /**
         * <p>
         * The name of the processing job. The name must be unique within an AWS Region in the AWS account.
         * </p>
         * 
         * @param processingJobName
         *        The name of the processing job. The name must be unique within an AWS Region in the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingJobName(String processingJobName);

        /**
         * <p>
         * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In
         * distributed training, you specify more than one instance.
         * </p>
         * 
         * @param processingResources
         *        Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job.
         *        In distributed training, you specify more than one instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingResources(ProcessingResources processingResources);

        /**
         * <p>
         * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a processing job. In
         * distributed training, you specify more than one instance.
         * </p>
         * This is a convenience that creates an instance of the {@link ProcessingResources.Builder} avoiding the need
         * to create one manually via {@link ProcessingResources#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProcessingResources.Builder#build()} is called immediately and
         * its result is passed to {@link #processingResources(ProcessingResources)}.
         * 
         * @param processingResources
         *        a consumer that will call methods on {@link ProcessingResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingResources(ProcessingResources)
         */
        default Builder processingResources(Consumer<ProcessingResources.Builder> processingResources) {
            return processingResources(ProcessingResources.builder().applyMutation(processingResources).build());
        }

        /**
         * <p>
         * The time limit for how long the processing job is allowed to run.
         * </p>
         * 
         * @param stoppingCondition
         *        The time limit for how long the processing job is allowed to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingCondition(ProcessingStoppingCondition stoppingCondition);

        /**
         * <p>
         * The time limit for how long the processing job is allowed to run.
         * </p>
         * This is a convenience that creates an instance of the {@link ProcessingStoppingCondition.Builder} avoiding
         * the need to create one manually via {@link ProcessingStoppingCondition#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProcessingStoppingCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #stoppingCondition(ProcessingStoppingCondition)}.
         * 
         * @param stoppingCondition
         *        a consumer that will call methods on {@link ProcessingStoppingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingCondition(ProcessingStoppingCondition)
         */
        default Builder stoppingCondition(Consumer<ProcessingStoppingCondition.Builder> stoppingCondition) {
            return stoppingCondition(ProcessingStoppingCondition.builder().applyMutation(stoppingCondition).build());
        }

        /**
         * <p>
         * Configures the processing job to run a specified container image.
         * </p>
         * 
         * @param appSpecification
         *        Configures the processing job to run a specified container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appSpecification(AppSpecification appSpecification);

        /**
         * <p>
         * Configures the processing job to run a specified container image.
         * </p>
         * This is a convenience that creates an instance of the {@link AppSpecification.Builder} avoiding the need to
         * create one manually via {@link AppSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link AppSpecification.Builder#build()} is called immediately and its
         * result is passed to {@link #appSpecification(AppSpecification)}.
         * 
         * @param appSpecification
         *        a consumer that will call methods on {@link AppSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appSpecification(AppSpecification)
         */
        default Builder appSpecification(Consumer<AppSpecification.Builder> appSpecification) {
            return appSpecification(AppSpecification.builder().applyMutation(appSpecification).build());
        }

        /**
         * <p>
         * The environment variables set in the Docker container.
         * </p>
         * 
         * @param environment
         *        The environment variables set in the Docker container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Map<String, String> environment);

        /**
         * <p>
         * Networking options for a processing job.
         * </p>
         * 
         * @param networkConfig
         *        Networking options for a processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfig(NetworkConfig networkConfig);

        /**
         * <p>
         * Networking options for a processing job.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkConfig.Builder} avoiding the need to
         * create one manually via {@link NetworkConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #networkConfig(NetworkConfig)}.
         * 
         * @param networkConfig
         *        a consumer that will call methods on {@link NetworkConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfig(NetworkConfig)
         */
        default Builder networkConfig(Consumer<NetworkConfig.Builder> networkConfig) {
            return networkConfig(NetworkConfig.builder().applyMutation(networkConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your
         * behalf.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on
         *        your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The configuration information used to create an experiment.
         * </p>
         * 
         * @param experimentConfig
         *        The configuration information used to create an experiment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentConfig(ExperimentConfig experimentConfig);

        /**
         * <p>
         * The configuration information used to create an experiment.
         * </p>
         * This is a convenience that creates an instance of the {@link ExperimentConfig.Builder} avoiding the need to
         * create one manually via {@link ExperimentConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExperimentConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #experimentConfig(ExperimentConfig)}.
         * 
         * @param experimentConfig
         *        a consumer that will call methods on {@link ExperimentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #experimentConfig(ExperimentConfig)
         */
        default Builder experimentConfig(Consumer<ExperimentConfig.Builder> experimentConfig) {
            return experimentConfig(ExperimentConfig.builder().applyMutation(experimentConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the processing job.
         * </p>
         * 
         * @param processingJobArn
         *        The Amazon Resource Name (ARN) of the processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingJobArn(String processingJobArn);

        /**
         * <p>
         * Provides the status of a processing job.
         * </p>
         * 
         * @param processingJobStatus
         *        Provides the status of a processing job.
         * @see ProcessingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingJobStatus
         */
        Builder processingJobStatus(String processingJobStatus);

        /**
         * <p>
         * Provides the status of a processing job.
         * </p>
         * 
         * @param processingJobStatus
         *        Provides the status of a processing job.
         * @see ProcessingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingJobStatus
         */
        Builder processingJobStatus(ProcessingJobStatus processingJobStatus);

        /**
         * <p>
         * An optional string, up to one KB in size, that contains metadata from the processing container when the
         * processing job exits.
         * </p>
         * 
         * @param exitMessage
         *        An optional string, up to one KB in size, that contains metadata from the processing container when
         *        the processing job exits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exitMessage(String exitMessage);

        /**
         * <p>
         * A string, up to one KB in size, that contains the reason a processing job failed, if it failed.
         * </p>
         * 
         * @param failureReason
         *        A string, up to one KB in size, that contains the reason a processing job failed, if it failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The time at which the processing job completed.
         * </p>
         * 
         * @param processingEndTime
         *        The time at which the processing job completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingEndTime(Instant processingEndTime);

        /**
         * <p>
         * The time at which the processing job started.
         * </p>
         * 
         * @param processingStartTime
         *        The time at which the processing job started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingStartTime(Instant processingStartTime);

        /**
         * <p>
         * The time at which the processing job was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time at which the processing job was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The time at which the processing job was created.
         * </p>
         * 
         * @param creationTime
         *        The time at which the processing job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The ARN of a monitoring schedule for an endpoint associated with this processing job.
         * </p>
         * 
         * @param monitoringScheduleArn
         *        The ARN of a monitoring schedule for an endpoint associated with this processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringScheduleArn(String monitoringScheduleArn);

        /**
         * <p>
         * The ARN of an AutoML job associated with this processing job.
         * </p>
         * 
         * @param autoMLJobArn
         *        The ARN of an AutoML job associated with this processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobArn(String autoMLJobArn);

        /**
         * <p>
         * The ARN of a training job associated with this processing job.
         * </p>
         * 
         * @param trainingJobArn
         *        The ARN of a training job associated with this processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobArn(String trainingJobArn);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<ProcessingInput> processingInputs = DefaultSdkAutoConstructList.getInstance();

        private ProcessingOutputConfig processingOutputConfig;

        private String processingJobName;

        private ProcessingResources processingResources;

        private ProcessingStoppingCondition stoppingCondition;

        private AppSpecification appSpecification;

        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();

        private NetworkConfig networkConfig;

        private String roleArn;

        private ExperimentConfig experimentConfig;

        private String processingJobArn;

        private String processingJobStatus;

        private String exitMessage;

        private String failureReason;

        private Instant processingEndTime;

        private Instant processingStartTime;

        private Instant lastModifiedTime;

        private Instant creationTime;

        private String monitoringScheduleArn;

        private String autoMLJobArn;

        private String trainingJobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProcessingJobResponse model) {
            super(model);
            processingInputs(model.processingInputs);
            processingOutputConfig(model.processingOutputConfig);
            processingJobName(model.processingJobName);
            processingResources(model.processingResources);
            stoppingCondition(model.stoppingCondition);
            appSpecification(model.appSpecification);
            environment(model.environment);
            networkConfig(model.networkConfig);
            roleArn(model.roleArn);
            experimentConfig(model.experimentConfig);
            processingJobArn(model.processingJobArn);
            processingJobStatus(model.processingJobStatus);
            exitMessage(model.exitMessage);
            failureReason(model.failureReason);
            processingEndTime(model.processingEndTime);
            processingStartTime(model.processingStartTime);
            lastModifiedTime(model.lastModifiedTime);
            creationTime(model.creationTime);
            monitoringScheduleArn(model.monitoringScheduleArn);
            autoMLJobArn(model.autoMLJobArn);
            trainingJobArn(model.trainingJobArn);
        }

        public final Collection<ProcessingInput.Builder> getProcessingInputs() {
            return processingInputs != null ? processingInputs.stream().map(ProcessingInput::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder processingInputs(Collection<ProcessingInput> processingInputs) {
            this.processingInputs = ProcessingInputsCopier.copy(processingInputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingInputs(ProcessingInput... processingInputs) {
            processingInputs(Arrays.asList(processingInputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingInputs(Consumer<ProcessingInput.Builder>... processingInputs) {
            processingInputs(Stream.of(processingInputs).map(c -> ProcessingInput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProcessingInputs(Collection<ProcessingInput.BuilderImpl> processingInputs) {
            this.processingInputs = ProcessingInputsCopier.copyFromBuilder(processingInputs);
        }

        public final ProcessingOutputConfig.Builder getProcessingOutputConfig() {
            return processingOutputConfig != null ? processingOutputConfig.toBuilder() : null;
        }

        @Override
        public final Builder processingOutputConfig(ProcessingOutputConfig processingOutputConfig) {
            this.processingOutputConfig = processingOutputConfig;
            return this;
        }

        public final void setProcessingOutputConfig(ProcessingOutputConfig.BuilderImpl processingOutputConfig) {
            this.processingOutputConfig = processingOutputConfig != null ? processingOutputConfig.build() : null;
        }

        public final String getProcessingJobName() {
            return processingJobName;
        }

        @Override
        public final Builder processingJobName(String processingJobName) {
            this.processingJobName = processingJobName;
            return this;
        }

        public final void setProcessingJobName(String processingJobName) {
            this.processingJobName = processingJobName;
        }

        public final ProcessingResources.Builder getProcessingResources() {
            return processingResources != null ? processingResources.toBuilder() : null;
        }

        @Override
        public final Builder processingResources(ProcessingResources processingResources) {
            this.processingResources = processingResources;
            return this;
        }

        public final void setProcessingResources(ProcessingResources.BuilderImpl processingResources) {
            this.processingResources = processingResources != null ? processingResources.build() : null;
        }

        public final ProcessingStoppingCondition.Builder getStoppingCondition() {
            return stoppingCondition != null ? stoppingCondition.toBuilder() : null;
        }

        @Override
        public final Builder stoppingCondition(ProcessingStoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final void setStoppingCondition(ProcessingStoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        public final AppSpecification.Builder getAppSpecification() {
            return appSpecification != null ? appSpecification.toBuilder() : null;
        }

        @Override
        public final Builder appSpecification(AppSpecification appSpecification) {
            this.appSpecification = appSpecification;
            return this;
        }

        public final void setAppSpecification(AppSpecification.BuilderImpl appSpecification) {
            this.appSpecification = appSpecification != null ? appSpecification.build() : null;
        }

        public final Map<String, String> getEnvironment() {
            return environment;
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = ProcessingEnvironmentMapCopier.copy(environment);
            return this;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = ProcessingEnvironmentMapCopier.copy(environment);
        }

        public final NetworkConfig.Builder getNetworkConfig() {
            return networkConfig != null ? networkConfig.toBuilder() : null;
        }

        @Override
        public final Builder networkConfig(NetworkConfig networkConfig) {
            this.networkConfig = networkConfig;
            return this;
        }

        public final void setNetworkConfig(NetworkConfig.BuilderImpl networkConfig) {
            this.networkConfig = networkConfig != null ? networkConfig.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final ExperimentConfig.Builder getExperimentConfig() {
            return experimentConfig != null ? experimentConfig.toBuilder() : null;
        }

        @Override
        public final Builder experimentConfig(ExperimentConfig experimentConfig) {
            this.experimentConfig = experimentConfig;
            return this;
        }

        public final void setExperimentConfig(ExperimentConfig.BuilderImpl experimentConfig) {
            this.experimentConfig = experimentConfig != null ? experimentConfig.build() : null;
        }

        public final String getProcessingJobArn() {
            return processingJobArn;
        }

        @Override
        public final Builder processingJobArn(String processingJobArn) {
            this.processingJobArn = processingJobArn;
            return this;
        }

        public final void setProcessingJobArn(String processingJobArn) {
            this.processingJobArn = processingJobArn;
        }

        public final String getProcessingJobStatusAsString() {
            return processingJobStatus;
        }

        @Override
        public final Builder processingJobStatus(String processingJobStatus) {
            this.processingJobStatus = processingJobStatus;
            return this;
        }

        @Override
        public final Builder processingJobStatus(ProcessingJobStatus processingJobStatus) {
            this.processingJobStatus(processingJobStatus == null ? null : processingJobStatus.toString());
            return this;
        }

        public final void setProcessingJobStatus(String processingJobStatus) {
            this.processingJobStatus = processingJobStatus;
        }

        public final String getExitMessage() {
            return exitMessage;
        }

        @Override
        public final Builder exitMessage(String exitMessage) {
            this.exitMessage = exitMessage;
            return this;
        }

        public final void setExitMessage(String exitMessage) {
            this.exitMessage = exitMessage;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final Instant getProcessingEndTime() {
            return processingEndTime;
        }

        @Override
        public final Builder processingEndTime(Instant processingEndTime) {
            this.processingEndTime = processingEndTime;
            return this;
        }

        public final void setProcessingEndTime(Instant processingEndTime) {
            this.processingEndTime = processingEndTime;
        }

        public final Instant getProcessingStartTime() {
            return processingStartTime;
        }

        @Override
        public final Builder processingStartTime(Instant processingStartTime) {
            this.processingStartTime = processingStartTime;
            return this;
        }

        public final void setProcessingStartTime(Instant processingStartTime) {
            this.processingStartTime = processingStartTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getMonitoringScheduleArn() {
            return monitoringScheduleArn;
        }

        @Override
        public final Builder monitoringScheduleArn(String monitoringScheduleArn) {
            this.monitoringScheduleArn = monitoringScheduleArn;
            return this;
        }

        public final void setMonitoringScheduleArn(String monitoringScheduleArn) {
            this.monitoringScheduleArn = monitoringScheduleArn;
        }

        public final String getAutoMLJobArn() {
            return autoMLJobArn;
        }

        @Override
        public final Builder autoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
            return this;
        }

        public final void setAutoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
        }

        public final String getTrainingJobArn() {
            return trainingJobArn;
        }

        @Override
        public final Builder trainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
            return this;
        }

        public final void setTrainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
        }

        @Override
        public DescribeProcessingJobResponse build() {
            return new DescribeProcessingJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
