/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeModelPackageResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeModelPackageResponse.Builder, DescribeModelPackageResponse> {
    private static final SdkField<String> MODEL_PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeModelPackageResponse::modelPackageName)).setter(setter(Builder::modelPackageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageName").build()).build();

    private static final SdkField<String> MODEL_PACKAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeModelPackageResponse::modelPackageArn)).setter(setter(Builder::modelPackageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageArn").build()).build();

    private static final SdkField<String> MODEL_PACKAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeModelPackageResponse::modelPackageDescription))
            .setter(setter(Builder::modelPackageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageDescription").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeModelPackageResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<InferenceSpecification> INFERENCE_SPECIFICATION_FIELD = SdkField
            .<InferenceSpecification> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeModelPackageResponse::inferenceSpecification)).setter(setter(Builder::inferenceSpecification))
            .constructor(InferenceSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSpecification").build())
            .build();

    private static final SdkField<SourceAlgorithmSpecification> SOURCE_ALGORITHM_SPECIFICATION_FIELD = SdkField
            .<SourceAlgorithmSpecification> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeModelPackageResponse::sourceAlgorithmSpecification))
            .setter(setter(Builder::sourceAlgorithmSpecification))
            .constructor(SourceAlgorithmSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAlgorithmSpecification")
                    .build()).build();

    private static final SdkField<ModelPackageValidationSpecification> VALIDATION_SPECIFICATION_FIELD = SdkField
            .<ModelPackageValidationSpecification> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeModelPackageResponse::validationSpecification))
            .setter(setter(Builder::validationSpecification)).constructor(ModelPackageValidationSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationSpecification").build())
            .build();

    private static final SdkField<String> MODEL_PACKAGE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeModelPackageResponse::modelPackageStatusAsString)).setter(setter(Builder::modelPackageStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageStatus").build())
            .build();

    private static final SdkField<ModelPackageStatusDetails> MODEL_PACKAGE_STATUS_DETAILS_FIELD = SdkField
            .<ModelPackageStatusDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeModelPackageResponse::modelPackageStatusDetails))
            .setter(setter(Builder::modelPackageStatusDetails)).constructor(ModelPackageStatusDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageStatusDetails").build())
            .build();

    private static final SdkField<Boolean> CERTIFY_FOR_MARKETPLACE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DescribeModelPackageResponse::certifyForMarketplace)).setter(setter(Builder::certifyForMarketplace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertifyForMarketplace").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_PACKAGE_NAME_FIELD,
            MODEL_PACKAGE_ARN_FIELD, MODEL_PACKAGE_DESCRIPTION_FIELD, CREATION_TIME_FIELD, INFERENCE_SPECIFICATION_FIELD,
            SOURCE_ALGORITHM_SPECIFICATION_FIELD, VALIDATION_SPECIFICATION_FIELD, MODEL_PACKAGE_STATUS_FIELD,
            MODEL_PACKAGE_STATUS_DETAILS_FIELD, CERTIFY_FOR_MARKETPLACE_FIELD));

    private final String modelPackageName;

    private final String modelPackageArn;

    private final String modelPackageDescription;

    private final Instant creationTime;

    private final InferenceSpecification inferenceSpecification;

    private final SourceAlgorithmSpecification sourceAlgorithmSpecification;

    private final ModelPackageValidationSpecification validationSpecification;

    private final String modelPackageStatus;

    private final ModelPackageStatusDetails modelPackageStatusDetails;

    private final Boolean certifyForMarketplace;

    private DescribeModelPackageResponse(BuilderImpl builder) {
        super(builder);
        this.modelPackageName = builder.modelPackageName;
        this.modelPackageArn = builder.modelPackageArn;
        this.modelPackageDescription = builder.modelPackageDescription;
        this.creationTime = builder.creationTime;
        this.inferenceSpecification = builder.inferenceSpecification;
        this.sourceAlgorithmSpecification = builder.sourceAlgorithmSpecification;
        this.validationSpecification = builder.validationSpecification;
        this.modelPackageStatus = builder.modelPackageStatus;
        this.modelPackageStatusDetails = builder.modelPackageStatusDetails;
        this.certifyForMarketplace = builder.certifyForMarketplace;
    }

    /**
     * <p>
     * The name of the model package being described.
     * </p>
     * 
     * @return The name of the model package being described.
     */
    public String modelPackageName() {
        return modelPackageName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model package.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model package.
     */
    public String modelPackageArn() {
        return modelPackageArn;
    }

    /**
     * <p>
     * A brief summary of the model package.
     * </p>
     * 
     * @return A brief summary of the model package.
     */
    public String modelPackageDescription() {
        return modelPackageDescription;
    }

    /**
     * <p>
     * A timestamp specifying when the model package was created.
     * </p>
     * 
     * @return A timestamp specifying when the model package was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Details about inference jobs that can be run with models based on this model package.
     * </p>
     * 
     * @return Details about inference jobs that can be run with models based on this model package.
     */
    public InferenceSpecification inferenceSpecification() {
        return inferenceSpecification;
    }

    /**
     * <p>
     * Details about the algorithm that was used to create the model package.
     * </p>
     * 
     * @return Details about the algorithm that was used to create the model package.
     */
    public SourceAlgorithmSpecification sourceAlgorithmSpecification() {
        return sourceAlgorithmSpecification;
    }

    /**
     * <p>
     * Configurations for one or more transform jobs that Amazon SageMaker runs to test the model package.
     * </p>
     * 
     * @return Configurations for one or more transform jobs that Amazon SageMaker runs to test the model package.
     */
    public ModelPackageValidationSpecification validationSpecification() {
        return validationSpecification;
    }

    /**
     * <p>
     * The current status of the model package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelPackageStatus} will return {@link ModelPackageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #modelPackageStatusAsString}.
     * </p>
     * 
     * @return The current status of the model package.
     * @see ModelPackageStatus
     */
    public ModelPackageStatus modelPackageStatus() {
        return ModelPackageStatus.fromValue(modelPackageStatus);
    }

    /**
     * <p>
     * The current status of the model package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelPackageStatus} will return {@link ModelPackageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #modelPackageStatusAsString}.
     * </p>
     * 
     * @return The current status of the model package.
     * @see ModelPackageStatus
     */
    public String modelPackageStatusAsString() {
        return modelPackageStatus;
    }

    /**
     * <p>
     * Details about the current status of the model package.
     * </p>
     * 
     * @return Details about the current status of the model package.
     */
    public ModelPackageStatusDetails modelPackageStatusDetails() {
        return modelPackageStatusDetails;
    }

    /**
     * <p>
     * Whether the model package is certified for listing on AWS Marketplace.
     * </p>
     * 
     * @return Whether the model package is certified for listing on AWS Marketplace.
     */
    public Boolean certifyForMarketplace() {
        return certifyForMarketplace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageName());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAlgorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(validationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(certifyForMarketplace());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelPackageResponse)) {
            return false;
        }
        DescribeModelPackageResponse other = (DescribeModelPackageResponse) obj;
        return Objects.equals(modelPackageName(), other.modelPackageName())
                && Objects.equals(modelPackageArn(), other.modelPackageArn())
                && Objects.equals(modelPackageDescription(), other.modelPackageDescription())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(inferenceSpecification(), other.inferenceSpecification())
                && Objects.equals(sourceAlgorithmSpecification(), other.sourceAlgorithmSpecification())
                && Objects.equals(validationSpecification(), other.validationSpecification())
                && Objects.equals(modelPackageStatusAsString(), other.modelPackageStatusAsString())
                && Objects.equals(modelPackageStatusDetails(), other.modelPackageStatusDetails())
                && Objects.equals(certifyForMarketplace(), other.certifyForMarketplace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeModelPackageResponse").add("ModelPackageName", modelPackageName())
                .add("ModelPackageArn", modelPackageArn()).add("ModelPackageDescription", modelPackageDescription())
                .add("CreationTime", creationTime()).add("InferenceSpecification", inferenceSpecification())
                .add("SourceAlgorithmSpecification", sourceAlgorithmSpecification())
                .add("ValidationSpecification", validationSpecification())
                .add("ModelPackageStatus", modelPackageStatusAsString())
                .add("ModelPackageStatusDetails", modelPackageStatusDetails())
                .add("CertifyForMarketplace", certifyForMarketplace()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelPackageName":
            return Optional.ofNullable(clazz.cast(modelPackageName()));
        case "ModelPackageArn":
            return Optional.ofNullable(clazz.cast(modelPackageArn()));
        case "ModelPackageDescription":
            return Optional.ofNullable(clazz.cast(modelPackageDescription()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "InferenceSpecification":
            return Optional.ofNullable(clazz.cast(inferenceSpecification()));
        case "SourceAlgorithmSpecification":
            return Optional.ofNullable(clazz.cast(sourceAlgorithmSpecification()));
        case "ValidationSpecification":
            return Optional.ofNullable(clazz.cast(validationSpecification()));
        case "ModelPackageStatus":
            return Optional.ofNullable(clazz.cast(modelPackageStatusAsString()));
        case "ModelPackageStatusDetails":
            return Optional.ofNullable(clazz.cast(modelPackageStatusDetails()));
        case "CertifyForMarketplace":
            return Optional.ofNullable(clazz.cast(certifyForMarketplace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelPackageResponse, T> g) {
        return obj -> g.apply((DescribeModelPackageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeModelPackageResponse> {
        /**
         * <p>
         * The name of the model package being described.
         * </p>
         * 
         * @param modelPackageName
         *        The name of the model package being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageName(String modelPackageName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model package.
         * </p>
         * 
         * @param modelPackageArn
         *        The Amazon Resource Name (ARN) of the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageArn(String modelPackageArn);

        /**
         * <p>
         * A brief summary of the model package.
         * </p>
         * 
         * @param modelPackageDescription
         *        A brief summary of the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageDescription(String modelPackageDescription);

        /**
         * <p>
         * A timestamp specifying when the model package was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp specifying when the model package was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Details about inference jobs that can be run with models based on this model package.
         * </p>
         * 
         * @param inferenceSpecification
         *        Details about inference jobs that can be run with models based on this model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSpecification(InferenceSpecification inferenceSpecification);

        /**
         * <p>
         * Details about inference jobs that can be run with models based on this model package.
         * </p>
         * This is a convenience that creates an instance of the {@link InferenceSpecification.Builder} avoiding the
         * need to create one manually via {@link InferenceSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link InferenceSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #inferenceSpecification(InferenceSpecification)}.
         * 
         * @param inferenceSpecification
         *        a consumer that will call methods on {@link InferenceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceSpecification(InferenceSpecification)
         */
        default Builder inferenceSpecification(Consumer<InferenceSpecification.Builder> inferenceSpecification) {
            return inferenceSpecification(InferenceSpecification.builder().applyMutation(inferenceSpecification).build());
        }

        /**
         * <p>
         * Details about the algorithm that was used to create the model package.
         * </p>
         * 
         * @param sourceAlgorithmSpecification
         *        Details about the algorithm that was used to create the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAlgorithmSpecification(SourceAlgorithmSpecification sourceAlgorithmSpecification);

        /**
         * <p>
         * Details about the algorithm that was used to create the model package.
         * </p>
         * This is a convenience that creates an instance of the {@link SourceAlgorithmSpecification.Builder} avoiding
         * the need to create one manually via {@link SourceAlgorithmSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceAlgorithmSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceAlgorithmSpecification(SourceAlgorithmSpecification)}.
         * 
         * @param sourceAlgorithmSpecification
         *        a consumer that will call methods on {@link SourceAlgorithmSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceAlgorithmSpecification(SourceAlgorithmSpecification)
         */
        default Builder sourceAlgorithmSpecification(Consumer<SourceAlgorithmSpecification.Builder> sourceAlgorithmSpecification) {
            return sourceAlgorithmSpecification(SourceAlgorithmSpecification.builder()
                    .applyMutation(sourceAlgorithmSpecification).build());
        }

        /**
         * <p>
         * Configurations for one or more transform jobs that Amazon SageMaker runs to test the model package.
         * </p>
         * 
         * @param validationSpecification
         *        Configurations for one or more transform jobs that Amazon SageMaker runs to test the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationSpecification(ModelPackageValidationSpecification validationSpecification);

        /**
         * <p>
         * Configurations for one or more transform jobs that Amazon SageMaker runs to test the model package.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelPackageValidationSpecification.Builder}
         * avoiding the need to create one manually via {@link ModelPackageValidationSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelPackageValidationSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #validationSpecification(ModelPackageValidationSpecification)}
         * .
         * 
         * @param validationSpecification
         *        a consumer that will call methods on {@link ModelPackageValidationSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationSpecification(ModelPackageValidationSpecification)
         */
        default Builder validationSpecification(Consumer<ModelPackageValidationSpecification.Builder> validationSpecification) {
            return validationSpecification(ModelPackageValidationSpecification.builder().applyMutation(validationSpecification)
                    .build());
        }

        /**
         * <p>
         * The current status of the model package.
         * </p>
         * 
         * @param modelPackageStatus
         *        The current status of the model package.
         * @see ModelPackageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelPackageStatus
         */
        Builder modelPackageStatus(String modelPackageStatus);

        /**
         * <p>
         * The current status of the model package.
         * </p>
         * 
         * @param modelPackageStatus
         *        The current status of the model package.
         * @see ModelPackageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelPackageStatus
         */
        Builder modelPackageStatus(ModelPackageStatus modelPackageStatus);

        /**
         * <p>
         * Details about the current status of the model package.
         * </p>
         * 
         * @param modelPackageStatusDetails
         *        Details about the current status of the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageStatusDetails(ModelPackageStatusDetails modelPackageStatusDetails);

        /**
         * <p>
         * Details about the current status of the model package.
         * </p>
         * This is a convenience that creates an instance of the {@link ModelPackageStatusDetails.Builder} avoiding the
         * need to create one manually via {@link ModelPackageStatusDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ModelPackageStatusDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #modelPackageStatusDetails(ModelPackageStatusDetails)}.
         * 
         * @param modelPackageStatusDetails
         *        a consumer that will call methods on {@link ModelPackageStatusDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelPackageStatusDetails(ModelPackageStatusDetails)
         */
        default Builder modelPackageStatusDetails(Consumer<ModelPackageStatusDetails.Builder> modelPackageStatusDetails) {
            return modelPackageStatusDetails(ModelPackageStatusDetails.builder().applyMutation(modelPackageStatusDetails).build());
        }

        /**
         * <p>
         * Whether the model package is certified for listing on AWS Marketplace.
         * </p>
         * 
         * @param certifyForMarketplace
         *        Whether the model package is certified for listing on AWS Marketplace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certifyForMarketplace(Boolean certifyForMarketplace);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String modelPackageName;

        private String modelPackageArn;

        private String modelPackageDescription;

        private Instant creationTime;

        private InferenceSpecification inferenceSpecification;

        private SourceAlgorithmSpecification sourceAlgorithmSpecification;

        private ModelPackageValidationSpecification validationSpecification;

        private String modelPackageStatus;

        private ModelPackageStatusDetails modelPackageStatusDetails;

        private Boolean certifyForMarketplace;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelPackageResponse model) {
            super(model);
            modelPackageName(model.modelPackageName);
            modelPackageArn(model.modelPackageArn);
            modelPackageDescription(model.modelPackageDescription);
            creationTime(model.creationTime);
            inferenceSpecification(model.inferenceSpecification);
            sourceAlgorithmSpecification(model.sourceAlgorithmSpecification);
            validationSpecification(model.validationSpecification);
            modelPackageStatus(model.modelPackageStatus);
            modelPackageStatusDetails(model.modelPackageStatusDetails);
            certifyForMarketplace(model.certifyForMarketplace);
        }

        public final String getModelPackageName() {
            return modelPackageName;
        }

        @Override
        public final Builder modelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
            return this;
        }

        public final void setModelPackageName(String modelPackageName) {
            this.modelPackageName = modelPackageName;
        }

        public final String getModelPackageArn() {
            return modelPackageArn;
        }

        @Override
        public final Builder modelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
            return this;
        }

        public final void setModelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
        }

        public final String getModelPackageDescription() {
            return modelPackageDescription;
        }

        @Override
        public final Builder modelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
            return this;
        }

        public final void setModelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final InferenceSpecification.Builder getInferenceSpecification() {
            return inferenceSpecification != null ? inferenceSpecification.toBuilder() : null;
        }

        @Override
        public final Builder inferenceSpecification(InferenceSpecification inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification;
            return this;
        }

        public final void setInferenceSpecification(InferenceSpecification.BuilderImpl inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification != null ? inferenceSpecification.build() : null;
        }

        public final SourceAlgorithmSpecification.Builder getSourceAlgorithmSpecification() {
            return sourceAlgorithmSpecification != null ? sourceAlgorithmSpecification.toBuilder() : null;
        }

        @Override
        public final Builder sourceAlgorithmSpecification(SourceAlgorithmSpecification sourceAlgorithmSpecification) {
            this.sourceAlgorithmSpecification = sourceAlgorithmSpecification;
            return this;
        }

        public final void setSourceAlgorithmSpecification(SourceAlgorithmSpecification.BuilderImpl sourceAlgorithmSpecification) {
            this.sourceAlgorithmSpecification = sourceAlgorithmSpecification != null ? sourceAlgorithmSpecification.build()
                    : null;
        }

        public final ModelPackageValidationSpecification.Builder getValidationSpecification() {
            return validationSpecification != null ? validationSpecification.toBuilder() : null;
        }

        @Override
        public final Builder validationSpecification(ModelPackageValidationSpecification validationSpecification) {
            this.validationSpecification = validationSpecification;
            return this;
        }

        public final void setValidationSpecification(ModelPackageValidationSpecification.BuilderImpl validationSpecification) {
            this.validationSpecification = validationSpecification != null ? validationSpecification.build() : null;
        }

        public final String getModelPackageStatus() {
            return modelPackageStatus;
        }

        @Override
        public final Builder modelPackageStatus(String modelPackageStatus) {
            this.modelPackageStatus = modelPackageStatus;
            return this;
        }

        @Override
        public final Builder modelPackageStatus(ModelPackageStatus modelPackageStatus) {
            this.modelPackageStatus(modelPackageStatus == null ? null : modelPackageStatus.toString());
            return this;
        }

        public final void setModelPackageStatus(String modelPackageStatus) {
            this.modelPackageStatus = modelPackageStatus;
        }

        public final ModelPackageStatusDetails.Builder getModelPackageStatusDetails() {
            return modelPackageStatusDetails != null ? modelPackageStatusDetails.toBuilder() : null;
        }

        @Override
        public final Builder modelPackageStatusDetails(ModelPackageStatusDetails modelPackageStatusDetails) {
            this.modelPackageStatusDetails = modelPackageStatusDetails;
            return this;
        }

        public final void setModelPackageStatusDetails(ModelPackageStatusDetails.BuilderImpl modelPackageStatusDetails) {
            this.modelPackageStatusDetails = modelPackageStatusDetails != null ? modelPackageStatusDetails.build() : null;
        }

        public final Boolean getCertifyForMarketplace() {
            return certifyForMarketplace;
        }

        @Override
        public final Builder certifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
            return this;
        }

        public final void setCertifyForMarketplace(Boolean certifyForMarketplace) {
            this.certifyForMarketplace = certifyForMarketplace;
        }

        @Override
        public DescribeModelPackageResponse build() {
            return new DescribeModelPackageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
