/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information about an algorithm.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlgorithmSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AlgorithmSummary.Builder, AlgorithmSummary> {
    private static final SdkField<String> ALGORITHM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AlgorithmSummary::algorithmName)).setter(setter(Builder::algorithmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmName").build()).build();

    private static final SdkField<String> ALGORITHM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AlgorithmSummary::algorithmArn)).setter(setter(Builder::algorithmArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmArn").build()).build();

    private static final SdkField<String> ALGORITHM_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AlgorithmSummary::algorithmDescription)).setter(setter(Builder::algorithmDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmDescription").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AlgorithmSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> ALGORITHM_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AlgorithmSummary::algorithmStatusAsString)).setter(setter(Builder::algorithmStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_NAME_FIELD,
            ALGORITHM_ARN_FIELD, ALGORITHM_DESCRIPTION_FIELD, CREATION_TIME_FIELD, ALGORITHM_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String algorithmName;

    private final String algorithmArn;

    private final String algorithmDescription;

    private final Instant creationTime;

    private final String algorithmStatus;

    private AlgorithmSummary(BuilderImpl builder) {
        this.algorithmName = builder.algorithmName;
        this.algorithmArn = builder.algorithmArn;
        this.algorithmDescription = builder.algorithmDescription;
        this.creationTime = builder.creationTime;
        this.algorithmStatus = builder.algorithmStatus;
    }

    /**
     * <p>
     * The name of the algorithm that is described by the summary.
     * </p>
     * 
     * @return The name of the algorithm that is described by the summary.
     */
    public String algorithmName() {
        return algorithmName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the algorithm.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the algorithm.
     */
    public String algorithmArn() {
        return algorithmArn;
    }

    /**
     * <p>
     * A brief description of the algorithm.
     * </p>
     * 
     * @return A brief description of the algorithm.
     */
    public String algorithmDescription() {
        return algorithmDescription;
    }

    /**
     * <p>
     * A timestamp that shows when the algorithm was created.
     * </p>
     * 
     * @return A timestamp that shows when the algorithm was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The overall status of the algorithm.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #algorithmStatus}
     * will return {@link AlgorithmStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #algorithmStatusAsString}.
     * </p>
     * 
     * @return The overall status of the algorithm.
     * @see AlgorithmStatus
     */
    public AlgorithmStatus algorithmStatus() {
        return AlgorithmStatus.fromValue(algorithmStatus);
    }

    /**
     * <p>
     * The overall status of the algorithm.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #algorithmStatus}
     * will return {@link AlgorithmStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #algorithmStatusAsString}.
     * </p>
     * 
     * @return The overall status of the algorithm.
     * @see AlgorithmStatus
     */
    public String algorithmStatusAsString() {
        return algorithmStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(algorithmName());
        hashCode = 31 * hashCode + Objects.hashCode(algorithmArn());
        hashCode = 31 * hashCode + Objects.hashCode(algorithmDescription());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(algorithmStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlgorithmSummary)) {
            return false;
        }
        AlgorithmSummary other = (AlgorithmSummary) obj;
        return Objects.equals(algorithmName(), other.algorithmName()) && Objects.equals(algorithmArn(), other.algorithmArn())
                && Objects.equals(algorithmDescription(), other.algorithmDescription())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(algorithmStatusAsString(), other.algorithmStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AlgorithmSummary").add("AlgorithmName", algorithmName()).add("AlgorithmArn", algorithmArn())
                .add("AlgorithmDescription", algorithmDescription()).add("CreationTime", creationTime())
                .add("AlgorithmStatus", algorithmStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlgorithmName":
            return Optional.ofNullable(clazz.cast(algorithmName()));
        case "AlgorithmArn":
            return Optional.ofNullable(clazz.cast(algorithmArn()));
        case "AlgorithmDescription":
            return Optional.ofNullable(clazz.cast(algorithmDescription()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "AlgorithmStatus":
            return Optional.ofNullable(clazz.cast(algorithmStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlgorithmSummary, T> g) {
        return obj -> g.apply((AlgorithmSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlgorithmSummary> {
        /**
         * <p>
         * The name of the algorithm that is described by the summary.
         * </p>
         * 
         * @param algorithmName
         *        The name of the algorithm that is described by the summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmName(String algorithmName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the algorithm.
         * </p>
         * 
         * @param algorithmArn
         *        The Amazon Resource Name (ARN) of the algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmArn(String algorithmArn);

        /**
         * <p>
         * A brief description of the algorithm.
         * </p>
         * 
         * @param algorithmDescription
         *        A brief description of the algorithm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmDescription(String algorithmDescription);

        /**
         * <p>
         * A timestamp that shows when the algorithm was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp that shows when the algorithm was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The overall status of the algorithm.
         * </p>
         * 
         * @param algorithmStatus
         *        The overall status of the algorithm.
         * @see AlgorithmStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlgorithmStatus
         */
        Builder algorithmStatus(String algorithmStatus);

        /**
         * <p>
         * The overall status of the algorithm.
         * </p>
         * 
         * @param algorithmStatus
         *        The overall status of the algorithm.
         * @see AlgorithmStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlgorithmStatus
         */
        Builder algorithmStatus(AlgorithmStatus algorithmStatus);
    }

    static final class BuilderImpl implements Builder {
        private String algorithmName;

        private String algorithmArn;

        private String algorithmDescription;

        private Instant creationTime;

        private String algorithmStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AlgorithmSummary model) {
            algorithmName(model.algorithmName);
            algorithmArn(model.algorithmArn);
            algorithmDescription(model.algorithmDescription);
            creationTime(model.creationTime);
            algorithmStatus(model.algorithmStatus);
        }

        public final String getAlgorithmName() {
            return algorithmName;
        }

        @Override
        public final Builder algorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
            return this;
        }

        public final void setAlgorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
        }

        public final String getAlgorithmArn() {
            return algorithmArn;
        }

        @Override
        public final Builder algorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
            return this;
        }

        public final void setAlgorithmArn(String algorithmArn) {
            this.algorithmArn = algorithmArn;
        }

        public final String getAlgorithmDescription() {
            return algorithmDescription;
        }

        @Override
        public final Builder algorithmDescription(String algorithmDescription) {
            this.algorithmDescription = algorithmDescription;
            return this;
        }

        public final void setAlgorithmDescription(String algorithmDescription) {
            this.algorithmDescription = algorithmDescription;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getAlgorithmStatus() {
            return algorithmStatus;
        }

        @Override
        public final Builder algorithmStatus(String algorithmStatus) {
            this.algorithmStatus = algorithmStatus;
            return this;
        }

        @Override
        public final Builder algorithmStatus(AlgorithmStatus algorithmStatus) {
            this.algorithmStatus(algorithmStatus == null ? null : algorithmStatus.toString());
            return this;
        }

        public final void setAlgorithmStatus(String algorithmStatus) {
            this.algorithmStatus = algorithmStatus;
        }

        @Override
        public AlgorithmSummary build() {
            return new AlgorithmSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
