/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration details about the monitoring schedule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduleConfig implements SdkPojo, Serializable, ToCopyableBuilder<ScheduleConfig.Builder, ScheduleConfig> {
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ScheduleConfig::scheduleExpression)).setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_EXPRESSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String scheduleExpression;

    private ScheduleConfig(BuilderImpl builder) {
        this.scheduleExpression = builder.scheduleExpression;
    }

    /**
     * <p>
     * A cron expression that describes details about the monitoring schedule.
     * </p>
     * <p>
     * Currently the only supported cron expressions are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you want to set the job to start every hour, please use the following:
     * </p>
     * <p>
     * <code>Hourly: cron(0 * ? * * *)</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * If you want to start the job daily:
     * </p>
     * <p>
     * <code>cron(0 [00-23] ? * * *)</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For example, the following are valid cron expressions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Daily at noon UTC: <code>cron(0 12 ? * * *)</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Daily at midnight UTC: <code>cron(0 0 ? * * *)</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To support running every 6, 12 hours, the following are also supported:
     * </p>
     * <p>
     * <code>cron(0 [00-23]/[01-24] ? * * *)</code>
     * </p>
     * <p>
     * For example, the following are valid cron expressions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Every 12 hours, starting at 5pm UTC: <code>cron(0 17/12 ? * * *)</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Every two hours starting at midnight: <code>cron(0 0/2 ? * * *)</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Even though the cron expression is set to start at 5PM UTC, note that there could be a delay of 0-20 minutes from
     * the actual requested time to run the execution.
     * </p>
     * </li>
     * <li>
     * <p>
     * We recommend that if you would like a daily schedule, you do not provide this parameter. Amazon SageMaker will
     * pick a time for running every day.
     * </p>
     * </li>
     * </ul>
     * </note>
     * 
     * @return A cron expression that describes details about the monitoring schedule.</p>
     *         <p>
     *         Currently the only supported cron expressions are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you want to set the job to start every hour, please use the following:
     *         </p>
     *         <p>
     *         <code>Hourly: cron(0 * ? * * *)</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you want to start the job daily:
     *         </p>
     *         <p>
     *         <code>cron(0 [00-23] ? * * *)</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For example, the following are valid cron expressions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Daily at noon UTC: <code>cron(0 12 ? * * *)</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Daily at midnight UTC: <code>cron(0 0 ? * * *)</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To support running every 6, 12 hours, the following are also supported:
     *         </p>
     *         <p>
     *         <code>cron(0 [00-23]/[01-24] ? * * *)</code>
     *         </p>
     *         <p>
     *         For example, the following are valid cron expressions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Every 12 hours, starting at 5pm UTC: <code>cron(0 17/12 ? * * *)</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Every two hours starting at midnight: <code>cron(0 0/2 ? * * *)</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <ul>
     *         <li>
     *         <p>
     *         Even though the cron expression is set to start at 5PM UTC, note that there could be a delay of 0-20
     *         minutes from the actual requested time to run the execution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         We recommend that if you would like a daily schedule, you do not provide this parameter. Amazon SageMaker
     *         will pick a time for running every day.
     *         </p>
     *         </li>
     *         </ul>
     */
    public String scheduleExpression() {
        return scheduleExpression;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleConfig)) {
            return false;
        }
        ScheduleConfig other = (ScheduleConfig) obj;
        return Objects.equals(scheduleExpression(), other.scheduleExpression());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ScheduleConfig").add("ScheduleExpression", scheduleExpression()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleConfig, T> g) {
        return obj -> g.apply((ScheduleConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduleConfig> {
        /**
         * <p>
         * A cron expression that describes details about the monitoring schedule.
         * </p>
         * <p>
         * Currently the only supported cron expressions are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you want to set the job to start every hour, please use the following:
         * </p>
         * <p>
         * <code>Hourly: cron(0 * ? * * *)</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * If you want to start the job daily:
         * </p>
         * <p>
         * <code>cron(0 [00-23] ? * * *)</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For example, the following are valid cron expressions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Daily at noon UTC: <code>cron(0 12 ? * * *)</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Daily at midnight UTC: <code>cron(0 0 ? * * *)</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * To support running every 6, 12 hours, the following are also supported:
         * </p>
         * <p>
         * <code>cron(0 [00-23]/[01-24] ? * * *)</code>
         * </p>
         * <p>
         * For example, the following are valid cron expressions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Every 12 hours, starting at 5pm UTC: <code>cron(0 17/12 ? * * *)</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Every two hours starting at midnight: <code>cron(0 0/2 ? * * *)</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <ul>
         * <li>
         * <p>
         * Even though the cron expression is set to start at 5PM UTC, note that there could be a delay of 0-20 minutes
         * from the actual requested time to run the execution.
         * </p>
         * </li>
         * <li>
         * <p>
         * We recommend that if you would like a daily schedule, you do not provide this parameter. Amazon SageMaker
         * will pick a time for running every day.
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param scheduleExpression
         *        A cron expression that describes details about the monitoring schedule.</p>
         *        <p>
         *        Currently the only supported cron expressions are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you want to set the job to start every hour, please use the following:
         *        </p>
         *        <p>
         *        <code>Hourly: cron(0 * ? * * *)</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you want to start the job daily:
         *        </p>
         *        <p>
         *        <code>cron(0 [00-23] ? * * *)</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For example, the following are valid cron expressions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Daily at noon UTC: <code>cron(0 12 ? * * *)</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Daily at midnight UTC: <code>cron(0 0 ? * * *)</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To support running every 6, 12 hours, the following are also supported:
         *        </p>
         *        <p>
         *        <code>cron(0 [00-23]/[01-24] ? * * *)</code>
         *        </p>
         *        <p>
         *        For example, the following are valid cron expressions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Every 12 hours, starting at 5pm UTC: <code>cron(0 17/12 ? * * *)</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Every two hours starting at midnight: <code>cron(0 0/2 ? * * *)</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <ul>
         *        <li>
         *        <p>
         *        Even though the cron expression is set to start at 5PM UTC, note that there could be a delay of 0-20
         *        minutes from the actual requested time to run the execution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        We recommend that if you would like a daily schedule, you do not provide this parameter. Amazon
         *        SageMaker will pick a time for running every day.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);
    }

    static final class BuilderImpl implements Builder {
        private String scheduleExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleConfig model) {
            scheduleExpression(model.scheduleExpression);
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public ScheduleConfig build() {
            return new ScheduleConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
