/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. The ARN is
 * stored as metadata in Amazon SageMaker Studio notebooks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceSpec implements SdkPojo, Serializable, ToCopyableBuilder<ResourceSpec.Builder, ResourceSpec> {
    private static final SdkField<String> SAGE_MAKER_IMAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceSpec::sageMakerImageArn)).setter(setter(Builder::sageMakerImageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SageMakerImageArn").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceSpec::instanceTypeAsString)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAGE_MAKER_IMAGE_ARN_FIELD,
            INSTANCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sageMakerImageArn;

    private final String instanceType;

    private ResourceSpec(BuilderImpl builder) {
        this.sageMakerImageArn = builder.sageMakerImageArn;
        this.instanceType = builder.instanceType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SageMaker image created on the instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SageMaker image created on the instance.
     */
    public String sageMakerImageArn() {
        return sageMakerImageArn;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link AppInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type.
     * @see AppInstanceType
     */
    public AppInstanceType instanceType() {
        return AppInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link AppInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type.
     * @see AppInstanceType
     */
    public String instanceTypeAsString() {
        return instanceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sageMakerImageArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSpec)) {
            return false;
        }
        ResourceSpec other = (ResourceSpec) obj;
        return Objects.equals(sageMakerImageArn(), other.sageMakerImageArn())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceSpec").add("SageMakerImageArn", sageMakerImageArn())
                .add("InstanceType", instanceTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SageMakerImageArn":
            return Optional.ofNullable(clazz.cast(sageMakerImageArn()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceSpec, T> g) {
        return obj -> g.apply((ResourceSpec) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceSpec> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SageMaker image created on the instance.
         * </p>
         * 
         * @param sageMakerImageArn
         *        The Amazon Resource Name (ARN) of the SageMaker image created on the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sageMakerImageArn(String sageMakerImageArn);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see AppInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @see AppInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppInstanceType
         */
        Builder instanceType(AppInstanceType instanceType);
    }

    static final class BuilderImpl implements Builder {
        private String sageMakerImageArn;

        private String instanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSpec model) {
            sageMakerImageArn(model.sageMakerImageArn);
            instanceType(model.instanceType);
        }

        public final String getSageMakerImageArn() {
            return sageMakerImageArn;
        }

        @Override
        public final Builder sageMakerImageArn(String sageMakerImageArn) {
            this.sageMakerImageArn = sageMakerImageArn;
            return this;
        }

        public final void setSageMakerImageArn(String sageMakerImageArn) {
            this.sageMakerImageArn = sageMakerImageArn;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(AppInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public ResourceSpec build() {
            return new ResourceSpec(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
