/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information about a training job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrainingJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TrainingJobSummary.Builder, TrainingJobSummary> {
    private static final SdkField<String> TRAINING_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TrainingJobSummary::trainingJobName)).setter(setter(Builder::trainingJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobName").build()).build();

    private static final SdkField<String> TRAINING_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TrainingJobSummary::trainingJobArn)).setter(setter(Builder::trainingJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TrainingJobSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> TRAINING_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TrainingJobSummary::trainingEndTime)).setter(setter(Builder::trainingEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingEndTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TrainingJobSummary::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> TRAINING_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TrainingJobSummary::trainingJobStatusAsString)).setter(setter(Builder::trainingJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_JOB_NAME_FIELD,
            TRAINING_JOB_ARN_FIELD, CREATION_TIME_FIELD, TRAINING_END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD,
            TRAINING_JOB_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String trainingJobName;

    private final String trainingJobArn;

    private final Instant creationTime;

    private final Instant trainingEndTime;

    private final Instant lastModifiedTime;

    private final String trainingJobStatus;

    private TrainingJobSummary(BuilderImpl builder) {
        this.trainingJobName = builder.trainingJobName;
        this.trainingJobArn = builder.trainingJobArn;
        this.creationTime = builder.creationTime;
        this.trainingEndTime = builder.trainingEndTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.trainingJobStatus = builder.trainingJobStatus;
    }

    /**
     * <p>
     * The name of the training job that you want a summary for.
     * </p>
     * 
     * @return The name of the training job that you want a summary for.
     */
    public String trainingJobName() {
        return trainingJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the training job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the training job.
     */
    public String trainingJobArn() {
        return trainingJobArn;
    }

    /**
     * <p>
     * A timestamp that shows when the training job was created.
     * </p>
     * 
     * @return A timestamp that shows when the training job was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * A timestamp that shows when the training job ended. This field is set only if the training job has one of the
     * terminal statuses (<code>Completed</code>, <code>Failed</code>, or <code>Stopped</code>).
     * </p>
     * 
     * @return A timestamp that shows when the training job ended. This field is set only if the training job has one of
     *         the terminal statuses (<code>Completed</code>, <code>Failed</code>, or <code>Stopped</code>).
     */
    public Instant trainingEndTime() {
        return trainingEndTime;
    }

    /**
     * <p>
     * Timestamp when the training job was last modified.
     * </p>
     * 
     * @return Timestamp when the training job was last modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The status of the training job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trainingJobStatus}
     * will return {@link TrainingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trainingJobStatusAsString}.
     * </p>
     * 
     * @return The status of the training job.
     * @see TrainingJobStatus
     */
    public TrainingJobStatus trainingJobStatus() {
        return TrainingJobStatus.fromValue(trainingJobStatus);
    }

    /**
     * <p>
     * The status of the training job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trainingJobStatus}
     * will return {@link TrainingJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trainingJobStatusAsString}.
     * </p>
     * 
     * @return The status of the training job.
     * @see TrainingJobStatus
     */
    public String trainingJobStatusAsString() {
        return trainingJobStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trainingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(trainingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainingEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainingJobStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingJobSummary)) {
            return false;
        }
        TrainingJobSummary other = (TrainingJobSummary) obj;
        return Objects.equals(trainingJobName(), other.trainingJobName())
                && Objects.equals(trainingJobArn(), other.trainingJobArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(trainingEndTime(), other.trainingEndTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(trainingJobStatusAsString(), other.trainingJobStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TrainingJobSummary").add("TrainingJobName", trainingJobName())
                .add("TrainingJobArn", trainingJobArn()).add("CreationTime", creationTime())
                .add("TrainingEndTime", trainingEndTime()).add("LastModifiedTime", lastModifiedTime())
                .add("TrainingJobStatus", trainingJobStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrainingJobName":
            return Optional.ofNullable(clazz.cast(trainingJobName()));
        case "TrainingJobArn":
            return Optional.ofNullable(clazz.cast(trainingJobArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "TrainingEndTime":
            return Optional.ofNullable(clazz.cast(trainingEndTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "TrainingJobStatus":
            return Optional.ofNullable(clazz.cast(trainingJobStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrainingJobSummary, T> g) {
        return obj -> g.apply((TrainingJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrainingJobSummary> {
        /**
         * <p>
         * The name of the training job that you want a summary for.
         * </p>
         * 
         * @param trainingJobName
         *        The name of the training job that you want a summary for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobName(String trainingJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the training job.
         * </p>
         * 
         * @param trainingJobArn
         *        The Amazon Resource Name (ARN) of the training job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobArn(String trainingJobArn);

        /**
         * <p>
         * A timestamp that shows when the training job was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp that shows when the training job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * A timestamp that shows when the training job ended. This field is set only if the training job has one of the
         * terminal statuses (<code>Completed</code>, <code>Failed</code>, or <code>Stopped</code>).
         * </p>
         * 
         * @param trainingEndTime
         *        A timestamp that shows when the training job ended. This field is set only if the training job has one
         *        of the terminal statuses (<code>Completed</code>, <code>Failed</code>, or <code>Stopped</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingEndTime(Instant trainingEndTime);

        /**
         * <p>
         * Timestamp when the training job was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        Timestamp when the training job was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The status of the training job.
         * </p>
         * 
         * @param trainingJobStatus
         *        The status of the training job.
         * @see TrainingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingJobStatus
         */
        Builder trainingJobStatus(String trainingJobStatus);

        /**
         * <p>
         * The status of the training job.
         * </p>
         * 
         * @param trainingJobStatus
         *        The status of the training job.
         * @see TrainingJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingJobStatus
         */
        Builder trainingJobStatus(TrainingJobStatus trainingJobStatus);
    }

    static final class BuilderImpl implements Builder {
        private String trainingJobName;

        private String trainingJobArn;

        private Instant creationTime;

        private Instant trainingEndTime;

        private Instant lastModifiedTime;

        private String trainingJobStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingJobSummary model) {
            trainingJobName(model.trainingJobName);
            trainingJobArn(model.trainingJobArn);
            creationTime(model.creationTime);
            trainingEndTime(model.trainingEndTime);
            lastModifiedTime(model.lastModifiedTime);
            trainingJobStatus(model.trainingJobStatus);
        }

        public final String getTrainingJobName() {
            return trainingJobName;
        }

        @Override
        public final Builder trainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
            return this;
        }

        public final void setTrainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
        }

        public final String getTrainingJobArn() {
            return trainingJobArn;
        }

        @Override
        public final Builder trainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
            return this;
        }

        public final void setTrainingJobArn(String trainingJobArn) {
            this.trainingJobArn = trainingJobArn;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getTrainingEndTime() {
            return trainingEndTime;
        }

        @Override
        public final Builder trainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
            return this;
        }

        public final void setTrainingEndTime(Instant trainingEndTime) {
            this.trainingEndTime = trainingEndTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getTrainingJobStatus() {
            return trainingJobStatus;
        }

        @Override
        public final Builder trainingJobStatus(String trainingJobStatus) {
            this.trainingJobStatus = trainingJobStatus;
            return this;
        }

        @Override
        public final Builder trainingJobStatus(TrainingJobStatus trainingJobStatus) {
            this.trainingJobStatus(trainingJobStatus == null ? null : trainingJobStatus.toString());
            return this;
        }

        public final void setTrainingJobStatus(String trainingJobStatus) {
            this.trainingJobStatus = trainingJobStatus;
        }

        @Override
        public TrainingJobSummary build() {
            return new TrainingJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
