/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateNotebookInstanceRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateNotebookInstanceRequest.Builder, UpdateNotebookInstanceRequest> {
    private static final SdkField<String> NOTEBOOK_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateNotebookInstanceRequest::notebookInstanceName)).setter(setter(Builder::notebookInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceName").build())
            .build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateNotebookInstanceRequest::instanceTypeAsString)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateNotebookInstanceRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> LIFECYCLE_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateNotebookInstanceRequest::lifecycleConfigName)).setter(setter(Builder::lifecycleConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleConfigName").build())
            .build();

    private static final SdkField<Boolean> DISASSOCIATE_LIFECYCLE_CONFIG_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateNotebookInstanceRequest::disassociateLifecycleConfig))
            .setter(setter(Builder::disassociateLifecycleConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisassociateLifecycleConfig")
                    .build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateNotebookInstanceRequest::volumeSizeInGB)).setter(setter(Builder::volumeSizeInGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInGB").build()).build();

    private static final SdkField<String> DEFAULT_CODE_REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateNotebookInstanceRequest::defaultCodeRepository)).setter(setter(Builder::defaultCodeRepository))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCodeRepository").build())
            .build();

    private static final SdkField<List<String>> ADDITIONAL_CODE_REPOSITORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UpdateNotebookInstanceRequest::additionalCodeRepositories))
            .setter(setter(Builder::additionalCodeRepositories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalCodeRepositories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ACCELERATOR_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UpdateNotebookInstanceRequest::acceleratorTypesAsStrings))
            .setter(setter(Builder::acceleratorTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DISASSOCIATE_ACCELERATOR_TYPES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateNotebookInstanceRequest::disassociateAcceleratorTypes))
            .setter(setter(Builder::disassociateAcceleratorTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisassociateAcceleratorTypes")
                    .build()).build();

    private static final SdkField<Boolean> DISASSOCIATE_DEFAULT_CODE_REPOSITORY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateNotebookInstanceRequest::disassociateDefaultCodeRepository))
            .setter(setter(Builder::disassociateDefaultCodeRepository))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisassociateDefaultCodeRepository")
                    .build()).build();

    private static final SdkField<Boolean> DISASSOCIATE_ADDITIONAL_CODE_REPOSITORIES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateNotebookInstanceRequest::disassociateAdditionalCodeRepositories))
            .setter(setter(Builder::disassociateAdditionalCodeRepositories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DisassociateAdditionalCodeRepositories").build()).build();

    private static final SdkField<String> ROOT_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateNotebookInstanceRequest::rootAccessAsString)).setter(setter(Builder::rootAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootAccess").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_INSTANCE_NAME_FIELD,
            INSTANCE_TYPE_FIELD, ROLE_ARN_FIELD, LIFECYCLE_CONFIG_NAME_FIELD, DISASSOCIATE_LIFECYCLE_CONFIG_FIELD,
            VOLUME_SIZE_IN_GB_FIELD, DEFAULT_CODE_REPOSITORY_FIELD, ADDITIONAL_CODE_REPOSITORIES_FIELD, ACCELERATOR_TYPES_FIELD,
            DISASSOCIATE_ACCELERATOR_TYPES_FIELD, DISASSOCIATE_DEFAULT_CODE_REPOSITORY_FIELD,
            DISASSOCIATE_ADDITIONAL_CODE_REPOSITORIES_FIELD, ROOT_ACCESS_FIELD));

    private final String notebookInstanceName;

    private final String instanceType;

    private final String roleArn;

    private final String lifecycleConfigName;

    private final Boolean disassociateLifecycleConfig;

    private final Integer volumeSizeInGB;

    private final String defaultCodeRepository;

    private final List<String> additionalCodeRepositories;

    private final List<String> acceleratorTypes;

    private final Boolean disassociateAcceleratorTypes;

    private final Boolean disassociateDefaultCodeRepository;

    private final Boolean disassociateAdditionalCodeRepositories;

    private final String rootAccess;

    private UpdateNotebookInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.notebookInstanceName = builder.notebookInstanceName;
        this.instanceType = builder.instanceType;
        this.roleArn = builder.roleArn;
        this.lifecycleConfigName = builder.lifecycleConfigName;
        this.disassociateLifecycleConfig = builder.disassociateLifecycleConfig;
        this.volumeSizeInGB = builder.volumeSizeInGB;
        this.defaultCodeRepository = builder.defaultCodeRepository;
        this.additionalCodeRepositories = builder.additionalCodeRepositories;
        this.acceleratorTypes = builder.acceleratorTypes;
        this.disassociateAcceleratorTypes = builder.disassociateAcceleratorTypes;
        this.disassociateDefaultCodeRepository = builder.disassociateDefaultCodeRepository;
        this.disassociateAdditionalCodeRepositories = builder.disassociateAdditionalCodeRepositories;
        this.rootAccess = builder.rootAccess;
    }

    /**
     * <p>
     * The name of the notebook instance to update.
     * </p>
     * 
     * @return The name of the notebook instance to update.
     */
    public String notebookInstanceName() {
        return notebookInstanceName;
    }

    /**
     * <p>
     * The Amazon ML compute instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The Amazon ML compute instance type.
     * @see InstanceType
     */
    public InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The Amazon ML compute instance type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The Amazon ML compute instance type.
     * @see InstanceType
     */
    public String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can assume to access the notebook instance.
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon
     * SageMaker Roles</a>.
     * </p>
     * <note>
     * <p>
     * To be able to pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code>
     * permission.
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can assume to access the notebook
     *         instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>.
     *         </p> <note>
     *         <p>
     *         To be able to pass this role to Amazon SageMaker, the caller of this API must have the
     *         <code>iam:PassRole</code> permission.
     *         </p>
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The name of a lifecycle configuration to associate with the notebook instance. For information about lifestyle
     * configurations, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step
     * 2.1: (Optional) Customize a Notebook Instance</a>.
     * </p>
     * 
     * @return The name of a lifecycle configuration to associate with the notebook instance. For information about
     *         lifestyle configurations, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1:
     *         (Optional) Customize a Notebook Instance</a>.
     */
    public String lifecycleConfigName() {
        return lifecycleConfigName;
    }

    /**
     * <p>
     * Set to <code>true</code> to remove the notebook instance lifecycle configuration currently associated with the
     * notebook instance. This operation is idempotent. If you specify a lifecycle configuration that is not associated
     * with the notebook instance when you call this method, it does not throw an error.
     * </p>
     * 
     * @return Set to <code>true</code> to remove the notebook instance lifecycle configuration currently associated
     *         with the notebook instance. This operation is idempotent. If you specify a lifecycle configuration that
     *         is not associated with the notebook instance when you call this method, it does not throw an error.
     */
    public Boolean disassociateLifecycleConfig() {
        return disassociateLifecycleConfig;
    }

    /**
     * <p>
     * The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB. ML
     * storage volumes are encrypted, so Amazon SageMaker can't determine the amount of available free space on the
     * volume. Because of this, you can increase the volume size when you update a notebook instance, but you can't
     * decrease the volume size. If you want to decrease the size of the ML storage volume in use, create a new notebook
     * instance with the desired size.
     * </p>
     * 
     * @return The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB.
     *         ML storage volumes are encrypted, so Amazon SageMaker can't determine the amount of available free space
     *         on the volume. Because of this, you can increase the volume size when you update a notebook instance, but
     *         you can't decrease the volume size. If you want to decrease the size of the ML storage volume in use,
     *         create a new notebook instance with the desired size.
     */
    public Integer volumeSizeInGB() {
        return volumeSizeInGB;
    }

    /**
     * <p>
     * The Git repository to associate with the notebook instance as its default code repository. This can be either the
     * name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other
     * Git repository. When you open a notebook instance, it opens in the directory that contains this repository. For
     * more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git
     * Repositories with Amazon SageMaker Notebook Instances</a>.
     * </p>
     * 
     * @return The Git repository to associate with the notebook instance as its default code repository. This can be
     *         either the name of a Git repository stored as a resource in your account, or the URL of a Git repository
     *         in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or
     *         in any other Git repository. When you open a notebook instance, it opens in the directory that contains
     *         this repository. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
     *         with Amazon SageMaker Notebook Instances</a>.
     */
    public String defaultCodeRepository() {
        return defaultCodeRepository;
    }

    /**
     * Returns true if the AdditionalCodeRepositories property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasAdditionalCodeRepositories() {
        return additionalCodeRepositories != null && !(additionalCodeRepositories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of up to three Git repositories to associate with the notebook instance. These can be either the names
     * of Git repositories stored as resources in your account, or the URL of Git repositories in <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any other
     * Git repository. These repositories are cloned at the same level as the default repository of your notebook
     * instance. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with Amazon
     * SageMaker Notebook Instances</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdditionalCodeRepositories()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of up to three Git repositories to associate with the notebook instance. These can be either the
     *         names of Git repositories stored as resources in your account, or the URL of Git repositories in <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any
     *         other Git repository. These repositories are cloned at the same level as the default repository of your
     *         notebook instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
     *         with Amazon SageMaker Notebook Instances</a>.
     */
    public List<String> additionalCodeRepositories() {
        return additionalCodeRepositories;
    }

    /**
     * <p>
     * A list of the Elastic Inference (EI) instance types to associate with this notebook instance. Currently only one
     * EI instance type can be associated with a notebook instance. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAcceleratorTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the Elastic Inference (EI) instance types to associate with this notebook instance. Currently
     *         only one EI instance type can be associated with a notebook instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
     *         SageMaker</a>.
     */
    public List<NotebookInstanceAcceleratorType> acceleratorTypes() {
        return NotebookInstanceAcceleratorTypesCopier.copyStringToEnum(acceleratorTypes);
    }

    /**
     * Returns true if the AcceleratorTypes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAcceleratorTypes() {
        return acceleratorTypes != null && !(acceleratorTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the Elastic Inference (EI) instance types to associate with this notebook instance. Currently only one
     * EI instance type can be associated with a notebook instance. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon SageMaker</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAcceleratorTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the Elastic Inference (EI) instance types to associate with this notebook instance. Currently
     *         only one EI instance type can be associated with a notebook instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
     *         SageMaker</a>.
     */
    public List<String> acceleratorTypesAsStrings() {
        return acceleratorTypes;
    }

    /**
     * <p>
     * A list of the Elastic Inference (EI) instance types to remove from this notebook instance. This operation is
     * idempotent. If you specify an accelerator type that is not associated with the notebook instance when you call
     * this method, it does not throw an error.
     * </p>
     * 
     * @return A list of the Elastic Inference (EI) instance types to remove from this notebook instance. This operation
     *         is idempotent. If you specify an accelerator type that is not associated with the notebook instance when
     *         you call this method, it does not throw an error.
     */
    public Boolean disassociateAcceleratorTypes() {
        return disassociateAcceleratorTypes;
    }

    /**
     * <p>
     * The name or URL of the default Git repository to remove from this notebook instance. This operation is
     * idempotent. If you specify a Git repository that is not associated with the notebook instance when you call this
     * method, it does not throw an error.
     * </p>
     * 
     * @return The name or URL of the default Git repository to remove from this notebook instance. This operation is
     *         idempotent. If you specify a Git repository that is not associated with the notebook instance when you
     *         call this method, it does not throw an error.
     */
    public Boolean disassociateDefaultCodeRepository() {
        return disassociateDefaultCodeRepository;
    }

    /**
     * <p>
     * A list of names or URLs of the default Git repositories to remove from this notebook instance. This operation is
     * idempotent. If you specify a Git repository that is not associated with the notebook instance when you call this
     * method, it does not throw an error.
     * </p>
     * 
     * @return A list of names or URLs of the default Git repositories to remove from this notebook instance. This
     *         operation is idempotent. If you specify a Git repository that is not associated with the notebook
     *         instance when you call this method, it does not throw an error.
     */
    public Boolean disassociateAdditionalCodeRepositories() {
        return disassociateAdditionalCodeRepositories;
    }

    /**
     * <p>
     * Whether root access is enabled or disabled for users of the notebook instance. The default value is
     * <code>Enabled</code>.
     * </p>
     * <note>
     * <p>
     * If you set this to <code>Disabled</code>, users don't have root access on the notebook instance, but lifecycle
     * configuration scripts still run with root permissions.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootAccess} will
     * return {@link RootAccess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rootAccessAsString}.
     * </p>
     * 
     * @return Whether root access is enabled or disabled for users of the notebook instance. The default value is
     *         <code>Enabled</code>.</p> <note>
     *         <p>
     *         If you set this to <code>Disabled</code>, users don't have root access on the notebook instance, but
     *         lifecycle configuration scripts still run with root permissions.
     *         </p>
     * @see RootAccess
     */
    public RootAccess rootAccess() {
        return RootAccess.fromValue(rootAccess);
    }

    /**
     * <p>
     * Whether root access is enabled or disabled for users of the notebook instance. The default value is
     * <code>Enabled</code>.
     * </p>
     * <note>
     * <p>
     * If you set this to <code>Disabled</code>, users don't have root access on the notebook instance, but lifecycle
     * configuration scripts still run with root permissions.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootAccess} will
     * return {@link RootAccess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rootAccessAsString}.
     * </p>
     * 
     * @return Whether root access is enabled or disabled for users of the notebook instance. The default value is
     *         <code>Enabled</code>.</p> <note>
     *         <p>
     *         If you set this to <code>Disabled</code>, users don't have root access on the notebook instance, but
     *         lifecycle configuration scripts still run with root permissions.
     *         </p>
     * @see RootAccess
     */
    public String rootAccessAsString() {
        return rootAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(disassociateLifecycleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(defaultCodeRepository());
        hashCode = 31 * hashCode + Objects.hashCode(additionalCodeRepositories());
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(disassociateAcceleratorTypes());
        hashCode = 31 * hashCode + Objects.hashCode(disassociateDefaultCodeRepository());
        hashCode = 31 * hashCode + Objects.hashCode(disassociateAdditionalCodeRepositories());
        hashCode = 31 * hashCode + Objects.hashCode(rootAccessAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNotebookInstanceRequest)) {
            return false;
        }
        UpdateNotebookInstanceRequest other = (UpdateNotebookInstanceRequest) obj;
        return Objects.equals(notebookInstanceName(), other.notebookInstanceName())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(lifecycleConfigName(), other.lifecycleConfigName())
                && Objects.equals(disassociateLifecycleConfig(), other.disassociateLifecycleConfig())
                && Objects.equals(volumeSizeInGB(), other.volumeSizeInGB())
                && Objects.equals(defaultCodeRepository(), other.defaultCodeRepository())
                && Objects.equals(additionalCodeRepositories(), other.additionalCodeRepositories())
                && Objects.equals(acceleratorTypesAsStrings(), other.acceleratorTypesAsStrings())
                && Objects.equals(disassociateAcceleratorTypes(), other.disassociateAcceleratorTypes())
                && Objects.equals(disassociateDefaultCodeRepository(), other.disassociateDefaultCodeRepository())
                && Objects.equals(disassociateAdditionalCodeRepositories(), other.disassociateAdditionalCodeRepositories())
                && Objects.equals(rootAccessAsString(), other.rootAccessAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateNotebookInstanceRequest").add("NotebookInstanceName", notebookInstanceName())
                .add("InstanceType", instanceTypeAsString()).add("RoleArn", roleArn())
                .add("LifecycleConfigName", lifecycleConfigName())
                .add("DisassociateLifecycleConfig", disassociateLifecycleConfig()).add("VolumeSizeInGB", volumeSizeInGB())
                .add("DefaultCodeRepository", defaultCodeRepository())
                .add("AdditionalCodeRepositories", additionalCodeRepositories())
                .add("AcceleratorTypes", acceleratorTypesAsStrings())
                .add("DisassociateAcceleratorTypes", disassociateAcceleratorTypes())
                .add("DisassociateDefaultCodeRepository", disassociateDefaultCodeRepository())
                .add("DisassociateAdditionalCodeRepositories", disassociateAdditionalCodeRepositories())
                .add("RootAccess", rootAccessAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotebookInstanceName":
            return Optional.ofNullable(clazz.cast(notebookInstanceName()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "LifecycleConfigName":
            return Optional.ofNullable(clazz.cast(lifecycleConfigName()));
        case "DisassociateLifecycleConfig":
            return Optional.ofNullable(clazz.cast(disassociateLifecycleConfig()));
        case "VolumeSizeInGB":
            return Optional.ofNullable(clazz.cast(volumeSizeInGB()));
        case "DefaultCodeRepository":
            return Optional.ofNullable(clazz.cast(defaultCodeRepository()));
        case "AdditionalCodeRepositories":
            return Optional.ofNullable(clazz.cast(additionalCodeRepositories()));
        case "AcceleratorTypes":
            return Optional.ofNullable(clazz.cast(acceleratorTypesAsStrings()));
        case "DisassociateAcceleratorTypes":
            return Optional.ofNullable(clazz.cast(disassociateAcceleratorTypes()));
        case "DisassociateDefaultCodeRepository":
            return Optional.ofNullable(clazz.cast(disassociateDefaultCodeRepository()));
        case "DisassociateAdditionalCodeRepositories":
            return Optional.ofNullable(clazz.cast(disassociateAdditionalCodeRepositories()));
        case "RootAccess":
            return Optional.ofNullable(clazz.cast(rootAccessAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNotebookInstanceRequest, T> g) {
        return obj -> g.apply((UpdateNotebookInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateNotebookInstanceRequest> {
        /**
         * <p>
         * The name of the notebook instance to update.
         * </p>
         * 
         * @param notebookInstanceName
         *        The name of the notebook instance to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceName(String notebookInstanceName);

        /**
         * <p>
         * The Amazon ML compute instance type.
         * </p>
         * 
         * @param instanceType
         *        The Amazon ML compute instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The Amazon ML compute instance type.
         * </p>
         * 
         * @param instanceType
         *        The Amazon ML compute instance type.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can assume to access the notebook
         * instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>.
         * </p>
         * <note>
         * <p>
         * To be able to pass this role to Amazon SageMaker, the caller of this API must have the
         * <code>iam:PassRole</code> permission.
         * </p>
         * </note>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can assume to access the notebook
         *        instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker
         *        Roles</a>. </p> <note>
         *        <p>
         *        To be able to pass this role to Amazon SageMaker, the caller of this API must have the
         *        <code>iam:PassRole</code> permission.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The name of a lifecycle configuration to associate with the notebook instance. For information about
         * lifestyle configurations, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
         * Customize a Notebook Instance</a>.
         * </p>
         * 
         * @param lifecycleConfigName
         *        The name of a lifecycle configuration to associate with the notebook instance. For information about
         *        lifestyle configurations, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1:
         *        (Optional) Customize a Notebook Instance</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleConfigName(String lifecycleConfigName);

        /**
         * <p>
         * Set to <code>true</code> to remove the notebook instance lifecycle configuration currently associated with
         * the notebook instance. This operation is idempotent. If you specify a lifecycle configuration that is not
         * associated with the notebook instance when you call this method, it does not throw an error.
         * </p>
         * 
         * @param disassociateLifecycleConfig
         *        Set to <code>true</code> to remove the notebook instance lifecycle configuration currently associated
         *        with the notebook instance. This operation is idempotent. If you specify a lifecycle configuration
         *        that is not associated with the notebook instance when you call this method, it does not throw an
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disassociateLifecycleConfig(Boolean disassociateLifecycleConfig);

        /**
         * <p>
         * The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5 GB. ML
         * storage volumes are encrypted, so Amazon SageMaker can't determine the amount of available free space on the
         * volume. Because of this, you can increase the volume size when you update a notebook instance, but you can't
         * decrease the volume size. If you want to decrease the size of the ML storage volume in use, create a new
         * notebook instance with the desired size.
         * </p>
         * 
         * @param volumeSizeInGB
         *        The size, in GB, of the ML storage volume to attach to the notebook instance. The default value is 5
         *        GB. ML storage volumes are encrypted, so Amazon SageMaker can't determine the amount of available free
         *        space on the volume. Because of this, you can increase the volume size when you update a notebook
         *        instance, but you can't decrease the volume size. If you want to decrease the size of the ML storage
         *        volume in use, create a new notebook instance with the desired size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSizeInGB(Integer volumeSizeInGB);

        /**
         * <p>
         * The Git repository to associate with the notebook instance as its default code repository. This can be either
         * the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a
         * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any
         * other Git repository. When you open a notebook instance, it opens in the directory that contains this
         * repository. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with
         * Amazon SageMaker Notebook Instances</a>.
         * </p>
         * 
         * @param defaultCodeRepository
         *        The Git repository to associate with the notebook instance as its default code repository. This can be
         *        either the name of a Git repository stored as a resource in your account, or the URL of a Git
         *        repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS
         *        CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the
         *        directory that contains this repository. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
         *        with Amazon SageMaker Notebook Instances</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCodeRepository(String defaultCodeRepository);

        /**
         * <p>
         * An array of up to three Git repositories to associate with the notebook instance. These can be either the
         * names of Git repositories stored as resources in your account, or the URL of Git repositories in <a
         * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any
         * other Git repository. These repositories are cloned at the same level as the default repository of your
         * notebook instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with
         * Amazon SageMaker Notebook Instances</a>.
         * </p>
         * 
         * @param additionalCodeRepositories
         *        An array of up to three Git repositories to associate with the notebook instance. These can be either
         *        the names of Git repositories stored as resources in your account, or the URL of Git repositories in
         *        <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or
         *        in any other Git repository. These repositories are cloned at the same level as the default repository
         *        of your notebook instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
         *        with Amazon SageMaker Notebook Instances</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalCodeRepositories(Collection<String> additionalCodeRepositories);

        /**
         * <p>
         * An array of up to three Git repositories to associate with the notebook instance. These can be either the
         * names of Git repositories stored as resources in your account, or the URL of Git repositories in <a
         * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or in any
         * other Git repository. These repositories are cloned at the same level as the default repository of your
         * notebook instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with
         * Amazon SageMaker Notebook Instances</a>.
         * </p>
         * 
         * @param additionalCodeRepositories
         *        An array of up to three Git repositories to associate with the notebook instance. These can be either
         *        the names of Git repositories stored as resources in your account, or the URL of Git repositories in
         *        <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">AWS CodeCommit</a> or
         *        in any other Git repository. These repositories are cloned at the same level as the default repository
         *        of your notebook instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
         *        with Amazon SageMaker Notebook Instances</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalCodeRepositories(String... additionalCodeRepositories);

        /**
         * <p>
         * A list of the Elastic Inference (EI) instance types to associate with this notebook instance. Currently only
         * one EI instance type can be associated with a notebook instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
         * SageMaker</a>.
         * </p>
         * 
         * @param acceleratorTypes
         *        A list of the Elastic Inference (EI) instance types to associate with this notebook instance.
         *        Currently only one EI instance type can be associated with a notebook instance. For more information,
         *        see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in
         *        Amazon SageMaker</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypesWithStrings(Collection<String> acceleratorTypes);

        /**
         * <p>
         * A list of the Elastic Inference (EI) instance types to associate with this notebook instance. Currently only
         * one EI instance type can be associated with a notebook instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
         * SageMaker</a>.
         * </p>
         * 
         * @param acceleratorTypes
         *        A list of the Elastic Inference (EI) instance types to associate with this notebook instance.
         *        Currently only one EI instance type can be associated with a notebook instance. For more information,
         *        see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in
         *        Amazon SageMaker</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypesWithStrings(String... acceleratorTypes);

        /**
         * <p>
         * A list of the Elastic Inference (EI) instance types to associate with this notebook instance. Currently only
         * one EI instance type can be associated with a notebook instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
         * SageMaker</a>.
         * </p>
         * 
         * @param acceleratorTypes
         *        A list of the Elastic Inference (EI) instance types to associate with this notebook instance.
         *        Currently only one EI instance type can be associated with a notebook instance. For more information,
         *        see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in
         *        Amazon SageMaker</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypes(Collection<NotebookInstanceAcceleratorType> acceleratorTypes);

        /**
         * <p>
         * A list of the Elastic Inference (EI) instance types to associate with this notebook instance. Currently only
         * one EI instance type can be associated with a notebook instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in Amazon
         * SageMaker</a>.
         * </p>
         * 
         * @param acceleratorTypes
         *        A list of the Elastic Inference (EI) instance types to associate with this notebook instance.
         *        Currently only one EI instance type can be associated with a notebook instance. For more information,
         *        see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/ei.html">Using Elastic Inference in
         *        Amazon SageMaker</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypes(NotebookInstanceAcceleratorType... acceleratorTypes);

        /**
         * <p>
         * A list of the Elastic Inference (EI) instance types to remove from this notebook instance. This operation is
         * idempotent. If you specify an accelerator type that is not associated with the notebook instance when you
         * call this method, it does not throw an error.
         * </p>
         * 
         * @param disassociateAcceleratorTypes
         *        A list of the Elastic Inference (EI) instance types to remove from this notebook instance. This
         *        operation is idempotent. If you specify an accelerator type that is not associated with the notebook
         *        instance when you call this method, it does not throw an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disassociateAcceleratorTypes(Boolean disassociateAcceleratorTypes);

        /**
         * <p>
         * The name or URL of the default Git repository to remove from this notebook instance. This operation is
         * idempotent. If you specify a Git repository that is not associated with the notebook instance when you call
         * this method, it does not throw an error.
         * </p>
         * 
         * @param disassociateDefaultCodeRepository
         *        The name or URL of the default Git repository to remove from this notebook instance. This operation is
         *        idempotent. If you specify a Git repository that is not associated with the notebook instance when you
         *        call this method, it does not throw an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disassociateDefaultCodeRepository(Boolean disassociateDefaultCodeRepository);

        /**
         * <p>
         * A list of names or URLs of the default Git repositories to remove from this notebook instance. This operation
         * is idempotent. If you specify a Git repository that is not associated with the notebook instance when you
         * call this method, it does not throw an error.
         * </p>
         * 
         * @param disassociateAdditionalCodeRepositories
         *        A list of names or URLs of the default Git repositories to remove from this notebook instance. This
         *        operation is idempotent. If you specify a Git repository that is not associated with the notebook
         *        instance when you call this method, it does not throw an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disassociateAdditionalCodeRepositories(Boolean disassociateAdditionalCodeRepositories);

        /**
         * <p>
         * Whether root access is enabled or disabled for users of the notebook instance. The default value is
         * <code>Enabled</code>.
         * </p>
         * <note>
         * <p>
         * If you set this to <code>Disabled</code>, users don't have root access on the notebook instance, but
         * lifecycle configuration scripts still run with root permissions.
         * </p>
         * </note>
         * 
         * @param rootAccess
         *        Whether root access is enabled or disabled for users of the notebook instance. The default value is
         *        <code>Enabled</code>.</p> <note>
         *        <p>
         *        If you set this to <code>Disabled</code>, users don't have root access on the notebook instance, but
         *        lifecycle configuration scripts still run with root permissions.
         *        </p>
         * @see RootAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootAccess
         */
        Builder rootAccess(String rootAccess);

        /**
         * <p>
         * Whether root access is enabled or disabled for users of the notebook instance. The default value is
         * <code>Enabled</code>.
         * </p>
         * <note>
         * <p>
         * If you set this to <code>Disabled</code>, users don't have root access on the notebook instance, but
         * lifecycle configuration scripts still run with root permissions.
         * </p>
         * </note>
         * 
         * @param rootAccess
         *        Whether root access is enabled or disabled for users of the notebook instance. The default value is
         *        <code>Enabled</code>.</p> <note>
         *        <p>
         *        If you set this to <code>Disabled</code>, users don't have root access on the notebook instance, but
         *        lifecycle configuration scripts still run with root permissions.
         *        </p>
         * @see RootAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootAccess
         */
        Builder rootAccess(RootAccess rootAccess);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String notebookInstanceName;

        private String instanceType;

        private String roleArn;

        private String lifecycleConfigName;

        private Boolean disassociateLifecycleConfig;

        private Integer volumeSizeInGB;

        private String defaultCodeRepository;

        private List<String> additionalCodeRepositories = DefaultSdkAutoConstructList.getInstance();

        private List<String> acceleratorTypes = DefaultSdkAutoConstructList.getInstance();

        private Boolean disassociateAcceleratorTypes;

        private Boolean disassociateDefaultCodeRepository;

        private Boolean disassociateAdditionalCodeRepositories;

        private String rootAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNotebookInstanceRequest model) {
            super(model);
            notebookInstanceName(model.notebookInstanceName);
            instanceType(model.instanceType);
            roleArn(model.roleArn);
            lifecycleConfigName(model.lifecycleConfigName);
            disassociateLifecycleConfig(model.disassociateLifecycleConfig);
            volumeSizeInGB(model.volumeSizeInGB);
            defaultCodeRepository(model.defaultCodeRepository);
            additionalCodeRepositories(model.additionalCodeRepositories);
            acceleratorTypesWithStrings(model.acceleratorTypes);
            disassociateAcceleratorTypes(model.disassociateAcceleratorTypes);
            disassociateDefaultCodeRepository(model.disassociateDefaultCodeRepository);
            disassociateAdditionalCodeRepositories(model.disassociateAdditionalCodeRepositories);
            rootAccess(model.rootAccess);
        }

        public final String getNotebookInstanceName() {
            return notebookInstanceName;
        }

        @Override
        public final Builder notebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
            return this;
        }

        public final void setNotebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getLifecycleConfigName() {
            return lifecycleConfigName;
        }

        @Override
        public final Builder lifecycleConfigName(String lifecycleConfigName) {
            this.lifecycleConfigName = lifecycleConfigName;
            return this;
        }

        public final void setLifecycleConfigName(String lifecycleConfigName) {
            this.lifecycleConfigName = lifecycleConfigName;
        }

        public final Boolean getDisassociateLifecycleConfig() {
            return disassociateLifecycleConfig;
        }

        @Override
        public final Builder disassociateLifecycleConfig(Boolean disassociateLifecycleConfig) {
            this.disassociateLifecycleConfig = disassociateLifecycleConfig;
            return this;
        }

        public final void setDisassociateLifecycleConfig(Boolean disassociateLifecycleConfig) {
            this.disassociateLifecycleConfig = disassociateLifecycleConfig;
        }

        public final Integer getVolumeSizeInGB() {
            return volumeSizeInGB;
        }

        @Override
        public final Builder volumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
            return this;
        }

        public final void setVolumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
        }

        public final String getDefaultCodeRepository() {
            return defaultCodeRepository;
        }

        @Override
        public final Builder defaultCodeRepository(String defaultCodeRepository) {
            this.defaultCodeRepository = defaultCodeRepository;
            return this;
        }

        public final void setDefaultCodeRepository(String defaultCodeRepository) {
            this.defaultCodeRepository = defaultCodeRepository;
        }

        public final Collection<String> getAdditionalCodeRepositories() {
            return additionalCodeRepositories;
        }

        @Override
        public final Builder additionalCodeRepositories(Collection<String> additionalCodeRepositories) {
            this.additionalCodeRepositories = AdditionalCodeRepositoryNamesOrUrlsCopier.copy(additionalCodeRepositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalCodeRepositories(String... additionalCodeRepositories) {
            additionalCodeRepositories(Arrays.asList(additionalCodeRepositories));
            return this;
        }

        public final void setAdditionalCodeRepositories(Collection<String> additionalCodeRepositories) {
            this.additionalCodeRepositories = AdditionalCodeRepositoryNamesOrUrlsCopier.copy(additionalCodeRepositories);
        }

        public final Collection<String> getAcceleratorTypes() {
            return acceleratorTypes;
        }

        @Override
        public final Builder acceleratorTypesWithStrings(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copy(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypesWithStrings(String... acceleratorTypes) {
            acceleratorTypesWithStrings(Arrays.asList(acceleratorTypes));
            return this;
        }

        @Override
        public final Builder acceleratorTypes(Collection<NotebookInstanceAcceleratorType> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copyEnumToString(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypes(NotebookInstanceAcceleratorType... acceleratorTypes) {
            acceleratorTypes(Arrays.asList(acceleratorTypes));
            return this;
        }

        public final void setAcceleratorTypes(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copy(acceleratorTypes);
        }

        public final Boolean getDisassociateAcceleratorTypes() {
            return disassociateAcceleratorTypes;
        }

        @Override
        public final Builder disassociateAcceleratorTypes(Boolean disassociateAcceleratorTypes) {
            this.disassociateAcceleratorTypes = disassociateAcceleratorTypes;
            return this;
        }

        public final void setDisassociateAcceleratorTypes(Boolean disassociateAcceleratorTypes) {
            this.disassociateAcceleratorTypes = disassociateAcceleratorTypes;
        }

        public final Boolean getDisassociateDefaultCodeRepository() {
            return disassociateDefaultCodeRepository;
        }

        @Override
        public final Builder disassociateDefaultCodeRepository(Boolean disassociateDefaultCodeRepository) {
            this.disassociateDefaultCodeRepository = disassociateDefaultCodeRepository;
            return this;
        }

        public final void setDisassociateDefaultCodeRepository(Boolean disassociateDefaultCodeRepository) {
            this.disassociateDefaultCodeRepository = disassociateDefaultCodeRepository;
        }

        public final Boolean getDisassociateAdditionalCodeRepositories() {
            return disassociateAdditionalCodeRepositories;
        }

        @Override
        public final Builder disassociateAdditionalCodeRepositories(Boolean disassociateAdditionalCodeRepositories) {
            this.disassociateAdditionalCodeRepositories = disassociateAdditionalCodeRepositories;
            return this;
        }

        public final void setDisassociateAdditionalCodeRepositories(Boolean disassociateAdditionalCodeRepositories) {
            this.disassociateAdditionalCodeRepositories = disassociateAdditionalCodeRepositories;
        }

        public final String getRootAccess() {
            return rootAccess;
        }

        @Override
        public final Builder rootAccess(String rootAccess) {
            this.rootAccess = rootAccess;
            return this;
        }

        @Override
        public final Builder rootAccess(RootAccess rootAccess) {
            this.rootAccess(rootAccess == null ? null : rootAccess.toString());
            return this;
        }

        public final void setRootAccess(String rootAccess) {
            this.rootAccess = rootAccess;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNotebookInstanceRequest build() {
            return new UpdateNotebookInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
