/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Operator {
    EQUALS("Equals"),
    NOT_EQUALS("NotEquals"),
    GREATER_THAN("GreaterThan"),
    GREATER_THAN_OR_EQUAL_TO("GreaterThanOrEqualTo"),
    LESS_THAN("LessThan"),
    LESS_THAN_OR_EQUAL_TO("LessThanOrEqualTo"),
    CONTAINS("Contains"),
    EXISTS("Exists"),
    NOT_EXISTS("NotExists"),
    IN("In"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Operator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Operator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Operator.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Operator> knownValues() {
        return Stream.of(Operator.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

