/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about where and how you want to obtain the inputs for an processing job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProcessingS3Input implements SdkPojo, Serializable,
        ToCopyableBuilder<ProcessingS3Input.Builder, ProcessingS3Input> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProcessingS3Input::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final SdkField<String> LOCAL_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProcessingS3Input::localPath)).setter(setter(Builder::localPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPath").build()).build();

    private static final SdkField<String> S3_DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProcessingS3Input::s3DataTypeAsString)).setter(setter(Builder::s3DataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataType").build()).build();

    private static final SdkField<String> S3_INPUT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProcessingS3Input::s3InputModeAsString)).setter(setter(Builder::s3InputMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3InputMode").build()).build();

    private static final SdkField<String> S3_DATA_DISTRIBUTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProcessingS3Input::s3DataDistributionTypeAsString)).setter(setter(Builder::s3DataDistributionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataDistributionType").build())
            .build();

    private static final SdkField<String> S3_COMPRESSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ProcessingS3Input::s3CompressionTypeAsString)).setter(setter(Builder::s3CompressionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3CompressionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(S3_URI_FIELD, LOCAL_PATH_FIELD, S3_DATA_TYPE_FIELD, S3_INPUT_MODE_FIELD, S3_DATA_DISTRIBUTION_TYPE_FIELD,
                    S3_COMPRESSION_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3Uri;

    private final String localPath;

    private final String s3DataType;

    private final String s3InputMode;

    private final String s3DataDistributionType;

    private final String s3CompressionType;

    private ProcessingS3Input(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.localPath = builder.localPath;
        this.s3DataType = builder.s3DataType;
        this.s3InputMode = builder.s3InputMode;
        this.s3DataDistributionType = builder.s3DataDistributionType;
        this.s3CompressionType = builder.s3CompressionType;
    }

    /**
     * <p>
     * The URI for the Amazon S3 storage where you want Amazon SageMaker to download the artifacts needed to run a
     * processing job.
     * </p>
     * 
     * @return The URI for the Amazon S3 storage where you want Amazon SageMaker to download the artifacts needed to run
     *         a processing job.
     */
    public String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * The local path to the Amazon S3 bucket where you want Amazon SageMaker to download the inputs to run a processing
     * job. <code>LocalPath</code> is an absolute path to the input data.
     * </p>
     * 
     * @return The local path to the Amazon S3 bucket where you want Amazon SageMaker to download the inputs to run a
     *         processing job. <code>LocalPath</code> is an absolute path to the input data.
     */
    public String localPath() {
        return localPath;
    }

    /**
     * <p>
     * Whether you use an <code>S3Prefix</code> or a <code>ManifestFile</code> for the data type. If you choose
     * <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses all objects with
     * the specified key name prefix for the processing job. If you choose <code>ManifestFile</code>, <code>S3Uri</code>
     * identifies an object that is a manifest file containing a list of object keys that you want Amazon SageMaker to
     * use for the processing job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3DataType} will
     * return {@link ProcessingS3DataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3DataTypeAsString}.
     * </p>
     * 
     * @return Whether you use an <code>S3Prefix</code> or a <code>ManifestFile</code> for the data type. If you choose
     *         <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses all objects
     *         with the specified key name prefix for the processing job. If you choose <code>ManifestFile</code>,
     *         <code>S3Uri</code> identifies an object that is a manifest file containing a list of object keys that you
     *         want Amazon SageMaker to use for the processing job.
     * @see ProcessingS3DataType
     */
    public ProcessingS3DataType s3DataType() {
        return ProcessingS3DataType.fromValue(s3DataType);
    }

    /**
     * <p>
     * Whether you use an <code>S3Prefix</code> or a <code>ManifestFile</code> for the data type. If you choose
     * <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses all objects with
     * the specified key name prefix for the processing job. If you choose <code>ManifestFile</code>, <code>S3Uri</code>
     * identifies an object that is a manifest file containing a list of object keys that you want Amazon SageMaker to
     * use for the processing job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3DataType} will
     * return {@link ProcessingS3DataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3DataTypeAsString}.
     * </p>
     * 
     * @return Whether you use an <code>S3Prefix</code> or a <code>ManifestFile</code> for the data type. If you choose
     *         <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses all objects
     *         with the specified key name prefix for the processing job. If you choose <code>ManifestFile</code>,
     *         <code>S3Uri</code> identifies an object that is a manifest file containing a list of object keys that you
     *         want Amazon SageMaker to use for the processing job.
     * @see ProcessingS3DataType
     */
    public String s3DataTypeAsString() {
        return s3DataType;
    }

    /**
     * <p>
     * Whether to use <code>File</code> or <code>Pipe</code> input mode. In <code>File</code> mode, Amazon SageMaker
     * copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS) volumes before
     * starting your training algorithm. This is the most commonly used input mode. In <code>Pipe</code> mode, Amazon
     * SageMaker streams input data from the source directly to your algorithm without using the EBS volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3InputMode} will
     * return {@link ProcessingS3InputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3InputModeAsString}.
     * </p>
     * 
     * @return Whether to use <code>File</code> or <code>Pipe</code> input mode. In <code>File</code> mode, Amazon
     *         SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS)
     *         volumes before starting your training algorithm. This is the most commonly used input mode. In
     *         <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your algorithm
     *         without using the EBS volume.
     * @see ProcessingS3InputMode
     */
    public ProcessingS3InputMode s3InputMode() {
        return ProcessingS3InputMode.fromValue(s3InputMode);
    }

    /**
     * <p>
     * Whether to use <code>File</code> or <code>Pipe</code> input mode. In <code>File</code> mode, Amazon SageMaker
     * copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS) volumes before
     * starting your training algorithm. This is the most commonly used input mode. In <code>Pipe</code> mode, Amazon
     * SageMaker streams input data from the source directly to your algorithm without using the EBS volume.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3InputMode} will
     * return {@link ProcessingS3InputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3InputModeAsString}.
     * </p>
     * 
     * @return Whether to use <code>File</code> or <code>Pipe</code> input mode. In <code>File</code> mode, Amazon
     *         SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS)
     *         volumes before starting your training algorithm. This is the most commonly used input mode. In
     *         <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your algorithm
     *         without using the EBS volume.
     * @see ProcessingS3InputMode
     */
    public String s3InputModeAsString() {
        return s3InputMode;
    }

    /**
     * <p>
     * Whether the data stored in Amazon S3 is <code>FullyReplicated</code> or <code>ShardedByS3Key</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #s3DataDistributionType} will return {@link ProcessingS3DataDistributionType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #s3DataDistributionTypeAsString}.
     * </p>
     * 
     * @return Whether the data stored in Amazon S3 is <code>FullyReplicated</code> or <code>ShardedByS3Key</code>.
     * @see ProcessingS3DataDistributionType
     */
    public ProcessingS3DataDistributionType s3DataDistributionType() {
        return ProcessingS3DataDistributionType.fromValue(s3DataDistributionType);
    }

    /**
     * <p>
     * Whether the data stored in Amazon S3 is <code>FullyReplicated</code> or <code>ShardedByS3Key</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #s3DataDistributionType} will return {@link ProcessingS3DataDistributionType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #s3DataDistributionTypeAsString}.
     * </p>
     * 
     * @return Whether the data stored in Amazon S3 is <code>FullyReplicated</code> or <code>ShardedByS3Key</code>.
     * @see ProcessingS3DataDistributionType
     */
    public String s3DataDistributionTypeAsString() {
        return s3DataDistributionType;
    }

    /**
     * <p>
     * Whether to use <code>Gzip</code> compression for Amazon S3 storage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3CompressionType}
     * will return {@link ProcessingS3CompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #s3CompressionTypeAsString}.
     * </p>
     * 
     * @return Whether to use <code>Gzip</code> compression for Amazon S3 storage.
     * @see ProcessingS3CompressionType
     */
    public ProcessingS3CompressionType s3CompressionType() {
        return ProcessingS3CompressionType.fromValue(s3CompressionType);
    }

    /**
     * <p>
     * Whether to use <code>Gzip</code> compression for Amazon S3 storage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3CompressionType}
     * will return {@link ProcessingS3CompressionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #s3CompressionTypeAsString}.
     * </p>
     * 
     * @return Whether to use <code>Gzip</code> compression for Amazon S3 storage.
     * @see ProcessingS3CompressionType
     */
    public String s3CompressionTypeAsString() {
        return s3CompressionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(localPath());
        hashCode = 31 * hashCode + Objects.hashCode(s3DataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3InputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3DataDistributionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3CompressionTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessingS3Input)) {
            return false;
        }
        ProcessingS3Input other = (ProcessingS3Input) obj;
        return Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(localPath(), other.localPath())
                && Objects.equals(s3DataTypeAsString(), other.s3DataTypeAsString())
                && Objects.equals(s3InputModeAsString(), other.s3InputModeAsString())
                && Objects.equals(s3DataDistributionTypeAsString(), other.s3DataDistributionTypeAsString())
                && Objects.equals(s3CompressionTypeAsString(), other.s3CompressionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProcessingS3Input").add("S3Uri", s3Uri()).add("LocalPath", localPath())
                .add("S3DataType", s3DataTypeAsString()).add("S3InputMode", s3InputModeAsString())
                .add("S3DataDistributionType", s3DataDistributionTypeAsString())
                .add("S3CompressionType", s3CompressionTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "LocalPath":
            return Optional.ofNullable(clazz.cast(localPath()));
        case "S3DataType":
            return Optional.ofNullable(clazz.cast(s3DataTypeAsString()));
        case "S3InputMode":
            return Optional.ofNullable(clazz.cast(s3InputModeAsString()));
        case "S3DataDistributionType":
            return Optional.ofNullable(clazz.cast(s3DataDistributionTypeAsString()));
        case "S3CompressionType":
            return Optional.ofNullable(clazz.cast(s3CompressionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProcessingS3Input, T> g) {
        return obj -> g.apply((ProcessingS3Input) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProcessingS3Input> {
        /**
         * <p>
         * The URI for the Amazon S3 storage where you want Amazon SageMaker to download the artifacts needed to run a
         * processing job.
         * </p>
         * 
         * @param s3Uri
         *        The URI for the Amazon S3 storage where you want Amazon SageMaker to download the artifacts needed to
         *        run a processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * The local path to the Amazon S3 bucket where you want Amazon SageMaker to download the inputs to run a
         * processing job. <code>LocalPath</code> is an absolute path to the input data.
         * </p>
         * 
         * @param localPath
         *        The local path to the Amazon S3 bucket where you want Amazon SageMaker to download the inputs to run a
         *        processing job. <code>LocalPath</code> is an absolute path to the input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localPath(String localPath);

        /**
         * <p>
         * Whether you use an <code>S3Prefix</code> or a <code>ManifestFile</code> for the data type. If you choose
         * <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses all objects
         * with the specified key name prefix for the processing job. If you choose <code>ManifestFile</code>,
         * <code>S3Uri</code> identifies an object that is a manifest file containing a list of object keys that you
         * want Amazon SageMaker to use for the processing job.
         * </p>
         * 
         * @param s3DataType
         *        Whether you use an <code>S3Prefix</code> or a <code>ManifestFile</code> for the data type. If you
         *        choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses
         *        all objects with the specified key name prefix for the processing job. If you choose
         *        <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that is a manifest file containing
         *        a list of object keys that you want Amazon SageMaker to use for the processing job.
         * @see ProcessingS3DataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingS3DataType
         */
        Builder s3DataType(String s3DataType);

        /**
         * <p>
         * Whether you use an <code>S3Prefix</code> or a <code>ManifestFile</code> for the data type. If you choose
         * <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses all objects
         * with the specified key name prefix for the processing job. If you choose <code>ManifestFile</code>,
         * <code>S3Uri</code> identifies an object that is a manifest file containing a list of object keys that you
         * want Amazon SageMaker to use for the processing job.
         * </p>
         * 
         * @param s3DataType
         *        Whether you use an <code>S3Prefix</code> or a <code>ManifestFile</code> for the data type. If you
         *        choose <code>S3Prefix</code>, <code>S3Uri</code> identifies a key name prefix. Amazon SageMaker uses
         *        all objects with the specified key name prefix for the processing job. If you choose
         *        <code>ManifestFile</code>, <code>S3Uri</code> identifies an object that is a manifest file containing
         *        a list of object keys that you want Amazon SageMaker to use for the processing job.
         * @see ProcessingS3DataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingS3DataType
         */
        Builder s3DataType(ProcessingS3DataType s3DataType);

        /**
         * <p>
         * Whether to use <code>File</code> or <code>Pipe</code> input mode. In <code>File</code> mode, Amazon SageMaker
         * copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS) volumes before
         * starting your training algorithm. This is the most commonly used input mode. In <code>Pipe</code> mode,
         * Amazon SageMaker streams input data from the source directly to your algorithm without using the EBS volume.
         * </p>
         * 
         * @param s3InputMode
         *        Whether to use <code>File</code> or <code>Pipe</code> input mode. In <code>File</code> mode, Amazon
         *        SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS)
         *        volumes before starting your training algorithm. This is the most commonly used input mode. In
         *        <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your algorithm
         *        without using the EBS volume.
         * @see ProcessingS3InputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingS3InputMode
         */
        Builder s3InputMode(String s3InputMode);

        /**
         * <p>
         * Whether to use <code>File</code> or <code>Pipe</code> input mode. In <code>File</code> mode, Amazon SageMaker
         * copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS) volumes before
         * starting your training algorithm. This is the most commonly used input mode. In <code>Pipe</code> mode,
         * Amazon SageMaker streams input data from the source directly to your algorithm without using the EBS volume.
         * </p>
         * 
         * @param s3InputMode
         *        Whether to use <code>File</code> or <code>Pipe</code> input mode. In <code>File</code> mode, Amazon
         *        SageMaker copies the data from the input source onto the local Amazon Elastic Block Store (Amazon EBS)
         *        volumes before starting your training algorithm. This is the most commonly used input mode. In
         *        <code>Pipe</code> mode, Amazon SageMaker streams input data from the source directly to your algorithm
         *        without using the EBS volume.
         * @see ProcessingS3InputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingS3InputMode
         */
        Builder s3InputMode(ProcessingS3InputMode s3InputMode);

        /**
         * <p>
         * Whether the data stored in Amazon S3 is <code>FullyReplicated</code> or <code>ShardedByS3Key</code>.
         * </p>
         * 
         * @param s3DataDistributionType
         *        Whether the data stored in Amazon S3 is <code>FullyReplicated</code> or <code>ShardedByS3Key</code>.
         * @see ProcessingS3DataDistributionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingS3DataDistributionType
         */
        Builder s3DataDistributionType(String s3DataDistributionType);

        /**
         * <p>
         * Whether the data stored in Amazon S3 is <code>FullyReplicated</code> or <code>ShardedByS3Key</code>.
         * </p>
         * 
         * @param s3DataDistributionType
         *        Whether the data stored in Amazon S3 is <code>FullyReplicated</code> or <code>ShardedByS3Key</code>.
         * @see ProcessingS3DataDistributionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingS3DataDistributionType
         */
        Builder s3DataDistributionType(ProcessingS3DataDistributionType s3DataDistributionType);

        /**
         * <p>
         * Whether to use <code>Gzip</code> compression for Amazon S3 storage.
         * </p>
         * 
         * @param s3CompressionType
         *        Whether to use <code>Gzip</code> compression for Amazon S3 storage.
         * @see ProcessingS3CompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingS3CompressionType
         */
        Builder s3CompressionType(String s3CompressionType);

        /**
         * <p>
         * Whether to use <code>Gzip</code> compression for Amazon S3 storage.
         * </p>
         * 
         * @param s3CompressionType
         *        Whether to use <code>Gzip</code> compression for Amazon S3 storage.
         * @see ProcessingS3CompressionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingS3CompressionType
         */
        Builder s3CompressionType(ProcessingS3CompressionType s3CompressionType);
    }

    static final class BuilderImpl implements Builder {
        private String s3Uri;

        private String localPath;

        private String s3DataType;

        private String s3InputMode;

        private String s3DataDistributionType;

        private String s3CompressionType;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessingS3Input model) {
            s3Uri(model.s3Uri);
            localPath(model.localPath);
            s3DataType(model.s3DataType);
            s3InputMode(model.s3InputMode);
            s3DataDistributionType(model.s3DataDistributionType);
            s3CompressionType(model.s3CompressionType);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        public final String getLocalPath() {
            return localPath;
        }

        @Override
        public final Builder localPath(String localPath) {
            this.localPath = localPath;
            return this;
        }

        public final void setLocalPath(String localPath) {
            this.localPath = localPath;
        }

        public final String getS3DataType() {
            return s3DataType;
        }

        @Override
        public final Builder s3DataType(String s3DataType) {
            this.s3DataType = s3DataType;
            return this;
        }

        @Override
        public final Builder s3DataType(ProcessingS3DataType s3DataType) {
            this.s3DataType(s3DataType == null ? null : s3DataType.toString());
            return this;
        }

        public final void setS3DataType(String s3DataType) {
            this.s3DataType = s3DataType;
        }

        public final String getS3InputMode() {
            return s3InputMode;
        }

        @Override
        public final Builder s3InputMode(String s3InputMode) {
            this.s3InputMode = s3InputMode;
            return this;
        }

        @Override
        public final Builder s3InputMode(ProcessingS3InputMode s3InputMode) {
            this.s3InputMode(s3InputMode == null ? null : s3InputMode.toString());
            return this;
        }

        public final void setS3InputMode(String s3InputMode) {
            this.s3InputMode = s3InputMode;
        }

        public final String getS3DataDistributionType() {
            return s3DataDistributionType;
        }

        @Override
        public final Builder s3DataDistributionType(String s3DataDistributionType) {
            this.s3DataDistributionType = s3DataDistributionType;
            return this;
        }

        @Override
        public final Builder s3DataDistributionType(ProcessingS3DataDistributionType s3DataDistributionType) {
            this.s3DataDistributionType(s3DataDistributionType == null ? null : s3DataDistributionType.toString());
            return this;
        }

        public final void setS3DataDistributionType(String s3DataDistributionType) {
            this.s3DataDistributionType = s3DataDistributionType;
        }

        public final String getS3CompressionType() {
            return s3CompressionType;
        }

        @Override
        public final Builder s3CompressionType(String s3CompressionType) {
            this.s3CompressionType = s3CompressionType;
            return this;
        }

        @Override
        public final Builder s3CompressionType(ProcessingS3CompressionType s3CompressionType) {
            this.s3CompressionType(s3CompressionType == null ? null : s3CompressionType.toString());
            return this;
        }

        public final void setS3CompressionType(String s3CompressionType) {
            this.s3CompressionType = s3CompressionType;
        }

        @Override
        public ProcessingS3Input build() {
            return new ProcessingS3Input(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
