/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ProcessingS3DataDistributionType;
import software.amazon.awssdk.services.sagemaker.model.ProcessingS3InputMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointInput> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EndpointInput.getter(EndpointInput::endpointName)).setter(EndpointInput.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<String> LOCAL_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EndpointInput.getter(EndpointInput::localPath)).setter(EndpointInput.setter(Builder::localPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPath").build()}).build();
    private static final SdkField<String> S3_INPUT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EndpointInput.getter(EndpointInput::s3InputModeAsString)).setter(EndpointInput.setter(Builder::s3InputMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3InputMode").build()}).build();
    private static final SdkField<String> S3_DATA_DISTRIBUTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EndpointInput.getter(EndpointInput::s3DataDistributionTypeAsString)).setter(EndpointInput.setter(Builder::s3DataDistributionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataDistributionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD, LOCAL_PATH_FIELD, S3_INPUT_MODE_FIELD, S3_DATA_DISTRIBUTION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String endpointName;
    private final String localPath;
    private final String s3InputMode;
    private final String s3DataDistributionType;

    private EndpointInput(BuilderImpl builder) {
        this.endpointName = builder.endpointName;
        this.localPath = builder.localPath;
        this.s3InputMode = builder.s3InputMode;
        this.s3DataDistributionType = builder.s3DataDistributionType;
    }

    public String endpointName() {
        return this.endpointName;
    }

    public String localPath() {
        return this.localPath;
    }

    public ProcessingS3InputMode s3InputMode() {
        return ProcessingS3InputMode.fromValue(this.s3InputMode);
    }

    public String s3InputModeAsString() {
        return this.s3InputMode;
    }

    public ProcessingS3DataDistributionType s3DataDistributionType() {
        return ProcessingS3DataDistributionType.fromValue(this.s3DataDistributionType);
    }

    public String s3DataDistributionTypeAsString() {
        return this.s3DataDistributionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.localPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3InputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DataDistributionTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointInput)) {
            return false;
        }
        EndpointInput other = (EndpointInput)obj;
        return Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.localPath(), other.localPath()) && Objects.equals(this.s3InputModeAsString(), other.s3InputModeAsString()) && Objects.equals(this.s3DataDistributionTypeAsString(), other.s3DataDistributionTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"EndpointInput").add("EndpointName", (Object)this.endpointName()).add("LocalPath", (Object)this.localPath()).add("S3InputMode", (Object)this.s3InputModeAsString()).add("S3DataDistributionType", (Object)this.s3DataDistributionTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "LocalPath": {
                return Optional.ofNullable(clazz.cast(this.localPath()));
            }
            case "S3InputMode": {
                return Optional.ofNullable(clazz.cast(this.s3InputModeAsString()));
            }
            case "S3DataDistributionType": {
                return Optional.ofNullable(clazz.cast(this.s3DataDistributionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EndpointInput, T> g) {
        return obj -> g.apply((EndpointInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointName;
        private String localPath;
        private String s3InputMode;
        private String s3DataDistributionType;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointInput model) {
            this.endpointName(model.endpointName);
            this.localPath(model.localPath);
            this.s3InputMode(model.s3InputMode);
            this.s3DataDistributionType(model.s3DataDistributionType);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final String getLocalPath() {
            return this.localPath;
        }

        @Override
        public final Builder localPath(String localPath) {
            this.localPath = localPath;
            return this;
        }

        public final void setLocalPath(String localPath) {
            this.localPath = localPath;
        }

        public final String getS3InputMode() {
            return this.s3InputMode;
        }

        @Override
        public final Builder s3InputMode(String s3InputMode) {
            this.s3InputMode = s3InputMode;
            return this;
        }

        @Override
        public final Builder s3InputMode(ProcessingS3InputMode s3InputMode) {
            this.s3InputMode(s3InputMode == null ? null : s3InputMode.toString());
            return this;
        }

        public final void setS3InputMode(String s3InputMode) {
            this.s3InputMode = s3InputMode;
        }

        public final String getS3DataDistributionType() {
            return this.s3DataDistributionType;
        }

        @Override
        public final Builder s3DataDistributionType(String s3DataDistributionType) {
            this.s3DataDistributionType = s3DataDistributionType;
            return this;
        }

        @Override
        public final Builder s3DataDistributionType(ProcessingS3DataDistributionType s3DataDistributionType) {
            this.s3DataDistributionType(s3DataDistributionType == null ? null : s3DataDistributionType.toString());
            return this;
        }

        public final void setS3DataDistributionType(String s3DataDistributionType) {
            this.s3DataDistributionType = s3DataDistributionType;
        }

        public EndpointInput build() {
            return new EndpointInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointInput> {
        public Builder endpointName(String var1);

        public Builder localPath(String var1);

        public Builder s3InputMode(String var1);

        public Builder s3InputMode(ProcessingS3InputMode var1);

        public Builder s3DataDistributionType(String var1);

        public Builder s3DataDistributionType(ProcessingS3DataDistributionType var1);
    }
}

