/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrialComponentRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateTrialComponentRequest.Builder, CreateTrialComponentRequest> {
    private static final SdkField<String> TRIAL_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTrialComponentRequest::trialComponentName)).setter(setter(Builder::trialComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentName").build())
            .build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTrialComponentRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<TrialComponentStatus> STATUS_FIELD = SdkField
            .<TrialComponentStatus> builder(MarshallingType.SDK_POJO).getter(getter(CreateTrialComponentRequest::status))
            .setter(setter(Builder::status)).constructor(TrialComponentStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CreateTrialComponentRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(CreateTrialComponentRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Map<String, TrialComponentParameterValue>> PARAMETERS_FIELD = SdkField
            .<Map<String, TrialComponentParameterValue>> builder(MarshallingType.MAP)
            .getter(getter(CreateTrialComponentRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TrialComponentParameterValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrialComponentParameterValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, TrialComponentArtifact>> INPUT_ARTIFACTS_FIELD = SdkField
            .<Map<String, TrialComponentArtifact>> builder(MarshallingType.MAP)
            .getter(getter(CreateTrialComponentRequest::inputArtifacts))
            .setter(setter(Builder::inputArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputArtifacts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TrialComponentArtifact> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrialComponentArtifact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, TrialComponentArtifact>> OUTPUT_ARTIFACTS_FIELD = SdkField
            .<Map<String, TrialComponentArtifact>> builder(MarshallingType.MAP)
            .getter(getter(CreateTrialComponentRequest::outputArtifacts))
            .setter(setter(Builder::outputArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputArtifacts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TrialComponentArtifact> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrialComponentArtifact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateTrialComponentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_COMPONENT_NAME_FIELD,
            DISPLAY_NAME_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, PARAMETERS_FIELD, INPUT_ARTIFACTS_FIELD,
            OUTPUT_ARTIFACTS_FIELD, TAGS_FIELD));

    private final String trialComponentName;

    private final String displayName;

    private final TrialComponentStatus status;

    private final Instant startTime;

    private final Instant endTime;

    private final Map<String, TrialComponentParameterValue> parameters;

    private final Map<String, TrialComponentArtifact> inputArtifacts;

    private final Map<String, TrialComponentArtifact> outputArtifacts;

    private final List<Tag> tags;

    private CreateTrialComponentRequest(BuilderImpl builder) {
        super(builder);
        this.trialComponentName = builder.trialComponentName;
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.parameters = builder.parameters;
        this.inputArtifacts = builder.inputArtifacts;
        this.outputArtifacts = builder.outputArtifacts;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the component. The name must be unique in your AWS account and is not case-sensitive.
     * </p>
     * 
     * @return The name of the component. The name must be unique in your AWS account and is not case-sensitive.
     */
    public String trialComponentName() {
        return trialComponentName;
    }

    /**
     * <p>
     * The name of the component as displayed. The name doesn't need to be unique. If <code>DisplayName</code> isn't
     * specified, <code>TrialComponentName</code> is displayed.
     * </p>
     * 
     * @return The name of the component as displayed. The name doesn't need to be unique. If <code>DisplayName</code>
     *         isn't specified, <code>TrialComponentName</code> is displayed.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The status of the component. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * InProgress
     * </p>
     * </li>
     * <li>
     * <p>
     * Completed
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the component. States include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         InProgress
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Completed
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed
     *         </p>
     *         </li>
     */
    public TrialComponentStatus status() {
        return status;
    }

    /**
     * <p>
     * When the component started.
     * </p>
     * 
     * @return When the component started.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * When the component ended.
     * </p>
     * 
     * @return When the component ended.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The hyperparameters for the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The hyperparameters for the component.
     */
    public Map<String, TrialComponentParameterValue> parameters() {
        return parameters;
    }

    /**
     * Returns true if the InputArtifacts property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasInputArtifacts() {
        return inputArtifacts != null && !(inputArtifacts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The input artifacts for the component. Examples of input artifacts are datasets, algorithms, hyperparameters,
     * source code, and instance types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputArtifacts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The input artifacts for the component. Examples of input artifacts are datasets, algorithms,
     *         hyperparameters, source code, and instance types.
     */
    public Map<String, TrialComponentArtifact> inputArtifacts() {
        return inputArtifacts;
    }

    /**
     * Returns true if the OutputArtifacts property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasOutputArtifacts() {
        return outputArtifacts != null && !(outputArtifacts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The output artifacts for the component. Examples of output artifacts are metrics, snapshots, logs, and images.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOutputArtifacts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The output artifacts for the component. Examples of output artifacts are metrics, snapshots, logs, and
     *         images.
     */
    public Map<String, TrialComponentArtifact> outputArtifacts() {
        return outputArtifacts;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to associate with the component. You can use <a>Search</a> API to search on the tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tags to associate with the component. You can use <a>Search</a> API to search on the tags.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trialComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(inputArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(outputArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrialComponentRequest)) {
            return false;
        }
        CreateTrialComponentRequest other = (CreateTrialComponentRequest) obj;
        return Objects.equals(trialComponentName(), other.trialComponentName())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(status(), other.status())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(inputArtifacts(), other.inputArtifacts())
                && Objects.equals(outputArtifacts(), other.outputArtifacts()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateTrialComponentRequest").add("TrialComponentName", trialComponentName())
                .add("DisplayName", displayName()).add("Status", status()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("Parameters", parameters()).add("InputArtifacts", inputArtifacts())
                .add("OutputArtifacts", outputArtifacts()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrialComponentName":
            return Optional.ofNullable(clazz.cast(trialComponentName()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "InputArtifacts":
            return Optional.ofNullable(clazz.cast(inputArtifacts()));
        case "OutputArtifacts":
            return Optional.ofNullable(clazz.cast(outputArtifacts()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrialComponentRequest, T> g) {
        return obj -> g.apply((CreateTrialComponentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrialComponentRequest> {
        /**
         * <p>
         * The name of the component. The name must be unique in your AWS account and is not case-sensitive.
         * </p>
         * 
         * @param trialComponentName
         *        The name of the component. The name must be unique in your AWS account and is not case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialComponentName(String trialComponentName);

        /**
         * <p>
         * The name of the component as displayed. The name doesn't need to be unique. If <code>DisplayName</code> isn't
         * specified, <code>TrialComponentName</code> is displayed.
         * </p>
         * 
         * @param displayName
         *        The name of the component as displayed. The name doesn't need to be unique. If
         *        <code>DisplayName</code> isn't specified, <code>TrialComponentName</code> is displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The status of the component. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * InProgress
         * </p>
         * </li>
         * <li>
         * <p>
         * Completed
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the component. States include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        InProgress
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Completed
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(TrialComponentStatus status);

        /**
         * <p>
         * The status of the component. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * InProgress
         * </p>
         * </li>
         * <li>
         * <p>
         * Completed
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link TrialComponentStatus.Builder} avoiding the need
         * to create one manually via {@link TrialComponentStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrialComponentStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #status(TrialComponentStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link TrialComponentStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(TrialComponentStatus)
         */
        default Builder status(Consumer<TrialComponentStatus.Builder> status) {
            return status(TrialComponentStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * When the component started.
         * </p>
         * 
         * @param startTime
         *        When the component started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * When the component ended.
         * </p>
         * 
         * @param endTime
         *        When the component ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The hyperparameters for the component.
         * </p>
         * 
         * @param parameters
         *        The hyperparameters for the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, TrialComponentParameterValue> parameters);

        /**
         * <p>
         * The input artifacts for the component. Examples of input artifacts are datasets, algorithms, hyperparameters,
         * source code, and instance types.
         * </p>
         * 
         * @param inputArtifacts
         *        The input artifacts for the component. Examples of input artifacts are datasets, algorithms,
         *        hyperparameters, source code, and instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputArtifacts(Map<String, TrialComponentArtifact> inputArtifacts);

        /**
         * <p>
         * The output artifacts for the component. Examples of output artifacts are metrics, snapshots, logs, and
         * images.
         * </p>
         * 
         * @param outputArtifacts
         *        The output artifacts for the component. Examples of output artifacts are metrics, snapshots, logs, and
         *        images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputArtifacts(Map<String, TrialComponentArtifact> outputArtifacts);

        /**
         * <p>
         * A list of tags to associate with the component. You can use <a>Search</a> API to search on the tags.
         * </p>
         * 
         * @param tags
         *        A list of tags to associate with the component. You can use <a>Search</a> API to search on the tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to associate with the component. You can use <a>Search</a> API to search on the tags.
         * </p>
         * 
         * @param tags
         *        A list of tags to associate with the component. You can use <a>Search</a> API to search on the tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to associate with the component. You can use <a>Search</a> API to search on the tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String trialComponentName;

        private String displayName;

        private TrialComponentStatus status;

        private Instant startTime;

        private Instant endTime;

        private Map<String, TrialComponentParameterValue> parameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, TrialComponentArtifact> inputArtifacts = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, TrialComponentArtifact> outputArtifacts = DefaultSdkAutoConstructMap.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrialComponentRequest model) {
            super(model);
            trialComponentName(model.trialComponentName);
            displayName(model.displayName);
            status(model.status);
            startTime(model.startTime);
            endTime(model.endTime);
            parameters(model.parameters);
            inputArtifacts(model.inputArtifacts);
            outputArtifacts(model.outputArtifacts);
            tags(model.tags);
        }

        public final String getTrialComponentName() {
            return trialComponentName;
        }

        @Override
        public final Builder trialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
            return this;
        }

        public final void setTrialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final TrialComponentStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        @Override
        public final Builder status(TrialComponentStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(TrialComponentStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Map<String, TrialComponentParameterValue.Builder> getParameters() {
            return parameters != null ? CollectionUtils.mapValues(parameters, TrialComponentParameterValue::toBuilder) : null;
        }

        @Override
        public final Builder parameters(Map<String, TrialComponentParameterValue> parameters) {
            this.parameters = TrialComponentParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, TrialComponentParameterValue.BuilderImpl> parameters) {
            this.parameters = TrialComponentParametersCopier.copyFromBuilder(parameters);
        }

        public final Map<String, TrialComponentArtifact.Builder> getInputArtifacts() {
            return inputArtifacts != null ? CollectionUtils.mapValues(inputArtifacts, TrialComponentArtifact::toBuilder) : null;
        }

        @Override
        public final Builder inputArtifacts(Map<String, TrialComponentArtifact> inputArtifacts) {
            this.inputArtifacts = TrialComponentArtifactsCopier.copy(inputArtifacts);
            return this;
        }

        public final void setInputArtifacts(Map<String, TrialComponentArtifact.BuilderImpl> inputArtifacts) {
            this.inputArtifacts = TrialComponentArtifactsCopier.copyFromBuilder(inputArtifacts);
        }

        public final Map<String, TrialComponentArtifact.Builder> getOutputArtifacts() {
            return outputArtifacts != null ? CollectionUtils.mapValues(outputArtifacts, TrialComponentArtifact::toBuilder) : null;
        }

        @Override
        public final Builder outputArtifacts(Map<String, TrialComponentArtifact> outputArtifacts) {
            this.outputArtifacts = TrialComponentArtifactsCopier.copy(outputArtifacts);
            return this;
        }

        public final void setOutputArtifacts(Map<String, TrialComponentArtifact.BuilderImpl> outputArtifacts) {
            this.outputArtifacts = TrialComponentArtifactsCopier.copyFromBuilder(outputArtifacts);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrialComponentRequest build() {
            return new CreateTrialComponentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
