/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUserProfilesResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListUserProfilesResponse.Builder, ListUserProfilesResponse> {
    private static final SdkField<List<UserProfileDetails>> USER_PROFILES_FIELD = SdkField
            .<List<UserProfileDetails>> builder(MarshallingType.LIST)
            .getter(getter(ListUserProfilesResponse::userProfiles))
            .setter(setter(Builder::userProfiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserProfileDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserProfileDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListUserProfilesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_PROFILES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<UserProfileDetails> userProfiles;

    private final String nextToken;

    private ListUserProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.userProfiles = builder.userProfiles;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the UserProfiles property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUserProfiles() {
        return userProfiles != null && !(userProfiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of user profiles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserProfiles()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of user profiles.
     */
    public List<UserProfileDetails> userProfiles() {
        return userProfiles;
    }

    /**
     * <p>
     * If the previous response was truncated, you will receive this token. Use it in your next request to receive the
     * next set of results.
     * </p>
     * 
     * @return If the previous response was truncated, you will receive this token. Use it in your next request to
     *         receive the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userProfiles());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUserProfilesResponse)) {
            return false;
        }
        ListUserProfilesResponse other = (ListUserProfilesResponse) obj;
        return Objects.equals(userProfiles(), other.userProfiles()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListUserProfilesResponse").add("UserProfiles", userProfiles()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserProfiles":
            return Optional.ofNullable(clazz.cast(userProfiles()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUserProfilesResponse, T> g) {
        return obj -> g.apply((ListUserProfilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListUserProfilesResponse> {
        /**
         * <p>
         * The list of user profiles.
         * </p>
         * 
         * @param userProfiles
         *        The list of user profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfiles(Collection<UserProfileDetails> userProfiles);

        /**
         * <p>
         * The list of user profiles.
         * </p>
         * 
         * @param userProfiles
         *        The list of user profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfiles(UserProfileDetails... userProfiles);

        /**
         * <p>
         * The list of user profiles.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UserProfileDetails>.Builder} avoiding the
         * need to create one manually via {@link List<UserProfileDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserProfileDetails>.Builder#build()} is called immediately
         * and its result is passed to {@link #userProfiles(List<UserProfileDetails>)}.
         * 
         * @param userProfiles
         *        a consumer that will call methods on {@link List<UserProfileDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userProfiles(List<UserProfileDetails>)
         */
        Builder userProfiles(Consumer<UserProfileDetails.Builder>... userProfiles);

        /**
         * <p>
         * If the previous response was truncated, you will receive this token. Use it in your next request to receive
         * the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was truncated, you will receive this token. Use it in your next request to
         *        receive the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<UserProfileDetails> userProfiles = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUserProfilesResponse model) {
            super(model);
            userProfiles(model.userProfiles);
            nextToken(model.nextToken);
        }

        public final Collection<UserProfileDetails.Builder> getUserProfiles() {
            return userProfiles != null ? userProfiles.stream().map(UserProfileDetails::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder userProfiles(Collection<UserProfileDetails> userProfiles) {
            this.userProfiles = UserProfileListCopier.copy(userProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProfiles(UserProfileDetails... userProfiles) {
            userProfiles(Arrays.asList(userProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProfiles(Consumer<UserProfileDetails.Builder>... userProfiles) {
            userProfiles(Stream.of(userProfiles).map(c -> UserProfileDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUserProfiles(Collection<UserProfileDetails.BuilderImpl> userProfiles) {
            this.userProfiles = UserProfileListCopier.copyFromBuilder(userProfiles);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListUserProfilesResponse build() {
            return new ListUserProfilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
