/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaptureContentTypeHeader implements SdkPojo, Serializable,
        ToCopyableBuilder<CaptureContentTypeHeader.Builder, CaptureContentTypeHeader> {
    private static final SdkField<List<String>> CSV_CONTENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CaptureContentTypeHeader::csvContentTypes))
            .setter(setter(Builder::csvContentTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CsvContentTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> JSON_CONTENT_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CaptureContentTypeHeader::jsonContentTypes))
            .setter(setter(Builder::jsonContentTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JsonContentTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CSV_CONTENT_TYPES_FIELD,
            JSON_CONTENT_TYPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> csvContentTypes;

    private final List<String> jsonContentTypes;

    private CaptureContentTypeHeader(BuilderImpl builder) {
        this.csvContentTypes = builder.csvContentTypes;
        this.jsonContentTypes = builder.jsonContentTypes;
    }

    /**
     * Returns true if the CsvContentTypes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCsvContentTypes() {
        return csvContentTypes != null && !(csvContentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCsvContentTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return
     */
    public List<String> csvContentTypes() {
        return csvContentTypes;
    }

    /**
     * Returns true if the JsonContentTypes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasJsonContentTypes() {
        return jsonContentTypes != null && !(jsonContentTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasJsonContentTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return
     */
    public List<String> jsonContentTypes() {
        return jsonContentTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(csvContentTypes());
        hashCode = 31 * hashCode + Objects.hashCode(jsonContentTypes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptureContentTypeHeader)) {
            return false;
        }
        CaptureContentTypeHeader other = (CaptureContentTypeHeader) obj;
        return Objects.equals(csvContentTypes(), other.csvContentTypes())
                && Objects.equals(jsonContentTypes(), other.jsonContentTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CaptureContentTypeHeader").add("CsvContentTypes", csvContentTypes())
                .add("JsonContentTypes", jsonContentTypes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CsvContentTypes":
            return Optional.ofNullable(clazz.cast(csvContentTypes()));
        case "JsonContentTypes":
            return Optional.ofNullable(clazz.cast(jsonContentTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CaptureContentTypeHeader, T> g) {
        return obj -> g.apply((CaptureContentTypeHeader) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaptureContentTypeHeader> {
        /**
         * <p/>
         * 
         * @param csvContentTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvContentTypes(Collection<String> csvContentTypes);

        /**
         * <p/>
         * 
         * @param csvContentTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder csvContentTypes(String... csvContentTypes);

        /**
         * <p/>
         * 
         * @param jsonContentTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonContentTypes(Collection<String> jsonContentTypes);

        /**
         * <p/>
         * 
         * @param jsonContentTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonContentTypes(String... jsonContentTypes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> csvContentTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> jsonContentTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CaptureContentTypeHeader model) {
            csvContentTypes(model.csvContentTypes);
            jsonContentTypes(model.jsonContentTypes);
        }

        public final Collection<String> getCsvContentTypes() {
            return csvContentTypes;
        }

        @Override
        public final Builder csvContentTypes(Collection<String> csvContentTypes) {
            this.csvContentTypes = CsvContentTypesCopier.copy(csvContentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder csvContentTypes(String... csvContentTypes) {
            csvContentTypes(Arrays.asList(csvContentTypes));
            return this;
        }

        public final void setCsvContentTypes(Collection<String> csvContentTypes) {
            this.csvContentTypes = CsvContentTypesCopier.copy(csvContentTypes);
        }

        public final Collection<String> getJsonContentTypes() {
            return jsonContentTypes;
        }

        @Override
        public final Builder jsonContentTypes(Collection<String> jsonContentTypes) {
            this.jsonContentTypes = JsonContentTypesCopier.copy(jsonContentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jsonContentTypes(String... jsonContentTypes) {
            jsonContentTypes(Arrays.asList(jsonContentTypes));
            return this;
        }

        public final void setJsonContentTypes(Collection<String> jsonContentTypes) {
            this.jsonContentTypes = JsonContentTypesCopier.copy(jsonContentTypes);
        }

        @Override
        public CaptureContentTypeHeader build() {
            return new CaptureContentTypeHeader(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
