/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about the source of a trial component. Either <code>ProcessingJob</code> or
 * <code>TrainingJob</code> is returned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrialComponentSourceDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<TrialComponentSourceDetail.Builder, TrialComponentSourceDetail> {
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TrialComponentSourceDetail::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()).build();

    private static final SdkField<TrainingJob> TRAINING_JOB_FIELD = SdkField.<TrainingJob> builder(MarshallingType.SDK_POJO)
            .getter(getter(TrialComponentSourceDetail::trainingJob)).setter(setter(Builder::trainingJob))
            .constructor(TrainingJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJob").build()).build();

    private static final SdkField<ProcessingJob> PROCESSING_JOB_FIELD = SdkField
            .<ProcessingJob> builder(MarshallingType.SDK_POJO).getter(getter(TrialComponentSourceDetail::processingJob))
            .setter(setter(Builder::processingJob)).constructor(ProcessingJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJob").build()).build();

    private static final SdkField<TransformJob> TRANSFORM_JOB_FIELD = SdkField.<TransformJob> builder(MarshallingType.SDK_POJO)
            .getter(getter(TrialComponentSourceDetail::transformJob)).setter(setter(Builder::transformJob))
            .constructor(TransformJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ARN_FIELD,
            TRAINING_JOB_FIELD, PROCESSING_JOB_FIELD, TRANSFORM_JOB_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceArn;

    private final TrainingJob trainingJob;

    private final ProcessingJob processingJob;

    private final TransformJob transformJob;

    private TrialComponentSourceDetail(BuilderImpl builder) {
        this.sourceArn = builder.sourceArn;
        this.trainingJob = builder.trainingJob;
        this.processingJob = builder.processingJob;
        this.transformJob = builder.transformJob;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source.
     */
    public String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * Information about a training job that's the source of a trial component.
     * </p>
     * 
     * @return Information about a training job that's the source of a trial component.
     */
    public TrainingJob trainingJob() {
        return trainingJob;
    }

    /**
     * <p>
     * Information about a processing job that's the source of a trial component.
     * </p>
     * 
     * @return Information about a processing job that's the source of a trial component.
     */
    public ProcessingJob processingJob() {
        return processingJob;
    }

    /**
     * <p>
     * Information about a transform job that's the source of the trial component.
     * </p>
     * 
     * @return Information about a transform job that's the source of the trial component.
     */
    public TransformJob transformJob() {
        return transformJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(trainingJob());
        hashCode = 31 * hashCode + Objects.hashCode(processingJob());
        hashCode = 31 * hashCode + Objects.hashCode(transformJob());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrialComponentSourceDetail)) {
            return false;
        }
        TrialComponentSourceDetail other = (TrialComponentSourceDetail) obj;
        return Objects.equals(sourceArn(), other.sourceArn()) && Objects.equals(trainingJob(), other.trainingJob())
                && Objects.equals(processingJob(), other.processingJob()) && Objects.equals(transformJob(), other.transformJob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TrialComponentSourceDetail").add("SourceArn", sourceArn()).add("TrainingJob", trainingJob())
                .add("ProcessingJob", processingJob()).add("TransformJob", transformJob()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "TrainingJob":
            return Optional.ofNullable(clazz.cast(trainingJob()));
        case "ProcessingJob":
            return Optional.ofNullable(clazz.cast(processingJob()));
        case "TransformJob":
            return Optional.ofNullable(clazz.cast(transformJob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrialComponentSourceDetail, T> g) {
        return obj -> g.apply((TrialComponentSourceDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrialComponentSourceDetail> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source.
         * </p>
         * 
         * @param sourceArn
         *        The Amazon Resource Name (ARN) of the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * Information about a training job that's the source of a trial component.
         * </p>
         * 
         * @param trainingJob
         *        Information about a training job that's the source of a trial component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJob(TrainingJob trainingJob);

        /**
         * <p>
         * Information about a training job that's the source of a trial component.
         * </p>
         * This is a convenience that creates an instance of the {@link TrainingJob.Builder} avoiding the need to create
         * one manually via {@link TrainingJob#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrainingJob.Builder#build()} is called immediately and its result
         * is passed to {@link #trainingJob(TrainingJob)}.
         * 
         * @param trainingJob
         *        a consumer that will call methods on {@link TrainingJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingJob(TrainingJob)
         */
        default Builder trainingJob(Consumer<TrainingJob.Builder> trainingJob) {
            return trainingJob(TrainingJob.builder().applyMutation(trainingJob).build());
        }

        /**
         * <p>
         * Information about a processing job that's the source of a trial component.
         * </p>
         * 
         * @param processingJob
         *        Information about a processing job that's the source of a trial component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingJob(ProcessingJob processingJob);

        /**
         * <p>
         * Information about a processing job that's the source of a trial component.
         * </p>
         * This is a convenience that creates an instance of the {@link ProcessingJob.Builder} avoiding the need to
         * create one manually via {@link ProcessingJob#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProcessingJob.Builder#build()} is called immediately and its
         * result is passed to {@link #processingJob(ProcessingJob)}.
         * 
         * @param processingJob
         *        a consumer that will call methods on {@link ProcessingJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingJob(ProcessingJob)
         */
        default Builder processingJob(Consumer<ProcessingJob.Builder> processingJob) {
            return processingJob(ProcessingJob.builder().applyMutation(processingJob).build());
        }

        /**
         * <p>
         * Information about a transform job that's the source of the trial component.
         * </p>
         * 
         * @param transformJob
         *        Information about a transform job that's the source of the trial component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformJob(TransformJob transformJob);

        /**
         * <p>
         * Information about a transform job that's the source of the trial component.
         * </p>
         * This is a convenience that creates an instance of the {@link TransformJob.Builder} avoiding the need to
         * create one manually via {@link TransformJob#builder()}.
         *
         * When the {@link Consumer} completes, {@link TransformJob.Builder#build()} is called immediately and its
         * result is passed to {@link #transformJob(TransformJob)}.
         * 
         * @param transformJob
         *        a consumer that will call methods on {@link TransformJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transformJob(TransformJob)
         */
        default Builder transformJob(Consumer<TransformJob.Builder> transformJob) {
            return transformJob(TransformJob.builder().applyMutation(transformJob).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sourceArn;

        private TrainingJob trainingJob;

        private ProcessingJob processingJob;

        private TransformJob transformJob;

        private BuilderImpl() {
        }

        private BuilderImpl(TrialComponentSourceDetail model) {
            sourceArn(model.sourceArn);
            trainingJob(model.trainingJob);
            processingJob(model.processingJob);
            transformJob(model.transformJob);
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        public final TrainingJob.Builder getTrainingJob() {
            return trainingJob != null ? trainingJob.toBuilder() : null;
        }

        @Override
        public final Builder trainingJob(TrainingJob trainingJob) {
            this.trainingJob = trainingJob;
            return this;
        }

        public final void setTrainingJob(TrainingJob.BuilderImpl trainingJob) {
            this.trainingJob = trainingJob != null ? trainingJob.build() : null;
        }

        public final ProcessingJob.Builder getProcessingJob() {
            return processingJob != null ? processingJob.toBuilder() : null;
        }

        @Override
        public final Builder processingJob(ProcessingJob processingJob) {
            this.processingJob = processingJob;
            return this;
        }

        public final void setProcessingJob(ProcessingJob.BuilderImpl processingJob) {
            this.processingJob = processingJob != null ? processingJob.build() : null;
        }

        public final TransformJob.Builder getTransformJob() {
            return transformJob != null ? transformJob.toBuilder() : null;
        }

        @Override
        public final Builder transformJob(TransformJob transformJob) {
            this.transformJob = transformJob;
            return this;
        }

        public final void setTransformJob(TransformJob.BuilderImpl transformJob) {
            this.transformJob = transformJob != null ? transformJob.build() : null;
        }

        @Override
        public TrialComponentSourceDetail build() {
            return new TrialComponentSourceDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
