/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about where and how you want to store the results of a monitoring job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoringS3Output implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoringS3Output.Builder, MonitoringS3Output> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MonitoringS3Output::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final SdkField<String> LOCAL_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MonitoringS3Output::localPath)).setter(setter(Builder::localPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPath").build()).build();

    private static final SdkField<String> S3_UPLOAD_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MonitoringS3Output::s3UploadModeAsString)).setter(setter(Builder::s3UploadMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3UploadMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD,
            LOCAL_PATH_FIELD, S3_UPLOAD_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3Uri;

    private final String localPath;

    private final String s3UploadMode;

    private MonitoringS3Output(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.localPath = builder.localPath;
        this.s3UploadMode = builder.s3UploadMode;
    }

    /**
     * <p>
     * A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring
     * job.
     * </p>
     * 
     * @return A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a
     *         monitoring job.
     */
    public String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring job.
     * LocalPath is an absolute path for the output data.
     * </p>
     * 
     * @return The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring
     *         job. LocalPath is an absolute path for the output data.
     */
    public String localPath() {
        return localPath;
    }

    /**
     * <p>
     * Whether to upload the results of the monitoring job continuously or after the job completes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3UploadMode} will
     * return {@link ProcessingS3UploadMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3UploadModeAsString}.
     * </p>
     * 
     * @return Whether to upload the results of the monitoring job continuously or after the job completes.
     * @see ProcessingS3UploadMode
     */
    public ProcessingS3UploadMode s3UploadMode() {
        return ProcessingS3UploadMode.fromValue(s3UploadMode);
    }

    /**
     * <p>
     * Whether to upload the results of the monitoring job continuously or after the job completes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3UploadMode} will
     * return {@link ProcessingS3UploadMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3UploadModeAsString}.
     * </p>
     * 
     * @return Whether to upload the results of the monitoring job continuously or after the job completes.
     * @see ProcessingS3UploadMode
     */
    public String s3UploadModeAsString() {
        return s3UploadMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(localPath());
        hashCode = 31 * hashCode + Objects.hashCode(s3UploadModeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringS3Output)) {
            return false;
        }
        MonitoringS3Output other = (MonitoringS3Output) obj;
        return Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(localPath(), other.localPath())
                && Objects.equals(s3UploadModeAsString(), other.s3UploadModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MonitoringS3Output").add("S3Uri", s3Uri()).add("LocalPath", localPath())
                .add("S3UploadMode", s3UploadModeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "LocalPath":
            return Optional.ofNullable(clazz.cast(localPath()));
        case "S3UploadMode":
            return Optional.ofNullable(clazz.cast(s3UploadModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringS3Output, T> g) {
        return obj -> g.apply((MonitoringS3Output) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoringS3Output> {
        /**
         * <p>
         * A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring
         * job.
         * </p>
         * 
         * @param s3Uri
         *        A URI that identifies the Amazon S3 storage location where Amazon SageMaker saves the results of a
         *        monitoring job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a monitoring
         * job. LocalPath is an absolute path for the output data.
         * </p>
         * 
         * @param localPath
         *        The local path to the Amazon S3 storage location where Amazon SageMaker saves the results of a
         *        monitoring job. LocalPath is an absolute path for the output data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localPath(String localPath);

        /**
         * <p>
         * Whether to upload the results of the monitoring job continuously or after the job completes.
         * </p>
         * 
         * @param s3UploadMode
         *        Whether to upload the results of the monitoring job continuously or after the job completes.
         * @see ProcessingS3UploadMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingS3UploadMode
         */
        Builder s3UploadMode(String s3UploadMode);

        /**
         * <p>
         * Whether to upload the results of the monitoring job continuously or after the job completes.
         * </p>
         * 
         * @param s3UploadMode
         *        Whether to upload the results of the monitoring job continuously or after the job completes.
         * @see ProcessingS3UploadMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProcessingS3UploadMode
         */
        Builder s3UploadMode(ProcessingS3UploadMode s3UploadMode);
    }

    static final class BuilderImpl implements Builder {
        private String s3Uri;

        private String localPath;

        private String s3UploadMode;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringS3Output model) {
            s3Uri(model.s3Uri);
            localPath(model.localPath);
            s3UploadMode(model.s3UploadMode);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        public final String getLocalPath() {
            return localPath;
        }

        @Override
        public final Builder localPath(String localPath) {
            this.localPath = localPath;
            return this;
        }

        public final void setLocalPath(String localPath) {
            this.localPath = localPath;
        }

        public final String getS3UploadMode() {
            return s3UploadMode;
        }

        @Override
        public final Builder s3UploadMode(String s3UploadMode) {
            this.s3UploadMode = s3UploadMode;
            return this;
        }

        @Override
        public final Builder s3UploadMode(ProcessingS3UploadMode s3UploadMode) {
            this.s3UploadMode(s3UploadMode == null ? null : s3UploadMode.toString());
            return this;
        }

        public final void setS3UploadMode(String s3UploadMode) {
            this.s3UploadMode = s3UploadMode;
        }

        @Override
        public MonitoringS3Output build() {
            return new MonitoringS3Output(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
