/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDomainRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateDomainRequest.Builder, CreateDomainRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDomainRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> AUTH_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDomainRequest::authModeAsString)).setter(setter(Builder::authMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthMode").build()).build();

    private static final SdkField<UserSettings> DEFAULT_USER_SETTINGS_FIELD = SdkField
            .<UserSettings> builder(MarshallingType.SDK_POJO).getter(getter(CreateDomainRequest::defaultUserSettings))
            .setter(setter(Builder::defaultUserSettings)).constructor(UserSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultUserSettings").build())
            .build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateDomainRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDomainRequest::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateDomainRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> HOME_EFS_FILE_SYSTEM_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).getter(getter(CreateDomainRequest::homeEfsFileSystemKmsKeyId))
            .setter(setter(Builder::homeEfsFileSystemKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeEfsFileSystemKmsKeyId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            AUTH_MODE_FIELD, DEFAULT_USER_SETTINGS_FIELD, SUBNET_IDS_FIELD, VPC_ID_FIELD, TAGS_FIELD,
            HOME_EFS_FILE_SYSTEM_KMS_KEY_ID_FIELD));

    private final String domainName;

    private final String authMode;

    private final UserSettings defaultUserSettings;

    private final List<String> subnetIds;

    private final String vpcId;

    private final List<Tag> tags;

    private final String homeEfsFileSystemKmsKeyId;

    private CreateDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.authMode = builder.authMode;
        this.defaultUserSettings = builder.defaultUserSettings;
        this.subnetIds = builder.subnetIds;
        this.vpcId = builder.vpcId;
        this.tags = builder.tags;
        this.homeEfsFileSystemKmsKeyId = builder.homeEfsFileSystemKmsKeyId;
    }

    /**
     * <p>
     * A name for the domain.
     * </p>
     * 
     * @return A name for the domain.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The mode of authentication that members use to access the domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authMode} will
     * return {@link AuthMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authModeAsString}.
     * </p>
     * 
     * @return The mode of authentication that members use to access the domain.
     * @see AuthMode
     */
    public AuthMode authMode() {
        return AuthMode.fromValue(authMode);
    }

    /**
     * <p>
     * The mode of authentication that members use to access the domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authMode} will
     * return {@link AuthMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authModeAsString}.
     * </p>
     * 
     * @return The mode of authentication that members use to access the domain.
     * @see AuthMode
     */
    public String authModeAsString() {
        return authMode;
    }

    /**
     * <p>
     * The default user settings.
     * </p>
     * 
     * @return The default user settings.
     */
    public UserSettings defaultUserSettings() {
        return defaultUserSettings;
    }

    /**
     * Returns true if the SubnetIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The VPC subnets to use for communication with the EFS volume.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnetIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The VPC subnets to use for communication with the EFS volume.
     */
    public List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * The ID of the Amazon Virtual Private Cloud (VPC) to use for communication with the EFS volume.
     * </p>
     * 
     * @return The ID of the Amazon Virtual Private Cloud (VPC) to use for communication with the EFS volume.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to associated with the Domain. Each tag consists of a key and an optional value. Tag keys must be unique per
     * resource. Tags are searchable using the <a>Search</a> API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Tags to associated with the Domain. Each tag consists of a key and an optional value. Tag keys must be
     *         unique per resource. Tags are searchable using the <a>Search</a> API.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The AWS Key Management Service (KMS) encryption key ID. Encryption with a customer master key (CMK) is not
     * supported.
     * </p>
     * 
     * @return The AWS Key Management Service (KMS) encryption key ID. Encryption with a customer master key (CMK) is
     *         not supported.
     */
    public String homeEfsFileSystemKmsKeyId() {
        return homeEfsFileSystemKmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(authModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultUserSettings());
        hashCode = 31 * hashCode + Objects.hashCode(subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(homeEfsFileSystemKmsKeyId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainRequest)) {
            return false;
        }
        CreateDomainRequest other = (CreateDomainRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(authModeAsString(), other.authModeAsString())
                && Objects.equals(defaultUserSettings(), other.defaultUserSettings())
                && Objects.equals(subnetIds(), other.subnetIds()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(tags(), other.tags())
                && Objects.equals(homeEfsFileSystemKmsKeyId(), other.homeEfsFileSystemKmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDomainRequest").add("DomainName", domainName()).add("AuthMode", authModeAsString())
                .add("DefaultUserSettings", defaultUserSettings()).add("SubnetIds", subnetIds()).add("VpcId", vpcId())
                .add("Tags", tags()).add("HomeEfsFileSystemKmsKeyId", homeEfsFileSystemKmsKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "AuthMode":
            return Optional.ofNullable(clazz.cast(authModeAsString()));
        case "DefaultUserSettings":
            return Optional.ofNullable(clazz.cast(defaultUserSettings()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "HomeEfsFileSystemKmsKeyId":
            return Optional.ofNullable(clazz.cast(homeEfsFileSystemKmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainRequest, T> g) {
        return obj -> g.apply((CreateDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDomainRequest> {
        /**
         * <p>
         * A name for the domain.
         * </p>
         * 
         * @param domainName
         *        A name for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The mode of authentication that members use to access the domain.
         * </p>
         * 
         * @param authMode
         *        The mode of authentication that members use to access the domain.
         * @see AuthMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthMode
         */
        Builder authMode(String authMode);

        /**
         * <p>
         * The mode of authentication that members use to access the domain.
         * </p>
         * 
         * @param authMode
         *        The mode of authentication that members use to access the domain.
         * @see AuthMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthMode
         */
        Builder authMode(AuthMode authMode);

        /**
         * <p>
         * The default user settings.
         * </p>
         * 
         * @param defaultUserSettings
         *        The default user settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultUserSettings(UserSettings defaultUserSettings);

        /**
         * <p>
         * The default user settings.
         * </p>
         * This is a convenience that creates an instance of the {@link UserSettings.Builder} avoiding the need to
         * create one manually via {@link UserSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultUserSettings(UserSettings)}.
         * 
         * @param defaultUserSettings
         *        a consumer that will call methods on {@link UserSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultUserSettings(UserSettings)
         */
        default Builder defaultUserSettings(Consumer<UserSettings.Builder> defaultUserSettings) {
            return defaultUserSettings(UserSettings.builder().applyMutation(defaultUserSettings).build());
        }

        /**
         * <p>
         * The VPC subnets to use for communication with the EFS volume.
         * </p>
         * 
         * @param subnetIds
         *        The VPC subnets to use for communication with the EFS volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The VPC subnets to use for communication with the EFS volume.
         * </p>
         * 
         * @param subnetIds
         *        The VPC subnets to use for communication with the EFS volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The ID of the Amazon Virtual Private Cloud (VPC) to use for communication with the EFS volume.
         * </p>
         * 
         * @param vpcId
         *        The ID of the Amazon Virtual Private Cloud (VPC) to use for communication with the EFS volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Tags to associated with the Domain. Each tag consists of a key and an optional value. Tag keys must be unique
         * per resource. Tags are searchable using the <a>Search</a> API.
         * </p>
         * 
         * @param tags
         *        Tags to associated with the Domain. Each tag consists of a key and an optional value. Tag keys must be
         *        unique per resource. Tags are searchable using the <a>Search</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags to associated with the Domain. Each tag consists of a key and an optional value. Tag keys must be unique
         * per resource. Tags are searchable using the <a>Search</a> API.
         * </p>
         * 
         * @param tags
         *        Tags to associated with the Domain. Each tag consists of a key and an optional value. Tag keys must be
         *        unique per resource. Tags are searchable using the <a>Search</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags to associated with the Domain. Each tag consists of a key and an optional value. Tag keys must be unique
         * per resource. Tags are searchable using the <a>Search</a> API.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The AWS Key Management Service (KMS) encryption key ID. Encryption with a customer master key (CMK) is not
         * supported.
         * </p>
         * 
         * @param homeEfsFileSystemKmsKeyId
         *        The AWS Key Management Service (KMS) encryption key ID. Encryption with a customer master key (CMK) is
         *        not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeEfsFileSystemKmsKeyId(String homeEfsFileSystemKmsKeyId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String domainName;

        private String authMode;

        private UserSettings defaultUserSettings;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String homeEfsFileSystemKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainRequest model) {
            super(model);
            domainName(model.domainName);
            authMode(model.authMode);
            defaultUserSettings(model.defaultUserSettings);
            subnetIds(model.subnetIds);
            vpcId(model.vpcId);
            tags(model.tags);
            homeEfsFileSystemKmsKeyId(model.homeEfsFileSystemKmsKeyId);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getAuthMode() {
            return authMode;
        }

        @Override
        public final Builder authMode(String authMode) {
            this.authMode = authMode;
            return this;
        }

        @Override
        public final Builder authMode(AuthMode authMode) {
            this.authMode(authMode == null ? null : authMode.toString());
            return this;
        }

        public final void setAuthMode(String authMode) {
            this.authMode = authMode;
        }

        public final UserSettings.Builder getDefaultUserSettings() {
            return defaultUserSettings != null ? defaultUserSettings.toBuilder() : null;
        }

        @Override
        public final Builder defaultUserSettings(UserSettings defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings;
            return this;
        }

        public final void setDefaultUserSettings(UserSettings.BuilderImpl defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings != null ? defaultUserSettings.build() : null;
        }

        public final Collection<String> getSubnetIds() {
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetsCopier.copy(subnetIds);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getHomeEfsFileSystemKmsKeyId() {
            return homeEfsFileSystemKmsKeyId;
        }

        @Override
        public final Builder homeEfsFileSystemKmsKeyId(String homeEfsFileSystemKmsKeyId) {
            this.homeEfsFileSystemKmsKeyId = homeEfsFileSystemKmsKeyId;
            return this;
        }

        public final void setHomeEfsFileSystemKmsKeyId(String homeEfsFileSystemKmsKeyId) {
            this.homeEfsFileSystemKmsKeyId = homeEfsFileSystemKmsKeyId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDomainRequest build() {
            return new CreateDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
