/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkforceRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateWorkforceRequest.Builder, CreateWorkforceRequest> {
    private static final SdkField<CognitoConfig> COGNITO_CONFIG_FIELD = SdkField
            .<CognitoConfig> builder(MarshallingType.SDK_POJO).getter(getter(CreateWorkforceRequest::cognitoConfig))
            .setter(setter(Builder::cognitoConfig)).constructor(CognitoConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoConfig").build()).build();

    private static final SdkField<OidcConfig> OIDC_CONFIG_FIELD = SdkField.<OidcConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateWorkforceRequest::oidcConfig)).setter(setter(Builder::oidcConfig))
            .constructor(OidcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OidcConfig").build()).build();

    private static final SdkField<SourceIpConfig> SOURCE_IP_CONFIG_FIELD = SdkField
            .<SourceIpConfig> builder(MarshallingType.SDK_POJO).getter(getter(CreateWorkforceRequest::sourceIpConfig))
            .setter(setter(Builder::sourceIpConfig)).constructor(SourceIpConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIpConfig").build()).build();

    private static final SdkField<String> WORKFORCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateWorkforceRequest::workforceName)).setter(setter(Builder::workforceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkforceName").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateWorkforceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COGNITO_CONFIG_FIELD,
            OIDC_CONFIG_FIELD, SOURCE_IP_CONFIG_FIELD, WORKFORCE_NAME_FIELD, TAGS_FIELD));

    private final CognitoConfig cognitoConfig;

    private final OidcConfig oidcConfig;

    private final SourceIpConfig sourceIpConfig;

    private final String workforceName;

    private final List<Tag> tags;

    private CreateWorkforceRequest(BuilderImpl builder) {
        super(builder);
        this.cognitoConfig = builder.cognitoConfig;
        this.oidcConfig = builder.oidcConfig;
        this.sourceIpConfig = builder.sourceIpConfig;
        this.workforceName = builder.workforceName;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is created using
     * and corresponds to a single <a
     * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> Amazon Cognito
     * user pool</a>.
     * </p>
     * <p>
     * Do not use <code>OidcConfig</code> if you specify values for <code>CognitoConfig</code>.
     * </p>
     * 
     * @return Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is
     *         created using and corresponds to a single <a
     *         href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> Amazon
     *         Cognito user pool</a>.</p>
     *         <p>
     *         Do not use <code>OidcConfig</code> if you specify values for <code>CognitoConfig</code>.
     */
    public CognitoConfig cognitoConfig() {
        return cognitoConfig;
    }

    /**
     * <p>
     * Use this parameter to configure a private workforce using your own OIDC Identity Provider. Do not use
     * <code>CognitoConfig</code> if you specify values for <code>OidcConfig</code>.
     * </p>
     * 
     * @return Use this parameter to configure a private workforce using your own OIDC Identity Provider. Do not use
     *         <code>CognitoConfig</code> if you specify values for <code>OidcConfig</code>.
     */
    public OidcConfig oidcConfig() {
        return oidcConfig;
    }

    /**
     * Returns the value of the SourceIpConfig property for this object.
     * 
     * @return The value of the SourceIpConfig property for this object.
     */
    public SourceIpConfig sourceIpConfig() {
        return sourceIpConfig;
    }

    /**
     * <p>
     * The name of the private workforce.
     * </p>
     * 
     * @return The name of the private workforce.
     */
    public String workforceName() {
        return workforceName;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs that contain metadata to help you categorize and organize our workforce. Each tag
     * consists of a key and a value, both of which you define.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of key-value pairs that contain metadata to help you categorize and organize our workforce. Each
     *         tag consists of a key and a value, both of which you define.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cognitoConfig());
        hashCode = 31 * hashCode + Objects.hashCode(oidcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(sourceIpConfig());
        hashCode = 31 * hashCode + Objects.hashCode(workforceName());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkforceRequest)) {
            return false;
        }
        CreateWorkforceRequest other = (CreateWorkforceRequest) obj;
        return Objects.equals(cognitoConfig(), other.cognitoConfig()) && Objects.equals(oidcConfig(), other.oidcConfig())
                && Objects.equals(sourceIpConfig(), other.sourceIpConfig())
                && Objects.equals(workforceName(), other.workforceName()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateWorkforceRequest").add("CognitoConfig", cognitoConfig()).add("OidcConfig", oidcConfig())
                .add("SourceIpConfig", sourceIpConfig()).add("WorkforceName", workforceName()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CognitoConfig":
            return Optional.ofNullable(clazz.cast(cognitoConfig()));
        case "OidcConfig":
            return Optional.ofNullable(clazz.cast(oidcConfig()));
        case "SourceIpConfig":
            return Optional.ofNullable(clazz.cast(sourceIpConfig()));
        case "WorkforceName":
            return Optional.ofNullable(clazz.cast(workforceName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkforceRequest, T> g) {
        return obj -> g.apply((CreateWorkforceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWorkforceRequest> {
        /**
         * <p>
         * Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is created
         * using and corresponds to a single <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> Amazon
         * Cognito user pool</a>.
         * </p>
         * <p>
         * Do not use <code>OidcConfig</code> if you specify values for <code>CognitoConfig</code>.
         * </p>
         * 
         * @param cognitoConfig
         *        Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is
         *        created using and corresponds to a single <a
         *        href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html">
         *        Amazon Cognito user pool</a>.</p>
         *        <p>
         *        Do not use <code>OidcConfig</code> if you specify values for <code>CognitoConfig</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cognitoConfig(CognitoConfig cognitoConfig);

        /**
         * <p>
         * Use this parameter to configure an Amazon Cognito private workforce. A single Cognito workforce is created
         * using and corresponds to a single <a
         * href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html"> Amazon
         * Cognito user pool</a>.
         * </p>
         * <p>
         * Do not use <code>OidcConfig</code> if you specify values for <code>CognitoConfig</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link CognitoConfig.Builder} avoiding the need to
         * create one manually via {@link CognitoConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link CognitoConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #cognitoConfig(CognitoConfig)}.
         * 
         * @param cognitoConfig
         *        a consumer that will call methods on {@link CognitoConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cognitoConfig(CognitoConfig)
         */
        default Builder cognitoConfig(Consumer<CognitoConfig.Builder> cognitoConfig) {
            return cognitoConfig(CognitoConfig.builder().applyMutation(cognitoConfig).build());
        }

        /**
         * <p>
         * Use this parameter to configure a private workforce using your own OIDC Identity Provider. Do not use
         * <code>CognitoConfig</code> if you specify values for <code>OidcConfig</code>.
         * </p>
         * 
         * @param oidcConfig
         *        Use this parameter to configure a private workforce using your own OIDC Identity Provider. Do not use
         *        <code>CognitoConfig</code> if you specify values for <code>OidcConfig</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oidcConfig(OidcConfig oidcConfig);

        /**
         * <p>
         * Use this parameter to configure a private workforce using your own OIDC Identity Provider. Do not use
         * <code>CognitoConfig</code> if you specify values for <code>OidcConfig</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link OidcConfig.Builder} avoiding the need to create
         * one manually via {@link OidcConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OidcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #oidcConfig(OidcConfig)}.
         * 
         * @param oidcConfig
         *        a consumer that will call methods on {@link OidcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oidcConfig(OidcConfig)
         */
        default Builder oidcConfig(Consumer<OidcConfig.Builder> oidcConfig) {
            return oidcConfig(OidcConfig.builder().applyMutation(oidcConfig).build());
        }

        /**
         * Sets the value of the SourceIpConfig property for this object.
         *
         * @param sourceIpConfig
         *        The new value for the SourceIpConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIpConfig(SourceIpConfig sourceIpConfig);

        /**
         * Sets the value of the SourceIpConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link SourceIpConfig.Builder} avoiding the need to
         * create one manually via {@link SourceIpConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceIpConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceIpConfig(SourceIpConfig)}.
         * 
         * @param sourceIpConfig
         *        a consumer that will call methods on {@link SourceIpConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceIpConfig(SourceIpConfig)
         */
        default Builder sourceIpConfig(Consumer<SourceIpConfig.Builder> sourceIpConfig) {
            return sourceIpConfig(SourceIpConfig.builder().applyMutation(sourceIpConfig).build());
        }

        /**
         * <p>
         * The name of the private workforce.
         * </p>
         * 
         * @param workforceName
         *        The name of the private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workforceName(String workforceName);

        /**
         * <p>
         * An array of key-value pairs that contain metadata to help you categorize and organize our workforce. Each tag
         * consists of a key and a value, both of which you define.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs that contain metadata to help you categorize and organize our workforce.
         *        Each tag consists of a key and a value, both of which you define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key-value pairs that contain metadata to help you categorize and organize our workforce. Each tag
         * consists of a key and a value, both of which you define.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs that contain metadata to help you categorize and organize our workforce.
         *        Each tag consists of a key and a value, both of which you define.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key-value pairs that contain metadata to help you categorize and organize our workforce. Each tag
         * consists of a key and a value, both of which you define.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private CognitoConfig cognitoConfig;

        private OidcConfig oidcConfig;

        private SourceIpConfig sourceIpConfig;

        private String workforceName;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkforceRequest model) {
            super(model);
            cognitoConfig(model.cognitoConfig);
            oidcConfig(model.oidcConfig);
            sourceIpConfig(model.sourceIpConfig);
            workforceName(model.workforceName);
            tags(model.tags);
        }

        public final CognitoConfig.Builder getCognitoConfig() {
            return cognitoConfig != null ? cognitoConfig.toBuilder() : null;
        }

        @Override
        public final Builder cognitoConfig(CognitoConfig cognitoConfig) {
            this.cognitoConfig = cognitoConfig;
            return this;
        }

        public final void setCognitoConfig(CognitoConfig.BuilderImpl cognitoConfig) {
            this.cognitoConfig = cognitoConfig != null ? cognitoConfig.build() : null;
        }

        public final OidcConfig.Builder getOidcConfig() {
            return oidcConfig != null ? oidcConfig.toBuilder() : null;
        }

        @Override
        public final Builder oidcConfig(OidcConfig oidcConfig) {
            this.oidcConfig = oidcConfig;
            return this;
        }

        public final void setOidcConfig(OidcConfig.BuilderImpl oidcConfig) {
            this.oidcConfig = oidcConfig != null ? oidcConfig.build() : null;
        }

        public final SourceIpConfig.Builder getSourceIpConfig() {
            return sourceIpConfig != null ? sourceIpConfig.toBuilder() : null;
        }

        @Override
        public final Builder sourceIpConfig(SourceIpConfig sourceIpConfig) {
            this.sourceIpConfig = sourceIpConfig;
            return this;
        }

        public final void setSourceIpConfig(SourceIpConfig.BuilderImpl sourceIpConfig) {
            this.sourceIpConfig = sourceIpConfig != null ? sourceIpConfig.build() : null;
        }

        public final String getWorkforceName() {
            return workforceName;
        }

        @Override
        public final Builder workforceName(String workforceName) {
            this.workforceName = workforceName;
            return this;
        }

        public final void setWorkforceName(String workforceName) {
            this.workforceName = workforceName;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkforceRequest build() {
            return new CreateWorkforceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
