/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the work to be performed by human workers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HumanLoopConfig implements SdkPojo, Serializable, ToCopyableBuilder<HumanLoopConfig.Builder, HumanLoopConfig> {
    private static final SdkField<String> WORKTEAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HumanLoopConfig::workteamArn)).setter(setter(Builder::workteamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkteamArn").build()).build();

    private static final SdkField<String> HUMAN_TASK_UI_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HumanLoopConfig::humanTaskUiArn)).setter(setter(Builder::humanTaskUiArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanTaskUiArn").build()).build();

    private static final SdkField<String> TASK_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HumanLoopConfig::taskTitle)).setter(setter(Builder::taskTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskTitle").build()).build();

    private static final SdkField<String> TASK_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HumanLoopConfig::taskDescription)).setter(setter(Builder::taskDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskDescription").build()).build();

    private static final SdkField<Integer> TASK_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HumanLoopConfig::taskCount)).setter(setter(Builder::taskCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskCount").build()).build();

    private static final SdkField<Integer> TASK_AVAILABILITY_LIFETIME_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HumanLoopConfig::taskAvailabilityLifetimeInSeconds))
            .setter(setter(Builder::taskAvailabilityLifetimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskAvailabilityLifetimeInSeconds")
                    .build()).build();

    private static final SdkField<Integer> TASK_TIME_LIMIT_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(HumanLoopConfig::taskTimeLimitInSeconds)).setter(setter(Builder::taskTimeLimitInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskTimeLimitInSeconds").build())
            .build();

    private static final SdkField<List<String>> TASK_KEYWORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(HumanLoopConfig::taskKeywords))
            .setter(setter(Builder::taskKeywords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskKeywords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<PublicWorkforceTaskPrice> PUBLIC_WORKFORCE_TASK_PRICE_FIELD = SdkField
            .<PublicWorkforceTaskPrice> builder(MarshallingType.SDK_POJO)
            .getter(getter(HumanLoopConfig::publicWorkforceTaskPrice)).setter(setter(Builder::publicWorkforceTaskPrice))
            .constructor(PublicWorkforceTaskPrice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicWorkforceTaskPrice").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKTEAM_ARN_FIELD,
            HUMAN_TASK_UI_ARN_FIELD, TASK_TITLE_FIELD, TASK_DESCRIPTION_FIELD, TASK_COUNT_FIELD,
            TASK_AVAILABILITY_LIFETIME_IN_SECONDS_FIELD, TASK_TIME_LIMIT_IN_SECONDS_FIELD, TASK_KEYWORDS_FIELD,
            PUBLIC_WORKFORCE_TASK_PRICE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String workteamArn;

    private final String humanTaskUiArn;

    private final String taskTitle;

    private final String taskDescription;

    private final Integer taskCount;

    private final Integer taskAvailabilityLifetimeInSeconds;

    private final Integer taskTimeLimitInSeconds;

    private final List<String> taskKeywords;

    private final PublicWorkforceTaskPrice publicWorkforceTaskPrice;

    private HumanLoopConfig(BuilderImpl builder) {
        this.workteamArn = builder.workteamArn;
        this.humanTaskUiArn = builder.humanTaskUiArn;
        this.taskTitle = builder.taskTitle;
        this.taskDescription = builder.taskDescription;
        this.taskCount = builder.taskCount;
        this.taskAvailabilityLifetimeInSeconds = builder.taskAvailabilityLifetimeInSeconds;
        this.taskTimeLimitInSeconds = builder.taskTimeLimitInSeconds;
        this.taskKeywords = builder.taskKeywords;
        this.publicWorkforceTaskPrice = builder.publicWorkforceTaskPrice;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of a team of workers.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of a team of workers.
     */
    public String workteamArn() {
        return workteamArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the human task user interface.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the human task user interface.
     */
    public String humanTaskUiArn() {
        return humanTaskUiArn;
    }

    /**
     * <p>
     * A title for the human worker task.
     * </p>
     * 
     * @return A title for the human worker task.
     */
    public String taskTitle() {
        return taskTitle;
    }

    /**
     * <p>
     * A description for the human worker task.
     * </p>
     * 
     * @return A description for the human worker task.
     */
    public String taskDescription() {
        return taskDescription;
    }

    /**
     * <p>
     * The number of distinct workers who will perform the same task on each object. For example, if
     * <code>TaskCount</code> is set to <code>3</code> for an image classification labeling job, three workers will
     * classify each input image. Increasing <code>TaskCount</code> can improve label accuracy.
     * </p>
     * 
     * @return The number of distinct workers who will perform the same task on each object. For example, if
     *         <code>TaskCount</code> is set to <code>3</code> for an image classification labeling job, three workers
     *         will classify each input image. Increasing <code>TaskCount</code> can improve label accuracy.
     */
    public Integer taskCount() {
        return taskCount;
    }

    /**
     * <p>
     * The length of time that a task remains available for labeling by human workers.
     * </p>
     * 
     * @return The length of time that a task remains available for labeling by human workers.
     */
    public Integer taskAvailabilityLifetimeInSeconds() {
        return taskAvailabilityLifetimeInSeconds;
    }

    /**
     * <p>
     * The amount of time that a worker has to complete a task.
     * </p>
     * 
     * @return The amount of time that a worker has to complete a task.
     */
    public Integer taskTimeLimitInSeconds() {
        return taskTimeLimitInSeconds;
    }

    /**
     * Returns true if the TaskKeywords property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTaskKeywords() {
        return taskKeywords != null && !(taskKeywords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Keywords used to describe the task so that workers can discover the task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTaskKeywords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Keywords used to describe the task so that workers can discover the task.
     */
    public List<String> taskKeywords() {
        return taskKeywords;
    }

    /**
     * Returns the value of the PublicWorkforceTaskPrice property for this object.
     * 
     * @return The value of the PublicWorkforceTaskPrice property for this object.
     */
    public PublicWorkforceTaskPrice publicWorkforceTaskPrice() {
        return publicWorkforceTaskPrice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workteamArn());
        hashCode = 31 * hashCode + Objects.hashCode(humanTaskUiArn());
        hashCode = 31 * hashCode + Objects.hashCode(taskTitle());
        hashCode = 31 * hashCode + Objects.hashCode(taskDescription());
        hashCode = 31 * hashCode + Objects.hashCode(taskCount());
        hashCode = 31 * hashCode + Objects.hashCode(taskAvailabilityLifetimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(taskTimeLimitInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(taskKeywords());
        hashCode = 31 * hashCode + Objects.hashCode(publicWorkforceTaskPrice());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanLoopConfig)) {
            return false;
        }
        HumanLoopConfig other = (HumanLoopConfig) obj;
        return Objects.equals(workteamArn(), other.workteamArn()) && Objects.equals(humanTaskUiArn(), other.humanTaskUiArn())
                && Objects.equals(taskTitle(), other.taskTitle()) && Objects.equals(taskDescription(), other.taskDescription())
                && Objects.equals(taskCount(), other.taskCount())
                && Objects.equals(taskAvailabilityLifetimeInSeconds(), other.taskAvailabilityLifetimeInSeconds())
                && Objects.equals(taskTimeLimitInSeconds(), other.taskTimeLimitInSeconds())
                && Objects.equals(taskKeywords(), other.taskKeywords())
                && Objects.equals(publicWorkforceTaskPrice(), other.publicWorkforceTaskPrice());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HumanLoopConfig").add("WorkteamArn", workteamArn()).add("HumanTaskUiArn", humanTaskUiArn())
                .add("TaskTitle", taskTitle()).add("TaskDescription", taskDescription()).add("TaskCount", taskCount())
                .add("TaskAvailabilityLifetimeInSeconds", taskAvailabilityLifetimeInSeconds())
                .add("TaskTimeLimitInSeconds", taskTimeLimitInSeconds()).add("TaskKeywords", taskKeywords())
                .add("PublicWorkforceTaskPrice", publicWorkforceTaskPrice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkteamArn":
            return Optional.ofNullable(clazz.cast(workteamArn()));
        case "HumanTaskUiArn":
            return Optional.ofNullable(clazz.cast(humanTaskUiArn()));
        case "TaskTitle":
            return Optional.ofNullable(clazz.cast(taskTitle()));
        case "TaskDescription":
            return Optional.ofNullable(clazz.cast(taskDescription()));
        case "TaskCount":
            return Optional.ofNullable(clazz.cast(taskCount()));
        case "TaskAvailabilityLifetimeInSeconds":
            return Optional.ofNullable(clazz.cast(taskAvailabilityLifetimeInSeconds()));
        case "TaskTimeLimitInSeconds":
            return Optional.ofNullable(clazz.cast(taskTimeLimitInSeconds()));
        case "TaskKeywords":
            return Optional.ofNullable(clazz.cast(taskKeywords()));
        case "PublicWorkforceTaskPrice":
            return Optional.ofNullable(clazz.cast(publicWorkforceTaskPrice()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HumanLoopConfig, T> g) {
        return obj -> g.apply((HumanLoopConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HumanLoopConfig> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of a team of workers.
         * </p>
         * 
         * @param workteamArn
         *        Amazon Resource Name (ARN) of a team of workers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workteamArn(String workteamArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the human task user interface.
         * </p>
         * 
         * @param humanTaskUiArn
         *        The Amazon Resource Name (ARN) of the human task user interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanTaskUiArn(String humanTaskUiArn);

        /**
         * <p>
         * A title for the human worker task.
         * </p>
         * 
         * @param taskTitle
         *        A title for the human worker task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskTitle(String taskTitle);

        /**
         * <p>
         * A description for the human worker task.
         * </p>
         * 
         * @param taskDescription
         *        A description for the human worker task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskDescription(String taskDescription);

        /**
         * <p>
         * The number of distinct workers who will perform the same task on each object. For example, if
         * <code>TaskCount</code> is set to <code>3</code> for an image classification labeling job, three workers will
         * classify each input image. Increasing <code>TaskCount</code> can improve label accuracy.
         * </p>
         * 
         * @param taskCount
         *        The number of distinct workers who will perform the same task on each object. For example, if
         *        <code>TaskCount</code> is set to <code>3</code> for an image classification labeling job, three
         *        workers will classify each input image. Increasing <code>TaskCount</code> can improve label accuracy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskCount(Integer taskCount);

        /**
         * <p>
         * The length of time that a task remains available for labeling by human workers.
         * </p>
         * 
         * @param taskAvailabilityLifetimeInSeconds
         *        The length of time that a task remains available for labeling by human workers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskAvailabilityLifetimeInSeconds(Integer taskAvailabilityLifetimeInSeconds);

        /**
         * <p>
         * The amount of time that a worker has to complete a task.
         * </p>
         * 
         * @param taskTimeLimitInSeconds
         *        The amount of time that a worker has to complete a task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskTimeLimitInSeconds(Integer taskTimeLimitInSeconds);

        /**
         * <p>
         * Keywords used to describe the task so that workers can discover the task.
         * </p>
         * 
         * @param taskKeywords
         *        Keywords used to describe the task so that workers can discover the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskKeywords(Collection<String> taskKeywords);

        /**
         * <p>
         * Keywords used to describe the task so that workers can discover the task.
         * </p>
         * 
         * @param taskKeywords
         *        Keywords used to describe the task so that workers can discover the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskKeywords(String... taskKeywords);

        /**
         * Sets the value of the PublicWorkforceTaskPrice property for this object.
         *
         * @param publicWorkforceTaskPrice
         *        The new value for the PublicWorkforceTaskPrice property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicWorkforceTaskPrice(PublicWorkforceTaskPrice publicWorkforceTaskPrice);

        /**
         * Sets the value of the PublicWorkforceTaskPrice property for this object.
         *
         * This is a convenience that creates an instance of the {@link PublicWorkforceTaskPrice.Builder} avoiding the
         * need to create one manually via {@link PublicWorkforceTaskPrice#builder()}.
         *
         * When the {@link Consumer} completes, {@link PublicWorkforceTaskPrice.Builder#build()} is called immediately
         * and its result is passed to {@link #publicWorkforceTaskPrice(PublicWorkforceTaskPrice)}.
         * 
         * @param publicWorkforceTaskPrice
         *        a consumer that will call methods on {@link PublicWorkforceTaskPrice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publicWorkforceTaskPrice(PublicWorkforceTaskPrice)
         */
        default Builder publicWorkforceTaskPrice(Consumer<PublicWorkforceTaskPrice.Builder> publicWorkforceTaskPrice) {
            return publicWorkforceTaskPrice(PublicWorkforceTaskPrice.builder().applyMutation(publicWorkforceTaskPrice).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String workteamArn;

        private String humanTaskUiArn;

        private String taskTitle;

        private String taskDescription;

        private Integer taskCount;

        private Integer taskAvailabilityLifetimeInSeconds;

        private Integer taskTimeLimitInSeconds;

        private List<String> taskKeywords = DefaultSdkAutoConstructList.getInstance();

        private PublicWorkforceTaskPrice publicWorkforceTaskPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(HumanLoopConfig model) {
            workteamArn(model.workteamArn);
            humanTaskUiArn(model.humanTaskUiArn);
            taskTitle(model.taskTitle);
            taskDescription(model.taskDescription);
            taskCount(model.taskCount);
            taskAvailabilityLifetimeInSeconds(model.taskAvailabilityLifetimeInSeconds);
            taskTimeLimitInSeconds(model.taskTimeLimitInSeconds);
            taskKeywords(model.taskKeywords);
            publicWorkforceTaskPrice(model.publicWorkforceTaskPrice);
        }

        public final String getWorkteamArn() {
            return workteamArn;
        }

        @Override
        public final Builder workteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
            return this;
        }

        public final void setWorkteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
        }

        public final String getHumanTaskUiArn() {
            return humanTaskUiArn;
        }

        @Override
        public final Builder humanTaskUiArn(String humanTaskUiArn) {
            this.humanTaskUiArn = humanTaskUiArn;
            return this;
        }

        public final void setHumanTaskUiArn(String humanTaskUiArn) {
            this.humanTaskUiArn = humanTaskUiArn;
        }

        public final String getTaskTitle() {
            return taskTitle;
        }

        @Override
        public final Builder taskTitle(String taskTitle) {
            this.taskTitle = taskTitle;
            return this;
        }

        public final void setTaskTitle(String taskTitle) {
            this.taskTitle = taskTitle;
        }

        public final String getTaskDescription() {
            return taskDescription;
        }

        @Override
        public final Builder taskDescription(String taskDescription) {
            this.taskDescription = taskDescription;
            return this;
        }

        public final void setTaskDescription(String taskDescription) {
            this.taskDescription = taskDescription;
        }

        public final Integer getTaskCount() {
            return taskCount;
        }

        @Override
        public final Builder taskCount(Integer taskCount) {
            this.taskCount = taskCount;
            return this;
        }

        public final void setTaskCount(Integer taskCount) {
            this.taskCount = taskCount;
        }

        public final Integer getTaskAvailabilityLifetimeInSeconds() {
            return taskAvailabilityLifetimeInSeconds;
        }

        @Override
        public final Builder taskAvailabilityLifetimeInSeconds(Integer taskAvailabilityLifetimeInSeconds) {
            this.taskAvailabilityLifetimeInSeconds = taskAvailabilityLifetimeInSeconds;
            return this;
        }

        public final void setTaskAvailabilityLifetimeInSeconds(Integer taskAvailabilityLifetimeInSeconds) {
            this.taskAvailabilityLifetimeInSeconds = taskAvailabilityLifetimeInSeconds;
        }

        public final Integer getTaskTimeLimitInSeconds() {
            return taskTimeLimitInSeconds;
        }

        @Override
        public final Builder taskTimeLimitInSeconds(Integer taskTimeLimitInSeconds) {
            this.taskTimeLimitInSeconds = taskTimeLimitInSeconds;
            return this;
        }

        public final void setTaskTimeLimitInSeconds(Integer taskTimeLimitInSeconds) {
            this.taskTimeLimitInSeconds = taskTimeLimitInSeconds;
        }

        public final Collection<String> getTaskKeywords() {
            return taskKeywords;
        }

        @Override
        public final Builder taskKeywords(Collection<String> taskKeywords) {
            this.taskKeywords = FlowDefinitionTaskKeywordsCopier.copy(taskKeywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskKeywords(String... taskKeywords) {
            taskKeywords(Arrays.asList(taskKeywords));
            return this;
        }

        public final void setTaskKeywords(Collection<String> taskKeywords) {
            this.taskKeywords = FlowDefinitionTaskKeywordsCopier.copy(taskKeywords);
        }

        public final PublicWorkforceTaskPrice.Builder getPublicWorkforceTaskPrice() {
            return publicWorkforceTaskPrice != null ? publicWorkforceTaskPrice.toBuilder() : null;
        }

        @Override
        public final Builder publicWorkforceTaskPrice(PublicWorkforceTaskPrice publicWorkforceTaskPrice) {
            this.publicWorkforceTaskPrice = publicWorkforceTaskPrice;
            return this;
        }

        public final void setPublicWorkforceTaskPrice(PublicWorkforceTaskPrice.BuilderImpl publicWorkforceTaskPrice) {
            this.publicWorkforceTaskPrice = publicWorkforceTaskPrice != null ? publicWorkforceTaskPrice.build() : null;
        }

        @Override
        public HumanLoopConfig build() {
            return new HumanLoopConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
