/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFlowDefinitionResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeFlowDefinitionResponse.Builder, DescribeFlowDefinitionResponse> {
    private static final SdkField<String> FLOW_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeFlowDefinitionResponse::flowDefinitionArn)).setter(setter(Builder::flowDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionArn").build()).build();

    private static final SdkField<String> FLOW_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeFlowDefinitionResponse::flowDefinitionName)).setter(setter(Builder::flowDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionName").build())
            .build();

    private static final SdkField<String> FLOW_DEFINITION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeFlowDefinitionResponse::flowDefinitionStatusAsString))
            .setter(setter(Builder::flowDefinitionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowDefinitionStatus").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeFlowDefinitionResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<HumanLoopRequestSource> HUMAN_LOOP_REQUEST_SOURCE_FIELD = SdkField
            .<HumanLoopRequestSource> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeFlowDefinitionResponse::humanLoopRequestSource))
            .setter(setter(Builder::humanLoopRequestSource)).constructor(HumanLoopRequestSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopRequestSource").build())
            .build();

    private static final SdkField<HumanLoopActivationConfig> HUMAN_LOOP_ACTIVATION_CONFIG_FIELD = SdkField
            .<HumanLoopActivationConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeFlowDefinitionResponse::humanLoopActivationConfig))
            .setter(setter(Builder::humanLoopActivationConfig)).constructor(HumanLoopActivationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopActivationConfig").build())
            .build();

    private static final SdkField<HumanLoopConfig> HUMAN_LOOP_CONFIG_FIELD = SdkField
            .<HumanLoopConfig> builder(MarshallingType.SDK_POJO).getter(getter(DescribeFlowDefinitionResponse::humanLoopConfig))
            .setter(setter(Builder::humanLoopConfig)).constructor(HumanLoopConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanLoopConfig").build()).build();

    private static final SdkField<FlowDefinitionOutputConfig> OUTPUT_CONFIG_FIELD = SdkField
            .<FlowDefinitionOutputConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeFlowDefinitionResponse::outputConfig)).setter(setter(Builder::outputConfig))
            .constructor(FlowDefinitionOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeFlowDefinitionResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeFlowDefinitionResponse::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_DEFINITION_ARN_FIELD,
            FLOW_DEFINITION_NAME_FIELD, FLOW_DEFINITION_STATUS_FIELD, CREATION_TIME_FIELD, HUMAN_LOOP_REQUEST_SOURCE_FIELD,
            HUMAN_LOOP_ACTIVATION_CONFIG_FIELD, HUMAN_LOOP_CONFIG_FIELD, OUTPUT_CONFIG_FIELD, ROLE_ARN_FIELD,
            FAILURE_REASON_FIELD));

    private final String flowDefinitionArn;

    private final String flowDefinitionName;

    private final String flowDefinitionStatus;

    private final Instant creationTime;

    private final HumanLoopRequestSource humanLoopRequestSource;

    private final HumanLoopActivationConfig humanLoopActivationConfig;

    private final HumanLoopConfig humanLoopConfig;

    private final FlowDefinitionOutputConfig outputConfig;

    private final String roleArn;

    private final String failureReason;

    private DescribeFlowDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.flowDefinitionArn = builder.flowDefinitionArn;
        this.flowDefinitionName = builder.flowDefinitionName;
        this.flowDefinitionStatus = builder.flowDefinitionStatus;
        this.creationTime = builder.creationTime;
        this.humanLoopRequestSource = builder.humanLoopRequestSource;
        this.humanLoopActivationConfig = builder.humanLoopActivationConfig;
        this.humanLoopConfig = builder.humanLoopConfig;
        this.outputConfig = builder.outputConfig;
        this.roleArn = builder.roleArn;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the flow defintion.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the flow defintion.
     */
    public String flowDefinitionArn() {
        return flowDefinitionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the flow definition.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the flow definition.
     */
    public String flowDefinitionName() {
        return flowDefinitionName;
    }

    /**
     * <p>
     * The status of the flow definition. Valid values are listed below.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flowDefinitionStatus} will return {@link FlowDefinitionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #flowDefinitionStatusAsString}.
     * </p>
     * 
     * @return The status of the flow definition. Valid values are listed below.
     * @see FlowDefinitionStatus
     */
    public FlowDefinitionStatus flowDefinitionStatus() {
        return FlowDefinitionStatus.fromValue(flowDefinitionStatus);
    }

    /**
     * <p>
     * The status of the flow definition. Valid values are listed below.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flowDefinitionStatus} will return {@link FlowDefinitionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #flowDefinitionStatusAsString}.
     * </p>
     * 
     * @return The status of the flow definition. Valid values are listed below.
     * @see FlowDefinitionStatus
     */
    public String flowDefinitionStatusAsString() {
        return flowDefinitionStatus;
    }

    /**
     * <p>
     * The timestamp when the flow definition was created.
     * </p>
     * 
     * @return The timestamp when the flow definition was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Container for configuring the source of human task requests. Used to specify if Amazon Rekognition or Amazon
     * Textract is used as an integration source.
     * </p>
     * 
     * @return Container for configuring the source of human task requests. Used to specify if Amazon Rekognition or
     *         Amazon Textract is used as an integration source.
     */
    public HumanLoopRequestSource humanLoopRequestSource() {
        return humanLoopRequestSource;
    }

    /**
     * <p>
     * An object containing information about what triggers a human review workflow.
     * </p>
     * 
     * @return An object containing information about what triggers a human review workflow.
     */
    public HumanLoopActivationConfig humanLoopActivationConfig() {
        return humanLoopActivationConfig;
    }

    /**
     * <p>
     * An object containing information about who works on the task, the workforce task price, and other task details.
     * </p>
     * 
     * @return An object containing information about who works on the task, the workforce task price, and other task
     *         details.
     */
    public HumanLoopConfig humanLoopConfig() {
        return humanLoopConfig;
    }

    /**
     * <p>
     * An object containing information about the output file.
     * </p>
     * 
     * @return An object containing information about the output file.
     */
    public FlowDefinitionOutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) execution role for the flow
     * definition.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) execution role for the
     *         flow definition.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The reason your flow definition failed.
     * </p>
     * 
     * @return The reason your flow definition failed.
     */
    public String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(flowDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(flowDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(flowDefinitionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopRequestSource());
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopActivationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(humanLoopConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFlowDefinitionResponse)) {
            return false;
        }
        DescribeFlowDefinitionResponse other = (DescribeFlowDefinitionResponse) obj;
        return Objects.equals(flowDefinitionArn(), other.flowDefinitionArn())
                && Objects.equals(flowDefinitionName(), other.flowDefinitionName())
                && Objects.equals(flowDefinitionStatusAsString(), other.flowDefinitionStatusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(humanLoopRequestSource(), other.humanLoopRequestSource())
                && Objects.equals(humanLoopActivationConfig(), other.humanLoopActivationConfig())
                && Objects.equals(humanLoopConfig(), other.humanLoopConfig())
                && Objects.equals(outputConfig(), other.outputConfig()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeFlowDefinitionResponse").add("FlowDefinitionArn", flowDefinitionArn())
                .add("FlowDefinitionName", flowDefinitionName()).add("FlowDefinitionStatus", flowDefinitionStatusAsString())
                .add("CreationTime", creationTime()).add("HumanLoopRequestSource", humanLoopRequestSource())
                .add("HumanLoopActivationConfig", humanLoopActivationConfig()).add("HumanLoopConfig", humanLoopConfig())
                .add("OutputConfig", outputConfig()).add("RoleArn", roleArn()).add("FailureReason", failureReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FlowDefinitionArn":
            return Optional.ofNullable(clazz.cast(flowDefinitionArn()));
        case "FlowDefinitionName":
            return Optional.ofNullable(clazz.cast(flowDefinitionName()));
        case "FlowDefinitionStatus":
            return Optional.ofNullable(clazz.cast(flowDefinitionStatusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "HumanLoopRequestSource":
            return Optional.ofNullable(clazz.cast(humanLoopRequestSource()));
        case "HumanLoopActivationConfig":
            return Optional.ofNullable(clazz.cast(humanLoopActivationConfig()));
        case "HumanLoopConfig":
            return Optional.ofNullable(clazz.cast(humanLoopConfig()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFlowDefinitionResponse, T> g) {
        return obj -> g.apply((DescribeFlowDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFlowDefinitionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the flow defintion.
         * </p>
         * 
         * @param flowDefinitionArn
         *        The Amazon Resource Name (ARN) of the flow defintion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowDefinitionArn(String flowDefinitionArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the flow definition.
         * </p>
         * 
         * @param flowDefinitionName
         *        The Amazon Resource Name (ARN) of the flow definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowDefinitionName(String flowDefinitionName);

        /**
         * <p>
         * The status of the flow definition. Valid values are listed below.
         * </p>
         * 
         * @param flowDefinitionStatus
         *        The status of the flow definition. Valid values are listed below.
         * @see FlowDefinitionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowDefinitionStatus
         */
        Builder flowDefinitionStatus(String flowDefinitionStatus);

        /**
         * <p>
         * The status of the flow definition. Valid values are listed below.
         * </p>
         * 
         * @param flowDefinitionStatus
         *        The status of the flow definition. Valid values are listed below.
         * @see FlowDefinitionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowDefinitionStatus
         */
        Builder flowDefinitionStatus(FlowDefinitionStatus flowDefinitionStatus);

        /**
         * <p>
         * The timestamp when the flow definition was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp when the flow definition was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Container for configuring the source of human task requests. Used to specify if Amazon Rekognition or Amazon
         * Textract is used as an integration source.
         * </p>
         * 
         * @param humanLoopRequestSource
         *        Container for configuring the source of human task requests. Used to specify if Amazon Rekognition or
         *        Amazon Textract is used as an integration source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopRequestSource(HumanLoopRequestSource humanLoopRequestSource);

        /**
         * <p>
         * Container for configuring the source of human task requests. Used to specify if Amazon Rekognition or Amazon
         * Textract is used as an integration source.
         * </p>
         * This is a convenience that creates an instance of the {@link HumanLoopRequestSource.Builder} avoiding the
         * need to create one manually via {@link HumanLoopRequestSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link HumanLoopRequestSource.Builder#build()} is called immediately and
         * its result is passed to {@link #humanLoopRequestSource(HumanLoopRequestSource)}.
         * 
         * @param humanLoopRequestSource
         *        a consumer that will call methods on {@link HumanLoopRequestSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #humanLoopRequestSource(HumanLoopRequestSource)
         */
        default Builder humanLoopRequestSource(Consumer<HumanLoopRequestSource.Builder> humanLoopRequestSource) {
            return humanLoopRequestSource(HumanLoopRequestSource.builder().applyMutation(humanLoopRequestSource).build());
        }

        /**
         * <p>
         * An object containing information about what triggers a human review workflow.
         * </p>
         * 
         * @param humanLoopActivationConfig
         *        An object containing information about what triggers a human review workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopActivationConfig(HumanLoopActivationConfig humanLoopActivationConfig);

        /**
         * <p>
         * An object containing information about what triggers a human review workflow.
         * </p>
         * This is a convenience that creates an instance of the {@link HumanLoopActivationConfig.Builder} avoiding the
         * need to create one manually via {@link HumanLoopActivationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HumanLoopActivationConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #humanLoopActivationConfig(HumanLoopActivationConfig)}.
         * 
         * @param humanLoopActivationConfig
         *        a consumer that will call methods on {@link HumanLoopActivationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #humanLoopActivationConfig(HumanLoopActivationConfig)
         */
        default Builder humanLoopActivationConfig(Consumer<HumanLoopActivationConfig.Builder> humanLoopActivationConfig) {
            return humanLoopActivationConfig(HumanLoopActivationConfig.builder().applyMutation(humanLoopActivationConfig).build());
        }

        /**
         * <p>
         * An object containing information about who works on the task, the workforce task price, and other task
         * details.
         * </p>
         * 
         * @param humanLoopConfig
         *        An object containing information about who works on the task, the workforce task price, and other task
         *        details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanLoopConfig(HumanLoopConfig humanLoopConfig);

        /**
         * <p>
         * An object containing information about who works on the task, the workforce task price, and other task
         * details.
         * </p>
         * This is a convenience that creates an instance of the {@link HumanLoopConfig.Builder} avoiding the need to
         * create one manually via {@link HumanLoopConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link HumanLoopConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #humanLoopConfig(HumanLoopConfig)}.
         * 
         * @param humanLoopConfig
         *        a consumer that will call methods on {@link HumanLoopConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #humanLoopConfig(HumanLoopConfig)
         */
        default Builder humanLoopConfig(Consumer<HumanLoopConfig.Builder> humanLoopConfig) {
            return humanLoopConfig(HumanLoopConfig.builder().applyMutation(humanLoopConfig).build());
        }

        /**
         * <p>
         * An object containing information about the output file.
         * </p>
         * 
         * @param outputConfig
         *        An object containing information about the output file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(FlowDefinitionOutputConfig outputConfig);

        /**
         * <p>
         * An object containing information about the output file.
         * </p>
         * This is a convenience that creates an instance of the {@link FlowDefinitionOutputConfig.Builder} avoiding the
         * need to create one manually via {@link FlowDefinitionOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link FlowDefinitionOutputConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #outputConfig(FlowDefinitionOutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link FlowDefinitionOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(FlowDefinitionOutputConfig)
         */
        default Builder outputConfig(Consumer<FlowDefinitionOutputConfig.Builder> outputConfig) {
            return outputConfig(FlowDefinitionOutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) execution role for the flow
         * definition.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) execution role for the
         *        flow definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The reason your flow definition failed.
         * </p>
         * 
         * @param failureReason
         *        The reason your flow definition failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String flowDefinitionArn;

        private String flowDefinitionName;

        private String flowDefinitionStatus;

        private Instant creationTime;

        private HumanLoopRequestSource humanLoopRequestSource;

        private HumanLoopActivationConfig humanLoopActivationConfig;

        private HumanLoopConfig humanLoopConfig;

        private FlowDefinitionOutputConfig outputConfig;

        private String roleArn;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFlowDefinitionResponse model) {
            super(model);
            flowDefinitionArn(model.flowDefinitionArn);
            flowDefinitionName(model.flowDefinitionName);
            flowDefinitionStatus(model.flowDefinitionStatus);
            creationTime(model.creationTime);
            humanLoopRequestSource(model.humanLoopRequestSource);
            humanLoopActivationConfig(model.humanLoopActivationConfig);
            humanLoopConfig(model.humanLoopConfig);
            outputConfig(model.outputConfig);
            roleArn(model.roleArn);
            failureReason(model.failureReason);
        }

        public final String getFlowDefinitionArn() {
            return flowDefinitionArn;
        }

        @Override
        public final Builder flowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
            return this;
        }

        public final void setFlowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
        }

        public final String getFlowDefinitionName() {
            return flowDefinitionName;
        }

        @Override
        public final Builder flowDefinitionName(String flowDefinitionName) {
            this.flowDefinitionName = flowDefinitionName;
            return this;
        }

        public final void setFlowDefinitionName(String flowDefinitionName) {
            this.flowDefinitionName = flowDefinitionName;
        }

        public final String getFlowDefinitionStatus() {
            return flowDefinitionStatus;
        }

        @Override
        public final Builder flowDefinitionStatus(String flowDefinitionStatus) {
            this.flowDefinitionStatus = flowDefinitionStatus;
            return this;
        }

        @Override
        public final Builder flowDefinitionStatus(FlowDefinitionStatus flowDefinitionStatus) {
            this.flowDefinitionStatus(flowDefinitionStatus == null ? null : flowDefinitionStatus.toString());
            return this;
        }

        public final void setFlowDefinitionStatus(String flowDefinitionStatus) {
            this.flowDefinitionStatus = flowDefinitionStatus;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final HumanLoopRequestSource.Builder getHumanLoopRequestSource() {
            return humanLoopRequestSource != null ? humanLoopRequestSource.toBuilder() : null;
        }

        @Override
        public final Builder humanLoopRequestSource(HumanLoopRequestSource humanLoopRequestSource) {
            this.humanLoopRequestSource = humanLoopRequestSource;
            return this;
        }

        public final void setHumanLoopRequestSource(HumanLoopRequestSource.BuilderImpl humanLoopRequestSource) {
            this.humanLoopRequestSource = humanLoopRequestSource != null ? humanLoopRequestSource.build() : null;
        }

        public final HumanLoopActivationConfig.Builder getHumanLoopActivationConfig() {
            return humanLoopActivationConfig != null ? humanLoopActivationConfig.toBuilder() : null;
        }

        @Override
        public final Builder humanLoopActivationConfig(HumanLoopActivationConfig humanLoopActivationConfig) {
            this.humanLoopActivationConfig = humanLoopActivationConfig;
            return this;
        }

        public final void setHumanLoopActivationConfig(HumanLoopActivationConfig.BuilderImpl humanLoopActivationConfig) {
            this.humanLoopActivationConfig = humanLoopActivationConfig != null ? humanLoopActivationConfig.build() : null;
        }

        public final HumanLoopConfig.Builder getHumanLoopConfig() {
            return humanLoopConfig != null ? humanLoopConfig.toBuilder() : null;
        }

        @Override
        public final Builder humanLoopConfig(HumanLoopConfig humanLoopConfig) {
            this.humanLoopConfig = humanLoopConfig;
            return this;
        }

        public final void setHumanLoopConfig(HumanLoopConfig.BuilderImpl humanLoopConfig) {
            this.humanLoopConfig = humanLoopConfig != null ? humanLoopConfig.build() : null;
        }

        public final FlowDefinitionOutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputConfig(FlowDefinitionOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final void setOutputConfig(FlowDefinitionOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public DescribeFlowDefinitionResponse build() {
            return new DescribeFlowDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
