/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHumanTaskUiResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeHumanTaskUiResponse.Builder, DescribeHumanTaskUiResponse> {
    private static final SdkField<String> HUMAN_TASK_UI_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeHumanTaskUiResponse::humanTaskUiArn)).setter(setter(Builder::humanTaskUiArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanTaskUiArn").build()).build();

    private static final SdkField<String> HUMAN_TASK_UI_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeHumanTaskUiResponse::humanTaskUiName)).setter(setter(Builder::humanTaskUiName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanTaskUiName").build()).build();

    private static final SdkField<String> HUMAN_TASK_UI_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeHumanTaskUiResponse::humanTaskUiStatusAsString)).setter(setter(Builder::humanTaskUiStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanTaskUiStatus").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeHumanTaskUiResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<UiTemplateInfo> UI_TEMPLATE_FIELD = SdkField.<UiTemplateInfo> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeHumanTaskUiResponse::uiTemplate)).setter(setter(Builder::uiTemplate))
            .constructor(UiTemplateInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UiTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_TASK_UI_ARN_FIELD,
            HUMAN_TASK_UI_NAME_FIELD, HUMAN_TASK_UI_STATUS_FIELD, CREATION_TIME_FIELD, UI_TEMPLATE_FIELD));

    private final String humanTaskUiArn;

    private final String humanTaskUiName;

    private final String humanTaskUiStatus;

    private final Instant creationTime;

    private final UiTemplateInfo uiTemplate;

    private DescribeHumanTaskUiResponse(BuilderImpl builder) {
        super(builder);
        this.humanTaskUiArn = builder.humanTaskUiArn;
        this.humanTaskUiName = builder.humanTaskUiName;
        this.humanTaskUiStatus = builder.humanTaskUiStatus;
        this.creationTime = builder.creationTime;
        this.uiTemplate = builder.uiTemplate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the human task user interface (worker task template).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the human task user interface (worker task template).
     */
    public String humanTaskUiArn() {
        return humanTaskUiArn;
    }

    /**
     * <p>
     * The name of the human task user interface (worker task template).
     * </p>
     * 
     * @return The name of the human task user interface (worker task template).
     */
    public String humanTaskUiName() {
        return humanTaskUiName;
    }

    /**
     * <p>
     * The status of the human task user interface (worker task template). Valid values are listed below.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #humanTaskUiStatus}
     * will return {@link HumanTaskUiStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #humanTaskUiStatusAsString}.
     * </p>
     * 
     * @return The status of the human task user interface (worker task template). Valid values are listed below.
     * @see HumanTaskUiStatus
     */
    public HumanTaskUiStatus humanTaskUiStatus() {
        return HumanTaskUiStatus.fromValue(humanTaskUiStatus);
    }

    /**
     * <p>
     * The status of the human task user interface (worker task template). Valid values are listed below.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #humanTaskUiStatus}
     * will return {@link HumanTaskUiStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #humanTaskUiStatusAsString}.
     * </p>
     * 
     * @return The status of the human task user interface (worker task template). Valid values are listed below.
     * @see HumanTaskUiStatus
     */
    public String humanTaskUiStatusAsString() {
        return humanTaskUiStatus;
    }

    /**
     * <p>
     * The timestamp when the human task user interface was created.
     * </p>
     * 
     * @return The timestamp when the human task user interface was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the UiTemplate property for this object.
     * 
     * @return The value of the UiTemplate property for this object.
     */
    public UiTemplateInfo uiTemplate() {
        return uiTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(humanTaskUiArn());
        hashCode = 31 * hashCode + Objects.hashCode(humanTaskUiName());
        hashCode = 31 * hashCode + Objects.hashCode(humanTaskUiStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(uiTemplate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHumanTaskUiResponse)) {
            return false;
        }
        DescribeHumanTaskUiResponse other = (DescribeHumanTaskUiResponse) obj;
        return Objects.equals(humanTaskUiArn(), other.humanTaskUiArn())
                && Objects.equals(humanTaskUiName(), other.humanTaskUiName())
                && Objects.equals(humanTaskUiStatusAsString(), other.humanTaskUiStatusAsString())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(uiTemplate(), other.uiTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeHumanTaskUiResponse").add("HumanTaskUiArn", humanTaskUiArn())
                .add("HumanTaskUiName", humanTaskUiName()).add("HumanTaskUiStatus", humanTaskUiStatusAsString())
                .add("CreationTime", creationTime()).add("UiTemplate", uiTemplate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HumanTaskUiArn":
            return Optional.ofNullable(clazz.cast(humanTaskUiArn()));
        case "HumanTaskUiName":
            return Optional.ofNullable(clazz.cast(humanTaskUiName()));
        case "HumanTaskUiStatus":
            return Optional.ofNullable(clazz.cast(humanTaskUiStatusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "UiTemplate":
            return Optional.ofNullable(clazz.cast(uiTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHumanTaskUiResponse, T> g) {
        return obj -> g.apply((DescribeHumanTaskUiResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeHumanTaskUiResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the human task user interface (worker task template).
         * </p>
         * 
         * @param humanTaskUiArn
         *        The Amazon Resource Name (ARN) of the human task user interface (worker task template).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanTaskUiArn(String humanTaskUiArn);

        /**
         * <p>
         * The name of the human task user interface (worker task template).
         * </p>
         * 
         * @param humanTaskUiName
         *        The name of the human task user interface (worker task template).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanTaskUiName(String humanTaskUiName);

        /**
         * <p>
         * The status of the human task user interface (worker task template). Valid values are listed below.
         * </p>
         * 
         * @param humanTaskUiStatus
         *        The status of the human task user interface (worker task template). Valid values are listed below.
         * @see HumanTaskUiStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HumanTaskUiStatus
         */
        Builder humanTaskUiStatus(String humanTaskUiStatus);

        /**
         * <p>
         * The status of the human task user interface (worker task template). Valid values are listed below.
         * </p>
         * 
         * @param humanTaskUiStatus
         *        The status of the human task user interface (worker task template). Valid values are listed below.
         * @see HumanTaskUiStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HumanTaskUiStatus
         */
        Builder humanTaskUiStatus(HumanTaskUiStatus humanTaskUiStatus);

        /**
         * <p>
         * The timestamp when the human task user interface was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp when the human task user interface was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * Sets the value of the UiTemplate property for this object.
         *
         * @param uiTemplate
         *        The new value for the UiTemplate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uiTemplate(UiTemplateInfo uiTemplate);

        /**
         * Sets the value of the UiTemplate property for this object.
         *
         * This is a convenience that creates an instance of the {@link UiTemplateInfo.Builder} avoiding the need to
         * create one manually via {@link UiTemplateInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link UiTemplateInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #uiTemplate(UiTemplateInfo)}.
         * 
         * @param uiTemplate
         *        a consumer that will call methods on {@link UiTemplateInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uiTemplate(UiTemplateInfo)
         */
        default Builder uiTemplate(Consumer<UiTemplateInfo.Builder> uiTemplate) {
            return uiTemplate(UiTemplateInfo.builder().applyMutation(uiTemplate).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String humanTaskUiArn;

        private String humanTaskUiName;

        private String humanTaskUiStatus;

        private Instant creationTime;

        private UiTemplateInfo uiTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHumanTaskUiResponse model) {
            super(model);
            humanTaskUiArn(model.humanTaskUiArn);
            humanTaskUiName(model.humanTaskUiName);
            humanTaskUiStatus(model.humanTaskUiStatus);
            creationTime(model.creationTime);
            uiTemplate(model.uiTemplate);
        }

        public final String getHumanTaskUiArn() {
            return humanTaskUiArn;
        }

        @Override
        public final Builder humanTaskUiArn(String humanTaskUiArn) {
            this.humanTaskUiArn = humanTaskUiArn;
            return this;
        }

        public final void setHumanTaskUiArn(String humanTaskUiArn) {
            this.humanTaskUiArn = humanTaskUiArn;
        }

        public final String getHumanTaskUiName() {
            return humanTaskUiName;
        }

        @Override
        public final Builder humanTaskUiName(String humanTaskUiName) {
            this.humanTaskUiName = humanTaskUiName;
            return this;
        }

        public final void setHumanTaskUiName(String humanTaskUiName) {
            this.humanTaskUiName = humanTaskUiName;
        }

        public final String getHumanTaskUiStatus() {
            return humanTaskUiStatus;
        }

        @Override
        public final Builder humanTaskUiStatus(String humanTaskUiStatus) {
            this.humanTaskUiStatus = humanTaskUiStatus;
            return this;
        }

        @Override
        public final Builder humanTaskUiStatus(HumanTaskUiStatus humanTaskUiStatus) {
            this.humanTaskUiStatus(humanTaskUiStatus == null ? null : humanTaskUiStatus.toString());
            return this;
        }

        public final void setHumanTaskUiStatus(String humanTaskUiStatus) {
            this.humanTaskUiStatus = humanTaskUiStatus;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final UiTemplateInfo.Builder getUiTemplate() {
            return uiTemplate != null ? uiTemplate.toBuilder() : null;
        }

        @Override
        public final Builder uiTemplate(UiTemplateInfo uiTemplate) {
            this.uiTemplate = uiTemplate;
            return this;
        }

        public final void setUiTemplate(UiTemplateInfo.BuilderImpl uiTemplate) {
            this.uiTemplate = uiTemplate != null ? uiTemplate.build() : null;
        }

        @Override
        public DescribeHumanTaskUiResponse build() {
            return new DescribeHumanTaskUiResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
