/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Your Amazon Cognito workforce configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OidcConfigForResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<OidcConfigForResponse.Builder, OidcConfigForResponse> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OidcConfigForResponse::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()).build();

    private static final SdkField<String> ISSUER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OidcConfigForResponse::issuer)).setter(setter(Builder::issuer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()).build();

    private static final SdkField<String> AUTHORIZATION_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OidcConfigForResponse::authorizationEndpoint)).setter(setter(Builder::authorizationEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationEndpoint").build())
            .build();

    private static final SdkField<String> TOKEN_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OidcConfigForResponse::tokenEndpoint)).setter(setter(Builder::tokenEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenEndpoint").build()).build();

    private static final SdkField<String> USER_INFO_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OidcConfigForResponse::userInfoEndpoint)).setter(setter(Builder::userInfoEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserInfoEndpoint").build()).build();

    private static final SdkField<String> LOGOUT_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OidcConfigForResponse::logoutEndpoint)).setter(setter(Builder::logoutEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogoutEndpoint").build()).build();

    private static final SdkField<String> JWKS_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OidcConfigForResponse::jwksUri)).setter(setter(Builder::jwksUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JwksUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, ISSUER_FIELD,
            AUTHORIZATION_ENDPOINT_FIELD, TOKEN_ENDPOINT_FIELD, USER_INFO_ENDPOINT_FIELD, LOGOUT_ENDPOINT_FIELD, JWKS_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clientId;

    private final String issuer;

    private final String authorizationEndpoint;

    private final String tokenEndpoint;

    private final String userInfoEndpoint;

    private final String logoutEndpoint;

    private final String jwksUri;

    private OidcConfigForResponse(BuilderImpl builder) {
        this.clientId = builder.clientId;
        this.issuer = builder.issuer;
        this.authorizationEndpoint = builder.authorizationEndpoint;
        this.tokenEndpoint = builder.tokenEndpoint;
        this.userInfoEndpoint = builder.userInfoEndpoint;
        this.logoutEndpoint = builder.logoutEndpoint;
        this.jwksUri = builder.jwksUri;
    }

    /**
     * <p>
     * The OIDC IdP client ID used to configure your private workforce.
     * </p>
     * 
     * @return The OIDC IdP client ID used to configure your private workforce.
     */
    public String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The OIDC IdP issuer used to configure your private workforce.
     * </p>
     * 
     * @return The OIDC IdP issuer used to configure your private workforce.
     */
    public String issuer() {
        return issuer;
    }

    /**
     * <p>
     * The OIDC IdP authorization endpoint used to configure your private workforce.
     * </p>
     * 
     * @return The OIDC IdP authorization endpoint used to configure your private workforce.
     */
    public String authorizationEndpoint() {
        return authorizationEndpoint;
    }

    /**
     * <p>
     * The OIDC IdP token endpoint used to configure your private workforce.
     * </p>
     * 
     * @return The OIDC IdP token endpoint used to configure your private workforce.
     */
    public String tokenEndpoint() {
        return tokenEndpoint;
    }

    /**
     * <p>
     * The OIDC IdP user information endpoint used to configure your private workforce.
     * </p>
     * 
     * @return The OIDC IdP user information endpoint used to configure your private workforce.
     */
    public String userInfoEndpoint() {
        return userInfoEndpoint;
    }

    /**
     * <p>
     * The OIDC IdP logout endpoint used to configure your private workforce.
     * </p>
     * 
     * @return The OIDC IdP logout endpoint used to configure your private workforce.
     */
    public String logoutEndpoint() {
        return logoutEndpoint;
    }

    /**
     * <p>
     * The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.
     * </p>
     * 
     * @return The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.
     */
    public String jwksUri() {
        return jwksUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(issuer());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(tokenEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(userInfoEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(logoutEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(jwksUri());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OidcConfigForResponse)) {
            return false;
        }
        OidcConfigForResponse other = (OidcConfigForResponse) obj;
        return Objects.equals(clientId(), other.clientId()) && Objects.equals(issuer(), other.issuer())
                && Objects.equals(authorizationEndpoint(), other.authorizationEndpoint())
                && Objects.equals(tokenEndpoint(), other.tokenEndpoint())
                && Objects.equals(userInfoEndpoint(), other.userInfoEndpoint())
                && Objects.equals(logoutEndpoint(), other.logoutEndpoint()) && Objects.equals(jwksUri(), other.jwksUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OidcConfigForResponse").add("ClientId", clientId()).add("Issuer", issuer())
                .add("AuthorizationEndpoint", authorizationEndpoint()).add("TokenEndpoint", tokenEndpoint())
                .add("UserInfoEndpoint", userInfoEndpoint()).add("LogoutEndpoint", logoutEndpoint()).add("JwksUri", jwksUri())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "Issuer":
            return Optional.ofNullable(clazz.cast(issuer()));
        case "AuthorizationEndpoint":
            return Optional.ofNullable(clazz.cast(authorizationEndpoint()));
        case "TokenEndpoint":
            return Optional.ofNullable(clazz.cast(tokenEndpoint()));
        case "UserInfoEndpoint":
            return Optional.ofNullable(clazz.cast(userInfoEndpoint()));
        case "LogoutEndpoint":
            return Optional.ofNullable(clazz.cast(logoutEndpoint()));
        case "JwksUri":
            return Optional.ofNullable(clazz.cast(jwksUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OidcConfigForResponse, T> g) {
        return obj -> g.apply((OidcConfigForResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OidcConfigForResponse> {
        /**
         * <p>
         * The OIDC IdP client ID used to configure your private workforce.
         * </p>
         * 
         * @param clientId
         *        The OIDC IdP client ID used to configure your private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The OIDC IdP issuer used to configure your private workforce.
         * </p>
         * 
         * @param issuer
         *        The OIDC IdP issuer used to configure your private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuer(String issuer);

        /**
         * <p>
         * The OIDC IdP authorization endpoint used to configure your private workforce.
         * </p>
         * 
         * @param authorizationEndpoint
         *        The OIDC IdP authorization endpoint used to configure your private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationEndpoint(String authorizationEndpoint);

        /**
         * <p>
         * The OIDC IdP token endpoint used to configure your private workforce.
         * </p>
         * 
         * @param tokenEndpoint
         *        The OIDC IdP token endpoint used to configure your private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenEndpoint(String tokenEndpoint);

        /**
         * <p>
         * The OIDC IdP user information endpoint used to configure your private workforce.
         * </p>
         * 
         * @param userInfoEndpoint
         *        The OIDC IdP user information endpoint used to configure your private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userInfoEndpoint(String userInfoEndpoint);

        /**
         * <p>
         * The OIDC IdP logout endpoint used to configure your private workforce.
         * </p>
         * 
         * @param logoutEndpoint
         *        The OIDC IdP logout endpoint used to configure your private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logoutEndpoint(String logoutEndpoint);

        /**
         * <p>
         * The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.
         * </p>
         * 
         * @param jwksUri
         *        The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jwksUri(String jwksUri);
    }

    static final class BuilderImpl implements Builder {
        private String clientId;

        private String issuer;

        private String authorizationEndpoint;

        private String tokenEndpoint;

        private String userInfoEndpoint;

        private String logoutEndpoint;

        private String jwksUri;

        private BuilderImpl() {
        }

        private BuilderImpl(OidcConfigForResponse model) {
            clientId(model.clientId);
            issuer(model.issuer);
            authorizationEndpoint(model.authorizationEndpoint);
            tokenEndpoint(model.tokenEndpoint);
            userInfoEndpoint(model.userInfoEndpoint);
            logoutEndpoint(model.logoutEndpoint);
            jwksUri(model.jwksUri);
        }

        public final String getClientId() {
            return clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getIssuer() {
            return issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        public final String getAuthorizationEndpoint() {
            return authorizationEndpoint;
        }

        @Override
        public final Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public final void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        public final String getTokenEndpoint() {
            return tokenEndpoint;
        }

        @Override
        public final Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public final void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        public final String getUserInfoEndpoint() {
            return userInfoEndpoint;
        }

        @Override
        public final Builder userInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
            return this;
        }

        public final void setUserInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
        }

        public final String getLogoutEndpoint() {
            return logoutEndpoint;
        }

        @Override
        public final Builder logoutEndpoint(String logoutEndpoint) {
            this.logoutEndpoint = logoutEndpoint;
            return this;
        }

        public final void setLogoutEndpoint(String logoutEndpoint) {
            this.logoutEndpoint = logoutEndpoint;
        }

        public final String getJwksUri() {
            return jwksUri;
        }

        @Override
        public final Builder jwksUri(String jwksUri) {
            this.jwksUri = jwksUri;
            return this;
        }

        public final void setJwksUri(String jwksUri) {
            this.jwksUri = jwksUri;
        }

        @Override
        public OidcConfigForResponse build() {
            return new OidcConfigForResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
