/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCandidatesForAutoMlJobResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListCandidatesForAutoMlJobResponse.Builder, ListCandidatesForAutoMlJobResponse> {
    private static final SdkField<List<AutoMLCandidate>> CANDIDATES_FIELD = SdkField
            .<List<AutoMLCandidate>> builder(MarshallingType.LIST)
            .getter(getter(ListCandidatesForAutoMlJobResponse::candidates))
            .setter(setter(Builder::candidates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Candidates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoMLCandidate> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoMLCandidate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCandidatesForAutoMlJobResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANDIDATES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AutoMLCandidate> candidates;

    private final String nextToken;

    private ListCandidatesForAutoMlJobResponse(BuilderImpl builder) {
        super(builder);
        this.candidates = builder.candidates;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Candidates property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCandidates() {
        return candidates != null && !(candidates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summaries about the Candidates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCandidates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Summaries about the Candidates.
     */
    public List<AutoMLCandidate> candidates() {
        return candidates;
    }

    /**
     * <p>
     * If the previous response was truncated, you receive this token. Use it in your next request to receive the next
     * set of results.
     * </p>
     * 
     * @return If the previous response was truncated, you receive this token. Use it in your next request to receive
     *         the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(candidates());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCandidatesForAutoMlJobResponse)) {
            return false;
        }
        ListCandidatesForAutoMlJobResponse other = (ListCandidatesForAutoMlJobResponse) obj;
        return Objects.equals(candidates(), other.candidates()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListCandidatesForAutoMlJobResponse").add("Candidates", candidates())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Candidates":
            return Optional.ofNullable(clazz.cast(candidates()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCandidatesForAutoMlJobResponse, T> g) {
        return obj -> g.apply((ListCandidatesForAutoMlJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCandidatesForAutoMlJobResponse> {
        /**
         * <p>
         * Summaries about the Candidates.
         * </p>
         * 
         * @param candidates
         *        Summaries about the Candidates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder candidates(Collection<AutoMLCandidate> candidates);

        /**
         * <p>
         * Summaries about the Candidates.
         * </p>
         * 
         * @param candidates
         *        Summaries about the Candidates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder candidates(AutoMLCandidate... candidates);

        /**
         * <p>
         * Summaries about the Candidates.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AutoMLCandidate>.Builder} avoiding the need
         * to create one manually via {@link List<AutoMLCandidate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AutoMLCandidate>.Builder#build()} is called immediately and
         * its result is passed to {@link #candidates(List<AutoMLCandidate>)}.
         * 
         * @param candidates
         *        a consumer that will call methods on {@link List<AutoMLCandidate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #candidates(List<AutoMLCandidate>)
         */
        Builder candidates(Consumer<AutoMLCandidate.Builder>... candidates);

        /**
         * <p>
         * If the previous response was truncated, you receive this token. Use it in your next request to receive the
         * next set of results.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was truncated, you receive this token. Use it in your next request to receive
         *        the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<AutoMLCandidate> candidates = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCandidatesForAutoMlJobResponse model) {
            super(model);
            candidates(model.candidates);
            nextToken(model.nextToken);
        }

        public final Collection<AutoMLCandidate.Builder> getCandidates() {
            return candidates != null ? candidates.stream().map(AutoMLCandidate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder candidates(Collection<AutoMLCandidate> candidates) {
            this.candidates = AutoMLCandidatesCopier.copy(candidates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder candidates(AutoMLCandidate... candidates) {
            candidates(Arrays.asList(candidates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder candidates(Consumer<AutoMLCandidate.Builder>... candidates) {
            candidates(Stream.of(candidates).map(c -> AutoMLCandidate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCandidates(Collection<AutoMLCandidate.BuilderImpl> candidates) {
            this.candidates = AutoMLCandidatesCopier.copyFromBuilder(candidates);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCandidatesForAutoMlJobResponse build() {
            return new ListCandidatesForAutoMlJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
