/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines an Amazon Cognito or your own OIDC IdP user group that is part of a work team.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemberDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<MemberDefinition.Builder, MemberDefinition> {
    private static final SdkField<CognitoMemberDefinition> COGNITO_MEMBER_DEFINITION_FIELD = SdkField
            .<CognitoMemberDefinition> builder(MarshallingType.SDK_POJO)
            .getter(getter(MemberDefinition::cognitoMemberDefinition)).setter(setter(Builder::cognitoMemberDefinition))
            .constructor(CognitoMemberDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoMemberDefinition").build())
            .build();

    private static final SdkField<OidcMemberDefinition> OIDC_MEMBER_DEFINITION_FIELD = SdkField
            .<OidcMemberDefinition> builder(MarshallingType.SDK_POJO).getter(getter(MemberDefinition::oidcMemberDefinition))
            .setter(setter(Builder::oidcMemberDefinition)).constructor(OidcMemberDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OidcMemberDefinition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COGNITO_MEMBER_DEFINITION_FIELD, OIDC_MEMBER_DEFINITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final CognitoMemberDefinition cognitoMemberDefinition;

    private final OidcMemberDefinition oidcMemberDefinition;

    private MemberDefinition(BuilderImpl builder) {
        this.cognitoMemberDefinition = builder.cognitoMemberDefinition;
        this.oidcMemberDefinition = builder.oidcMemberDefinition;
    }

    /**
     * <p>
     * The Amazon Cognito user group that is part of the work team.
     * </p>
     * 
     * @return The Amazon Cognito user group that is part of the work team.
     */
    public CognitoMemberDefinition cognitoMemberDefinition() {
        return cognitoMemberDefinition;
    }

    /**
     * <p>
     * A list user groups that exist in your OIDC Identity Provider (IdP). One to ten groups can be used to create a
     * single private work team. When you add a user group to the list of <code>Groups</code>, you can add that user
     * group to one or more private work teams. If you add a user group to a private work team, all workers in that user
     * group are added to the work team.
     * </p>
     * 
     * @return A list user groups that exist in your OIDC Identity Provider (IdP). One to ten groups can be used to
     *         create a single private work team. When you add a user group to the list of <code>Groups</code>, you can
     *         add that user group to one or more private work teams. If you add a user group to a private work team,
     *         all workers in that user group are added to the work team.
     */
    public OidcMemberDefinition oidcMemberDefinition() {
        return oidcMemberDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cognitoMemberDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(oidcMemberDefinition());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberDefinition)) {
            return false;
        }
        MemberDefinition other = (MemberDefinition) obj;
        return Objects.equals(cognitoMemberDefinition(), other.cognitoMemberDefinition())
                && Objects.equals(oidcMemberDefinition(), other.oidcMemberDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MemberDefinition").add("CognitoMemberDefinition", cognitoMemberDefinition())
                .add("OidcMemberDefinition", oidcMemberDefinition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CognitoMemberDefinition":
            return Optional.ofNullable(clazz.cast(cognitoMemberDefinition()));
        case "OidcMemberDefinition":
            return Optional.ofNullable(clazz.cast(oidcMemberDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemberDefinition, T> g) {
        return obj -> g.apply((MemberDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemberDefinition> {
        /**
         * <p>
         * The Amazon Cognito user group that is part of the work team.
         * </p>
         * 
         * @param cognitoMemberDefinition
         *        The Amazon Cognito user group that is part of the work team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cognitoMemberDefinition(CognitoMemberDefinition cognitoMemberDefinition);

        /**
         * <p>
         * The Amazon Cognito user group that is part of the work team.
         * </p>
         * This is a convenience that creates an instance of the {@link CognitoMemberDefinition.Builder} avoiding the
         * need to create one manually via {@link CognitoMemberDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link CognitoMemberDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #cognitoMemberDefinition(CognitoMemberDefinition)}.
         * 
         * @param cognitoMemberDefinition
         *        a consumer that will call methods on {@link CognitoMemberDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cognitoMemberDefinition(CognitoMemberDefinition)
         */
        default Builder cognitoMemberDefinition(Consumer<CognitoMemberDefinition.Builder> cognitoMemberDefinition) {
            return cognitoMemberDefinition(CognitoMemberDefinition.builder().applyMutation(cognitoMemberDefinition).build());
        }

        /**
         * <p>
         * A list user groups that exist in your OIDC Identity Provider (IdP). One to ten groups can be used to create a
         * single private work team. When you add a user group to the list of <code>Groups</code>, you can add that user
         * group to one or more private work teams. If you add a user group to a private work team, all workers in that
         * user group are added to the work team.
         * </p>
         * 
         * @param oidcMemberDefinition
         *        A list user groups that exist in your OIDC Identity Provider (IdP). One to ten groups can be used to
         *        create a single private work team. When you add a user group to the list of <code>Groups</code>, you
         *        can add that user group to one or more private work teams. If you add a user group to a private work
         *        team, all workers in that user group are added to the work team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oidcMemberDefinition(OidcMemberDefinition oidcMemberDefinition);

        /**
         * <p>
         * A list user groups that exist in your OIDC Identity Provider (IdP). One to ten groups can be used to create a
         * single private work team. When you add a user group to the list of <code>Groups</code>, you can add that user
         * group to one or more private work teams. If you add a user group to a private work team, all workers in that
         * user group are added to the work team.
         * </p>
         * This is a convenience that creates an instance of the {@link OidcMemberDefinition.Builder} avoiding the need
         * to create one manually via {@link OidcMemberDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link OidcMemberDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #oidcMemberDefinition(OidcMemberDefinition)}.
         * 
         * @param oidcMemberDefinition
         *        a consumer that will call methods on {@link OidcMemberDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oidcMemberDefinition(OidcMemberDefinition)
         */
        default Builder oidcMemberDefinition(Consumer<OidcMemberDefinition.Builder> oidcMemberDefinition) {
            return oidcMemberDefinition(OidcMemberDefinition.builder().applyMutation(oidcMemberDefinition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CognitoMemberDefinition cognitoMemberDefinition;

        private OidcMemberDefinition oidcMemberDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberDefinition model) {
            cognitoMemberDefinition(model.cognitoMemberDefinition);
            oidcMemberDefinition(model.oidcMemberDefinition);
        }

        public final CognitoMemberDefinition.Builder getCognitoMemberDefinition() {
            return cognitoMemberDefinition != null ? cognitoMemberDefinition.toBuilder() : null;
        }

        @Override
        public final Builder cognitoMemberDefinition(CognitoMemberDefinition cognitoMemberDefinition) {
            this.cognitoMemberDefinition = cognitoMemberDefinition;
            return this;
        }

        public final void setCognitoMemberDefinition(CognitoMemberDefinition.BuilderImpl cognitoMemberDefinition) {
            this.cognitoMemberDefinition = cognitoMemberDefinition != null ? cognitoMemberDefinition.build() : null;
        }

        public final OidcMemberDefinition.Builder getOidcMemberDefinition() {
            return oidcMemberDefinition != null ? oidcMemberDefinition.toBuilder() : null;
        }

        @Override
        public final Builder oidcMemberDefinition(OidcMemberDefinition oidcMemberDefinition) {
            this.oidcMemberDefinition = oidcMemberDefinition;
            return this;
        }

        public final void setOidcMemberDefinition(OidcMemberDefinition.BuilderImpl oidcMemberDefinition) {
            this.oidcMemberDefinition = oidcMemberDefinition != null ? oidcMemberDefinition.build() : null;
        }

        @Override
        public MemberDefinition build() {
            return new MemberDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
