/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkforceRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateWorkforceRequest.Builder, UpdateWorkforceRequest> {
    private static final SdkField<String> WORKFORCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateWorkforceRequest::workforceName)).setter(setter(Builder::workforceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkforceName").build()).build();

    private static final SdkField<SourceIpConfig> SOURCE_IP_CONFIG_FIELD = SdkField
            .<SourceIpConfig> builder(MarshallingType.SDK_POJO).getter(getter(UpdateWorkforceRequest::sourceIpConfig))
            .setter(setter(Builder::sourceIpConfig)).constructor(SourceIpConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIpConfig").build()).build();

    private static final SdkField<OidcConfig> OIDC_CONFIG_FIELD = SdkField.<OidcConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateWorkforceRequest::oidcConfig)).setter(setter(Builder::oidcConfig))
            .constructor(OidcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OidcConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFORCE_NAME_FIELD,
            SOURCE_IP_CONFIG_FIELD, OIDC_CONFIG_FIELD));

    private final String workforceName;

    private final SourceIpConfig sourceIpConfig;

    private final OidcConfig oidcConfig;

    private UpdateWorkforceRequest(BuilderImpl builder) {
        super(builder);
        this.workforceName = builder.workforceName;
        this.sourceIpConfig = builder.sourceIpConfig;
        this.oidcConfig = builder.oidcConfig;
    }

    /**
     * <p>
     * The name of the private workforce that you want to update. You can find your workforce name by using the
     * operation.
     * </p>
     * 
     * @return The name of the private workforce that you want to update. You can find your workforce name by using the
     *         operation.
     */
    public String workforceName() {
        return workforceName;
    }

    /**
     * <p>
     * A list of one to ten worker IP address ranges (<a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) that can be used to access
     * tasks assigned to this workforce.
     * </p>
     * <p>
     * Maximum: Ten CIDR values
     * </p>
     * 
     * @return A list of one to ten worker IP address ranges (<a
     *         href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) that can be used to
     *         access tasks assigned to this workforce.</p>
     *         <p>
     *         Maximum: Ten CIDR values
     */
    public SourceIpConfig sourceIpConfig() {
        return sourceIpConfig;
    }

    /**
     * <p>
     * Use this parameter to update your OIDC Identity Provider (IdP) configuration for a workforce made using your own
     * IdP.
     * </p>
     * 
     * @return Use this parameter to update your OIDC Identity Provider (IdP) configuration for a workforce made using
     *         your own IdP.
     */
    public OidcConfig oidcConfig() {
        return oidcConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workforceName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceIpConfig());
        hashCode = 31 * hashCode + Objects.hashCode(oidcConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkforceRequest)) {
            return false;
        }
        UpdateWorkforceRequest other = (UpdateWorkforceRequest) obj;
        return Objects.equals(workforceName(), other.workforceName()) && Objects.equals(sourceIpConfig(), other.sourceIpConfig())
                && Objects.equals(oidcConfig(), other.oidcConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateWorkforceRequest").add("WorkforceName", workforceName())
                .add("SourceIpConfig", sourceIpConfig()).add("OidcConfig", oidcConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkforceName":
            return Optional.ofNullable(clazz.cast(workforceName()));
        case "SourceIpConfig":
            return Optional.ofNullable(clazz.cast(sourceIpConfig()));
        case "OidcConfig":
            return Optional.ofNullable(clazz.cast(oidcConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkforceRequest, T> g) {
        return obj -> g.apply((UpdateWorkforceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWorkforceRequest> {
        /**
         * <p>
         * The name of the private workforce that you want to update. You can find your workforce name by using the
         * operation.
         * </p>
         * 
         * @param workforceName
         *        The name of the private workforce that you want to update. You can find your workforce name by using
         *        the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workforceName(String workforceName);

        /**
         * <p>
         * A list of one to ten worker IP address ranges (<a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) that can be used to
         * access tasks assigned to this workforce.
         * </p>
         * <p>
         * Maximum: Ten CIDR values
         * </p>
         * 
         * @param sourceIpConfig
         *        A list of one to ten worker IP address ranges (<a
         *        href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) that can be used
         *        to access tasks assigned to this workforce.</p>
         *        <p>
         *        Maximum: Ten CIDR values
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIpConfig(SourceIpConfig sourceIpConfig);

        /**
         * <p>
         * A list of one to ten worker IP address ranges (<a
         * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>) that can be used to
         * access tasks assigned to this workforce.
         * </p>
         * <p>
         * Maximum: Ten CIDR values
         * </p>
         * This is a convenience that creates an instance of the {@link SourceIpConfig.Builder} avoiding the need to
         * create one manually via {@link SourceIpConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceIpConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceIpConfig(SourceIpConfig)}.
         * 
         * @param sourceIpConfig
         *        a consumer that will call methods on {@link SourceIpConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceIpConfig(SourceIpConfig)
         */
        default Builder sourceIpConfig(Consumer<SourceIpConfig.Builder> sourceIpConfig) {
            return sourceIpConfig(SourceIpConfig.builder().applyMutation(sourceIpConfig).build());
        }

        /**
         * <p>
         * Use this parameter to update your OIDC Identity Provider (IdP) configuration for a workforce made using your
         * own IdP.
         * </p>
         * 
         * @param oidcConfig
         *        Use this parameter to update your OIDC Identity Provider (IdP) configuration for a workforce made
         *        using your own IdP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oidcConfig(OidcConfig oidcConfig);

        /**
         * <p>
         * Use this parameter to update your OIDC Identity Provider (IdP) configuration for a workforce made using your
         * own IdP.
         * </p>
         * This is a convenience that creates an instance of the {@link OidcConfig.Builder} avoiding the need to create
         * one manually via {@link OidcConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OidcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #oidcConfig(OidcConfig)}.
         * 
         * @param oidcConfig
         *        a consumer that will call methods on {@link OidcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #oidcConfig(OidcConfig)
         */
        default Builder oidcConfig(Consumer<OidcConfig.Builder> oidcConfig) {
            return oidcConfig(OidcConfig.builder().applyMutation(oidcConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String workforceName;

        private SourceIpConfig sourceIpConfig;

        private OidcConfig oidcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkforceRequest model) {
            super(model);
            workforceName(model.workforceName);
            sourceIpConfig(model.sourceIpConfig);
            oidcConfig(model.oidcConfig);
        }

        public final String getWorkforceName() {
            return workforceName;
        }

        @Override
        public final Builder workforceName(String workforceName) {
            this.workforceName = workforceName;
            return this;
        }

        public final void setWorkforceName(String workforceName) {
            this.workforceName = workforceName;
        }

        public final SourceIpConfig.Builder getSourceIpConfig() {
            return sourceIpConfig != null ? sourceIpConfig.toBuilder() : null;
        }

        @Override
        public final Builder sourceIpConfig(SourceIpConfig sourceIpConfig) {
            this.sourceIpConfig = sourceIpConfig;
            return this;
        }

        public final void setSourceIpConfig(SourceIpConfig.BuilderImpl sourceIpConfig) {
            this.sourceIpConfig = sourceIpConfig != null ? sourceIpConfig.build() : null;
        }

        public final OidcConfig.Builder getOidcConfig() {
            return oidcConfig != null ? oidcConfig.toBuilder() : null;
        }

        @Override
        public final Builder oidcConfig(OidcConfig oidcConfig) {
            this.oidcConfig = oidcConfig;
            return this;
        }

        public final void setOidcConfig(OidcConfig.BuilderImpl oidcConfig) {
            this.oidcConfig = oidcConfig != null ? oidcConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkforceRequest build() {
            return new UpdateWorkforceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
