/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary about a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoMLJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoMLJobSummary.Builder, AutoMLJobSummary> {
    private static final SdkField<String> AUTO_ML_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutoMLJobSummary::autoMLJobName)).setter(setter(Builder::autoMLJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobName").build()).build();

    private static final SdkField<String> AUTO_ML_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutoMLJobSummary::autoMLJobArn)).setter(setter(Builder::autoMLJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobArn").build()).build();

    private static final SdkField<String> AUTO_ML_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutoMLJobSummary::autoMLJobStatusAsString)).setter(setter(Builder::autoMLJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobStatus").build()).build();

    private static final SdkField<String> AUTO_ML_JOB_SECONDARY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutoMLJobSummary::autoMLJobSecondaryStatusAsString)).setter(setter(Builder::autoMLJobSecondaryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobSecondaryStatus").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AutoMLJobSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AutoMLJobSummary::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AutoMLJobSummary::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AutoMLJobSummary::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_ML_JOB_NAME_FIELD,
            AUTO_ML_JOB_ARN_FIELD, AUTO_ML_JOB_STATUS_FIELD, AUTO_ML_JOB_SECONDARY_STATUS_FIELD, CREATION_TIME_FIELD,
            END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String autoMLJobName;

    private final String autoMLJobArn;

    private final String autoMLJobStatus;

    private final String autoMLJobSecondaryStatus;

    private final Instant creationTime;

    private final Instant endTime;

    private final Instant lastModifiedTime;

    private final String failureReason;

    private AutoMLJobSummary(BuilderImpl builder) {
        this.autoMLJobName = builder.autoMLJobName;
        this.autoMLJobArn = builder.autoMLJobArn;
        this.autoMLJobStatus = builder.autoMLJobStatus;
        this.autoMLJobSecondaryStatus = builder.autoMLJobSecondaryStatus;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * The name of the object you are requesting.
     * </p>
     * 
     * @return The name of the object you are requesting.
     */
    public String autoMLJobName() {
        return autoMLJobName;
    }

    /**
     * <p>
     * The ARN of the job.
     * </p>
     * 
     * @return The ARN of the job.
     */
    public String autoMLJobArn() {
        return autoMLJobArn;
    }

    /**
     * <p>
     * The job's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoMLJobStatus}
     * will return {@link AutoMLJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #autoMLJobStatusAsString}.
     * </p>
     * 
     * @return The job's status.
     * @see AutoMLJobStatus
     */
    public AutoMLJobStatus autoMLJobStatus() {
        return AutoMLJobStatus.fromValue(autoMLJobStatus);
    }

    /**
     * <p>
     * The job's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoMLJobStatus}
     * will return {@link AutoMLJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #autoMLJobStatusAsString}.
     * </p>
     * 
     * @return The job's status.
     * @see AutoMLJobStatus
     */
    public String autoMLJobStatusAsString() {
        return autoMLJobStatus;
    }

    /**
     * <p>
     * The job's secondary status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoMLJobSecondaryStatus} will return {@link AutoMLJobSecondaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #autoMLJobSecondaryStatusAsString}.
     * </p>
     * 
     * @return The job's secondary status.
     * @see AutoMLJobSecondaryStatus
     */
    public AutoMLJobSecondaryStatus autoMLJobSecondaryStatus() {
        return AutoMLJobSecondaryStatus.fromValue(autoMLJobSecondaryStatus);
    }

    /**
     * <p>
     * The job's secondary status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoMLJobSecondaryStatus} will return {@link AutoMLJobSecondaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #autoMLJobSecondaryStatusAsString}.
     * </p>
     * 
     * @return The job's secondary status.
     * @see AutoMLJobSecondaryStatus
     */
    public String autoMLJobSecondaryStatusAsString() {
        return autoMLJobSecondaryStatus;
    }

    /**
     * <p>
     * When the job was created.
     * </p>
     * 
     * @return When the job was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The end time of an AutoML job.
     * </p>
     * 
     * @return The end time of an AutoML job.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * When the job was last modified.
     * </p>
     * 
     * @return When the job was last modified.
     */
    public Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The failure reason of a job.
     * </p>
     * 
     * @return The failure reason of a job.
     */
    public String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobName());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoMLJobSecondaryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLJobSummary)) {
            return false;
        }
        AutoMLJobSummary other = (AutoMLJobSummary) obj;
        return Objects.equals(autoMLJobName(), other.autoMLJobName()) && Objects.equals(autoMLJobArn(), other.autoMLJobArn())
                && Objects.equals(autoMLJobStatusAsString(), other.autoMLJobStatusAsString())
                && Objects.equals(autoMLJobSecondaryStatusAsString(), other.autoMLJobSecondaryStatusAsString())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AutoMLJobSummary").add("AutoMLJobName", autoMLJobName()).add("AutoMLJobArn", autoMLJobArn())
                .add("AutoMLJobStatus", autoMLJobStatusAsString())
                .add("AutoMLJobSecondaryStatus", autoMLJobSecondaryStatusAsString()).add("CreationTime", creationTime())
                .add("EndTime", endTime()).add("LastModifiedTime", lastModifiedTime()).add("FailureReason", failureReason())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoMLJobName":
            return Optional.ofNullable(clazz.cast(autoMLJobName()));
        case "AutoMLJobArn":
            return Optional.ofNullable(clazz.cast(autoMLJobArn()));
        case "AutoMLJobStatus":
            return Optional.ofNullable(clazz.cast(autoMLJobStatusAsString()));
        case "AutoMLJobSecondaryStatus":
            return Optional.ofNullable(clazz.cast(autoMLJobSecondaryStatusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLJobSummary, T> g) {
        return obj -> g.apply((AutoMLJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoMLJobSummary> {
        /**
         * <p>
         * The name of the object you are requesting.
         * </p>
         * 
         * @param autoMLJobName
         *        The name of the object you are requesting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobName(String autoMLJobName);

        /**
         * <p>
         * The ARN of the job.
         * </p>
         * 
         * @param autoMLJobArn
         *        The ARN of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMLJobArn(String autoMLJobArn);

        /**
         * <p>
         * The job's status.
         * </p>
         * 
         * @param autoMLJobStatus
         *        The job's status.
         * @see AutoMLJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLJobStatus
         */
        Builder autoMLJobStatus(String autoMLJobStatus);

        /**
         * <p>
         * The job's status.
         * </p>
         * 
         * @param autoMLJobStatus
         *        The job's status.
         * @see AutoMLJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLJobStatus
         */
        Builder autoMLJobStatus(AutoMLJobStatus autoMLJobStatus);

        /**
         * <p>
         * The job's secondary status.
         * </p>
         * 
         * @param autoMLJobSecondaryStatus
         *        The job's secondary status.
         * @see AutoMLJobSecondaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLJobSecondaryStatus
         */
        Builder autoMLJobSecondaryStatus(String autoMLJobSecondaryStatus);

        /**
         * <p>
         * The job's secondary status.
         * </p>
         * 
         * @param autoMLJobSecondaryStatus
         *        The job's secondary status.
         * @see AutoMLJobSecondaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoMLJobSecondaryStatus
         */
        Builder autoMLJobSecondaryStatus(AutoMLJobSecondaryStatus autoMLJobSecondaryStatus);

        /**
         * <p>
         * When the job was created.
         * </p>
         * 
         * @param creationTime
         *        When the job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The end time of an AutoML job.
         * </p>
         * 
         * @param endTime
         *        The end time of an AutoML job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * When the job was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        When the job was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The failure reason of a job.
         * </p>
         * 
         * @param failureReason
         *        The failure reason of a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String autoMLJobName;

        private String autoMLJobArn;

        private String autoMLJobStatus;

        private String autoMLJobSecondaryStatus;

        private Instant creationTime;

        private Instant endTime;

        private Instant lastModifiedTime;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLJobSummary model) {
            autoMLJobName(model.autoMLJobName);
            autoMLJobArn(model.autoMLJobArn);
            autoMLJobStatus(model.autoMLJobStatus);
            autoMLJobSecondaryStatus(model.autoMLJobSecondaryStatus);
            creationTime(model.creationTime);
            endTime(model.endTime);
            lastModifiedTime(model.lastModifiedTime);
            failureReason(model.failureReason);
        }

        public final String getAutoMLJobName() {
            return autoMLJobName;
        }

        @Override
        public final Builder autoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
            return this;
        }

        public final void setAutoMLJobName(String autoMLJobName) {
            this.autoMLJobName = autoMLJobName;
        }

        public final String getAutoMLJobArn() {
            return autoMLJobArn;
        }

        @Override
        public final Builder autoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
            return this;
        }

        public final void setAutoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
        }

        public final String getAutoMLJobStatus() {
            return autoMLJobStatus;
        }

        @Override
        public final Builder autoMLJobStatus(String autoMLJobStatus) {
            this.autoMLJobStatus = autoMLJobStatus;
            return this;
        }

        @Override
        public final Builder autoMLJobStatus(AutoMLJobStatus autoMLJobStatus) {
            this.autoMLJobStatus(autoMLJobStatus == null ? null : autoMLJobStatus.toString());
            return this;
        }

        public final void setAutoMLJobStatus(String autoMLJobStatus) {
            this.autoMLJobStatus = autoMLJobStatus;
        }

        public final String getAutoMLJobSecondaryStatus() {
            return autoMLJobSecondaryStatus;
        }

        @Override
        public final Builder autoMLJobSecondaryStatus(String autoMLJobSecondaryStatus) {
            this.autoMLJobSecondaryStatus = autoMLJobSecondaryStatus;
            return this;
        }

        @Override
        public final Builder autoMLJobSecondaryStatus(AutoMLJobSecondaryStatus autoMLJobSecondaryStatus) {
            this.autoMLJobSecondaryStatus(autoMLJobSecondaryStatus == null ? null : autoMLJobSecondaryStatus.toString());
            return this;
        }

        public final void setAutoMLJobSecondaryStatus(String autoMLJobSecondaryStatus) {
            this.autoMLJobSecondaryStatus = autoMLJobSecondaryStatus;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public AutoMLJobSummary build() {
            return new AutoMLJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
