/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrainingJobRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateTrainingJobRequest.Builder, CreateTrainingJobRequest> {
    private static final SdkField<String> TRAINING_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrainingJobName").getter(getter(CreateTrainingJobRequest::trainingJobName))
            .setter(setter(Builder::trainingJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobName").build()).build();

    private static final SdkField<Map<String, String>> HYPER_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("HyperParameters")
            .getter(getter(CreateTrainingJobRequest::hyperParameters))
            .setter(setter(Builder::hyperParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AlgorithmSpecification> ALGORITHM_SPECIFICATION_FIELD = SdkField
            .<AlgorithmSpecification> builder(MarshallingType.SDK_POJO).memberName("AlgorithmSpecification")
            .getter(getter(CreateTrainingJobRequest::algorithmSpecification)).setter(setter(Builder::algorithmSpecification))
            .constructor(AlgorithmSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmSpecification").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateTrainingJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<List<Channel>> INPUT_DATA_CONFIG_FIELD = SdkField
            .<List<Channel>> builder(MarshallingType.LIST)
            .memberName("InputDataConfig")
            .getter(getter(CreateTrainingJobRequest::inputDataConfig))
            .setter(setter(Builder::inputDataConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Channel> builder(MarshallingType.SDK_POJO)
                                            .constructor(Channel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<OutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("OutputDataConfig")
            .getter(getter(CreateTrainingJobRequest::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(OutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()).build();

    private static final SdkField<ResourceConfig> RESOURCE_CONFIG_FIELD = SdkField
            .<ResourceConfig> builder(MarshallingType.SDK_POJO).memberName("ResourceConfig")
            .getter(getter(CreateTrainingJobRequest::resourceConfig)).setter(setter(Builder::resourceConfig))
            .constructor(ResourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfig").build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(CreateTrainingJobRequest::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField
            .<StoppingCondition> builder(MarshallingType.SDK_POJO).memberName("StoppingCondition")
            .getter(getter(CreateTrainingJobRequest::stoppingCondition)).setter(setter(Builder::stoppingCondition))
            .constructor(StoppingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateTrainingJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_NETWORK_ISOLATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableNetworkIsolation").getter(getter(CreateTrainingJobRequest::enableNetworkIsolation))
            .setter(setter(Builder::enableNetworkIsolation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableNetworkIsolation").build())
            .build();

    private static final SdkField<Boolean> ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableInterContainerTrafficEncryption")
            .getter(getter(CreateTrainingJobRequest::enableInterContainerTrafficEncryption))
            .setter(setter(Builder::enableInterContainerTrafficEncryption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EnableInterContainerTrafficEncryption").build()).build();

    private static final SdkField<Boolean> ENABLE_MANAGED_SPOT_TRAINING_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("EnableManagedSpotTraining")
            .getter(getter(CreateTrainingJobRequest::enableManagedSpotTraining))
            .setter(setter(Builder::enableManagedSpotTraining))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableManagedSpotTraining").build())
            .build();

    private static final SdkField<CheckpointConfig> CHECKPOINT_CONFIG_FIELD = SdkField
            .<CheckpointConfig> builder(MarshallingType.SDK_POJO).memberName("CheckpointConfig")
            .getter(getter(CreateTrainingJobRequest::checkpointConfig)).setter(setter(Builder::checkpointConfig))
            .constructor(CheckpointConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointConfig").build()).build();

    private static final SdkField<DebugHookConfig> DEBUG_HOOK_CONFIG_FIELD = SdkField
            .<DebugHookConfig> builder(MarshallingType.SDK_POJO).memberName("DebugHookConfig")
            .getter(getter(CreateTrainingJobRequest::debugHookConfig)).setter(setter(Builder::debugHookConfig))
            .constructor(DebugHookConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DebugHookConfig").build()).build();

    private static final SdkField<List<DebugRuleConfiguration>> DEBUG_RULE_CONFIGURATIONS_FIELD = SdkField
            .<List<DebugRuleConfiguration>> builder(MarshallingType.LIST)
            .memberName("DebugRuleConfigurations")
            .getter(getter(CreateTrainingJobRequest::debugRuleConfigurations))
            .setter(setter(Builder::debugRuleConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DebugRuleConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DebugRuleConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DebugRuleConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TensorBoardOutputConfig> TENSOR_BOARD_OUTPUT_CONFIG_FIELD = SdkField
            .<TensorBoardOutputConfig> builder(MarshallingType.SDK_POJO).memberName("TensorBoardOutputConfig")
            .getter(getter(CreateTrainingJobRequest::tensorBoardOutputConfig)).setter(setter(Builder::tensorBoardOutputConfig))
            .constructor(TensorBoardOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TensorBoardOutputConfig").build())
            .build();

    private static final SdkField<ExperimentConfig> EXPERIMENT_CONFIG_FIELD = SdkField
            .<ExperimentConfig> builder(MarshallingType.SDK_POJO).memberName("ExperimentConfig")
            .getter(getter(CreateTrainingJobRequest::experimentConfig)).setter(setter(Builder::experimentConfig))
            .constructor(ExperimentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_JOB_NAME_FIELD,
            HYPER_PARAMETERS_FIELD, ALGORITHM_SPECIFICATION_FIELD, ROLE_ARN_FIELD, INPUT_DATA_CONFIG_FIELD,
            OUTPUT_DATA_CONFIG_FIELD, RESOURCE_CONFIG_FIELD, VPC_CONFIG_FIELD, STOPPING_CONDITION_FIELD, TAGS_FIELD,
            ENABLE_NETWORK_ISOLATION_FIELD, ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD, ENABLE_MANAGED_SPOT_TRAINING_FIELD,
            CHECKPOINT_CONFIG_FIELD, DEBUG_HOOK_CONFIG_FIELD, DEBUG_RULE_CONFIGURATIONS_FIELD, TENSOR_BOARD_OUTPUT_CONFIG_FIELD,
            EXPERIMENT_CONFIG_FIELD));

    private final String trainingJobName;

    private final Map<String, String> hyperParameters;

    private final AlgorithmSpecification algorithmSpecification;

    private final String roleArn;

    private final List<Channel> inputDataConfig;

    private final OutputDataConfig outputDataConfig;

    private final ResourceConfig resourceConfig;

    private final VpcConfig vpcConfig;

    private final StoppingCondition stoppingCondition;

    private final List<Tag> tags;

    private final Boolean enableNetworkIsolation;

    private final Boolean enableInterContainerTrafficEncryption;

    private final Boolean enableManagedSpotTraining;

    private final CheckpointConfig checkpointConfig;

    private final DebugHookConfig debugHookConfig;

    private final List<DebugRuleConfiguration> debugRuleConfigurations;

    private final TensorBoardOutputConfig tensorBoardOutputConfig;

    private final ExperimentConfig experimentConfig;

    private CreateTrainingJobRequest(BuilderImpl builder) {
        super(builder);
        this.trainingJobName = builder.trainingJobName;
        this.hyperParameters = builder.hyperParameters;
        this.algorithmSpecification = builder.algorithmSpecification;
        this.roleArn = builder.roleArn;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.resourceConfig = builder.resourceConfig;
        this.vpcConfig = builder.vpcConfig;
        this.stoppingCondition = builder.stoppingCondition;
        this.tags = builder.tags;
        this.enableNetworkIsolation = builder.enableNetworkIsolation;
        this.enableInterContainerTrafficEncryption = builder.enableInterContainerTrafficEncryption;
        this.enableManagedSpotTraining = builder.enableManagedSpotTraining;
        this.checkpointConfig = builder.checkpointConfig;
        this.debugHookConfig = builder.debugHookConfig;
        this.debugRuleConfigurations = builder.debugRuleConfigurations;
        this.tensorBoardOutputConfig = builder.tensorBoardOutputConfig;
        this.experimentConfig = builder.experimentConfig;
    }

    /**
     * <p>
     * The name of the training job. The name must be unique within an AWS Region in an AWS account.
     * </p>
     * 
     * @return The name of the training job. The name must be unique within an AWS Region in an AWS account.
     */
    public String trainingJobName() {
        return trainingJobName;
    }

    /**
     * Returns true if the HyperParameters property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasHyperParameters() {
        return hyperParameters != null && !(hyperParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Algorithm-specific parameters that influence the quality of the model. You set hyperparameters before you start
     * the learning process. For a list of hyperparameters for each training algorithm provided by Amazon SageMaker, see
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>.
     * </p>
     * <p>
     * You can specify a maximum of 100 hyperparameters. Each hyperparameter is a key-value pair. Each key and value is
     * limited to 256 characters, as specified by the <code>Length Constraint</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHyperParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Algorithm-specific parameters that influence the quality of the model. You set hyperparameters before you
     *         start the learning process. For a list of hyperparameters for each training algorithm provided by Amazon
     *         SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. </p>
     *         <p>
     *         You can specify a maximum of 100 hyperparameters. Each hyperparameter is a key-value pair. Each key and
     *         value is limited to 256 characters, as specified by the <code>Length Constraint</code>.
     */
    public Map<String, String> hyperParameters() {
        return hyperParameters;
    }

    /**
     * <p>
     * The registry path of the Docker image that contains the training algorithm and algorithm-specific metadata,
     * including the input mode. For more information about algorithms provided by Amazon SageMaker, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. For information about providing
     * your own algorithms, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using
     * Your Own Algorithms with Amazon SageMaker</a>.
     * </p>
     * 
     * @return The registry path of the Docker image that contains the training algorithm and algorithm-specific
     *         metadata, including the input mode. For more information about algorithms provided by Amazon SageMaker,
     *         see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. For information
     *         about providing your own algorithms, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms
     *         with Amazon SageMaker</a>.
     */
    public AlgorithmSpecification algorithmSpecification() {
        return algorithmSpecification;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your behalf.
     * </p>
     * <p>
     * During model training, Amazon SageMaker needs your permission to read input data from an S3 bucket, download a
     * Docker image that contains training code, write model artifacts to an S3 bucket, write logs to Amazon CloudWatch
     * Logs, and publish metrics to Amazon CloudWatch. You grant permissions for all of these tasks to an IAM role. For
     * more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon
     * SageMaker Roles</a>.
     * </p>
     * <note>
     * <p>
     * To be able to pass this role to Amazon SageMaker, the caller of this API must have the <code>iam:PassRole</code>
     * permission.
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your
     *         behalf. </p>
     *         <p>
     *         During model training, Amazon SageMaker needs your permission to read input data from an S3 bucket,
     *         download a Docker image that contains training code, write model artifacts to an S3 bucket, write logs to
     *         Amazon CloudWatch Logs, and publish metrics to Amazon CloudWatch. You grant permissions for all of these
     *         tasks to an IAM role. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>.
     *         </p>
     *         <note>
     *         <p>
     *         To be able to pass this role to Amazon SageMaker, the caller of this API must have the
     *         <code>iam:PassRole</code> permission.
     *         </p>
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * Returns true if the InputDataConfig property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasInputDataConfig() {
        return inputDataConfig != null && !(inputDataConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Channel</code> objects. Each channel is a named input source. <code>InputDataConfig</code>
     * describes the input data and its location.
     * </p>
     * <p>
     * Algorithms can accept input data from one or more channels. For example, an algorithm might have two channels of
     * input data, <code>training_data</code> and <code>validation_data</code>. The configuration for each channel
     * provides the S3, EFS, or FSx location where the input data is stored. It also provides information about the
     * stored data: the MIME type, compression method, and whether the data is wrapped in RecordIO format.
     * </p>
     * <p>
     * Depending on the input mode that the algorithm supports, Amazon SageMaker either copies input data files from an
     * S3 bucket to a local directory in the Docker container, or makes it available as input streams. For example, if
     * you specify an EFS location, input data files will be made available as input streams. They do not need to be
     * downloaded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInputDataConfig()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>Channel</code> objects. Each channel is a named input source.
     *         <code>InputDataConfig</code> describes the input data and its location. </p>
     *         <p>
     *         Algorithms can accept input data from one or more channels. For example, an algorithm might have two
     *         channels of input data, <code>training_data</code> and <code>validation_data</code>. The configuration
     *         for each channel provides the S3, EFS, or FSx location where the input data is stored. It also provides
     *         information about the stored data: the MIME type, compression method, and whether the data is wrapped in
     *         RecordIO format.
     *         </p>
     *         <p>
     *         Depending on the input mode that the algorithm supports, Amazon SageMaker either copies input data files
     *         from an S3 bucket to a local directory in the Docker container, or makes it available as input streams.
     *         For example, if you specify an EFS location, input data files will be made available as input streams.
     *         They do not need to be downloaded.
     */
    public List<Channel> inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * <p>
     * Specifies the path to the S3 location where you want to store model artifacts. Amazon SageMaker creates
     * subfolders for the artifacts.
     * </p>
     * 
     * @return Specifies the path to the S3 location where you want to store model artifacts. Amazon SageMaker creates
     *         subfolders for the artifacts.
     */
    public OutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    /**
     * <p>
     * The resources, including the ML compute instances and ML storage volumes, to use for model training.
     * </p>
     * <p>
     * ML storage volumes store model artifacts and incremental states. Training algorithms might also use ML storage
     * volumes for scratch space. If you want Amazon SageMaker to use the ML storage volume to store the training data,
     * choose <code>File</code> as the <code>TrainingInputMode</code> in the algorithm specification. For distributed
     * training algorithms, specify an instance count greater than 1.
     * </p>
     * 
     * @return The resources, including the ML compute instances and ML storage volumes, to use for model training. </p>
     *         <p>
     *         ML storage volumes store model artifacts and incremental states. Training algorithms might also use ML
     *         storage volumes for scratch space. If you want Amazon SageMaker to use the ML storage volume to store the
     *         training data, choose <code>File</code> as the <code>TrainingInputMode</code> in the algorithm
     *         specification. For distributed training algorithms, specify an instance count greater than 1.
     */
    public ResourceConfig resourceConfig() {
        return resourceConfig;
    }

    /**
     * <p>
     * A <a>VpcConfig</a> object that specifies the VPC that you want your training job to connect to. Control access to
     * and from your training container by configuring the VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon
     * Virtual Private Cloud</a>.
     * </p>
     * 
     * @return A <a>VpcConfig</a> object that specifies the VPC that you want your training job to connect to. Control
     *         access to and from your training container by configuring the VPC. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an
     *         Amazon Virtual Private Cloud</a>.
     */
    public VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * Specifies a limit to how long a model training job can run. When the job reaches the time limit, Amazon SageMaker
     * ends the training job. Use this API to cap model training costs.
     * </p>
     * <p>
     * To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination
     * for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of
     * training are not lost.
     * </p>
     * 
     * @return Specifies a limit to how long a model training job can run. When the job reaches the time limit, Amazon
     *         SageMaker ends the training job. Use this API to cap model training costs.</p>
     *         <p>
     *         To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job
     *         termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so
     *         the results of training are not lost.
     */
    public StoppingCondition stoppingCondition() {
        return stoppingCondition;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for example, by
     * purpose, owner, or environment. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for
     *         example, by purpose, owner, or environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Isolates the training container. No inbound or outbound network calls can be made, except for calls between peers
     * within a training cluster for distributed training. If you enable network isolation for training jobs that are
     * configured to use a VPC, Amazon SageMaker downloads and uploads customer data and model artifacts through the
     * specified VPC, but the training container does not have network access.
     * </p>
     * 
     * @return Isolates the training container. No inbound or outbound network calls can be made, except for calls
     *         between peers within a training cluster for distributed training. If you enable network isolation for
     *         training jobs that are configured to use a VPC, Amazon SageMaker downloads and uploads customer data and
     *         model artifacts through the specified VPC, but the training container does not have network access.
     */
    public Boolean enableNetworkIsolation() {
        return enableNetworkIsolation;
    }

    /**
     * <p>
     * To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>.
     * Encryption provides greater security for distributed training, but training might take longer. How long it takes
     * depends on the amount of communication between compute instances, especially if you use a deep learning algorithm
     * in distributed training. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-encrypt.html">Protect Communications Between ML
     * Compute Instances in a Distributed Training Job</a>.
     * </p>
     * 
     * @return To encrypt all communications between ML compute instances in distributed training, choose
     *         <code>True</code>. Encryption provides greater security for distributed training, but training might take
     *         longer. How long it takes depends on the amount of communication between compute instances, especially if
     *         you use a deep learning algorithm in distributed training. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-encrypt.html">Protect Communications Between
     *         ML Compute Instances in a Distributed Training Job</a>.
     */
    public Boolean enableInterContainerTrafficEncryption() {
        return enableInterContainerTrafficEncryption;
    }

    /**
     * <p>
     * To train models using managed spot training, choose <code>True</code>. Managed spot training provides a fully
     * managed and scalable infrastructure for training machine learning models. this option is useful when training
     * jobs can be interrupted and when there is flexibility when the training job is run.
     * </p>
     * <p>
     * The complete and intermediate results of jobs are stored in an Amazon S3 bucket, and can be used as a starting
     * point to train models incrementally. Amazon SageMaker provides metrics and logs in CloudWatch. They can be used
     * to see when managed spot training jobs are running, interrupted, resumed, or completed.
     * </p>
     * 
     * @return To train models using managed spot training, choose <code>True</code>. Managed spot training provides a
     *         fully managed and scalable infrastructure for training machine learning models. this option is useful
     *         when training jobs can be interrupted and when there is flexibility when the training job is run. </p>
     *         <p>
     *         The complete and intermediate results of jobs are stored in an Amazon S3 bucket, and can be used as a
     *         starting point to train models incrementally. Amazon SageMaker provides metrics and logs in CloudWatch.
     *         They can be used to see when managed spot training jobs are running, interrupted, resumed, or completed.
     */
    public Boolean enableManagedSpotTraining() {
        return enableManagedSpotTraining;
    }

    /**
     * <p>
     * Contains information about the output location for managed spot training checkpoint data.
     * </p>
     * 
     * @return Contains information about the output location for managed spot training checkpoint data.
     */
    public CheckpointConfig checkpointConfig() {
        return checkpointConfig;
    }

    /**
     * Returns the value of the DebugHookConfig property for this object.
     * 
     * @return The value of the DebugHookConfig property for this object.
     */
    public DebugHookConfig debugHookConfig() {
        return debugHookConfig;
    }

    /**
     * Returns true if the DebugRuleConfigurations property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDebugRuleConfigurations() {
        return debugRuleConfigurations != null && !(debugRuleConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration information for debugging rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDebugRuleConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Configuration information for debugging rules.
     */
    public List<DebugRuleConfiguration> debugRuleConfigurations() {
        return debugRuleConfigurations;
    }

    /**
     * Returns the value of the TensorBoardOutputConfig property for this object.
     * 
     * @return The value of the TensorBoardOutputConfig property for this object.
     */
    public TensorBoardOutputConfig tensorBoardOutputConfig() {
        return tensorBoardOutputConfig;
    }

    /**
     * Returns the value of the ExperimentConfig property for this object.
     * 
     * @return The value of the ExperimentConfig property for this object.
     */
    public ExperimentConfig experimentConfig() {
        return experimentConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trainingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(hasHyperParameters() ? hyperParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(algorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputDataConfig() ? inputDataConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enableNetworkIsolation());
        hashCode = 31 * hashCode + Objects.hashCode(enableInterContainerTrafficEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(enableManagedSpotTraining());
        hashCode = 31 * hashCode + Objects.hashCode(checkpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(debugHookConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasDebugRuleConfigurations() ? debugRuleConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tensorBoardOutputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(experimentConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrainingJobRequest)) {
            return false;
        }
        CreateTrainingJobRequest other = (CreateTrainingJobRequest) obj;
        return Objects.equals(trainingJobName(), other.trainingJobName()) && hasHyperParameters() == other.hasHyperParameters()
                && Objects.equals(hyperParameters(), other.hyperParameters())
                && Objects.equals(algorithmSpecification(), other.algorithmSpecification())
                && Objects.equals(roleArn(), other.roleArn()) && hasInputDataConfig() == other.hasInputDataConfig()
                && Objects.equals(inputDataConfig(), other.inputDataConfig())
                && Objects.equals(outputDataConfig(), other.outputDataConfig())
                && Objects.equals(resourceConfig(), other.resourceConfig()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(stoppingCondition(), other.stoppingCondition()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(enableNetworkIsolation(), other.enableNetworkIsolation())
                && Objects.equals(enableInterContainerTrafficEncryption(), other.enableInterContainerTrafficEncryption())
                && Objects.equals(enableManagedSpotTraining(), other.enableManagedSpotTraining())
                && Objects.equals(checkpointConfig(), other.checkpointConfig())
                && Objects.equals(debugHookConfig(), other.debugHookConfig())
                && hasDebugRuleConfigurations() == other.hasDebugRuleConfigurations()
                && Objects.equals(debugRuleConfigurations(), other.debugRuleConfigurations())
                && Objects.equals(tensorBoardOutputConfig(), other.tensorBoardOutputConfig())
                && Objects.equals(experimentConfig(), other.experimentConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateTrainingJobRequest").add("TrainingJobName", trainingJobName())
                .add("HyperParameters", hasHyperParameters() ? hyperParameters() : null)
                .add("AlgorithmSpecification", algorithmSpecification()).add("RoleArn", roleArn())
                .add("InputDataConfig", hasInputDataConfig() ? inputDataConfig() : null)
                .add("OutputDataConfig", outputDataConfig()).add("ResourceConfig", resourceConfig())
                .add("VpcConfig", vpcConfig()).add("StoppingCondition", stoppingCondition())
                .add("Tags", hasTags() ? tags() : null).add("EnableNetworkIsolation", enableNetworkIsolation())
                .add("EnableInterContainerTrafficEncryption", enableInterContainerTrafficEncryption())
                .add("EnableManagedSpotTraining", enableManagedSpotTraining()).add("CheckpointConfig", checkpointConfig())
                .add("DebugHookConfig", debugHookConfig())
                .add("DebugRuleConfigurations", hasDebugRuleConfigurations() ? debugRuleConfigurations() : null)
                .add("TensorBoardOutputConfig", tensorBoardOutputConfig()).add("ExperimentConfig", experimentConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrainingJobName":
            return Optional.ofNullable(clazz.cast(trainingJobName()));
        case "HyperParameters":
            return Optional.ofNullable(clazz.cast(hyperParameters()));
        case "AlgorithmSpecification":
            return Optional.ofNullable(clazz.cast(algorithmSpecification()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "InputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "OutputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        case "ResourceConfig":
            return Optional.ofNullable(clazz.cast(resourceConfig()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "StoppingCondition":
            return Optional.ofNullable(clazz.cast(stoppingCondition()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "EnableNetworkIsolation":
            return Optional.ofNullable(clazz.cast(enableNetworkIsolation()));
        case "EnableInterContainerTrafficEncryption":
            return Optional.ofNullable(clazz.cast(enableInterContainerTrafficEncryption()));
        case "EnableManagedSpotTraining":
            return Optional.ofNullable(clazz.cast(enableManagedSpotTraining()));
        case "CheckpointConfig":
            return Optional.ofNullable(clazz.cast(checkpointConfig()));
        case "DebugHookConfig":
            return Optional.ofNullable(clazz.cast(debugHookConfig()));
        case "DebugRuleConfigurations":
            return Optional.ofNullable(clazz.cast(debugRuleConfigurations()));
        case "TensorBoardOutputConfig":
            return Optional.ofNullable(clazz.cast(tensorBoardOutputConfig()));
        case "ExperimentConfig":
            return Optional.ofNullable(clazz.cast(experimentConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrainingJobRequest, T> g) {
        return obj -> g.apply((CreateTrainingJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrainingJobRequest> {
        /**
         * <p>
         * The name of the training job. The name must be unique within an AWS Region in an AWS account.
         * </p>
         * 
         * @param trainingJobName
         *        The name of the training job. The name must be unique within an AWS Region in an AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingJobName(String trainingJobName);

        /**
         * <p>
         * Algorithm-specific parameters that influence the quality of the model. You set hyperparameters before you
         * start the learning process. For a list of hyperparameters for each training algorithm provided by Amazon
         * SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>.
         * </p>
         * <p>
         * You can specify a maximum of 100 hyperparameters. Each hyperparameter is a key-value pair. Each key and value
         * is limited to 256 characters, as specified by the <code>Length Constraint</code>.
         * </p>
         * 
         * @param hyperParameters
         *        Algorithm-specific parameters that influence the quality of the model. You set hyperparameters before
         *        you start the learning process. For a list of hyperparameters for each training algorithm provided by
         *        Amazon SageMaker, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. </p>
         *        <p>
         *        You can specify a maximum of 100 hyperparameters. Each hyperparameter is a key-value pair. Each key
         *        and value is limited to 256 characters, as specified by the <code>Length Constraint</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameters(Map<String, String> hyperParameters);

        /**
         * <p>
         * The registry path of the Docker image that contains the training algorithm and algorithm-specific metadata,
         * including the input mode. For more information about algorithms provided by Amazon SageMaker, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. For information about
         * providing your own algorithms, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with
         * Amazon SageMaker</a>.
         * </p>
         * 
         * @param algorithmSpecification
         *        The registry path of the Docker image that contains the training algorithm and algorithm-specific
         *        metadata, including the input mode. For more information about algorithms provided by Amazon
         *        SageMaker, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>.
         *        For information about providing your own algorithms, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms
         *        with Amazon SageMaker</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder algorithmSpecification(AlgorithmSpecification algorithmSpecification);

        /**
         * <p>
         * The registry path of the Docker image that contains the training algorithm and algorithm-specific metadata,
         * including the input mode. For more information about algorithms provided by Amazon SageMaker, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>. For information about
         * providing your own algorithms, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html">Using Your Own Algorithms with
         * Amazon SageMaker</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link AlgorithmSpecification.Builder} avoiding the
         * need to create one manually via {@link AlgorithmSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link AlgorithmSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #algorithmSpecification(AlgorithmSpecification)}.
         * 
         * @param algorithmSpecification
         *        a consumer that will call methods on {@link AlgorithmSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #algorithmSpecification(AlgorithmSpecification)
         */
        default Builder algorithmSpecification(Consumer<AlgorithmSpecification.Builder> algorithmSpecification) {
            return algorithmSpecification(AlgorithmSpecification.builder().applyMutation(algorithmSpecification).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on your
         * behalf.
         * </p>
         * <p>
         * During model training, Amazon SageMaker needs your permission to read input data from an S3 bucket, download
         * a Docker image that contains training code, write model artifacts to an S3 bucket, write logs to Amazon
         * CloudWatch Logs, and publish metrics to Amazon CloudWatch. You grant permissions for all of these tasks to an
         * IAM role. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker Roles</a>.
         * </p>
         * <note>
         * <p>
         * To be able to pass this role to Amazon SageMaker, the caller of this API must have the
         * <code>iam:PassRole</code> permission.
         * </p>
         * </note>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to perform tasks on
         *        your behalf. </p>
         *        <p>
         *        During model training, Amazon SageMaker needs your permission to read input data from an S3 bucket,
         *        download a Docker image that contains training code, write model artifacts to an S3 bucket, write logs
         *        to Amazon CloudWatch Logs, and publish metrics to Amazon CloudWatch. You grant permissions for all of
         *        these tasks to an IAM role. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker
         *        Roles</a>.
         *        </p>
         *        <note>
         *        <p>
         *        To be able to pass this role to Amazon SageMaker, the caller of this API must have the
         *        <code>iam:PassRole</code> permission.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * An array of <code>Channel</code> objects. Each channel is a named input source. <code>InputDataConfig</code>
         * describes the input data and its location.
         * </p>
         * <p>
         * Algorithms can accept input data from one or more channels. For example, an algorithm might have two channels
         * of input data, <code>training_data</code> and <code>validation_data</code>. The configuration for each
         * channel provides the S3, EFS, or FSx location where the input data is stored. It also provides information
         * about the stored data: the MIME type, compression method, and whether the data is wrapped in RecordIO format.
         * </p>
         * <p>
         * Depending on the input mode that the algorithm supports, Amazon SageMaker either copies input data files from
         * an S3 bucket to a local directory in the Docker container, or makes it available as input streams. For
         * example, if you specify an EFS location, input data files will be made available as input streams. They do
         * not need to be downloaded.
         * </p>
         * 
         * @param inputDataConfig
         *        An array of <code>Channel</code> objects. Each channel is a named input source.
         *        <code>InputDataConfig</code> describes the input data and its location. </p>
         *        <p>
         *        Algorithms can accept input data from one or more channels. For example, an algorithm might have two
         *        channels of input data, <code>training_data</code> and <code>validation_data</code>. The configuration
         *        for each channel provides the S3, EFS, or FSx location where the input data is stored. It also
         *        provides information about the stored data: the MIME type, compression method, and whether the data is
         *        wrapped in RecordIO format.
         *        </p>
         *        <p>
         *        Depending on the input mode that the algorithm supports, Amazon SageMaker either copies input data
         *        files from an S3 bucket to a local directory in the Docker container, or makes it available as input
         *        streams. For example, if you specify an EFS location, input data files will be made available as input
         *        streams. They do not need to be downloaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(Collection<Channel> inputDataConfig);

        /**
         * <p>
         * An array of <code>Channel</code> objects. Each channel is a named input source. <code>InputDataConfig</code>
         * describes the input data and its location.
         * </p>
         * <p>
         * Algorithms can accept input data from one or more channels. For example, an algorithm might have two channels
         * of input data, <code>training_data</code> and <code>validation_data</code>. The configuration for each
         * channel provides the S3, EFS, or FSx location where the input data is stored. It also provides information
         * about the stored data: the MIME type, compression method, and whether the data is wrapped in RecordIO format.
         * </p>
         * <p>
         * Depending on the input mode that the algorithm supports, Amazon SageMaker either copies input data files from
         * an S3 bucket to a local directory in the Docker container, or makes it available as input streams. For
         * example, if you specify an EFS location, input data files will be made available as input streams. They do
         * not need to be downloaded.
         * </p>
         * 
         * @param inputDataConfig
         *        An array of <code>Channel</code> objects. Each channel is a named input source.
         *        <code>InputDataConfig</code> describes the input data and its location. </p>
         *        <p>
         *        Algorithms can accept input data from one or more channels. For example, an algorithm might have two
         *        channels of input data, <code>training_data</code> and <code>validation_data</code>. The configuration
         *        for each channel provides the S3, EFS, or FSx location where the input data is stored. It also
         *        provides information about the stored data: the MIME type, compression method, and whether the data is
         *        wrapped in RecordIO format.
         *        </p>
         *        <p>
         *        Depending on the input mode that the algorithm supports, Amazon SageMaker either copies input data
         *        files from an S3 bucket to a local directory in the Docker container, or makes it available as input
         *        streams. For example, if you specify an EFS location, input data files will be made available as input
         *        streams. They do not need to be downloaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(Channel... inputDataConfig);

        /**
         * <p>
         * An array of <code>Channel</code> objects. Each channel is a named input source. <code>InputDataConfig</code>
         * describes the input data and its location.
         * </p>
         * <p>
         * Algorithms can accept input data from one or more channels. For example, an algorithm might have two channels
         * of input data, <code>training_data</code> and <code>validation_data</code>. The configuration for each
         * channel provides the S3, EFS, or FSx location where the input data is stored. It also provides information
         * about the stored data: the MIME type, compression method, and whether the data is wrapped in RecordIO format.
         * </p>
         * <p>
         * Depending on the input mode that the algorithm supports, Amazon SageMaker either copies input data files from
         * an S3 bucket to a local directory in the Docker container, or makes it available as input streams. For
         * example, if you specify an EFS location, input data files will be made available as input streams. They do
         * not need to be downloaded.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Channel>.Builder} avoiding the need to
         * create one manually via {@link List<Channel>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Channel>.Builder#build()} is called immediately and its
         * result is passed to {@link #inputDataConfig(List<Channel>)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on {@link List<Channel>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(List<Channel>)
         */
        Builder inputDataConfig(Consumer<Channel.Builder>... inputDataConfig);

        /**
         * <p>
         * Specifies the path to the S3 location where you want to store model artifacts. Amazon SageMaker creates
         * subfolders for the artifacts.
         * </p>
         * 
         * @param outputDataConfig
         *        Specifies the path to the S3 location where you want to store model artifacts. Amazon SageMaker
         *        creates subfolders for the artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(OutputDataConfig outputDataConfig);

        /**
         * <p>
         * Specifies the path to the S3 location where you want to store model artifacts. Amazon SageMaker creates
         * subfolders for the artifacts.
         * </p>
         * This is a convenience that creates an instance of the {@link OutputDataConfig.Builder} avoiding the need to
         * create one manually via {@link OutputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputDataConfig(OutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link OutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(OutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(OutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        /**
         * <p>
         * The resources, including the ML compute instances and ML storage volumes, to use for model training.
         * </p>
         * <p>
         * ML storage volumes store model artifacts and incremental states. Training algorithms might also use ML
         * storage volumes for scratch space. If you want Amazon SageMaker to use the ML storage volume to store the
         * training data, choose <code>File</code> as the <code>TrainingInputMode</code> in the algorithm specification.
         * For distributed training algorithms, specify an instance count greater than 1.
         * </p>
         * 
         * @param resourceConfig
         *        The resources, including the ML compute instances and ML storage volumes, to use for model training.
         *        </p>
         *        <p>
         *        ML storage volumes store model artifacts and incremental states. Training algorithms might also use ML
         *        storage volumes for scratch space. If you want Amazon SageMaker to use the ML storage volume to store
         *        the training data, choose <code>File</code> as the <code>TrainingInputMode</code> in the algorithm
         *        specification. For distributed training algorithms, specify an instance count greater than 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfig(ResourceConfig resourceConfig);

        /**
         * <p>
         * The resources, including the ML compute instances and ML storage volumes, to use for model training.
         * </p>
         * <p>
         * ML storage volumes store model artifacts and incremental states. Training algorithms might also use ML
         * storage volumes for scratch space. If you want Amazon SageMaker to use the ML storage volume to store the
         * training data, choose <code>File</code> as the <code>TrainingInputMode</code> in the algorithm specification.
         * For distributed training algorithms, specify an instance count greater than 1.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceConfig.Builder} avoiding the need to
         * create one manually via {@link ResourceConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceConfig(ResourceConfig)}.
         * 
         * @param resourceConfig
         *        a consumer that will call methods on {@link ResourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceConfig(ResourceConfig)
         */
        default Builder resourceConfig(Consumer<ResourceConfig.Builder> resourceConfig) {
            return resourceConfig(ResourceConfig.builder().applyMutation(resourceConfig).build());
        }

        /**
         * <p>
         * A <a>VpcConfig</a> object that specifies the VPC that you want your training job to connect to. Control
         * access to and from your training container by configuring the VPC. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an
         * Amazon Virtual Private Cloud</a>.
         * </p>
         * 
         * @param vpcConfig
         *        A <a>VpcConfig</a> object that specifies the VPC that you want your training job to connect to.
         *        Control access to and from your training container by configuring the VPC. For more information, see
         *        <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by
         *        Using an Amazon Virtual Private Cloud</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * A <a>VpcConfig</a> object that specifies the VPC that you want your training job to connect to. Control
         * access to and from your training container by configuring the VPC. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an
         * Amazon Virtual Private Cloud</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConfig.Builder} avoiding the need to create
         * one manually via {@link VpcConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * Specifies a limit to how long a model training job can run. When the job reaches the time limit, Amazon
         * SageMaker ends the training job. Use this API to cap model training costs.
         * </p>
         * <p>
         * To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job
         * termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the
         * results of training are not lost.
         * </p>
         * 
         * @param stoppingCondition
         *        Specifies a limit to how long a model training job can run. When the job reaches the time limit,
         *        Amazon SageMaker ends the training job. Use this API to cap model training costs.</p>
         *        <p>
         *        To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job
         *        termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so
         *        the results of training are not lost.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingCondition(StoppingCondition stoppingCondition);

        /**
         * <p>
         * Specifies a limit to how long a model training job can run. When the job reaches the time limit, Amazon
         * SageMaker ends the training job. Use this API to cap model training costs.
         * </p>
         * <p>
         * To stop a job, Amazon SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job
         * termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the
         * results of training are not lost.
         * </p>
         * This is a convenience that creates an instance of the {@link StoppingCondition.Builder} avoiding the need to
         * create one manually via {@link StoppingCondition#builder()}.
         *
         * When the {@link Consumer} completes, {@link StoppingCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #stoppingCondition(StoppingCondition)}.
         * 
         * @param stoppingCondition
         *        a consumer that will call methods on {@link StoppingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingCondition(StoppingCondition)
         */
        default Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return stoppingCondition(StoppingCondition.builder().applyMutation(stoppingCondition).build());
        }

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for
         * example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for
         *        example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for
         * example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for
         *        example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your AWS resources in different ways, for
         * example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Isolates the training container. No inbound or outbound network calls can be made, except for calls between
         * peers within a training cluster for distributed training. If you enable network isolation for training jobs
         * that are configured to use a VPC, Amazon SageMaker downloads and uploads customer data and model artifacts
         * through the specified VPC, but the training container does not have network access.
         * </p>
         * 
         * @param enableNetworkIsolation
         *        Isolates the training container. No inbound or outbound network calls can be made, except for calls
         *        between peers within a training cluster for distributed training. If you enable network isolation for
         *        training jobs that are configured to use a VPC, Amazon SageMaker downloads and uploads customer data
         *        and model artifacts through the specified VPC, but the training container does not have network
         *        access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableNetworkIsolation(Boolean enableNetworkIsolation);

        /**
         * <p>
         * To encrypt all communications between ML compute instances in distributed training, choose <code>True</code>.
         * Encryption provides greater security for distributed training, but training might take longer. How long it
         * takes depends on the amount of communication between compute instances, especially if you use a deep learning
         * algorithm in distributed training. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-encrypt.html">Protect Communications Between ML
         * Compute Instances in a Distributed Training Job</a>.
         * </p>
         * 
         * @param enableInterContainerTrafficEncryption
         *        To encrypt all communications between ML compute instances in distributed training, choose
         *        <code>True</code>. Encryption provides greater security for distributed training, but training might
         *        take longer. How long it takes depends on the amount of communication between compute instances,
         *        especially if you use a deep learning algorithm in distributed training. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-encrypt.html">Protect Communications
         *        Between ML Compute Instances in a Distributed Training Job</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption);

        /**
         * <p>
         * To train models using managed spot training, choose <code>True</code>. Managed spot training provides a fully
         * managed and scalable infrastructure for training machine learning models. this option is useful when training
         * jobs can be interrupted and when there is flexibility when the training job is run.
         * </p>
         * <p>
         * The complete and intermediate results of jobs are stored in an Amazon S3 bucket, and can be used as a
         * starting point to train models incrementally. Amazon SageMaker provides metrics and logs in CloudWatch. They
         * can be used to see when managed spot training jobs are running, interrupted, resumed, or completed.
         * </p>
         * 
         * @param enableManagedSpotTraining
         *        To train models using managed spot training, choose <code>True</code>. Managed spot training provides
         *        a fully managed and scalable infrastructure for training machine learning models. this option is
         *        useful when training jobs can be interrupted and when there is flexibility when the training job is
         *        run. </p>
         *        <p>
         *        The complete and intermediate results of jobs are stored in an Amazon S3 bucket, and can be used as a
         *        starting point to train models incrementally. Amazon SageMaker provides metrics and logs in
         *        CloudWatch. They can be used to see when managed spot training jobs are running, interrupted, resumed,
         *        or completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableManagedSpotTraining(Boolean enableManagedSpotTraining);

        /**
         * <p>
         * Contains information about the output location for managed spot training checkpoint data.
         * </p>
         * 
         * @param checkpointConfig
         *        Contains information about the output location for managed spot training checkpoint data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkpointConfig(CheckpointConfig checkpointConfig);

        /**
         * <p>
         * Contains information about the output location for managed spot training checkpoint data.
         * </p>
         * This is a convenience that creates an instance of the {@link CheckpointConfig.Builder} avoiding the need to
         * create one manually via {@link CheckpointConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link CheckpointConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #checkpointConfig(CheckpointConfig)}.
         * 
         * @param checkpointConfig
         *        a consumer that will call methods on {@link CheckpointConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #checkpointConfig(CheckpointConfig)
         */
        default Builder checkpointConfig(Consumer<CheckpointConfig.Builder> checkpointConfig) {
            return checkpointConfig(CheckpointConfig.builder().applyMutation(checkpointConfig).build());
        }

        /**
         * Sets the value of the DebugHookConfig property for this object.
         *
         * @param debugHookConfig
         *        The new value for the DebugHookConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder debugHookConfig(DebugHookConfig debugHookConfig);

        /**
         * Sets the value of the DebugHookConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link DebugHookConfig.Builder} avoiding the need to
         * create one manually via {@link DebugHookConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DebugHookConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #debugHookConfig(DebugHookConfig)}.
         * 
         * @param debugHookConfig
         *        a consumer that will call methods on {@link DebugHookConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #debugHookConfig(DebugHookConfig)
         */
        default Builder debugHookConfig(Consumer<DebugHookConfig.Builder> debugHookConfig) {
            return debugHookConfig(DebugHookConfig.builder().applyMutation(debugHookConfig).build());
        }

        /**
         * <p>
         * Configuration information for debugging rules.
         * </p>
         * 
         * @param debugRuleConfigurations
         *        Configuration information for debugging rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder debugRuleConfigurations(Collection<DebugRuleConfiguration> debugRuleConfigurations);

        /**
         * <p>
         * Configuration information for debugging rules.
         * </p>
         * 
         * @param debugRuleConfigurations
         *        Configuration information for debugging rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder debugRuleConfigurations(DebugRuleConfiguration... debugRuleConfigurations);

        /**
         * <p>
         * Configuration information for debugging rules.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DebugRuleConfiguration>.Builder} avoiding
         * the need to create one manually via {@link List<DebugRuleConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DebugRuleConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #debugRuleConfigurations(List<DebugRuleConfiguration>)}.
         * 
         * @param debugRuleConfigurations
         *        a consumer that will call methods on {@link List<DebugRuleConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #debugRuleConfigurations(List<DebugRuleConfiguration>)
         */
        Builder debugRuleConfigurations(Consumer<DebugRuleConfiguration.Builder>... debugRuleConfigurations);

        /**
         * Sets the value of the TensorBoardOutputConfig property for this object.
         *
         * @param tensorBoardOutputConfig
         *        The new value for the TensorBoardOutputConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tensorBoardOutputConfig(TensorBoardOutputConfig tensorBoardOutputConfig);

        /**
         * Sets the value of the TensorBoardOutputConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link TensorBoardOutputConfig.Builder} avoiding the
         * need to create one manually via {@link TensorBoardOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link TensorBoardOutputConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #tensorBoardOutputConfig(TensorBoardOutputConfig)}.
         * 
         * @param tensorBoardOutputConfig
         *        a consumer that will call methods on {@link TensorBoardOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tensorBoardOutputConfig(TensorBoardOutputConfig)
         */
        default Builder tensorBoardOutputConfig(Consumer<TensorBoardOutputConfig.Builder> tensorBoardOutputConfig) {
            return tensorBoardOutputConfig(TensorBoardOutputConfig.builder().applyMutation(tensorBoardOutputConfig).build());
        }

        /**
         * Sets the value of the ExperimentConfig property for this object.
         *
         * @param experimentConfig
         *        The new value for the ExperimentConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experimentConfig(ExperimentConfig experimentConfig);

        /**
         * Sets the value of the ExperimentConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link ExperimentConfig.Builder} avoiding the need to
         * create one manually via {@link ExperimentConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExperimentConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #experimentConfig(ExperimentConfig)}.
         * 
         * @param experimentConfig
         *        a consumer that will call methods on {@link ExperimentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #experimentConfig(ExperimentConfig)
         */
        default Builder experimentConfig(Consumer<ExperimentConfig.Builder> experimentConfig) {
            return experimentConfig(ExperimentConfig.builder().applyMutation(experimentConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String trainingJobName;

        private Map<String, String> hyperParameters = DefaultSdkAutoConstructMap.getInstance();

        private AlgorithmSpecification algorithmSpecification;

        private String roleArn;

        private List<Channel> inputDataConfig = DefaultSdkAutoConstructList.getInstance();

        private OutputDataConfig outputDataConfig;

        private ResourceConfig resourceConfig;

        private VpcConfig vpcConfig;

        private StoppingCondition stoppingCondition;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean enableNetworkIsolation;

        private Boolean enableInterContainerTrafficEncryption;

        private Boolean enableManagedSpotTraining;

        private CheckpointConfig checkpointConfig;

        private DebugHookConfig debugHookConfig;

        private List<DebugRuleConfiguration> debugRuleConfigurations = DefaultSdkAutoConstructList.getInstance();

        private TensorBoardOutputConfig tensorBoardOutputConfig;

        private ExperimentConfig experimentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrainingJobRequest model) {
            super(model);
            trainingJobName(model.trainingJobName);
            hyperParameters(model.hyperParameters);
            algorithmSpecification(model.algorithmSpecification);
            roleArn(model.roleArn);
            inputDataConfig(model.inputDataConfig);
            outputDataConfig(model.outputDataConfig);
            resourceConfig(model.resourceConfig);
            vpcConfig(model.vpcConfig);
            stoppingCondition(model.stoppingCondition);
            tags(model.tags);
            enableNetworkIsolation(model.enableNetworkIsolation);
            enableInterContainerTrafficEncryption(model.enableInterContainerTrafficEncryption);
            enableManagedSpotTraining(model.enableManagedSpotTraining);
            checkpointConfig(model.checkpointConfig);
            debugHookConfig(model.debugHookConfig);
            debugRuleConfigurations(model.debugRuleConfigurations);
            tensorBoardOutputConfig(model.tensorBoardOutputConfig);
            experimentConfig(model.experimentConfig);
        }

        public final String getTrainingJobName() {
            return trainingJobName;
        }

        @Override
        public final Builder trainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
            return this;
        }

        public final void setTrainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
        }

        public final Map<String, String> getHyperParameters() {
            if (hyperParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return hyperParameters;
        }

        @Override
        public final Builder hyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
            return this;
        }

        public final void setHyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
        }

        public final AlgorithmSpecification.Builder getAlgorithmSpecification() {
            return algorithmSpecification != null ? algorithmSpecification.toBuilder() : null;
        }

        @Override
        public final Builder algorithmSpecification(AlgorithmSpecification algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification;
            return this;
        }

        public final void setAlgorithmSpecification(AlgorithmSpecification.BuilderImpl algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification != null ? algorithmSpecification.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<Channel.Builder> getInputDataConfig() {
            if (inputDataConfig instanceof SdkAutoConstructList) {
                return null;
            }
            return inputDataConfig != null ? inputDataConfig.stream().map(Channel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputDataConfig(Collection<Channel> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copy(inputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Channel... inputDataConfig) {
            inputDataConfig(Arrays.asList(inputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Consumer<Channel.Builder>... inputDataConfig) {
            inputDataConfig(Stream.of(inputDataConfig).map(c -> Channel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInputDataConfig(Collection<Channel.BuilderImpl> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copyFromBuilder(inputDataConfig);
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        public final ResourceConfig.Builder getResourceConfig() {
            return resourceConfig != null ? resourceConfig.toBuilder() : null;
        }

        @Override
        public final Builder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final void setResourceConfig(ResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return stoppingCondition != null ? stoppingCondition.toBuilder() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Boolean getEnableNetworkIsolation() {
            return enableNetworkIsolation;
        }

        @Override
        public final Builder enableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
            return this;
        }

        public final void setEnableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
        }

        public final Boolean getEnableInterContainerTrafficEncryption() {
            return enableInterContainerTrafficEncryption;
        }

        @Override
        public final Builder enableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
            return this;
        }

        public final void setEnableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
        }

        public final Boolean getEnableManagedSpotTraining() {
            return enableManagedSpotTraining;
        }

        @Override
        public final Builder enableManagedSpotTraining(Boolean enableManagedSpotTraining) {
            this.enableManagedSpotTraining = enableManagedSpotTraining;
            return this;
        }

        public final void setEnableManagedSpotTraining(Boolean enableManagedSpotTraining) {
            this.enableManagedSpotTraining = enableManagedSpotTraining;
        }

        public final CheckpointConfig.Builder getCheckpointConfig() {
            return checkpointConfig != null ? checkpointConfig.toBuilder() : null;
        }

        @Override
        public final Builder checkpointConfig(CheckpointConfig checkpointConfig) {
            this.checkpointConfig = checkpointConfig;
            return this;
        }

        public final void setCheckpointConfig(CheckpointConfig.BuilderImpl checkpointConfig) {
            this.checkpointConfig = checkpointConfig != null ? checkpointConfig.build() : null;
        }

        public final DebugHookConfig.Builder getDebugHookConfig() {
            return debugHookConfig != null ? debugHookConfig.toBuilder() : null;
        }

        @Override
        public final Builder debugHookConfig(DebugHookConfig debugHookConfig) {
            this.debugHookConfig = debugHookConfig;
            return this;
        }

        public final void setDebugHookConfig(DebugHookConfig.BuilderImpl debugHookConfig) {
            this.debugHookConfig = debugHookConfig != null ? debugHookConfig.build() : null;
        }

        public final Collection<DebugRuleConfiguration.Builder> getDebugRuleConfigurations() {
            if (debugRuleConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return debugRuleConfigurations != null ? debugRuleConfigurations.stream().map(DebugRuleConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder debugRuleConfigurations(Collection<DebugRuleConfiguration> debugRuleConfigurations) {
            this.debugRuleConfigurations = DebugRuleConfigurationsCopier.copy(debugRuleConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder debugRuleConfigurations(DebugRuleConfiguration... debugRuleConfigurations) {
            debugRuleConfigurations(Arrays.asList(debugRuleConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder debugRuleConfigurations(Consumer<DebugRuleConfiguration.Builder>... debugRuleConfigurations) {
            debugRuleConfigurations(Stream.of(debugRuleConfigurations)
                    .map(c -> DebugRuleConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDebugRuleConfigurations(Collection<DebugRuleConfiguration.BuilderImpl> debugRuleConfigurations) {
            this.debugRuleConfigurations = DebugRuleConfigurationsCopier.copyFromBuilder(debugRuleConfigurations);
        }

        public final TensorBoardOutputConfig.Builder getTensorBoardOutputConfig() {
            return tensorBoardOutputConfig != null ? tensorBoardOutputConfig.toBuilder() : null;
        }

        @Override
        public final Builder tensorBoardOutputConfig(TensorBoardOutputConfig tensorBoardOutputConfig) {
            this.tensorBoardOutputConfig = tensorBoardOutputConfig;
            return this;
        }

        public final void setTensorBoardOutputConfig(TensorBoardOutputConfig.BuilderImpl tensorBoardOutputConfig) {
            this.tensorBoardOutputConfig = tensorBoardOutputConfig != null ? tensorBoardOutputConfig.build() : null;
        }

        public final ExperimentConfig.Builder getExperimentConfig() {
            return experimentConfig != null ? experimentConfig.toBuilder() : null;
        }

        @Override
        public final Builder experimentConfig(ExperimentConfig experimentConfig) {
            this.experimentConfig = experimentConfig;
            return this;
        }

        public final void setExperimentConfig(ExperimentConfig.BuilderImpl experimentConfig) {
            this.experimentConfig = experimentConfig != null ? experimentConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrainingJobRequest build() {
            return new CreateTrainingJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
