/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAppImageConfigRequest extends SageMakerRequest implements
        ToCopyableBuilder<DescribeAppImageConfigRequest.Builder, DescribeAppImageConfigRequest> {
    private static final SdkField<String> APP_IMAGE_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppImageConfigName").getter(getter(DescribeAppImageConfigRequest::appImageConfigName))
            .setter(setter(Builder::appImageConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppImageConfigName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_IMAGE_CONFIG_NAME_FIELD));

    private final String appImageConfigName;

    private DescribeAppImageConfigRequest(BuilderImpl builder) {
        super(builder);
        this.appImageConfigName = builder.appImageConfigName;
    }

    /**
     * <p>
     * The name of the AppImageConfig to describe.
     * </p>
     * 
     * @return The name of the AppImageConfig to describe.
     */
    public String appImageConfigName() {
        return appImageConfigName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appImageConfigName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppImageConfigRequest)) {
            return false;
        }
        DescribeAppImageConfigRequest other = (DescribeAppImageConfigRequest) obj;
        return Objects.equals(appImageConfigName(), other.appImageConfigName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAppImageConfigRequest").add("AppImageConfigName", appImageConfigName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppImageConfigName":
            return Optional.ofNullable(clazz.cast(appImageConfigName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppImageConfigRequest, T> g) {
        return obj -> g.apply((DescribeAppImageConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAppImageConfigRequest> {
        /**
         * <p>
         * The name of the AppImageConfig to describe.
         * </p>
         * 
         * @param appImageConfigName
         *        The name of the AppImageConfig to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appImageConfigName(String appImageConfigName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String appImageConfigName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppImageConfigRequest model) {
            super(model);
            appImageConfigName(model.appImageConfigName);
        }

        public final String getAppImageConfigName() {
            return appImageConfigName;
        }

        @Override
        public final Builder appImageConfigName(String appImageConfigName) {
            this.appImageConfigName = appImageConfigName;
            return this;
        }

        public final void setAppImageConfigName(String appImageConfigName) {
            this.appImageConfigName = appImageConfigName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAppImageConfigRequest build() {
            return new DescribeAppImageConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
