/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHumanTaskUiRequest extends SageMakerRequest implements
        ToCopyableBuilder<DescribeHumanTaskUiRequest.Builder, DescribeHumanTaskUiRequest> {
    private static final SdkField<String> HUMAN_TASK_UI_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HumanTaskUiName").getter(getter(DescribeHumanTaskUiRequest::humanTaskUiName))
            .setter(setter(Builder::humanTaskUiName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanTaskUiName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_TASK_UI_NAME_FIELD));

    private final String humanTaskUiName;

    private DescribeHumanTaskUiRequest(BuilderImpl builder) {
        super(builder);
        this.humanTaskUiName = builder.humanTaskUiName;
    }

    /**
     * <p>
     * The name of the human task user interface (worker task template) you want information about.
     * </p>
     * 
     * @return The name of the human task user interface (worker task template) you want information about.
     */
    public String humanTaskUiName() {
        return humanTaskUiName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(humanTaskUiName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHumanTaskUiRequest)) {
            return false;
        }
        DescribeHumanTaskUiRequest other = (DescribeHumanTaskUiRequest) obj;
        return Objects.equals(humanTaskUiName(), other.humanTaskUiName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeHumanTaskUiRequest").add("HumanTaskUiName", humanTaskUiName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HumanTaskUiName":
            return Optional.ofNullable(clazz.cast(humanTaskUiName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHumanTaskUiRequest, T> g) {
        return obj -> g.apply((DescribeHumanTaskUiRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeHumanTaskUiRequest> {
        /**
         * <p>
         * The name of the human task user interface (worker task template) you want information about.
         * </p>
         * 
         * @param humanTaskUiName
         *        The name of the human task user interface (worker task template) you want information about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder humanTaskUiName(String humanTaskUiName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String humanTaskUiName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHumanTaskUiRequest model) {
            super(model);
            humanTaskUiName(model.humanTaskUiName);
        }

        public final String getHumanTaskUiName() {
            return humanTaskUiName;
        }

        @Override
        public final Builder humanTaskUiName(String humanTaskUiName) {
            this.humanTaskUiName = humanTaskUiName;
            return this;
        }

        public final void setHumanTaskUiName(String humanTaskUiName) {
            this.humanTaskUiName = humanTaskUiName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeHumanTaskUiRequest build() {
            return new DescribeHumanTaskUiRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
